/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapKey;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapTile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SlippyMapLayer
extends Layer
implements ImageObserver,
Preferences.PreferenceChangedListener {
    public int currentZoomLevel = SlippyMapPreferences.getMinZoomLvl();
    private HashMap<SlippyMapKey, SlippyMapTile>[] tileStorage = null;
    Point[][] pixelpos = new Point[21][21];
    LatLon lastTopLeft;
    LatLon lastBotRight;
    int z12x0;
    int z12x1;
    int z12y0;
    int z12y1;
    private Image bufferImage;
    private SlippyMapTile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;

    public SlippyMapLayer() {
        super(I18n.tr((String)"Slippy Map"));
        this.background = true;
        this.clearTileStorage();
        this.tileOptionMenu = new JPopupMenu();
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load Tile")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.loadImage();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Show Tile Status")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.loadMetadata();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Request Update")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.requestUpdate();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load All Tiles")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.loadAllTiles();
                SlippyMapLayer.this.needRedraw = true;
                Main.map.repaint();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Increase zoom")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.increaseZoomLevel();
                SlippyMapLayer.this.needRedraw = true;
                Main.map.repaint();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Decrease zoom")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.decreaseZoomLevel();
                SlippyMapLayer.this.needRedraw = true;
                Main.map.repaint();
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() != 3) {
                            return;
                        }
                        SlippyMapLayer.this.clickedTile = SlippyMapLayer.this.getTileForPixelpos(e.getX(), e.getY());
                        SlippyMapLayer.this.tileOptionMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                });
                listeners.add(new Layer.LayerChangeListener(){

                    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                    }

                    public void layerAdded(Layer newLayer) {
                    }

                    public void layerRemoved(Layer oldLayer) {
                        Main.pref.listener.remove(SlippyMapLayer.this);
                    }
                });
            }
        });
        Main.pref.listener.add(this);
    }

    public void increaseZoomLevel() {
        if (this.currentZoomLevel < SlippyMapPreferences.getMaxZoomLvl()) {
            ++this.currentZoomLevel;
        } else {
            System.err.println("current zoom lvl couldnt be increased. MaxZoomLvl reached.");
        }
    }

    public void decreaseZoomLevel() {
        if (this.currentZoomLevel > SlippyMapPreferences.getMinZoomLvl()) {
            --this.currentZoomLevel;
        } else {
            System.err.println("current zoom lvl couldnt be decreased. MinZoomLvl reached.");
        }
    }

    public void clearTileStorage() {
        int maxZoom = 30;
        this.tileStorage = new HashMap[maxZoom + 1];
        int i = 0;
        while (i < maxZoom + 1) {
            this.tileStorage[i] = new HashMap();
            ++i;
        }
    }

    void loadAllTiles() {
        int tmp;
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        this.z12x0 = this.lonToTileX(topLeft.lon());
        this.z12x1 = this.lonToTileX(botRight.lon());
        this.z12y0 = this.latToTileY(topLeft.lat());
        this.z12y1 = this.latToTileY(botRight.lat());
        if (this.z12x0 > this.z12x1) {
            tmp = this.z12x0;
            this.z12x0 = this.z12x1;
            this.z12x1 = tmp;
        }
        if (this.z12y0 > this.z12y1) {
            tmp = this.z12y0;
            this.z12y0 = this.z12y1;
            this.z12y1 = tmp;
        }
        if (this.z12x1 - this.z12x0 > 18) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on X axis!");
            return;
        }
        if (this.z12y1 - this.z12y0 > 18) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on Y axis!");
            return;
        }
        int x = this.z12x0 - 1;
        while (x <= this.z12x1) {
            int y = this.z12y0 - 1;
            while (y <= this.z12y1) {
                SlippyMapKey key = new SlippyMapKey(x, y);
                SlippyMapTile tile = this.tileStorage[this.currentZoomLevel].get(key);
                if (tile == null) {
                    tile = new SlippyMapTile(x, y, this.currentZoomLevel);
                    this.tileStorage[this.currentZoomLevel].put(key, tile);
                }
                if (tile.getImage() == null) {
                    tile.loadImage();
                }
                ++y;
            }
            ++x;
        }
    }

    public void paint(Graphics g, MapView mv) {
        int y;
        int tmp;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        Graphics oldg = g;
        if (this.lastTopLeft != null && this.lastBotRight != null && topLeft.equalsEpsilon(this.lastTopLeft) && botRight.equalsEpsilon(this.lastBotRight) && this.bufferImage != null && mv.getWidth() == this.bufferImage.getWidth(null) && mv.getHeight() == this.bufferImage.getHeight(null) && !this.needRedraw) {
            g.drawImage(this.bufferImage, 0, 0, null);
            return;
        }
        this.needRedraw = false;
        this.lastTopLeft = topLeft;
        this.lastBotRight = botRight;
        this.bufferImage = mv.createImage(mv.getWidth(), mv.getHeight());
        g = this.bufferImage.getGraphics();
        this.z12x0 = this.lonToTileX(topLeft.lon());
        this.z12x1 = this.lonToTileX(botRight.lon());
        this.z12y0 = this.latToTileY(topLeft.lat());
        this.z12y1 = this.latToTileY(botRight.lat());
        if (this.z12x0 > this.z12x1) {
            tmp = this.z12x0;
            this.z12x0 = this.z12x1;
            this.z12x1 = tmp;
        }
        if (this.z12y0 > this.z12y1) {
            tmp = this.z12y0;
            this.z12y0 = this.z12y1;
            this.z12y1 = tmp;
        }
        if (this.z12x1 - this.z12x0 > 18) {
            return;
        }
        if (this.z12y1 - this.z12y0 > 18) {
            return;
        }
        int x = this.z12x0 - 1;
        while (x <= this.z12x1 + 1) {
            double lon = this.tileXToLon(x);
            y = this.z12y0 - 1;
            while (y <= this.z12y1 + 1) {
                LatLon tmpLL = new LatLon(this.tileYToLat(y), lon);
                this.pixelpos[x - this.z12x0 + 1][y - this.z12y0 + 1] = mv.getPoint(Main.proj.latlon2eastNorth(tmpLL));
                ++y;
            }
            ++x;
        }
        int fontHeight = g.getFontMetrics().getHeight();
        g.setColor(Color.DARK_GRAY);
        float fadeBackground = SlippyMapPreferences.getFadeBackground();
        int x2 = this.z12x0 - 1;
        while (x2 <= this.z12x1) {
            y = this.z12y0 - 1;
            while (y <= this.z12y1) {
                Image img;
                SlippyMapTile tile;
                SlippyMapKey key = new SlippyMapKey(x2, y);
                try {
                    tile = this.tileStorage[this.currentZoomLevel].get(key);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new RuntimeException("currentZoomLevel=" + this.currentZoomLevel + " and tile storage array have just size=" + this.tileStorage.length + " and maxZoomLvl in preferences is " + SlippyMapPreferences.getMaxZoomLvl() + ".", ex);
                }
                if (tile == null) {
                    tile = new SlippyMapTile(x2, y, this.currentZoomLevel);
                    this.tileStorage[this.currentZoomLevel].put(key, tile);
                    if (SlippyMapPreferences.getAutoloadTiles()) {
                        tile.loadImage();
                    }
                }
                if ((img = tile.getImage()) != null) {
                    Point p = this.pixelpos[x2 - this.z12x0 + 1][y - this.z12y0 + 1];
                    Point p2 = this.pixelpos[x2 - this.z12x0 + 2][y - this.z12y0 + 2];
                    g.drawImage(img, p.x, p.y, p2.x - p.x, p2.y - p.y, this);
                    if (fadeBackground != 0.0f) {
                        g.setColor(new Color(1.0f, 1.0f, 1.0f, fadeBackground));
                        g.fillRect(p.x, p.y, p2.x - p.x, p2.y - p.y);
                    }
                }
                ++y;
            }
            ++x2;
        }
        g.setColor(Color.red);
        x2 = this.z12x0 - 1;
        while (x2 <= this.z12x1) {
            Point p = this.pixelpos[x2 - this.z12x0 + 1][0];
            if (SlippyMapPreferences.getDrawDebug()) {
                if (x2 % 32 == 0) {
                    g.fillRect(p.x - 1, 0, 3, mv.getHeight());
                } else {
                    g.drawLine(p.x, 0, p.x, mv.getHeight());
                }
            }
            int y2 = this.z12y0 - 1;
            while (y2 <= this.z12y1) {
                SlippyMapKey key = new SlippyMapKey(x2, y2);
                int texty = p.y + 2 + fontHeight;
                SlippyMapTile tile = this.tileStorage[this.currentZoomLevel].get(key);
                if (tile != null) {
                    String md;
                    p = this.pixelpos[x2 - this.z12x0 + 1][y2 - this.z12y0 + 2];
                    if (SlippyMapPreferences.getDrawDebug()) {
                        g.drawString("x=" + x2 + " y=" + y2 + " z=" + this.currentZoomLevel, p.x + 2, texty);
                        texty += 1 + fontHeight;
                        if (x2 % 32 == 0 && y2 % 32 == 0) {
                            g.drawString("x=" + x2 / 32 + " y=" + y2 / 32 + " z=7", p.x + 2, texty);
                            texty += 1 + fontHeight;
                        }
                    }
                    if ((md = tile.getMetadata()) != null) {
                        g.drawString(md, p.x + 2, texty);
                        texty += 1 + fontHeight;
                    }
                    if (tile.getImage() == null) {
                        g.drawString(I18n.tr((String)"image not loaded"), p.x + 2, texty);
                        texty += 1 + fontHeight;
                    }
                    if (SlippyMapPreferences.getDrawDebug() && x2 == this.z12x0 - 1) {
                        if (y2 % 32 == 31) {
                            g.fillRect(0, p.y - 1, mv.getWidth(), 3);
                        } else {
                            g.drawLine(0, p.y, mv.getWidth(), p.y);
                        }
                    }
                }
                ++y2;
            }
            ++x2;
        }
        oldg.drawImage(this.bufferImage, 0, 0, null);
        if (this.z12x1 - this.z12x0 < 2 || this.z12y1 - this.z12y0 < 2) {
            if (SlippyMapPreferences.getAutozoom()) {
                this.increaseZoomLevel();
            }
            this.paint(oldg, mv);
        }
        if (this.z12x1 - this.z12x0 > 6 || this.z12y1 - this.z12y0 > 6) {
            if (SlippyMapPreferences.getAutozoom()) {
                this.decreaseZoomLevel();
            }
            this.paint(oldg, mv);
        }
        g.setColor(Color.black);
        g.drawString("currentZoomLevel=" + this.currentZoomLevel, 120, 120);
    }

    SlippyMapTile getTileForPixelpos(int px, int py) {
        int tilex = this.z12x1;
        int tiley = this.z12y1;
        int x = this.z12x0;
        while (x <= this.z12x1) {
            if (this.pixelpos[x - this.z12x0 + 1][0].x > px) {
                tilex = x - 1;
                break;
            }
            ++x;
        }
        if (tilex == -1) {
            return null;
        }
        int y = this.z12y0;
        while (y <= this.z12y1) {
            if (this.pixelpos[0][y - this.z12y0 + 1].y > py) {
                tiley = y - 1;
                break;
            }
            ++y;
        }
        if (tiley == -1) {
            return null;
        }
        SlippyMapKey key = new SlippyMapKey(tilex, tiley);
        SlippyMapTile tile = this.tileStorage[this.currentZoomLevel].get(key);
        if (tile == null) {
            tile = new SlippyMapTile(tilex, tiley, this.currentZoomLevel);
            this.tileStorage[this.currentZoomLevel].put(key, tile);
        }
        return tile;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"slippymap");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(this.associatedFile, (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private int latToTileY(double lat) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return (int)(Math.pow(2.0, this.currentZoomLevel - 1) * (Math.PI - pf) / Math.PI);
    }

    private int lonToTileX(double lon) {
        return (int)(Math.pow(2.0, this.currentZoomLevel - 3) * (lon + 180.0) / 45.0);
    }

    private double tileYToLat(int y) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / Math.pow(2.0, this.currentZoomLevel - 1))) * 180.0 / Math.PI;
    }

    private double tileXToLon(int x) {
        return (double)x * 45.0 / Math.pow(2.0, this.currentZoomLevel - 3) - 180.0;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done = (infoflags & 0x70) != 0;
        this.needRedraw = true;
        Main.map.repaint((long)(done ? 0 : 100));
        return !done;
    }

    public void preferenceChanged(String key, String newValue) {
        if (key.startsWith("slippymap") && !key.equals("slippymap.fade_background")) {
            this.clearTileStorage();
        }
    }

    public void destroy() {
        Main.pref.listener.remove(this);
    }
}

