/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.util;

import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgregatePrimitivesVisitor
implements Visitor {
    Collection<OsmPrimitive> aggregatedData = new LinkedList<OsmPrimitive>();

    public Collection<OsmPrimitive> visit(Collection<OsmPrimitive> data) {
        for (OsmPrimitive osm : data) {
            osm.visit((Visitor)this);
        }
        return this.aggregatedData;
    }

    public void visit(Node n) {
        if (!this.aggregatedData.contains(n)) {
            this.aggregatedData.add((OsmPrimitive)n);
        }
    }

    public void visit(Way w) {
        if (!this.aggregatedData.contains(w)) {
            this.aggregatedData.add((OsmPrimitive)w);
            for (Node n : w.nodes) {
                this.visit(n);
            }
        }
    }

    public void visit(Relation r) {
        if (!this.aggregatedData.contains(r)) {
            this.aggregatedData.add((OsmPrimitive)r);
            for (RelationMember m : r.members) {
                m.member.visit((Visitor)this);
            }
        }
    }
}

