/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.EastNorthBound;
import cadastre_fr.GeorefImage;
import cadastre_fr.Scale;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLayer
extends Layer {
    Component[] component = null;
    public int lambertZone = -1;
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(CadastrePlugin.class.getResource("/images/cadastre_small.png")));
    protected ArrayList<GeorefImage> images = new ArrayList();
    protected final int serializeFormatVersion = 2;
    private ArrayList<EastNorthBound> dividedBbox = new ArrayList();
    private CacheControl cacheControl = null;
    private String location = "";
    private String codeCommune = "";
    private EastNorthBound communeBBox = new EastNorthBound(new EastNorth(0.0, 0.0), new EastNorth(0.0, 0.0));
    private boolean isRaster = false;
    private EastNorth rasterMin;
    private EastNorth rasterCenter;
    private double rasterRatio;
    double cRasterMaxSizeX = 12286.0;
    double cRasterMaxSizeY = 8730.0;

    public WMSLayer() {
        this(I18n.tr((String)"Blank Layer"), "", -1);
    }

    public WMSLayer(String location, String codeCommune, int lambertZone) {
        super(WMSLayer.buildName(location, codeCommune));
        this.location = location;
        this.codeCommune = codeCommune;
        this.lambertZone = Lambert.layoutZone;
        CadastrePlugin.pluginUsed = true;
    }

    private static String buildName(String location, String codeCommune) {
        String ret = new String(location.toUpperCase());
        if (codeCommune != null && !codeCommune.equals("")) {
            ret = ret + "(" + codeCommune + ")";
        }
        return ret;
    }

    private String rebuildName() {
        return WMSLayer.buildName(this.location.toUpperCase(), this.codeCommune);
    }

    public void grab(CadastreGrabber grabber, Bounds b) throws IOException {
        this.divideBbox(b, Integer.parseInt(Main.pref.get("cadastrewms.scale", Scale.X1.toString())));
        for (EastNorthBound n : this.dividedBbox) {
            GeorefImage newImage;
            try {
                newImage = grabber.grab(this, n.min, n.max);
            }
            catch (IOException e) {
                System.out.println("Download action cancelled by user or server did not respond");
                break;
            }
            if (grabber.getWmsInterface().downloadCancelled) {
                System.out.println("Download action cancelled by user");
                break;
            }
            if (CadastrePlugin.backgroundTransparent) {
                for (GeorefImage img : this.images) {
                    if (img.overlap(newImage)) {
                        img.withdraw(newImage);
                        continue;
                    }
                    newImage.withdraw(img);
                }
            }
            this.images.add(newImage);
            this.saveToCache(newImage);
            Main.map.mapView.repaint();
        }
    }

    private void divideBbox(Bounds b, int factor) {
        EastNorth lambertMin = Main.proj.latlon2eastNorth(b.min);
        EastNorth lambertMax = Main.proj.latlon2eastNorth(b.max);
        double minEast = lambertMin.east();
        double minNorth = lambertMin.north();
        double dEast = (lambertMax.east() - minEast) / (double)factor;
        double dNorth = (lambertMax.north() - minNorth) / (double)factor;
        this.dividedBbox.clear();
        if (factor < 4) {
            for (int xEast = 0; xEast < factor; ++xEast) {
                for (int xNorth = 0; xNorth < factor; ++xNorth) {
                    this.dividedBbox.add(new EastNorthBound(new EastNorth(minEast + (double)xEast * dEast, minNorth + (double)xNorth * dNorth), new EastNorth(minEast + (double)(xEast + 1) * dEast, minNorth + (double)(xNorth + 1) * dNorth)));
                }
            }
        } else {
            int cSquare = Integer.parseInt(Main.pref.get("cadastrewms.squareSize", "100"));
            minEast -= minEast % (double)cSquare;
            minNorth -= minNorth % (double)cSquare;
            int xEast = (int)minEast;
            while ((double)xEast < lambertMax.east()) {
                int xNorth = (int)minNorth;
                while ((double)xNorth < lambertMax.north()) {
                    this.dividedBbox.add(new EastNorthBound(new EastNorth((double)xEast, (double)xNorth), new EastNorth((double)(xEast + cSquare), (double)(xNorth + cSquare))));
                    xNorth += cSquare;
                }
                xEast += cSquare;
            }
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        String str = I18n.tr((String)"WMS layer ({0}), {1} tile(s) loaded", (Object[])new Object[]{this.name, this.images.size()});
        if (this.isRaster) {
            str = str + "\n" + I18n.tr((String)"Is not vectorized.");
            str = str + "\n" + I18n.tr((String)"Raster center: {0}", (Object[])new Object[]{this.rasterCenter});
        } else {
            str = str + "\n" + I18n.tr((String)"Is vectorized.");
        }
        str = str + "\n" + I18n.tr((String)"Commune bbox: {0}", (Object[])new Object[]{this.communeBBox});
        return str;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics g, MapView mv) {
        for (GeorefImage img : this.images) {
            img.paint((Graphics2D)g, (NavigatableComponent)mv, CadastrePlugin.backgroundTransparent, CadastrePlugin.transparency, CadastrePlugin.drawBoundaries);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (GeorefImage img : this.images) {
            v.visit(img.min);
            v.visit(img.max);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        this.component = new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JMenuItem(new LoadWmsAction()), new JMenuItem(new SaveWmsAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
        return this.component;
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        for (int i = this.images.size() - 1; i >= 0; --i) {
            if (!this.images.get(i).contains(eastNorth)) continue;
            return this.images.get(i);
        }
        return null;
    }

    public boolean isOverlapping(Bounds bounds) {
        GeorefImage georefImage = new GeorefImage(new BufferedImage(1, 1, 1), Main.proj.latlon2eastNorth(bounds.min), Main.proj.latlon2eastNorth(bounds.max));
        for (GeorefImage img : this.images) {
            if (!img.overlap(georefImage)) continue;
            return true;
        }
        return false;
    }

    public void saveToCache(GeorefImage image) {
        if (CacheControl.cacheEnabled) {
            this.getCacheControl().saveCache(image);
        }
    }

    public void saveNewCache() {
        if (CacheControl.cacheEnabled) {
            this.getCacheControl().deleteCacheFile();
            for (GeorefImage image : this.images) {
                this.getCacheControl().saveCache(image);
            }
        }
    }

    public CacheControl getCacheControl() {
        if (this.cacheControl == null) {
            this.cacheControl = new CacheControl(this);
        }
        return this.cacheControl;
    }

    protected static JFileChooser createAndOpenFileChooser(boolean open, boolean multiple) {
        File file;
        int answer;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        fc.setMultiSelectionEnabled(multiple);
        for (int i = 0; i < ExtensionFileFilter.filters.length; ++i) {
            fc.addChoosableFileFilter((FileFilter)ExtensionFileFilter.filters[i]);
        }
        fc.setAcceptAllFileFilterUsed(true);
        int n = answer = open ? fc.showOpenDialog(Main.parent) : fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!open && ((file = fc.getSelectedFile()) == null || file.exists() && 0 != JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"File exists. Overwrite?"), I18n.tr((String)"Overwrite"), 0))) {
            return null;
        }
        return fc;
    }

    public static File openFileDialog(boolean open) {
        JFileChooser fc = WMSLayer.createAndOpenFileChooser(open, false);
        if (fc == null) {
            return null;
        }
        File file = fc.getSelectedFile();
        String fn = file.getPath();
        if (fn.indexOf(46) == -1) {
            FileFilter ff = fc.getFileFilter();
            fn = ff instanceof ExtensionFileFilter ? "." + ((ExtensionFileFilter)ff).defaultExtension : fn + ".osm";
            file = new File(fn);
        }
        return file;
    }

    public String eastNorth2raster(EastNorth min, EastNorth max) {
        double minX = (min.east() - this.rasterMin.east()) / this.rasterRatio;
        double minY = (min.north() - this.rasterMin.north()) / this.rasterRatio;
        double maxX = (max.east() - this.rasterMin.east()) / this.rasterRatio;
        double maxY = (max.north() - this.rasterMin.north()) / this.rasterRatio;
        return minX + "," + minY + "," + maxX + "," + maxY;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.name = this.rebuildName();
        this.repaintLayerListDialog();
    }

    public String getCodeCommune() {
        return this.codeCommune;
    }

    public void setCodeCommune(String codeCommune) {
        this.codeCommune = codeCommune;
        this.name = this.rebuildName();
        this.repaintLayerListDialog();
    }

    public boolean isRaster() {
        return this.isRaster;
    }

    public void setRaster(boolean isRaster) {
        this.isRaster = isRaster;
    }

    public void setRasterBounds(Bounds bounds) {
        this.rasterMin = new EastNorth(Main.proj.latlon2eastNorth(bounds.min).east(), Main.proj.latlon2eastNorth(bounds.min).north());
        EastNorth rasterMax = new EastNorth(Main.proj.latlon2eastNorth(bounds.max).east(), Main.proj.latlon2eastNorth(bounds.max).north());
        double rasterHalfHeight = (rasterMax.east() - this.rasterMin.east()) / this.cRasterMaxSizeX * this.cRasterMaxSizeY / 2.0;
        double rasterMid = this.rasterMin.north() + (rasterMax.north() - this.rasterMin.north()) / 2.0;
        this.rasterMin.setLocation(this.rasterMin.east(), rasterMid - rasterHalfHeight);
        rasterMax.setLocation(rasterMax.east(), rasterMid + rasterHalfHeight);
        this.rasterCenter = new EastNorth(this.rasterMin.east() + (rasterMax.east() - this.rasterMin.east()) / 2.0, this.rasterMin.north() + (rasterMax.north() - this.rasterMin.north()) / 2.0);
        this.rasterRatio = (rasterMax.east() - this.rasterMin.east()) / this.cRasterMaxSizeX;
    }

    public EastNorth getRasterMin() {
        return this.rasterMin;
    }

    public void setRasterMin(EastNorth rasterMin) {
        this.rasterMin = rasterMin;
    }

    public void displace(double dx, double dy) {
        this.rasterMin = new EastNorth(this.rasterMin.east() + dx, this.rasterMin.north() + dy);
        this.rasterCenter = new EastNorth(this.rasterCenter.east() + dx, this.rasterCenter.north() + dy);
        for (GeorefImage img : this.images) {
            img.displace(dx, dy);
        }
    }

    public void resize(double proportion) {
        this.rasterMin = this.rasterMin.interpolate(this.rasterCenter, proportion);
        for (GeorefImage img : this.images) {
            img.resize(this.rasterCenter, proportion);
        }
    }

    public void rotate(double angle) {
        this.rasterMin = this.rasterMin.rotate(this.rasterCenter, angle);
        for (GeorefImage img : this.images) {
            img.rotate(this.rasterCenter, angle);
        }
    }

    private void repaintLayerListDialog() {
        if (Main.map != null) {
            for (Component c : Main.map.toggleDialogs.getComponents()) {
                if (!(c instanceof LayerListDialog)) continue;
                c.repaint();
            }
        }
    }

    public void write(ObjectOutputStream oos, ArrayList<GeorefImage> imgs) throws IOException {
        oos.writeInt(this.serializeFormatVersion);
        oos.writeObject(this.location);
        oos.writeObject(this.codeCommune);
        oos.writeInt(this.lambertZone);
        oos.writeBoolean(this.isRaster);
        if (this.isRaster) {
            oos.writeObject(this.rasterMin);
            oos.writeObject(this.rasterCenter);
            oos.writeDouble(this.rasterRatio);
        } else {
            oos.writeObject(this.communeBBox);
        }
        for (GeorefImage img : imgs) {
            oos.writeObject(img);
        }
    }

    public boolean read(ObjectInputStream ois, int currentLambertZone) throws IOException, ClassNotFoundException {
        int sfv = ois.readInt();
        if (sfv != this.serializeFormatVersion) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported cache file version; found {0}, expected {1}\nCreate a new one.", (Object[])new Object[]{sfv, this.serializeFormatVersion}), I18n.tr((String)"Cache Format Error"), 0);
            return false;
        }
        this.setLocation((String)ois.readObject());
        this.setCodeCommune((String)ois.readObject());
        this.lambertZone = ois.readInt();
        this.isRaster = ois.readBoolean();
        if (this.isRaster) {
            this.rasterMin = (EastNorth)ois.readObject();
            this.rasterCenter = (EastNorth)ois.readObject();
            this.rasterRatio = ois.readDouble();
        } else {
            this.communeBBox = (EastNorthBound)ois.readObject();
        }
        if (this.lambertZone != currentLambertZone) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Lambert zone {0} in cache  incompatible with current Lambert zone {1}", (Object[])new Object[]{this.lambertZone + 1, currentLambertZone}), I18n.tr((String)"Cache Lambert Zone Error"), 0);
            return false;
        }
        boolean EOF = false;
        try {
            while (!EOF) {
                GeorefImage newImage = (GeorefImage)ois.readObject();
                for (GeorefImage img : this.images) {
                    if (!CadastrePlugin.backgroundTransparent) continue;
                    if (img.overlap(newImage)) {
                        img.withdraw(newImage);
                        continue;
                    }
                    newImage.withdraw(img);
                }
                this.images.add(newImage);
            }
        }
        catch (EOFException ex) {
            // empty catch block
        }
        return true;
    }

    public double getRasterRatio() {
        return this.rasterRatio;
    }

    public void setRasterRatio(double rasterRatio) {
        this.rasterRatio = rasterRatio;
    }

    public EastNorth getRasterCenter() {
        return this.rasterCenter;
    }

    public void setRasterCenter(EastNorth rasterCenter) {
        this.rasterCenter = rasterCenter;
    }

    public EastNorthBound getCommuneBBox() {
        return this.communeBBox;
    }

    public void setCommuneBBox(EastNorthBound entireCommune) {
        this.communeBBox = entireCommune;
    }

    public class LoadWmsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LoadWmsAction() {
            super(I18n.tr((String)"Load WMS layer from file"), ImageProvider.get((String)"load"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = WMSLayer.openFileDialog(true);
            if (f == null) {
                return;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int sfv = ois.readInt();
                if (sfv != 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])new Object[]{sfv, 2}), I18n.tr((String)"File Format Error"), 0);
                    return;
                }
                WMSLayer.this.lambertZone = ois.readInt();
                int numImg = ois.readInt();
                for (int i = 0; i < numImg; ++i) {
                    GeorefImage img = (GeorefImage)ois.readObject();
                    WMSLayer.this.images.add(img);
                }
                ois.close();
                fis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
                return;
            }
        }
    }

    public class SaveWmsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveWmsAction() {
            super(I18n.tr((String)"Save WMS layer to file"), ImageProvider.get((String)"save"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = WMSLayer.openFileDialog(false);
            try {
                FileOutputStream fos = new FileOutputStream(f);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeInt(2);
                oos.writeInt(WMSLayer.this.lambertZone);
                oos.writeInt(WMSLayer.this.images.size());
                for (GeorefImage img : WMSLayer.this.images) {
                    oos.writeObject(img);
                }
                oos.close();
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }
}

