/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.LaunchAppropriateUI;
import edu.umd.cs.findbugs.Plugin;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;
import javax.annotation.CheckForNull;

public class Version {
    public static final String WEBSITE = "https://spotbugs.github.io/";
    public static final String VERSION_STRING;
    @Deprecated
    public static final String RELEASE;
    private static String applicationName;
    private static String applicationVersion;

    public static void registerApplication(String name, String version) {
        applicationName = name;
        applicationVersion = version;
    }

    @CheckForNull
    public static String getApplicationName() {
        return applicationName;
    }

    @CheckForNull
    public static String getApplicationVersion() {
        return applicationVersion;
    }

    public static void main(String[] argv) throws InterruptedException {
        if (argv.length == 0) {
            Version.printVersion(false);
            return;
        }
        String arg = argv[0];
        if ("-release".equals(arg)) {
            System.out.println(VERSION_STRING);
        } else if ("-plugins".equals(arg)) {
            DetectorFactoryCollection.instance();
            for (Plugin p : Plugin.getAllPlugins()) {
                String website;
                System.out.println("Plugin: " + p.getPluginId());
                System.out.println("  description: " + p.getShortDescription());
                System.out.println("     provider: " + p.getProvider());
                String version = p.getVersion();
                if (version != null && version.length() > 0) {
                    System.out.println("      version: " + version);
                }
                if ((website = p.getWebsite()) != null && website.length() > 0) {
                    System.out.println("      website: " + website);
                }
                System.out.println();
            }
        } else if ("-configuration".equals(arg)) {
            Version.printVersion(true);
        } else {
            Version.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: " + Version.class.getName() + "  [(-release|-date|-props|-configuration)]");
    }

    public static void printVersion(boolean justPrintConfiguration) throws InterruptedException {
        System.out.println("SpotBugs " + VERSION_STRING);
        if (justPrintConfiguration) {
            for (Plugin plugin : Plugin.getAllPlugins()) {
                Plugin parent;
                System.out.printf("Plugin %s, version %s, loaded from %s%n", plugin.getPluginId(), plugin.getVersion(), plugin.getPluginLoader().getURL());
                if (plugin.isCorePlugin()) {
                    System.out.println("  is core plugin");
                }
                if (plugin.isInitialPlugin()) {
                    System.out.println("  is initial plugin");
                }
                if (plugin.isEnabledByDefault()) {
                    System.out.println("  is enabled by default");
                }
                if (plugin.isGloballyEnabled()) {
                    System.out.println("  is globally enabled");
                }
                if ((parent = plugin.getParentPlugin()) != null) {
                    System.out.println("  has parent plugin " + parent.getPluginId());
                }
                for (DetectorFactory factory : plugin.getDetectorFactories()) {
                    System.out.printf("  detector %s%n", factory.getShortName());
                }
                System.out.println();
            }
        }
    }

    static {
        applicationName = "";
        applicationVersion = "";
        URL u = Version.class.getResource(Version.class.getSimpleName() + ".class");
        boolean fromFile = "file".equals(u.getProtocol());
        String version = "(Unknown)";
        if (!fromFile) {
            try {
                Enumeration<URL> resources = Version.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements()) {
                    InputStream is = resources.nextElement().openStream();
                    Throwable throwable = null;
                    try {
                        Manifest manifest = new Manifest(is);
                        String mainClass = manifest.getMainAttributes().getValue("Main-Class");
                        if (!LaunchAppropriateUI.class.getName().equals(mainClass)) continue;
                        version = manifest.getMainAttributes().getValue("Bundle-Version");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            catch (Exception exception) {}
        } else {
            version = "Development";
        }
        RELEASE = VERSION_STRING = version;
    }
}

