/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class GeorefImage
implements Serializable {
    public BufferedImage image = null;
    private Image reImg = null;
    private Dimension reImgHash = new Dimension(0, 0);
    public EastNorth min;
    public EastNorth max;
    public boolean downloadingStarted;
    public boolean failed = false;

    public GeorefImage(boolean downloadingStarted) {
        this.downloadingStarted = downloadingStarted;
    }

    public boolean contains(EastNorth en, double dx, double dy) {
        return this.min.east() + dx <= en.east() && en.east() <= this.max.east() + dx && this.min.north() + dy <= en.north() && en.north() <= this.max.north() + dy;
    }

    public boolean isVisible(NavigatableComponent nc) {
        Point minPt = nc.getPoint(this.min);
        Point maxPt = nc.getPoint(this.max);
        Graphics g = nc.getGraphics();
        return g.hitClip(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y);
    }

    public boolean paint(Graphics g, NavigatableComponent nc, double dx, double dy) {
        if (this.image == null || this.min == null || this.max == null) {
            return false;
        }
        EastNorth mi = new EastNorth(this.min.east() + dx, this.min.north() + dy);
        EastNorth ma = new EastNorth(this.max.east() + dx, this.max.north() + dy);
        Point minPt = nc.getPoint(mi);
        Point maxPt = nc.getPoint(ma);
        if (!g.hitClip(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y)) {
            return false;
        }
        int width = Math.abs(maxPt.x - minPt.x);
        int height = Math.abs(minPt.y - maxPt.y);
        int diffx = this.reImgHash.width - width;
        int diffy = this.reImgHash.height - height;
        if (width == 0 || height == 0) {
            return false;
        }
        if (diffx >= 0 && diffx <= 2 && diffy >= 0 && diffy <= 2 && this.reImg != null) {
            g.drawImage(this.reImg, minPt.x, maxPt.y, null);
            return true;
        }
        boolean alphaChannel = Main.pref.getBoolean("wmsplugin.alpha_channel");
        try {
            if (this.reImg != null) {
                this.reImg.flush();
            }
            long freeMem = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory();
            if (width > 10000 || height > 10000 || (long)(width * height * 3) > freeMem) {
                this.fallbackDraw(g, this.image, minPt, maxPt);
            } else {
                this.reImg = new BufferedImage(width, height, alphaChannel ? 2 : 5);
                this.reImg.getGraphics().drawImage(this.image, 0, 0, width, height, 0, 0, this.image.getWidth(null), this.image.getHeight(null), null);
                this.reImg.getGraphics().dispose();
                this.reImgHash.setSize(width, height);
                g.drawImage(this.reImg, minPt.x, maxPt.y, null);
            }
        }
        catch (Exception e) {
            this.fallbackDraw(g, this.image, minPt, maxPt);
        }
        return true;
    }

    private void fallbackDraw(Graphics g, Image img, Point min, Point max) {
        if (this.reImg != null) {
            this.reImg.flush();
        }
        this.reImg = null;
        g.drawImage(img, min.x, max.y, max.x, min.y, 0, 0, img.getWidth(null), img.getHeight(null), null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.max = (EastNorth)in.readObject();
        this.min = (EastNorth)in.readObject();
        this.image = ImageIO.read(ImageIO.createImageInputStream(in));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.max);
        out.writeObject(this.min);
        if (this.image == null) {
            out.writeObject(null);
        } else {
            ImageIO.write((RenderedImage)this.image, "png", ImageIO.createImageOutputStream(out));
        }
    }

    private Image clearAlpha(Image img) {
        ImageProducer ip = img.getSource();
        RGBImageFilter filter = new RGBImageFilter(){

            public int filterRGB(int x, int y, int rgb) {
                return rgb | 0xFF000000;
            }
        };
        FilteredImageSource filt_ip = new FilteredImageSource(ip, filter);
        Image out_img = Toolkit.getDefaultToolkit().createImage(filt_ip);
        return out_img;
    }

    public void flushedResizedCachedInstance() {
        this.reImg = null;
    }
}

