/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.DirectUpload;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class UploadDataGui
extends JFrame {
    private JTextArea OutputDisplay = new JTextArea();
    private JTextField descriptionField = new JTextField();
    private JTextField tagsField = new JTextField();
    private JCheckBox publicCheckbox = new JCheckBox();
    private JButton OkButton = new JButton();
    public static final String API_VERSION = "0.5";
    private static final String BOUNDARY = "----------------------------d10f7aa230e8";
    private static final String LINE_END = "\r\n";
    private String datename = new SimpleDateFormat("yyMMddHHmmss").format(new Date());

    public UploadDataGui() {
        this.setTitle(I18n.tr((String)"Upload Traces"));
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setPreferredSize(new Dimension(350, 200));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = this.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.OutputDisplay.setBackground(UIManager.getColor("Panel.background"));
        this.OutputDisplay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.OutputDisplay.setEditable(false);
        this.OutputDisplay.setFont(new JLabel().getFont());
        this.OutputDisplay.setLineWrap(true);
        this.OutputDisplay.setWrapStyleWord(true);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportView(this.OutputDisplay);
        this.OkButton.setText(I18n.tr((String)"Upload GPX track"));
        this.OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UploadDataGui.this.OkButtonActionPerformed(evt);
            }
        });
        JButton CancelButton = new JButton(I18n.tr((String)"Cancel"));
        CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UploadDataGui.this.CancelButtonActionPerformed(evt);
            }
        });
        this.publicCheckbox.setText(I18n.tr((String)"Public"));
        this.publicCheckbox.setToolTipText(I18n.tr((String)"Selected makes your trace public in openstreetmap.org"));
        JLabel descriptionLabel = new JLabel(I18n.tr((String)"Description"));
        this.descriptionField.setToolTipText("Please enter Description about your trace.");
        JLabel tagsLabel = new JLabel(I18n.tr((String)"Tags"));
        this.tagsField.setToolTipText("Please enter tags about your trace.");
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.add((Component)this.OutputDisplay, GBC.eol().fill());
        p.add((Component)tagsLabel, GBC.std().insets(0, 10, 0, 0));
        p.add((Component)this.tagsField, GBC.eol().fill(2));
        p.add((Component)descriptionLabel, GBC.std().insets(0, 10, 0, 0));
        p.add((Component)this.descriptionField, GBC.eol().fill(2));
        p.add((Component)this.publicCheckbox, GBC.eol());
        p.add((Component)CancelButton, GBC.std());
        p.add((Component)this.OkButton, GBC.eol().fill(2));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)p, GBC.eol().insets(10, 10, 10, 10).fill());
        this.pack();
        if (Main.map != null && Main.map.mapView != null) {
            MapView mv = Main.map.mapView;
            if (!(mv.getActiveLayer() instanceof GpxLayer)) {
                Layer lastLayer = null;
                int layerCount = 0;
                for (Layer l : mv.getAllLayers()) {
                    if (!(l instanceof GpxLayer)) continue;
                    lastLayer = l;
                    ++layerCount;
                }
                if (layerCount == 1) {
                    mv.setActiveLayer(lastLayer);
                }
            }
            if (mv.getActiveLayer() instanceof GpxLayer) {
                GpxData data = ((GpxLayer)Main.map.mapView.getActiveLayer()).data;
                this.descriptionField.setText(data.storageFile.getName().replaceAll("[&?/\\\\]", " ").replaceAll("(\\.[^.]*)$", ""));
            }
        }
        boolean x = this.checkForGPXLayer();
    }

    public void upload(String username, String password, String description, String tags, Boolean isPublic, GpxData gpxData) throws IOException {
        if (this.checkForErrors(username, password, description, gpxData)) {
            return;
        }
        this.OkButton.setEnabled(false);
        description = description.replaceAll("[&?/\\\\]", " ");
        tags = tags.replaceAll("[&?/\\\\.,;]", " ");
        Main.pleaseWaitDlg.progress.setValue(0);
        Main.pleaseWaitDlg.setIndeterminate(true);
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Connecting..."));
        Main.pleaseWaitDlg.cancel.setEnabled(false);
        try {
            URL url = new URL("http://www.openstreetmap.org/api/0.5/gpx/create");
            HttpURLConnection connect = (HttpURLConnection)url.openConnection();
            connect.setConnectTimeout(15000);
            connect.setRequestMethod("POST");
            connect.setDoOutput(true);
            CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
            String auth = username + ":" + password;
            ByteBuffer bytes = encoder.encode(CharBuffer.wrap(auth));
            connect.addRequestProperty("Authorization", "Basic " + Base64.encode((ByteBuffer)bytes));
            connect.addRequestProperty("Content-Type", "multipart/form-data; boundary=----------------------------d10f7aa230e8");
            connect.addRequestProperty("Connection", "close");
            connect.addRequestProperty("Expect", "");
            connect.connect();
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Uploading GPX track..."));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(connect.getOutputStream()));
            this.writeContentDispositionGpxData(out, "file", gpxData);
            this.writeContentDisposition(out, "description", description);
            this.writeContentDisposition(out, "tags", tags != null && tags.length() > 0 ? tags : "");
            this.writeContentDisposition(out, "public", isPublic != false ? "1" : "0");
            out.writeBytes("------------------------------d10f7aa230e8--\r\n");
            out.flush();
            String returnMsg = connect.getResponseMessage();
            boolean success = returnMsg.equals("OK");
            this.OutputDisplay.setText(success ? I18n.tr((String)"GPX upload was successful") : returnMsg);
            if (connect.getResponseCode() != 200 && connect.getHeaderField("Error") != null) {
                returnMsg = returnMsg + "\n" + connect.getHeaderField("Error");
            }
            out.close();
            connect.disconnect();
            this.OkButton.setEnabled(!success);
        }
        catch (UnsupportedEncodingException ignore) {
        }
        catch (MalformedURLException e) {
            this.OutputDisplay.setText(I18n.tr((String)"Error while uploading"));
            e.printStackTrace();
        }
    }

    private boolean checkForErrors(String username, String password, String description, GpxData gpxData) {
        String errors = "";
        if (description == null || description.length() == 0) {
            errors = errors + I18n.tr((String)"No description provided. Please provide some description.");
        }
        if (gpxData == null) {
            errors = errors + I18n.tr((String)"No GPX layer selected. Cannot upload a trace.");
        }
        if (username == null || username.length() == 0) {
            errors = errors + I18n.tr((String)"No username provided.");
        }
        if (password == null || password.length() == 0) {
            errors = errors + I18n.tr((String)"No password provided.");
        }
        this.OutputDisplay.setText(errors);
        return errors.length() > 0;
    }

    private boolean checkForGPXLayer() {
        if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getActiveLayer() == null || !(Main.map.mapView.getActiveLayer() instanceof GpxLayer)) {
            this.OutputDisplay.setText(I18n.tr((String)"No GPX layer selected. Cannot upload a trace."));
            return true;
        }
        return false;
    }

    private void OkButtonActionPerformed(ActionEvent evt) {
        if (this.checkForGPXLayer()) {
            return;
        }
        PleaseWaitRunnable uploadTask = new PleaseWaitRunnable(I18n.tr((String)"Uploading GPX Track")){

            protected void realRun() throws IOException {
                UploadDataGui.this.setAlwaysOnTop(false);
                UploadDataGui.this.upload(Main.pref.get("osm-server.username"), Main.pref.get("osm-server.password"), UploadDataGui.this.descriptionField.getText(), UploadDataGui.this.tagsField.getText(), UploadDataGui.this.publicCheckbox.isSelected(), ((GpxLayer)Main.map.mapView.getActiveLayer()).data);
            }

            protected void finish() {
                UploadDataGui.this.setAlwaysOnTop(true);
            }

            protected void cancel() {
            }
        };
        Main.worker.execute((Runnable)uploadTask);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void writeContentDisposition(DataOutputStream out, String name, String value) throws IOException {
        out.writeBytes("------------------------------d10f7aa230e8\r\n");
        out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"" + LINE_END);
        out.writeBytes(LINE_END);
        byte[] temp = value.getBytes("UTF-8");
        out.write(temp, 0, temp.length);
        out.writeBytes(LINE_END);
    }

    private void writeContentDispositionGpxData(DataOutputStream out, String name, GpxData gpxData) throws IOException {
        out.writeBytes("------------------------------d10f7aa230e8\r\n");
        out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + this.datename + ".gpx" + "\"" + LINE_END);
        out.writeBytes("Content-Type: application/octet-stream\r\n");
        out.writeBytes(LINE_END);
        new GpxWriter((OutputStream)out).write(gpxData);
        out.flush();
        out.writeBytes(LINE_END);
    }
}

