/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.DelegatingCodeBaseEntry;
import edu.umd.cs.findbugs.classfile.impl.DelegatingCodeBaseIterator;
import edu.umd.cs.findbugs.classfile.impl.NestedZipFileCodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.ZipCodeBaseFactory;
import edu.umd.cs.findbugs.io.IO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NestedZipFileCodeBase
extends AbstractScannableCodeBase {
    private final ICodeBase parentCodeBase;
    private final String resourceName;
    private File tempFile;
    private AbstractScannableCodeBase delegateCodeBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NestedZipFileCodeBase(NestedZipFileCodeBaseLocator codeBaseLocator) throws ResourceNotFoundException, IOException {
        BufferedOutputStream outputStream;
        block6: {
            super(codeBaseLocator);
            this.parentCodeBase = codeBaseLocator.getParentCodeBase();
            this.resourceName = codeBaseLocator.getResourceName();
            InputStream inputStream = null;
            outputStream = null;
            try {
                this.tempFile = File.createTempFile("spotbugs", ".zip");
                this.tempFile.deleteOnExit();
                ICodeBaseEntry resource = this.parentCodeBase.lookupResource(this.resourceName);
                if (resource == null) {
                    throw new ResourceNotFoundException(this.resourceName);
                }
                inputStream = resource.openResource();
                outputStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
                IO.copy(inputStream, outputStream);
                ((OutputStream)outputStream).flush();
                this.delegateCodeBase = ZipCodeBaseFactory.makeZipCodeBase(codeBaseLocator, this.tempFile);
                if (inputStream == null) break block6;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    IO.close(inputStream);
                }
                if (outputStream != null) {
                    IO.close(outputStream);
                }
                throw throwable;
            }
            IO.close(inputStream);
        }
        if (outputStream != null) {
            IO.close(outputStream);
        }
    }

    @Override
    public ICodeBaseIterator iterator() throws InterruptedException {
        return new DelegatingCodeBaseIterator(this, this.delegateCodeBase);
    }

    @Override
    public ICodeBaseEntry lookupResource(String resourceName) {
        ICodeBaseEntry delegateCodeBaseEntry = this.delegateCodeBase.lookupResource(resourceName);
        if (delegateCodeBaseEntry == null) {
            return null;
        }
        return new DelegatingCodeBaseEntry(this, delegateCodeBaseEntry);
    }

    @Override
    public String getPathName() {
        return null;
    }

    @Override
    public void close() {
        this.delegateCodeBase.close();
        if (!this.tempFile.delete()) {
            AnalysisContext.logError("Could not delete " + this.tempFile);
        }
    }
}

