/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class TerracerAction
extends JosmAction {
    public TerracerAction() {
        super(I18n.tr((String)"Terrace a building"), "terrace", I18n.tr((String)"Creates individual buildings from a long building."), Shortcut.registerShortcut((String)"tools:Terracer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Terrace a building")}), (int)84, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = Main.ds.getSelected();
        boolean badSelect = false;
        if (sel.size() == 1) {
            OsmPrimitive prim = (OsmPrimitive)sel.iterator().next();
            if (prim instanceof Way) {
                Way way = (Way)prim;
                if (way.nodes.size() == 5 && way.isClosed().booleanValue()) {
                    String answer = JOptionPane.showInputDialog(I18n.tr((String)"How many buildings are in the terrace?"));
                    if (answer != null) {
                        int nb = Integer.parseInt(answer);
                        this.terraceBuilding(way, nb);
                    }
                } else {
                    badSelect = true;
                }
            } else {
                badSelect = true;
            }
        } else {
            badSelect = true;
        }
        if (badSelect) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Select a single, closed way of four nodes."));
        }
    }

    private void terraceBuilding(Way w, int nb) {
        Node[] nodes = w.nodes.toArray(new Node[0]);
        double side1 = nodes[0].coor.greatCircleDistance(nodes[1].coor);
        double side2 = nodes[0].coor.greatCircleDistance(nodes[3].coor);
        Node[][] new_nodes = new Node[2][nb + 1];
        if (side1 > side2) {
            new_nodes[0][0] = nodes[0];
            new_nodes[0][nb] = nodes[1];
            new_nodes[1][0] = nodes[3];
            new_nodes[1][nb] = nodes[2];
        } else {
            new_nodes[0][0] = nodes[0];
            new_nodes[0][nb] = nodes[3];
            new_nodes[1][0] = nodes[1];
            new_nodes[1][nb] = nodes[2];
        }
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        LinkedList<Way> ways = new LinkedList<Way>();
        int i = 1;
        while (i < nb) {
            new_nodes[0][i] = this.interpolateNode(new_nodes[0][0], new_nodes[0][nb], (double)i / (double)nb);
            new_nodes[1][i] = this.interpolateNode(new_nodes[1][0], new_nodes[1][nb], (double)i / (double)nb);
            commands.add(new AddCommand((OsmPrimitive)new_nodes[0][i]));
            commands.add(new AddCommand((OsmPrimitive)new_nodes[1][i]));
            ++i;
        }
        i = 0;
        while (i < nb) {
            Way terr = new Way();
            terr.nodes.add(new_nodes[0][i]);
            terr.nodes.add(new_nodes[0][i + 1]);
            terr.nodes.add(new_nodes[1][i + 1]);
            terr.nodes.add(new_nodes[1][i]);
            terr.nodes.add(new_nodes[0][i]);
            ways.add(terr);
            commands.add(new AddCommand((OsmPrimitive)terr));
            ++i;
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Terrace"), commands));
        Main.ds.setSelected(ways);
    }

    private Node interpolateNode(Node a, Node b, double f) {
        Node n = new Node(new LatLon(a.coor.lat() * (1.0 - f) + b.coor.lat() * f, a.coor.lon() * (1.0 - f) + b.coor.lon() * f));
        return n;
    }
}

