/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastrePreferenceSetting;
import cadastre_fr.CheckSourceUploadHook;
import cadastre_fr.MenuActionBoundaries;
import cadastre_fr.MenuActionGrab;
import cadastre_fr.MenuActionLambertZone;
import cadastre_fr.MenuActionLoadFromCache;
import cadastre_fr.MenuActionNewLocation;
import cadastre_fr.MenuActionResetCookie;
import cadastre_fr.WMSAdjustAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;

public class CadastrePlugin
extends Plugin {
    static String VERSION = "0.8";
    static JMenu cadastreJMenu;
    public static CadastreGrabber cadastreGrabber;
    public static String source;
    public static boolean autoSourcing;
    public static boolean pluginUsed;
    public static String cacheDir;
    public static boolean alterColors;
    public static String colorBackground;
    public static boolean backgroundTransparent;
    public static float transparency;
    public static boolean drawBoundaries;
    private static boolean menuEnabled;

    public CadastrePlugin() throws Exception {
        System.out.println("Pluging \"french cadastre\" started...");
        if (!Main.proj.toString().equals(new Lambert().toString())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"To enable the cadastre WMS plugin, change\nthe JOSM projection to Lambert and restart"));
            return;
        }
        if (Main.pref.get("cadastrewms.cacheDir").equals("")) {
            cacheDir = Main.pref.getPreferencesDir() + "plugins/cadastrewms/";
        } else {
            cacheDir = Main.pref.get("cadastrewms.cacheDir");
            if (cacheDir.charAt(cacheDir.length() - 1) != '\\') {
                cacheDir = cacheDir + '\\';
            }
        }
        System.out.println("current cache directory: " + cacheDir);
        CadastrePlugin.refreshConfiguration();
        this.refreshMenu();
        LinkedList hooks = ((UploadAction)Main.main.menu.upload).uploadHooks;
        hooks.add(0, new CheckSourceUploadHook());
    }

    public void refreshMenu() throws Exception {
        MainMenu menu = Main.main.menu;
        if (cadastreJMenu == null) {
            cadastreJMenu = new JMenu(I18n.tr((String)"Cadastre"));
            cadastreJMenu.setMnemonic(67);
            menu.add((Component)cadastreJMenu, menu.getMenuCount() - 2);
            MenuActionGrab grab = new MenuActionGrab();
            JMenuItem menuGrab = new JMenuItem((Action)((Object)grab));
            KeyStroke ks = grab.getShortcut().getKeyStroke();
            if (ks != null) {
                menuGrab.setAccelerator(ks);
            }
            JMenuItem menuSettings = new JMenuItem((Action)((Object)new MenuActionNewLocation()));
            final JCheckBoxMenuItem menuSource = new JCheckBoxMenuItem(I18n.tr((String)"Auto sourcing"));
            menuSource.setSelected(autoSourcing);
            menuSource.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    Main.pref.put("cadastrewms.autosourcing", menuSource.isSelected());
                    autoSourcing = menuSource.isSelected();
                }
            });
            JMenuItem menuResetCookie = new JMenuItem((Action)((Object)new MenuActionResetCookie()));
            JMenuItem menuLambertZone = new JMenuItem((Action)((Object)new MenuActionLambertZone()));
            JMenuItem menuLoadFromCache = new JMenuItem((Action)((Object)new MenuActionLoadFromCache()));
            JMenuItem menuActionBoundaries = new JMenuItem((Action)((Object)new MenuActionBoundaries()));
            cadastreJMenu.add(menuGrab);
            cadastreJMenu.add(menuSettings);
            cadastreJMenu.add(menuSource);
            cadastreJMenu.add(menuResetCookie);
            cadastreJMenu.add(menuLambertZone);
            cadastreJMenu.add(menuLoadFromCache);
            cadastreJMenu.add(menuActionBoundaries);
        }
        this.setEnabledAll(menuEnabled);
    }

    public static void refreshConfiguration() {
        source = Main.pref.get("cadastrewms.source", "cadastre-dgi-fr source : Direction G\u00e9n\u00e9rale des Imp\u00f4ts - Cadastre ; mise \u00e0 jour : AAAA");
        autoSourcing = Main.pref.getBoolean("cadastrewms.autosourcing", true);
        alterColors = Main.pref.getBoolean("cadastrewms.alterColors");
        drawBoundaries = Main.pref.getBoolean("cadastrewms.drawBoundaries", false);
        colorBackground = Main.pref.get("color.background", "#FFFFFF");
        if (alterColors) {
            backgroundTransparent = Main.pref.getBoolean("cadastrewms.backgroundTransparent");
            transparency = Float.parseFloat(Main.pref.get("cadastrewms.brightness", "1.0f"));
        } else {
            backgroundTransparent = false;
            transparency = 1.0f;
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new CadastrePreferenceSetting();
    }

    private void setEnabledAll(boolean isEnabled) {
        for (int i = 0; i < cadastreJMenu.getItemCount(); ++i) {
            JMenuItem item = cadastreJMenu.getItem(i);
            if (item == null) continue;
            if (item.getText().equals(MenuActionGrab.name) || item.getText().equals(MenuActionBoundaries.name)) {
                item.setEnabled(isEnabled);
                continue;
            }
            if (!item.getText().equals(MenuActionLambertZone.name)) continue;
            item.setEnabled(!isEnabled);
        }
        menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (cadastreJMenu != null) {
            if (oldFrame == null && newFrame != null) {
                this.setEnabledAll(true);
                Main.map.addMapMode(new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
            } else if (oldFrame != null && newFrame == null) {
                this.setEnabledAll(false);
                Lambert.layoutZone = -1;
            }
        }
    }

    static {
        cadastreGrabber = new CadastreGrabber();
        source = "";
        autoSourcing = false;
        pluginUsed = false;
        cacheDir = null;
        alterColors = false;
        backgroundTransparent = false;
        transparency = 1.0f;
        drawBoundaries = false;
        menuEnabled = false;
    }
}

