/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.helper.DefI18nSource;
import wiremock.com.github.jknack.handlebars.helper.I18nSource;
import wiremock.com.github.jknack.handlebars.internal.Locales;
import wiremock.org.apache.commons.lang3.StringUtils;
import wiremock.org.apache.commons.lang3.Validate;

public enum I18nHelper implements Helper<String>
{
    i18n{

        @Override
        public Object apply(String key, Options options) throws IOException {
            Validate.notEmpty(key, "found: '%s', expected 'bundle's key'", key);
            Locale locale = Locales.fromString((String)options.hash("locale", this.defaultLocale.toString()));
            String baseName = (String)options.hash("bundle", this.defaultBundle);
            ClassLoader classLoader = (ClassLoader)options.hash("classLoader", this.getClass().getClassLoader());
            I18nSource localSource = this.source == null ? new DefI18nSource(baseName, locale, classLoader) : this.source;
            return localSource.message(key, locale, options.params);
        }
    }
    ,
    i18nJs{
        private final Pattern pattern = Pattern.compile("\\{(\\d+)\\}");

        @Override
        public Object apply(String localeName, Options options) throws IOException {
            String[] keys;
            Locale locale = Locales.fromString(StringUtils.defaultIfEmpty(localeName, this.defaultLocale.toString()));
            String baseName = (String)options.hash("bundle", this.defaultBundle);
            ClassLoader classLoader = (ClassLoader)options.hash("classLoader", this.getClass().getClassLoader());
            I18nSource localSource = this.source == null ? new DefI18nSource(baseName, locale, classLoader) : this.source;
            StringBuilder buffer = new StringBuilder();
            Boolean wrap = (Boolean)options.hash("wrap", true);
            if (wrap.booleanValue()) {
                buffer.append("<script type='text/javascript'>\n");
            }
            buffer.append("  /* ").append(locale.getDisplayName()).append(" */\n");
            buffer.append("  I18n.translations = I18n.translations || {};\n");
            buffer.append("  I18n.translations['").append(locale.toString()).append("'] = {\n");
            StringBuilder body = new StringBuilder();
            String separator = ",\n";
            for (String key : keys = localSource.keys(baseName, locale)) {
                String message = this.message(localSource.message(key, locale, new Object[0]));
                body.append("    \"").append(key).append("\": ");
                body.append("\"").append(message).append("\"").append(separator);
            }
            if (body.length() > 0) {
                body.setLength(body.length() - separator.length());
                buffer.append((CharSequence)body);
            }
            buffer.append("\n  };\n");
            if (wrap.booleanValue()) {
                buffer.append("</script>\n");
            }
            return new Handlebars.SafeString(buffer);
        }

        private String message(String message) {
            CharSequence escapedMessage = Handlebars.Utils.escapeExpression(message);
            Matcher matcher = this.pattern.matcher(escapedMessage);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(result, "{{arg" + matcher.group(1) + "}}");
            }
            matcher.appendTail(result);
            return result.toString();
        }
    };

    protected Locale defaultLocale = Locale.getDefault();
    protected String defaultBundle = "messages";
    protected I18nSource source;

    public void setSource(I18nSource source) {
        this.source = Validate.notNull(source, "The i18n source is required.", new Object[0]);
    }

    public void setDefaultBundle(String bundle) {
        this.defaultBundle = Validate.notEmpty(bundle, "A bundle's name is required.", new Object[0]);
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = Validate.notNull(locale, "A locale is required.", new Object[0]);
    }
}

