/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.net.URI;
import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;
import wiremock.org.apache.commons.lang3.StringUtils;

public class SafeNames {
    private static final Pattern NON_ALPHANUMERIC = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    public static String makeSafeFileName(StubMapping mapping) {
        return SafeNames.makeSafeFileName(mapping, "json");
    }

    public static String makeSafeFileName(StubMapping mapping, String extension) {
        String suffix = "-" + mapping.getId() + "." + extension;
        if (StringUtils.isNotEmpty(mapping.getName())) {
            return SafeNames.makeSafeName(mapping.getName()) + suffix;
        }
        UrlPattern urlMatcher = mapping.getRequest().getUrlMatcher();
        if (urlMatcher.getPattern() instanceof AnythingPattern) {
            return suffix.substring(1);
        }
        String expectedUrl = urlMatcher.getExpected();
        URI uri = URI.create(SafeNames.sanitise(expectedUrl));
        return SafeNames.makeSafeNameFromUrl(uri.getPath()) + suffix;
    }

    public static String makeSafeNameFromUrl(String urlPath) {
        String startingPath = urlPath.replace("/", "_");
        return SafeNames.makeSafeName(startingPath);
    }

    public static String makeSafeName(String name) {
        String nowhitespace = WHITESPACE.matcher(name).replaceAll("-");
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        String slug = SafeNames.sanitise(normalized);
        slug = slug.replaceAll("^[_]*", "");
        slug = slug.replaceAll("[_]*$", "");
        slug = StringUtils.truncate(slug, 200);
        return slug.toLowerCase(Locale.ENGLISH);
    }

    private static String sanitise(String s) {
        return NON_ALPHANUMERIC.matcher(s).replaceAll("");
    }
}

