/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.pollinterval;

import java.util.concurrent.TimeUnit;
import org.awaitility.Duration;
import org.awaitility.pollinterval.PollInterval;

public class FibonacciPollInterval
implements PollInterval {
    private static final int DEFAULT_OFFSET = 0;
    private final TimeUnit timeUnit;
    private final int offset;

    public FibonacciPollInterval() {
        this(TimeUnit.MILLISECONDS);
    }

    public FibonacciPollInterval(TimeUnit timeUnit) {
        this(0, timeUnit);
    }

    public FibonacciPollInterval(int offset, TimeUnit timeUnit) {
        if (offset <= -1) {
            throw new IllegalArgumentException("Offset must be greater than or equal to -1");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit cannot be null");
        }
        this.offset = offset;
        this.timeUnit = timeUnit;
    }

    @Override
    public Duration next(int pollCount, Duration previousDuration) {
        return new Duration(this.fibonacci(this.offset + pollCount), this.timeUnit);
    }

    public static FibonacciPollInterval fibonacci() {
        return new FibonacciPollInterval();
    }

    public static FibonacciPollInterval fibonacci(TimeUnit timeUnit) {
        return new FibonacciPollInterval(timeUnit);
    }

    public static FibonacciPollInterval fibonacci(int offset, TimeUnit timeUnit) {
        return new FibonacciPollInterval(offset, timeUnit);
    }

    public FibonacciPollInterval with() {
        return this;
    }

    public FibonacciPollInterval and() {
        return this;
    }

    public FibonacciPollInterval timeUnit(TimeUnit unit) {
        return new FibonacciPollInterval(this.offset, unit);
    }

    public FibonacciPollInterval offset(int offset) {
        return new FibonacciPollInterval(offset, this.timeUnit);
    }

    protected int fibonacci(int value) {
        return this.fib(value, 1, 0);
    }

    private int fib(int value, int current, int previous) {
        if (value == 0) {
            return previous;
        }
        if (value == 1) {
            return current;
        }
        return this.fib(value - 1, current + previous, current);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FibonacciPollInterval)) {
            return false;
        }
        FibonacciPollInterval that = (FibonacciPollInterval)o;
        return this.offset == that.offset && this.timeUnit == that.timeUnit;
    }

    public int hashCode() {
        int result = this.timeUnit.hashCode();
        result = 31 * result + this.offset;
        return result;
    }

    public String toString() {
        return "FibonacciPollInterval{offset=" + this.offset + ", timeUnit=" + (Object)((Object)this.timeUnit) + '}';
    }
}

