/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.jqno.equalsverifier.internal.reflection.SuperclassIterable;

public final class FieldIterable
implements Iterable<Field> {
    private final Class<?> type;
    private final boolean includeSuperclasses;

    private FieldIterable(Class<?> type, boolean includeSuperclasses) {
        this.type = type;
        this.includeSuperclasses = includeSuperclasses;
    }

    public static FieldIterable of(Class<?> type) {
        return new FieldIterable(type, true);
    }

    public static FieldIterable ofIgnoringSuper(Class<?> type) {
        return new FieldIterable(type, false);
    }

    @Override
    public Iterator<Field> iterator() {
        return this.createFieldList().iterator();
    }

    private List<Field> createFieldList() {
        ArrayList<Field> result = new ArrayList<Field>();
        result.addAll(this.addFieldsFor(this.type));
        if (this.includeSuperclasses) {
            for (Class<?> c : SuperclassIterable.of(this.type)) {
                result.addAll(this.addFieldsFor(c));
            }
        }
        return result;
    }

    private List<Field> addFieldsFor(Class<?> c) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : c.getDeclaredFields()) {
            if (field.isSynthetic() || "__cobertura_counters".equals(field.getName())) continue;
            result.add(field);
        }
        return result;
    }
}

