/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.ModifierReviewable;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatcher;

public class ModifierMatcher<T extends ModifierReviewable>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final Mode mode;

    public ModifierMatcher(Mode mode) {
        this.mode = mode;
    }

    @Override
    public boolean matches(T target) {
        return (this.mode.getModifiers() & target.getModifiers()) != 0;
    }

    public String toString() {
        return this.mode.getDescription();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifierMatcher)) {
            return false;
        }
        ModifierMatcher other = (ModifierMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Mode this$mode = this.mode;
        Mode other$mode = other.mode;
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifierMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Mode $mode = this.mode;
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    public static enum Mode {
        PUBLIC(1, "isPublic()"),
        PROTECTED(4, "isProtected()"),
        PRIVATE(2, "isPrivate()"),
        FINAL(16, "isFinal()"),
        STATIC(8, "isStatic()"),
        SYNCHRONIZED(32, "isSynchronized()"),
        NATIVE(256, "isNative()"),
        STRICT(2048, "isStrict()"),
        VAR_ARGS(128, "isVarArgs()"),
        SYNTHETIC(4096, "isSynthetic()"),
        BRIDGE(64, "isBridge()"),
        ABSTRACT(1024, "isAbstract()"),
        INTERFACE(512, "isInterface()"),
        ANNOTATION(8192, "isAnnotation()"),
        VOLATILE(64, "isVolatile()"),
        TRANSIENT(128, "isTransient()"),
        MANDATED(32768, "isMandated()"),
        ENUMERATION(16384, "isEnum()");

        private final int modifiers;
        private final String description;

        private Mode(int modifiers, String description) {
            this.modifiers = modifiers;
            this.description = description;
        }

        protected String getDescription() {
            return this.description;
        }

        protected int getModifiers() {
            return this.modifiers;
        }

        public String toString() {
            return "ModifierMatcher.Mode." + this.name();
        }
    }
}

