/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatcher;

public class CollectionOneToOneMatcher<T>
extends ElementMatcher.Junction.AbstractBase<Iterable<? extends T>> {
    private final List<? extends ElementMatcher<? super T>> matchers;

    public CollectionOneToOneMatcher(List<? extends ElementMatcher<? super T>> matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean matches(Iterable<? extends T> target) {
        if (target instanceof Collection && ((Collection)target).size() != this.matchers.size()) {
            return false;
        }
        Iterator<ElementMatcher<T>> iterator = this.matchers.iterator();
        for (T value : target) {
            if (iterator.hasNext() && iterator.next().matches(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("containing(");
        boolean first = true;
        for (ElementMatcher<? super T> elementMatcher : this.matchers) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(elementMatcher);
        }
        return stringBuilder.append(")").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionOneToOneMatcher)) {
            return false;
        }
        CollectionOneToOneMatcher other = (CollectionOneToOneMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ElementMatcher<T>> this$matchers = this.matchers;
        List<? extends ElementMatcher<? super T>> other$matchers = other.matchers;
        return !(this$matchers == null ? other$matchers != null : !((Object)this$matchers).equals(other$matchers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionOneToOneMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ElementMatcher<T>> $matchers = this.matchers;
        result = result * 59 + ($matchers == null ? 43 : ((Object)$matchers).hashCode());
        return result;
    }
}

