/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading.ClassLoadingStrategy;

public abstract class InjectionClassLoader
extends ClassLoader {
    protected InjectionClassLoader(ClassLoader parent) {
        super(parent);
    }

    public abstract Class<?> defineClass(String var1, byte[] var2) throws ClassNotFoundException;

    public abstract Map<String, Class<?>> defineClasses(Map<String, byte[]> var1) throws ClassNotFoundException;

    public static enum Strategy implements ClassLoadingStrategy<InjectionClassLoader>
    {
        INSTANCE;


        @Override
        public Map<TypeDescription, Class<?>> load(InjectionClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot add types to bootstrap class loader: " + types);
            }
            LinkedHashMap<String, byte[]> typeDefinitions = new LinkedHashMap<String, byte[]>();
            HashMap<String, TypeDescription> typeDescriptions = new HashMap<String, TypeDescription>();
            for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
                typeDefinitions.put(entry.getKey().getName(), entry.getValue());
                typeDescriptions.put(entry.getKey().getName(), entry.getKey());
            }
            HashMap loadedTypes = new HashMap();
            try {
                for (Map.Entry<String, Class<?>> entry : classLoader.defineClasses(typeDefinitions).entrySet()) {
                    loadedTypes.put((TypeDescription)typeDescriptions.get(entry.getKey()), entry.getValue());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("Cannot load classes: " + types, classNotFoundException);
            }
            return loadedTypes;
        }
    }
}

