/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.List;
import net.sourceforge.pmd.properties.AbstractMultiPackagedProperty;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.properties.builders.MultiPackagedPropertyBuilder;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorBuilderConversionWrapper;
import net.sourceforge.pmd.properties.modules.TypePropertyModule;

public final class TypeMultiProperty
extends AbstractMultiPackagedProperty<Class> {
    public TypeMultiProperty(String theName, String theDescription, List<Class> theDefaults, String[] legalPackageNames, float theUIOrder) {
        this(theName, theDescription, theDefaults, legalPackageNames, theUIOrder, false);
    }

    private TypeMultiProperty(String theName, String theDescription, List<Class> theTypeDefaults, String[] legalPackageNames, float theUIOrder, boolean isDefinedExternally) {
        super(theName, theDescription, theTypeDefaults, theUIOrder, isDefinedExternally, new TypePropertyModule(legalPackageNames, theTypeDefaults));
    }

    public TypeMultiProperty(String theName, String theDescription, String theTypeDefaults, String[] legalPackageNames, float theUIOrder) {
        this(theName, theDescription, TypeMultiProperty.typesFrom(theTypeDefaults), legalPackageNames, theUIOrder, false);
    }

    @Override
    public Class<Class> type() {
        return Class.class;
    }

    @Override
    public String asString(Class value) {
        return value == null ? "" : value.getName();
    }

    @Override
    protected Class createFrom(String toParse) {
        return ValueParserConstants.CLASS_PARSER.valueOf(toParse);
    }

    @Override
    public List<Class> valueFrom(String valueString) {
        return TypeMultiProperty.typesFrom(valueString);
    }

    private static List<Class> typesFrom(String valueString) {
        return ValueParserConstants.parsePrimitives(valueString, '|', ValueParserConstants.CLASS_PARSER);
    }

    public static PropertyDescriptorBuilderConversionWrapper.MultiValue.Packaged<Class, TypeMultiPBuilder> extractor() {
        return new PropertyDescriptorBuilderConversionWrapper.MultiValue.Packaged<Class, TypeMultiPBuilder>(Class.class, ValueParserConstants.CLASS_PARSER){

            @Override
            protected TypeMultiPBuilder newBuilder(String name) {
                return new TypeMultiPBuilder(name);
            }
        };
    }

    public static TypeMultiPBuilder named(String name) {
        return new TypeMultiPBuilder(name);
    }

    public static final class TypeMultiPBuilder
    extends MultiPackagedPropertyBuilder<Class, TypeMultiPBuilder> {
        private TypeMultiPBuilder(String name) {
            super(name);
        }

        public TypeMultiProperty build() {
            return new TypeMultiProperty(this.name, this.description, this.defaultValues, this.legalPackageNames, this.uiOrder, this.isDefinedInXML);
        }
    }
}

