/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.properties.AbstractMultiValueProperty;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.properties.builders.MultiValuePropertyBuilder;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorBuilderConversionWrapper;
import org.apache.commons.lang3.StringUtils;

public final class StringMultiProperty
extends AbstractMultiValueProperty<String> {
    public StringMultiProperty(String theName, String theDescription, String[] defaultValues, float theUIOrder, char delimiter) {
        this(theName, theDescription, Arrays.asList(defaultValues), theUIOrder, delimiter);
    }

    public StringMultiProperty(String theName, String theDescription, List<String> defaultValues, float theUIOrder, char delimiter) {
        this(theName, theDescription, defaultValues, theUIOrder, delimiter, false);
    }

    private StringMultiProperty(String theName, String theDescription, List<String> defaultValues, float theUIOrder, char delimiter, boolean isDefinedExternally) {
        super(theName, theDescription, defaultValues, theUIOrder, delimiter, isDefinedExternally);
        StringMultiProperty.checkDefaults(defaultValues, delimiter);
    }

    @Override
    public Class<String> type() {
        return String.class;
    }

    @Override
    public List<String> valueFrom(String valueString) {
        return Arrays.asList(StringUtils.split((String)valueString, (char)this.multiValueDelimiter()));
    }

    @Override
    protected String valueErrorFor(String value) {
        if (value == null) {
            return "Missing value";
        }
        if (this.containsDelimiter(value)) {
            return "Value cannot contain the '" + this.multiValueDelimiter() + "' character";
        }
        return null;
    }

    private boolean containsDelimiter(String value) {
        return value.indexOf(this.multiValueDelimiter()) >= 0;
    }

    @Override
    protected String createFrom(String toParse) {
        return toParse;
    }

    private static void checkDefaults(List<String> defaultValue, char delim) {
        if (defaultValue == null) {
            return;
        }
        for (String aDefaultValue : defaultValue) {
            if (aDefaultValue.indexOf(delim) < 0) continue;
            throw new IllegalArgumentException("Cannot include the delimiter in the set of defaults");
        }
    }

    static PropertyDescriptorBuilderConversionWrapper.MultiValue<String, StringMultiPBuilder> extractor() {
        return new PropertyDescriptorBuilderConversionWrapper.MultiValue<String, StringMultiPBuilder>(String.class, ValueParserConstants.STRING_PARSER){

            @Override
            protected StringMultiPBuilder newBuilder(String name) {
                return new StringMultiPBuilder(name);
            }
        };
    }

    public static StringMultiPBuilder named(String name) {
        return new StringMultiPBuilder(name);
    }

    public static final class StringMultiPBuilder
    extends MultiValuePropertyBuilder<String, StringMultiPBuilder> {
        private StringMultiPBuilder(String name) {
            super(name);
        }

        public StringMultiProperty build() {
            return new StringMultiProperty(this.name, this.description, this.defaultValues, this.uiOrder, this.multiValueDelimiter, this.isDefinedInXML);
        }
    }
}

