/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.properties.AbstractMultiNumericProperty;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.properties.builders.MultiNumericPropertyBuilder;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorBuilderConversionWrapper;

public final class IntegerMultiProperty
extends AbstractMultiNumericProperty<Integer> {
    public IntegerMultiProperty(String theName, String theDescription, Integer min, Integer max, Integer[] defaultValues, float theUIOrder) {
        this(theName, theDescription, min, max, Arrays.asList(defaultValues), theUIOrder, false);
    }

    private IntegerMultiProperty(String theName, String theDescription, Integer min, Integer max, List<Integer> defaultValues, float theUIOrder, boolean isDefinedExternally) {
        super(theName, theDescription, min, max, defaultValues, theUIOrder, isDefinedExternally);
    }

    public IntegerMultiProperty(String theName, String theDescription, Integer min, Integer max, List<Integer> defaultValues, float theUIOrder) {
        this(theName, theDescription, min, max, defaultValues, theUIOrder, false);
    }

    @Override
    public Class<Integer> type() {
        return Integer.class;
    }

    @Override
    protected Integer createFrom(String toParse) {
        return Integer.valueOf(toParse);
    }

    static PropertyDescriptorBuilderConversionWrapper.MultiValue.Numeric<Integer, IntegerMultiPBuilder> extractor() {
        return new PropertyDescriptorBuilderConversionWrapper.MultiValue.Numeric<Integer, IntegerMultiPBuilder>(Integer.class, ValueParserConstants.INTEGER_PARSER){

            @Override
            protected IntegerMultiPBuilder newBuilder(String name) {
                return new IntegerMultiPBuilder(name);
            }
        };
    }

    public static IntegerMultiPBuilder named(String name) {
        return new IntegerMultiPBuilder(name);
    }

    public static final class IntegerMultiPBuilder
    extends MultiNumericPropertyBuilder<Integer, IntegerMultiPBuilder> {
        private IntegerMultiPBuilder(String name) {
            super(name);
        }

        public IntegerMultiProperty build() {
            return new IntegerMultiProperty(this.name, this.description, (Integer)this.lowerLimit, (Integer)this.upperLimit, this.defaultValues, this.uiOrder, this.isDefinedInXML);
        }
    }
}

