/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Map;
import net.sourceforge.pmd.properties.AbstractSingleValueProperty;
import net.sourceforge.pmd.properties.EnumeratedPropertyDescriptor;
import net.sourceforge.pmd.properties.builders.SingleValuePropertyBuilder;
import net.sourceforge.pmd.properties.modules.EnumeratedPropertyModule;
import net.sourceforge.pmd.util.CollectionUtil;

public final class EnumeratedProperty<E>
extends AbstractSingleValueProperty<E>
implements EnumeratedPropertyDescriptor<E, E> {
    private final EnumeratedPropertyModule<E> module;

    @Deprecated
    public EnumeratedProperty(String theName, String theDescription, String[] theLabels, E[] theChoices, int defaultIndex, Class<E> valueType, float theUIOrder) {
        this(theName, theDescription, CollectionUtil.mapFrom(theLabels, theChoices), theChoices[defaultIndex], valueType, theUIOrder, false);
    }

    @Deprecated
    public EnumeratedProperty(String theName, String theDescription, String[] theLabels, E[] theChoices, int defaultIndex, float theUIOrder) {
        this(theName, theDescription, CollectionUtil.mapFrom(theLabels, theChoices), theChoices[defaultIndex], null, theUIOrder, false);
    }

    public EnumeratedProperty(String theName, String theDescription, Map<String, E> labelsToChoices, E defaultValue, Class<E> valueType, float theUIOrder) {
        this(theName, theDescription, labelsToChoices, defaultValue, valueType, theUIOrder, false);
    }

    private EnumeratedProperty(String theName, String theDescription, Map<String, E> labelsToChoices, E defaultValue, Class<E> valueType, float theUIOrder, boolean isDefinedExternally) {
        super(theName, theDescription, defaultValue, theUIOrder, isDefinedExternally);
        this.module = new EnumeratedPropertyModule<E>(labelsToChoices, valueType);
        this.module.checkValue(defaultValue);
    }

    @Override
    public Class<E> type() {
        return this.module.getValueType();
    }

    @Override
    public String errorFor(E value) {
        return this.module.errorFor(value);
    }

    @Override
    public E createFrom(String value) throws IllegalArgumentException {
        return this.module.choiceFrom(value);
    }

    @Override
    public String asString(E value) {
        return this.module.getLabelsByChoice().get(value);
    }

    @Override
    public Map<String, E> mappings() {
        return this.module.getChoicesByLabel();
    }

    public static <E> EnumPBuilder<E> named(String name) {
        return new EnumPBuilder(name);
    }

    public static final class EnumPBuilder<E>
    extends SingleValuePropertyBuilder<E, EnumPBuilder<E>> {
        private Class<E> valueType;
        private Map<String, E> mappings;

        private EnumPBuilder(String name) {
            super(name);
        }

        public EnumPBuilder<E> type(Class<E> type) {
            this.valueType = type;
            return this;
        }

        public EnumPBuilder<E> mappings(Map<String, E> map) {
            this.mappings = map;
            return this;
        }

        @Override
        public EnumeratedProperty<E> build() {
            return new EnumeratedProperty(this.name, this.description, this.mappings, this.defaultValue, this.valueType, this.uiOrder, this.isDefinedInXML);
        }
    }
}

