/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.datasource.DataSource;

public class PmdRunnable
implements Callable<Report> {
    private static final Logger LOG = Logger.getLogger(PmdRunnable.class.getName());
    private static final ThreadLocal<ThreadContext> LOCAL_THREAD_CONTEXT = new ThreadLocal();
    private final DataSource dataSource;
    private final String fileName;
    private final List<Renderer> renderers;
    private final RuleContext ruleContext;
    private final RuleSets ruleSets;
    private final SourceCodeProcessor sourceCodeProcessor;

    public PmdRunnable(DataSource dataSource, String fileName, List<Renderer> renderers, RuleContext ruleContext, RuleSets ruleSets, SourceCodeProcessor sourceCodeProcessor) {
        this.ruleSets = ruleSets;
        this.dataSource = dataSource;
        this.fileName = fileName;
        this.renderers = renderers;
        this.ruleContext = ruleContext;
        this.sourceCodeProcessor = sourceCodeProcessor;
    }

    public static void reset() {
        LOCAL_THREAD_CONTEXT.remove();
    }

    private void addError(Report report, Exception e, String errorMessage) {
        LOG.log(Level.FINE, errorMessage, e);
        report.addError(new Report.ProcessingError(e, this.fileName));
    }

    @Override
    public Report call() {
        ThreadContext tc = LOCAL_THREAD_CONTEXT.get();
        if (tc == null) {
            tc = new ThreadContext(new RuleSets(this.ruleSets), new RuleContext(this.ruleContext));
            LOCAL_THREAD_CONTEXT.set(tc);
        }
        Report report = Report.createReport(tc.ruleContext, this.fileName);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Processing " + tc.ruleContext.getSourceCodeFilename());
        }
        for (Renderer r : this.renderers) {
            r.startFileAnalysis(this.dataSource);
        }
        try (BufferedInputStream stream = new BufferedInputStream(this.dataSource.getInputStream());){
            tc.ruleContext.setLanguageVersion(null);
            this.sourceCodeProcessor.processSourceCode(stream, tc.ruleSets, tc.ruleContext);
        }
        catch (PMDException pmde) {
            this.addError(report, pmde, "Error while processing file: " + this.fileName);
        }
        catch (IOException ioe) {
            this.addError(report, ioe, "IOException during processing of " + this.fileName);
        }
        catch (RuntimeException re) {
            this.addError(report, re, "RuntimeException during processing of " + this.fileName);
        }
        return report;
    }

    private static class ThreadContext {
        final RuleSets ruleSets;
        final RuleContext ruleContext;

        ThreadContext(RuleSets ruleSets, RuleContext ruleContext) {
            this.ruleSets = ruleSets;
            this.ruleContext = ruleContext;
        }
    }
}

