/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.AbstractXPathRuleQuery;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.expr.AllNodeStep;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;
import org.jaxen.expr.UnionExpr;

public class JaxenXPathRuleQuery
extends AbstractXPathRuleQuery {
    private static final Logger LOG = Logger.getLogger(JaxenXPathRuleQuery.class.getName());
    private InitializationStatus initializationStatus = InitializationStatus.NONE;
    private Map<String, List<XPath>> nodeNameToXPaths;
    private static final String AST_ROOT = "_AST_ROOT_";

    @Override
    public boolean isSupportedVersion(String version) {
        return "1.0".equals(version);
    }

    @Override
    public List<Node> evaluate(Node node, RuleContext data) {
        ArrayList<Node> results = new ArrayList<Node>();
        try {
            this.initializeExpressionIfStatusIsNoneOrPartial(data.getLanguageVersion().getLanguageVersionHandler().getXPathHandler().getNavigator());
            List<XPath> xPaths = this.getXPathsForNodeOrDefault(node.getXPathNodeName());
            for (XPath xpath : xPaths) {
                List matchedNodes = xpath.selectNodes((Object)node);
                results.addAll(matchedNodes);
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        return results;
    }

    private List<XPath> getXPathsForNodeOrDefault(String nodeName) {
        List<XPath> xPaths = this.nodeNameToXPaths.get(nodeName);
        if (xPaths == null) {
            xPaths = this.nodeNameToXPaths.get(AST_ROOT);
        }
        return xPaths;
    }

    @Override
    public List<String> getRuleChainVisits() {
        try {
            this.initializeExpressionIfStatusIsNoneOrPartial(null);
            return super.getRuleChainVisits();
        }
        catch (JaxenException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initializeExpressionIfStatusIsNoneOrPartial(Navigator navigator) throws JaxenException {
        if (this.initializationStatus == InitializationStatus.FULL) {
            return;
        }
        if (this.initializationStatus == InitializationStatus.PARTIAL && navigator == null) {
            LOG.severe("XPathRule is not initialized because no navigator was provided. Please make sure to implement getXPathHandler in the handler of the language. See also AbstractLanguageVersionHandler.");
            return;
        }
        this.initializeXPathExpression(navigator);
    }

    private void initializeXPathExpression(Navigator navigator) throws JaxenException {
        this.nodeNameToXPaths = new HashMap<String, List<XPath>>();
        BaseXPath originalXPath = this.createXPath(this.xpath, navigator);
        this.addQueryToNode((XPath)originalXPath, AST_ROOT);
        boolean useRuleChain = true;
        ArrayDeque<Expr> pending = new ArrayDeque<Expr>();
        pending.push(originalXPath.getRootExpr());
        while (!pending.isEmpty()) {
            Expr node = (Expr)pending.pop();
            boolean valid = false;
            if (node instanceof LocationPath) {
                List steps;
                LocationPath locationPath = (LocationPath)node;
                if (locationPath.isAbsolute() && (steps = locationPath.getSteps()).size() >= 2) {
                    Step step1 = (Step)steps.get(0);
                    Step step2 = (Step)steps.get(1);
                    if (step1 instanceof AllNodeStep && step1.getAxis() == 12 && step2 instanceof NameStep && step2.getAxis() == 1) {
                        DefaultXPathFactory xpathFactory = new DefaultXPathFactory();
                        LocationPath relativeLocationPath = xpathFactory.createRelativeLocationPath();
                        Step allNodeStep = xpathFactory.createAllNodeStep(11);
                        List predicates = step2.getPredicates();
                        for (Predicate predicate : predicates) {
                            allNodeStep.addPredicate(predicate);
                        }
                        relativeLocationPath.addStep(allNodeStep);
                        for (int i = 2; i < steps.size(); ++i) {
                            relativeLocationPath.addStep((Step)steps.get(i));
                        }
                        BaseXPath xpath = this.createXPath(relativeLocationPath.getText(), navigator);
                        this.addQueryToNode((XPath)xpath, ((NameStep)step2).getLocalName());
                        valid = true;
                    }
                }
            } else if (node instanceof UnionExpr) {
                UnionExpr unionExpr = (UnionExpr)node;
                pending.push(unionExpr.getLHS());
                pending.push(unionExpr.getRHS());
                valid = true;
            }
            if (valid) continue;
            useRuleChain = false;
            break;
        }
        if (useRuleChain) {
            this.ruleChainVisits.addAll(this.nodeNameToXPaths.keySet());
        } else {
            this.nodeNameToXPaths.clear();
            this.addQueryToNode((XPath)originalXPath, AST_ROOT);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Unable to use RuleChain for XPath: " + this.xpath);
            }
        }
        if (navigator == null) {
            this.initializationStatus = InitializationStatus.PARTIAL;
            this.nodeNameToXPaths = null;
        } else {
            this.initializationStatus = InitializationStatus.FULL;
        }
    }

    private void addQueryToNode(XPath xPath, String nodeName) {
        List<XPath> xPathsForNode = this.nodeNameToXPaths.get(nodeName);
        if (xPathsForNode == null) {
            xPathsForNode = new ArrayList<XPath>();
            this.nodeNameToXPaths.put(nodeName, xPathsForNode);
        }
        xPathsForNode.add(xPath);
    }

    private BaseXPath createXPath(String xpathQueryString, Navigator navigator) throws JaxenException {
        BaseXPath xpath = new BaseXPath(xpathQueryString, navigator);
        if (this.properties.size() > 1) {
            SimpleVariableContext vc = new SimpleVariableContext();
            for (Map.Entry e : this.properties.entrySet()) {
                String propName = ((PropertyDescriptor)e.getKey()).name();
                if ("xpath".equals(propName)) continue;
                Object value = e.getValue();
                vc.setVariableValue(propName, (Object)(value != null ? value.toString() : null));
            }
            xpath.setVariableContext((VariableContext)vc);
        }
        return xpath;
    }

    private static enum InitializationStatus {
        NONE,
        PARTIAL,
        FULL;

    }
}

