/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.ast.xpath.DocumentNavigator;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import org.apache.commons.lang3.ArrayUtils;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractNode
implements Node {
    private static final Logger LOG = Logger.getLogger(AbstractNode.class.getName());
    protected Node parent;
    protected Node[] children;
    protected int childIndex;
    protected int id;
    private String image;
    protected int beginLine = -1;
    protected int endLine;
    protected int beginColumn = -1;
    protected int endColumn;
    private DataFlowNode dataFlowNode;
    private Object userData;
    protected GenericToken firstToken;
    protected GenericToken lastToken;

    public AbstractNode(int id) {
        this.id = id;
    }

    public AbstractNode(int id, int theBeginLine, int theEndLine, int theBeginColumn, int theEndColumn) {
        this(id);
        this.beginLine = theBeginLine;
        this.endLine = theEndLine;
        this.beginColumn = theBeginColumn;
        this.endColumn = theEndColumn;
    }

    public boolean isSingleLine() {
        return this.beginLine == this.endLine;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node child, int index) {
        if (this.children == null) {
            this.children = new Node[index + 1];
        } else if (index >= this.children.length) {
            Node[] newChildren = new Node[index + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.children[index] = child;
        child.jjtSetChildIndex(index);
    }

    @Override
    public void jjtSetChildIndex(int index) {
        this.childIndex = index;
    }

    @Override
    public int jjtGetChildIndex() {
        return this.childIndex;
    }

    @Override
    public Node jjtGetChild(int index) {
        return this.children[index];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public int jjtGetId() {
        return this.id;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public boolean hasImageEqualTo(String image) {
        return this.getImage() != null && this.getImage().equals(image);
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    public void testingOnlySetBeginLine(int i) {
        this.beginLine = i;
    }

    @Override
    public int getBeginColumn() {
        if (this.beginColumn != -1) {
            return this.beginColumn;
        }
        if (this.children != null && this.children.length > 0) {
            return this.children[0].getBeginColumn();
        }
        throw new RuntimeException("Unable to determine beginning line of Node.");
    }

    public void testingOnlySetBeginColumn(int i) {
        this.beginColumn = i;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public void testingOnlySetEndLine(int i) {
        this.endLine = i;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public void testingOnlySetEndColumn(int i) {
        this.endColumn = i;
    }

    @Override
    public DataFlowNode getDataFlowNode() {
        if (this.dataFlowNode == null) {
            if (this.parent != null) {
                return this.parent.getDataFlowNode();
            }
            return null;
        }
        return this.dataFlowNode;
    }

    @Override
    public void setDataFlowNode(DataFlowNode dataFlowNode) {
        this.dataFlowNode = dataFlowNode;
    }

    @Override
    public Node getNthParent(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Node result = this.jjtGetParent();
        for (int i = 1; i < n; ++i) {
            if (result == null) {
                return null;
            }
            result = result.jjtGetParent();
        }
        return result;
    }

    @Override
    public <T> T getFirstParentOfType(Class<T> parentType) {
        Node parentNode;
        for (parentNode = this.jjtGetParent(); parentNode != null && !parentType.isInstance(parentNode); parentNode = parentNode.jjtGetParent()) {
        }
        return parentType.cast(parentNode);
    }

    @Override
    public <T> List<T> getParentsOfType(Class<T> parentType) {
        ArrayList<T> parents = new ArrayList<T>();
        for (Node parentNode = this.jjtGetParent(); parentNode != null; parentNode = parentNode.jjtGetParent()) {
            if (!parentType.isInstance(parentNode)) continue;
            parents.add(parentType.cast(parentNode));
        }
        return parents;
    }

    @Override
    public <T> List<T> findDescendantsOfType(Class<T> targetType) {
        ArrayList list = new ArrayList();
        AbstractNode.findDescendantsOfType(this, targetType, list, true);
        return list;
    }

    @Override
    public <T> void findDescendantsOfType(Class<T> targetType, List<T> results, boolean crossBoundaries) {
        AbstractNode.findDescendantsOfType(this, targetType, results, crossBoundaries);
    }

    private static <T> void findDescendantsOfType(Node node, Class<T> targetType, List<T> results, boolean crossFindBoundaries) {
        if (!crossFindBoundaries && node.isFindBoundary()) {
            return;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            if (child.getClass() == targetType) {
                results.add(targetType.cast(child));
            }
            AbstractNode.findDescendantsOfType(child, targetType, results, crossFindBoundaries);
        }
    }

    @Override
    public <T> List<T> findChildrenOfType(Class<T> targetType) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            Node child = this.jjtGetChild(i);
            if (!targetType.isInstance(child)) continue;
            list.add(targetType.cast(child));
        }
        return list;
    }

    @Override
    public boolean isFindBoundary() {
        return false;
    }

    @Override
    public Document getAsDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            this.appendElement(document);
            return document;
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    protected void appendElement(org.w3c.dom.Node parentNode) {
        DocumentNavigator docNav = new DocumentNavigator();
        Document ownerDocument = parentNode.getOwnerDocument();
        if (ownerDocument == null) {
            ownerDocument = (Document)parentNode;
        }
        String elementName = docNav.getElementName(this);
        Element element = ownerDocument.createElement(elementName);
        parentNode.appendChild(element);
        Iterator<Object> iter = docNav.getAttributeAxisIterator(this);
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            element.setAttribute(attr.getName(), attr.getStringValue());
        }
        iter = docNav.getChildAxisIterator(this);
        while (iter.hasNext()) {
            AbstractNode child = (AbstractNode)iter.next();
            child.appendElement(element);
        }
    }

    @Override
    public <T> T getFirstDescendantOfType(Class<T> descendantType) {
        return AbstractNode.getFirstDescendantOfType(descendantType, this);
    }

    @Override
    public <T> T getFirstChildOfType(Class<T> childType) {
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node child = this.jjtGetChild(i);
            if (child.getClass() != childType) continue;
            return childType.cast(child);
        }
        return null;
    }

    private static <T> T getFirstDescendantOfType(Class<T> descendantType, Node node) {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node n1 = node.jjtGetChild(i);
            if (n1.getClass() == descendantType) {
                return descendantType.cast(n1);
            }
            T n2 = AbstractNode.getFirstDescendantOfType(descendantType, n1);
            if (n2 == null) continue;
            return n2;
        }
        return null;
    }

    @Override
    public final <T> boolean hasDescendantOfType(Class<T> type) {
        return this.getFirstDescendantOfType(type) != null;
    }

    @Deprecated
    public final boolean hasDecendantOfAnyType(Class<?> ... types) {
        return this.hasDescendantOfAnyType(types);
    }

    public final boolean hasDescendantOfAnyType(Class<?> ... types) {
        for (Class<?> type : types) {
            if (!this.hasDescendantOfType(type)) continue;
            return true;
        }
        return false;
    }

    public List<Node> findChildNodesWithXPath(String xpathString) throws JaxenException {
        return new BaseXPath(xpathString, (Navigator)new DocumentNavigator()).selectNodes((Object)this);
    }

    @Override
    public boolean hasDescendantMatchingXPath(String xpathString) {
        try {
            return !this.findChildNodesWithXPath(xpathString).isEmpty();
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression " + xpathString + " failed: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public GenericToken jjtGetFirstToken() {
        return this.firstToken;
    }

    public void jjtSetFirstToken(GenericToken token) {
        this.firstToken = token;
    }

    public GenericToken jjtGetLastToken() {
        return this.lastToken;
    }

    public void jjtSetLastToken(GenericToken token) {
        this.lastToken = token;
    }

    @Override
    public void remove() {
        Node parent = this.jjtGetParent();
        if (parent != null) {
            parent.removeChildAtIndex(this.jjtGetChildIndex());
            this.jjtSetParent(null);
        }
    }

    @Override
    public void removeChildAtIndex(int childIndex) {
        if (0 <= childIndex && childIndex < this.jjtGetNumChildren()) {
            this.children = (Node[])ArrayUtils.remove((Object[])this.children, (int)childIndex);
            for (int i = childIndex; i < this.jjtGetNumChildren(); ++i) {
                this.jjtGetChild(i).jjtSetChildIndex(i);
            }
        }
    }

    @Override
    public String getXPathNodeName() {
        LOG.warning("getXPathNodeName should be overriden in classes derived from AbstractNode. The implementation is provided for compatibility with existing implementors,but could be declared abstract as soon as release " + PMDVersion.getNextMajorRelease() + ".");
        return this.toString();
    }

    @Deprecated
    public String toString() {
        return this.getXPathNodeName();
    }
}

