/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.apache.commons.io.IOUtils;

public class AnyTokenizer
implements Tokenizer {
    public static final String TOKENS = " \t!#$%^&*(){}-=+<>/\\`~;:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder sb = sourceCode.getCodeBuffer();
        BufferedReader reader = new BufferedReader(new CharArrayReader(sb.toString().toCharArray()));
        try {
            int lineNumber = 1;
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, TOKENS, true);
                try {
                    String token = tokenizer.nextToken();
                    while (token != null) {
                        if (!" ".equals(token) && !"\t".equals(token)) {
                            tokenEntries.add(new TokenEntry(token, sourceCode.getFileName(), lineNumber));
                        }
                        token = tokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                line = reader.readLine();
                ++lineNumber;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            tokenEntries.add(TokenEntry.getEOF());
        }
    }
}

