/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactoryCompatibility;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.rules.RuleFactory;
import net.sourceforge.pmd.util.ResourceLoader;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RuleSetFactory {
    private static final Logger LOG = Logger.getLogger(RuleSetFactory.class.getName());
    private static final String DESCRIPTION = "description";
    private static final String UNEXPECTED_ELEMENT = "Unexpected element <";
    private static final String PRIORITY = "priority";
    private final ResourceLoader resourceLoader;
    private final RulePriority minimumPriority;
    private final boolean warnDeprecated;
    private final RuleSetFactoryCompatibility compatibilityFilter;

    public RuleSetFactory() {
        this(new ResourceLoader(), RulePriority.LOW, false, true);
    }

    @Deprecated
    public RuleSetFactory(ClassLoader classLoader, RulePriority minimumPriority, boolean warnDeprecated, boolean enableCompatibility) {
        this(new ResourceLoader(classLoader), minimumPriority, warnDeprecated, enableCompatibility);
    }

    public RuleSetFactory(ResourceLoader resourceLoader, RulePriority minimumPriority, boolean warnDeprecated, boolean enableCompatibility) {
        this.resourceLoader = resourceLoader;
        this.minimumPriority = minimumPriority;
        this.warnDeprecated = warnDeprecated;
        this.compatibilityFilter = enableCompatibility ? new RuleSetFactoryCompatibility() : null;
    }

    public RuleSetFactory(RuleSetFactory factory, boolean warnDeprecated) {
        this(factory.resourceLoader, factory.minimumPriority, warnDeprecated, factory.compatibilityFilter != null);
    }

    RuleSetFactoryCompatibility getCompatibilityFilter() {
        return this.compatibilityFilter;
    }

    public Iterator<RuleSet> getRegisteredRuleSets() throws RuleSetNotFoundException {
        String rulesetsProperties = null;
        try {
            ArrayList<RuleSetReferenceId> ruleSetReferenceIds = new ArrayList<RuleSetReferenceId>();
            for (Language language : LanguageRegistry.findWithRuleSupport()) {
                Properties props = new Properties();
                rulesetsProperties = "category/" + language.getTerseName() + "/categories.properties";
                try (InputStream inputStream = this.resourceLoader.loadClassPathResourceAsStreamOrThrow(rulesetsProperties);){
                    props.load(inputStream);
                }
                String rulesetFilenames = props.getProperty("rulesets.filenames");
                ruleSetReferenceIds.addAll(RuleSetReferenceId.parse(rulesetFilenames));
            }
            return this.createRuleSets(ruleSetReferenceIds).getRuleSetsIterator();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't find " + rulesetsProperties + "; please ensure that the directory is on the classpath. The current classpath is: " + System.getProperty("java.class.path"));
        }
    }

    public RuleSets createRuleSets(String referenceString) throws RuleSetNotFoundException {
        return this.createRuleSets(RuleSetReferenceId.parse(referenceString));
    }

    public RuleSets createRuleSets(List<RuleSetReferenceId> ruleSetReferenceIds) throws RuleSetNotFoundException {
        RuleSets ruleSets = new RuleSets();
        for (RuleSetReferenceId ruleSetReferenceId : ruleSetReferenceIds) {
            RuleSet ruleSet = this.createRuleSet(ruleSetReferenceId);
            ruleSets.addRuleSet(ruleSet);
        }
        return ruleSets;
    }

    public RuleSet createRuleSet(String referenceString) throws RuleSetNotFoundException {
        List<RuleSetReferenceId> references = RuleSetReferenceId.parse(referenceString);
        if (references.isEmpty()) {
            throw new RuleSetNotFoundException("No RuleSetReferenceId can be parsed from the string: <" + referenceString + ">");
        }
        return this.createRuleSet(references.get(0));
    }

    public RuleSet createRuleSet(RuleSetReferenceId ruleSetReferenceId) throws RuleSetNotFoundException {
        return this.createRuleSet(ruleSetReferenceId, false);
    }

    private RuleSet createRuleSet(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        return this.parseRuleSetNode(ruleSetReferenceId, withDeprecatedRuleReferences);
    }

    public RuleSet createRuleSetCopy(RuleSet original) {
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(original);
        return builder.build();
    }

    public RuleSet createNewRuleSet(String name, String description, String fileName, Collection<String> excludePatterns, Collection<String> includePatterns, Collection<Rule> rules) {
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(0L);
        builder.withName(name).withDescription(description).withFileName(fileName).setExcludePatterns(excludePatterns).setIncludePatterns(includePatterns);
        for (Rule rule : rules) {
            builder.addRule(rule);
        }
        return builder.build();
    }

    public RuleSet createSingleRuleRuleSet(Rule rule) {
        long checksum = rule instanceof XPathRule ? (long)rule.getProperty(XPathRule.XPATH_DESCRIPTOR).hashCode() : (long)(rule.getPropertiesByPropertyDescriptor().values().hashCode() * 31 + rule.getName().hashCode());
        RuleSet.RuleSetBuilder builder = new RuleSet.RuleSetBuilder(checksum).withName(rule.getName()).withDescription("RuleSet for " + rule.getName());
        builder.addRule(rule);
        return builder.build();
    }

    private Rule createRule(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        if (ruleSetReferenceId.isAllRules()) {
            throw new IllegalArgumentException("Cannot parse a single Rule from an all Rule RuleSet reference: <" + ruleSetReferenceId + ">.");
        }
        RuleSet ruleSet = this.createRuleSet(ruleSetReferenceId, withDeprecatedRuleReferences);
        return ruleSet.getRuleByName(ruleSetReferenceId.getRuleName());
    }

    private RuleSet parseRuleSetNode(RuleSetReferenceId ruleSetReferenceId, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        RuleSet ruleSet;
        CheckedInputStream inputStream = new CheckedInputStream(ruleSetReferenceId.getInputStream(this.resourceLoader), new Adler32());
        Throwable throwable = null;
        try {
            if (!ruleSetReferenceId.isExternal()) {
                throw new IllegalArgumentException("Cannot parse a RuleSet from a non-external reference: <" + ruleSetReferenceId + ">.");
            }
            DocumentBuilder builder = this.createDocumentBuilder();
            InputSource inputSource = this.compatibilityFilter != null ? new InputSource(this.compatibilityFilter.filterRuleSetFile(inputStream)) : new InputSource(inputStream);
            Document document = builder.parse(inputSource);
            Element ruleSetElement = document.getDocumentElement();
            RuleSet.RuleSetBuilder ruleSetBuilder = new RuleSet.RuleSetBuilder(inputStream.getChecksum().getValue()).withFileName(ruleSetReferenceId.getRuleSetFileName());
            if (ruleSetElement.hasAttribute("name")) {
                ruleSetBuilder.withName(ruleSetElement.getAttribute("name"));
            } else {
                LOG.warning("RuleSet name is missing. Future versions of PMD will require it.");
                ruleSetBuilder.withName("Missing RuleSet Name");
            }
            NodeList nodeList = ruleSetElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                if (DESCRIPTION.equals(nodeName)) {
                    ruleSetBuilder.withDescription(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if ("include-pattern".equals(nodeName)) {
                    ruleSetBuilder.addIncludePattern(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if ("exclude-pattern".equals(nodeName)) {
                    ruleSetBuilder.addExcludePattern(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if ("rule".equals(nodeName)) {
                    this.parseRuleNode(ruleSetReferenceId, ruleSetBuilder, node, withDeprecatedRuleReferences);
                    continue;
                }
                throw new IllegalArgumentException(UNEXPECTED_ELEMENT + node.getNodeName() + "> encountered as child of <ruleset> element.");
            }
            if (!ruleSetBuilder.hasDescription()) {
                LOG.warning("RuleSet description is missing. Future versions of PMD will require it.");
                ruleSetBuilder.withDescription("Missing description");
            }
            ruleSetBuilder.filterRulesByPriority(this.minimumPriority);
            ruleSet = ruleSetBuilder.build();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    RuleSetFactory.$closeResource(throwable, inputStream);
                    throw throwable3;
                }
            }
            catch (ClassNotFoundException cnfe) {
                return RuleSetFactory.classNotFoundProblem(cnfe);
            }
            catch (InstantiationException ie) {
                return RuleSetFactory.classNotFoundProblem(ie);
            }
            catch (IllegalAccessException iae) {
                return RuleSetFactory.classNotFoundProblem(iae);
            }
            catch (ParserConfigurationException pce) {
                return RuleSetFactory.classNotFoundProblem(pce);
            }
            catch (IOException ioe) {
                return RuleSetFactory.classNotFoundProblem(ioe);
            }
            catch (SAXException se) {
                return RuleSetFactory.classNotFoundProblem(se);
            }
        }
        RuleSetFactory.$closeResource(throwable, inputStream);
        return ruleSet;
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dbf.newDocumentBuilder();
    }

    private static RuleSet classNotFoundProblem(Exception ex) {
        ex.printStackTrace();
        throw new RuntimeException("Couldn't find the class " + ex.getMessage());
    }

    private void parseRuleNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode, boolean withDeprecatedRuleReferences) throws ClassNotFoundException, InstantiationException, IllegalAccessException, RuleSetNotFoundException {
        Element ruleElement = (Element)ruleNode;
        String ref = ruleElement.getAttribute("ref");
        if (ref.endsWith("xml")) {
            this.parseRuleSetReferenceNode(ruleSetReferenceId, ruleSetBuilder, ruleElement, ref);
        } else if (StringUtils.isBlank((CharSequence)ref)) {
            this.parseSingleRuleNode(ruleSetReferenceId, ruleSetBuilder, ruleNode);
        } else {
            this.parseRuleReferenceNode(ruleSetReferenceId, ruleSetBuilder, ruleNode, ref, withDeprecatedRuleReferences);
        }
    }

    private void parseRuleSetReferenceNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Element ruleElement, String ref) throws RuleSetNotFoundException {
        String priority = null;
        NodeList childNodes = ruleElement.getChildNodes();
        HashSet<String> excludedRulesCheck = new HashSet<String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (RuleSetFactory.isElementNode(child, "exclude")) {
                Element excludeElement = (Element)child;
                String excludedRuleName = excludeElement.getAttribute("name");
                excludedRulesCheck.add(excludedRuleName);
                continue;
            }
            if (!RuleSetFactory.isElementNode(child, PRIORITY)) continue;
            priority = RuleSetFactory.parseTextNode(child).trim();
        }
        RuleSetReference ruleSetReference = new RuleSetReference(ref, true, excludedRulesCheck);
        RuleSetFactory ruleSetFactory = new RuleSetFactory(this.resourceLoader, RulePriority.LOW, this.warnDeprecated, this.compatibilityFilter != null);
        RuleSet otherRuleSet = ruleSetFactory.createRuleSet(RuleSetReferenceId.parse(ref).get(0));
        ArrayList<RuleReference> potentialRules = new ArrayList<RuleReference>();
        int countDeprecated = 0;
        for (Rule rule : otherRuleSet.getRules()) {
            excludedRulesCheck.remove(rule.getName());
            if (ruleSetReference.getExcludes().contains(rule.getName())) continue;
            RuleReference ruleReference = new RuleReference();
            ruleReference.setRuleSetReference(ruleSetReference);
            ruleReference.setRule(rule);
            if (priority != null) {
                ruleReference.setPriority(RulePriority.valueOf(Integer.parseInt(priority)));
            }
            if (rule.isDeprecated()) {
                ++countDeprecated;
            }
            potentialRules.add(ruleReference);
        }
        boolean rulesetDeprecated = false;
        if (!potentialRules.isEmpty() && potentialRules.size() == countDeprecated) {
            rulesetDeprecated = true;
            LOG.warning("The RuleSet " + ref + " has been deprecated and will be removed in PMD " + PMDVersion.getNextMajorRelease());
        }
        for (RuleReference r : potentialRules) {
            if (!rulesetDeprecated && r.getRule().isDeprecated()) continue;
            ruleSetBuilder.addRuleIfNotExists(r);
        }
        if (!excludedRulesCheck.isEmpty()) {
            throw new IllegalArgumentException("Unable to exclude rules " + excludedRulesCheck + "; perhaps the rule name is mispelled?");
        }
    }

    private void parseSingleRuleNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Element ruleElement = (Element)ruleNode;
        if (StringUtils.isNotBlank((CharSequence)ruleSetReferenceId.getRuleName()) && !this.isRuleName(ruleElement, ruleSetReferenceId.getRuleName())) {
            return;
        }
        Rule rule = new RuleFactory().buildRule(ruleElement);
        rule.setRuleSetName(ruleSetBuilder.getName());
        ruleSetBuilder.addRule(rule);
    }

    private void parseRuleReferenceNode(RuleSetReferenceId ruleSetReferenceId, RuleSet.RuleSetBuilder ruleSetBuilder, Node ruleNode, String ref, boolean withDeprecatedRuleReferences) throws RuleSetNotFoundException {
        Rule referencedRule;
        Element ruleElement = (Element)ruleNode;
        if (StringUtils.isNotBlank((CharSequence)ruleSetReferenceId.getRuleName()) && !this.isRuleName(ruleElement, ruleSetReferenceId.getRuleName())) {
            return;
        }
        RuleSetFactory ruleSetFactory = new RuleSetFactory(this.resourceLoader, RulePriority.LOW, this.warnDeprecated, this.compatibilityFilter != null);
        boolean isSameRuleSet = false;
        RuleSetReferenceId otherRuleSetReferenceId = RuleSetReferenceId.parse(ref).get(0);
        if (!otherRuleSetReferenceId.isExternal() && this.containsRule(ruleSetReferenceId, otherRuleSetReferenceId.getRuleName())) {
            otherRuleSetReferenceId = new RuleSetReferenceId(ref, ruleSetReferenceId);
            isSameRuleSet = true;
        }
        if ((referencedRule = ruleSetFactory.createRule(otherRuleSetReferenceId, true)) == null) {
            throw new IllegalArgumentException("Unable to find referenced rule " + otherRuleSetReferenceId.getRuleName() + "; perhaps the rule name is mispelled?");
        }
        if (this.warnDeprecated && referencedRule.isDeprecated()) {
            if (referencedRule instanceof RuleReference) {
                RuleReference ruleReference = (RuleReference)referencedRule;
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Use Rule name " + ruleReference.getRuleSetReference().getRuleSetFileName() + "/" + ruleReference.getOriginalName() + " instead of the deprecated Rule name " + otherRuleSetReferenceId + ". PMD " + PMDVersion.getNextMajorRelease() + " will remove support for this deprecated Rule name usage.");
                }
            } else if (referencedRule instanceof MockRule) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Discontinue using Rule name " + otherRuleSetReferenceId + " as it has been removed from PMD and no longer functions. PMD " + PMDVersion.getNextMajorRelease() + " will remove support for this Rule.");
                }
            } else if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Discontinue using Rule name " + otherRuleSetReferenceId + " as it is scheduled for removal from PMD. PMD " + PMDVersion.getNextMajorRelease() + " will remove support for this Rule.");
            }
        }
        RuleSetReference ruleSetReference = new RuleSetReference(otherRuleSetReferenceId.getRuleSetFileName(), false);
        RuleReference ruleReference = new RuleFactory().decorateRule(referencedRule, ruleElement);
        ruleReference.setRuleSetReference(ruleSetReference);
        if (this.warnDeprecated && ruleReference.isDeprecated() && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Use Rule name " + ruleReference.getRuleSetReference().getRuleSetFileName() + "/" + ruleReference.getOriginalName() + " instead of the deprecated Rule name " + ruleSetReferenceId.getRuleSetFileName() + "/" + ruleReference.getName() + ". PMD " + PMDVersion.getNextMajorRelease() + " will remove support for this deprecated Rule name usage.");
        }
        if (withDeprecatedRuleReferences || !isSameRuleSet || !ruleReference.isDeprecated()) {
            ruleSetBuilder.addRuleReplaceIfExists(ruleReference);
        }
    }

    private boolean containsRule(RuleSetReferenceId ruleSetReferenceId, String ruleName) {
        boolean found = false;
        try (InputStream ruleSet = ruleSetReferenceId.getInputStream(this.resourceLoader);){
            DocumentBuilder builder = this.createDocumentBuilder();
            Document document = builder.parse(ruleSet);
            Element ruleSetElement = document.getDocumentElement();
            NodeList rules = ruleSetElement.getElementsByTagName("rule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Element rule = (Element)rules.item(i);
                if (!rule.hasAttribute("name") || !rule.getAttribute("name").equals(ruleName)) continue;
                found = true;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return found;
    }

    private static boolean isElementNode(Node node, String name) {
        return node.getNodeType() == 1 && node.getNodeName().equals(name);
    }

    private static String parseTextNode(Node node) {
        int nodeCount = node.getChildNodes().getLength();
        if (nodeCount == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < nodeCount; ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 4 && childNode.getNodeType() != 3) continue;
            buffer.append(childNode.getNodeValue());
        }
        return buffer.toString();
    }

    private boolean isRuleName(Element ruleElement, String ruleName) {
        if (ruleElement.hasAttribute("name")) {
            return ruleElement.getAttribute("name").equals(ruleName);
        }
        if (ruleElement.hasAttribute("ref")) {
            RuleSetReferenceId ruleSetReferenceId = RuleSetReferenceId.parse(ruleElement.getAttribute("ref")).get(0);
            return ruleSetReferenceId.getRuleName() != null && ruleSetReferenceId.getRuleName().equals(ruleName);
        }
        return false;
    }
}

