/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.controls;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.ChoiceBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.StringConverter;
import net.sourceforge.pmd.properties.PropertyTypeId;
import net.sourceforge.pmd.util.fxdesigner.EditPropertyDialogController;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import net.sourceforge.pmd.util.fxdesigner.util.PropertyDescriptorSpec;
import org.reactfx.value.Var;

public class PropertyTableView
extends TableView<PropertyDescriptorSpec> {
    private TableColumn<PropertyDescriptorSpec, String> propertyNameColumn = new TableColumn("Name");
    private TableColumn<PropertyDescriptorSpec, PropertyTypeId> propertyTypeColumn = new TableColumn("Type");
    private TableColumn<PropertyDescriptorSpec, String> propertyValueColumn = new TableColumn("Value");
    private SoftReference<Stage> editPropertyDialogCache;
    private Var<Consumer<? super PropertyDescriptorSpec>> onEditCommit = Var.newSimpleVar(null);

    public PropertyTableView() {
        this.initialize();
    }

    private void initialize() {
        this.getColumns().add(this.propertyNameColumn);
        this.getColumns().add(this.propertyTypeColumn);
        this.getColumns().add(this.propertyValueColumn);
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY);
        this.setTableMenuButtonVisible(true);
        ObservableList availableBuilders = FXCollections.observableArrayList(PropertyTypeId.typeIdsToConstants().values());
        Collections.sort(availableBuilders);
        StringConverter<PropertyTypeId> converter = DesignerUtil.stringConverter(PropertyTypeId::getStringId, PropertyTypeId::lookupMnemonic);
        this.propertyTypeColumn.setCellFactory(ChoiceBoxTableCell.forTableColumn(converter, (ObservableList)availableBuilders));
        this.propertyNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.propertyValueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.propertyTypeColumn.setCellValueFactory((Callback)new PropertyValueFactory("typeId"));
        this.setPlaceholder((Node)new Label("Right-click to add properties"));
        MenuItem editItem = new MenuItem("Edit...");
        editItem.setOnAction(e -> {
            PropertyDescriptorSpec spec = (PropertyDescriptorSpec)this.getSelectionModel().getSelectedItem();
            if (spec != null) {
                this.popEditPropertyDialog(spec);
            }
        });
        MenuItem removeItem = new MenuItem("Remove");
        removeItem.setOnAction(e -> {
            PropertyDescriptorSpec selected = (PropertyDescriptorSpec)this.getSelectionModel().getSelectedItem();
            if (selected != null) {
                this.getItems().remove((Object)selected);
            }
        });
        MenuItem addItem = new MenuItem("Add property...");
        addItem.setOnAction(e -> this.onAddPropertyClicked());
        ContextMenu fullMenu = new ContextMenu();
        fullMenu.getItems().addAll((Object[])new MenuItem[]{editItem, removeItem, new SeparatorMenuItem(), addItem});
        MenuItem addItem2 = new MenuItem("Add property...");
        addItem2.setOnAction(e -> this.onAddPropertyClicked());
        ContextMenu smallMenu = new ContextMenu();
        smallMenu.getItems().add((Object)addItem2);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, t -> {
            if (t.getButton() == MouseButton.SECONDARY || t.getButton() == MouseButton.PRIMARY && t.getClickCount() > 1) {
                if (this.getSelectionModel().getSelectedItem() != null) {
                    fullMenu.show((Node)this, t.getScreenX(), t.getScreenY());
                } else {
                    smallMenu.show((Node)this, t.getScreenX(), t.getScreenY());
                }
            }
        });
        this.propertyNameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.propertyValueColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.setEditable(false);
    }

    private void onAddPropertyClicked() {
        PropertyDescriptorSpec spec = new PropertyDescriptorSpec();
        this.getItems().add((Object)spec);
        this.popEditPropertyDialog(spec);
    }

    private void popEditPropertyDialog(PropertyDescriptorSpec edited) {
        if (this.editPropertyDialogCache == null || this.editPropertyDialogCache.get() == null) {
            try {
                this.editPropertyDialogCache = new SoftReference<Stage>(this.createEditPropertyDialog());
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        Stage dialog = this.editPropertyDialogCache.get();
        EditPropertyDialogController wizard = (EditPropertyDialogController)dialog.getUserData();
        Platform.runLater(() -> wizard.bindToDescriptor(edited, this.getRuleProperties()));
        dialog.setOnHiding(e -> {
            edited.unbind();
            this.onEditCommit.ifPresent(handler -> handler.accept(edited));
        });
        dialog.show();
    }

    private Stage createEditPropertyDialog() throws IOException {
        EditPropertyDialogController wizard = new EditPropertyDialogController();
        FXMLLoader loader = new FXMLLoader(DesignerUtil.getFxml("edit-property-dialog.fxml"));
        loader.setController((Object)wizard);
        Stage dialog = new Stage();
        dialog.initOwner(this.getScene().getWindow());
        dialog.initModality(Modality.WINDOW_MODAL);
        dialog.initStyle(StageStyle.UNDECORATED);
        Parent root = (Parent)loader.load();
        Scene scene = new Scene(root);
        dialog.setTitle("Edit property");
        dialog.setScene(scene);
        dialog.setUserData((Object)wizard);
        return dialog;
    }

    public ObservableList<PropertyDescriptorSpec> getRuleProperties() {
        return this.getItems();
    }

    public void setRuleProperties(ObservableList<PropertyDescriptorSpec> ruleProperties) {
        this.setItems(ruleProperties);
    }

    public ObjectProperty<ObservableList<PropertyDescriptorSpec>> rulePropertiesProperty() {
        return this.itemsProperty();
    }

    public Consumer<? super PropertyDescriptorSpec> getOnEditCommit() {
        return (Consumer)this.onEditCommit.getValue();
    }

    public Var<Consumer<? super PropertyDescriptorSpec>> onEditCommitProperty() {
        return this.onEditCommit;
    }

    public void setOnEditCommit(Consumer<? super PropertyDescriptorSpec> onEditCommit) {
        this.onEditCommit.setValue(onEditCommit);
    }
}

