/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.StyleContext;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.StyleLayer;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlighter;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.Subscription;

public class CustomCodeArea
extends CodeArea {
    private static final String SYNTAX_HIGHLIGHT_LAYER_ID = "syntax";
    private static final String PRIMARY_HIGHLIGHT_LAYER_ID = "primary";
    private ExecutorService executorService;
    private Subscription syntaxAutoRefresh;
    private BooleanProperty isSyntaxHighlightingEnabled = new SimpleBooleanProperty(false);
    private StyleContext styleContext = new StyleContext(this);
    private SyntaxHighlighter syntaxHighlighter;

    public CustomCodeArea() {
        this.styleContext.addLayer(PRIMARY_HIGHLIGHT_LAYER_ID, new StyleLayer(PRIMARY_HIGHLIGHT_LAYER_ID, this));
    }

    public void styleCss(int beginLine, int beginColumn, int endLine, int endColumn, Set<String> cssClasses) {
        HashSet<String> fullClasses = new HashSet<String>(cssClasses);
        fullClasses.add("text");
        fullClasses.add("styled-text-area");
        this.styleContext.getLayer(PRIMARY_HIGHLIGHT_LAYER_ID).style(beginLine, beginColumn, endLine, endColumn, fullClasses);
    }

    public void styleCss(Node node, Set<String> cssClasses) {
        this.styleCss(node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn(), cssClasses);
    }

    public void restylePrimaryStyleLayer(Node node, Set<String> cssClasses) {
        this.clearPrimaryStyleLayer();
        this.styleCss(node, cssClasses);
    }

    public boolean isInRange(Node n) {
        return n.getEndLine() <= this.getParagraphs().size() && (n.getEndLine() != this.getParagraphs().size() || n.getEndColumn() <= this.getParagraph(n.getEndLine() - 1).length());
    }

    public void clearPrimaryStyleLayer() {
        this.styleContext.getLayer(PRIMARY_HIGHLIGHT_LAYER_ID).clearStyles();
    }

    public void clearStyleLayers() {
        for (StyleLayer layer : this.styleContext) {
            layer.clearStyles();
        }
    }

    public boolean isSyntaxHighlightingEnabled() {
        return this.isSyntaxHighlightingEnabled.get();
    }

    public void setSyntaxHighlightingEnabled(SyntaxHighlighter highlighter) {
        this.setSyntaxHighlighter(highlighter);
        try {
            Task<StyleSpans<Collection<String>>> t = this.computeHighlightingAsync(this.getText());
            t.setOnSucceeded(e -> {
                StyleLayer layer = this.styleContext.getLayer(SYNTAX_HIGHLIGHT_LAYER_ID);
                layer.reset((StyleSpans<Collection<String>>)((StyleSpans)t.getValue()));
                this.paintCss();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BooleanProperty syntaxHighlightingEnabledProperty() {
        return this.isSyntaxHighlightingEnabled;
    }

    public void paintCss() {
        this.setStyleSpans(0, this.styleContext.getStyleSpans());
    }

    public void disableSyntaxHighlighting() {
        if (this.isSyntaxHighlightingEnabled.get()) {
            StyleLayer syntaxHighlightLayer;
            this.isSyntaxHighlightingEnabled.set(false);
            if (this.syntaxAutoRefresh != null) {
                this.syntaxAutoRefresh.unsubscribe();
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            if ((syntaxHighlightLayer = this.styleContext.getLayer(SYNTAX_HIGHLIGHT_LAYER_ID)) != null) {
                syntaxHighlightLayer.clearStyles();
            }
        }
        this.paintCss();
    }

    private void setSyntaxHighlighter(SyntaxHighlighter newHighlighter) {
        this.isSyntaxHighlightingEnabled.set(true);
        Objects.requireNonNull(newHighlighter, "The syntax highlighting highlighter cannot be null");
        StyleLayer syntaxHighlightLayer = this.styleContext.getLayer(SYNTAX_HIGHLIGHT_LAYER_ID);
        if (syntaxHighlightLayer == null) {
            this.styleContext.addLayer(SYNTAX_HIGHLIGHT_LAYER_ID, new StyleLayer(SYNTAX_HIGHLIGHT_LAYER_ID, this));
        }
        ObservableList styleClasses = this.getStyleClass();
        if (this.syntaxHighlighter != null) {
            styleClasses.remove((Object)("." + this.syntaxHighlighter.getLanguageTerseName()));
        }
        styleClasses.add((Object)("." + newHighlighter.getLanguageTerseName()));
        this.launchAsyncSyntaxHighlighting(newHighlighter);
    }

    private synchronized void launchAsyncSyntaxHighlighting(SyntaxHighlighter computer) {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        this.syntaxHighlighter = computer;
        if (this.isSyntaxHighlightingEnabled.get() && this.syntaxHighlighter != null) {
            this.executorService = Executors.newSingleThreadExecutor();
            this.syntaxAutoRefresh = this.richChanges().filter(ch -> !((StyledDocument)ch.getInserted()).equals(ch.getRemoved())).successionEnds(Duration.ofMillis(100L)).supplyTask(() -> this.computeHighlightingAsync(this.getText())).awaitLatest(this.richChanges()).filterMap(t -> {
                if (t.isSuccess()) {
                    return Optional.of((StyleSpans)t.get());
                }
                t.getFailure().printStackTrace();
                return Optional.empty();
            }).subscribe(spans -> {
                StyleLayer layer = this.styleContext.getLayer(SYNTAX_HIGHLIGHT_LAYER_ID);
                layer.reset((StyleSpans<Collection<String>>)spans);
                this.paintCss();
            });
        }
    }

    private Task<StyleSpans<Collection<String>>> computeHighlightingAsync(final String text) {
        Task<StyleSpans<Collection<String>>> task = new Task<StyleSpans<Collection<String>>>(){

            protected StyleSpans<Collection<String>> call() throws Exception {
                return CustomCodeArea.this.syntaxHighlighter.computeHighlighting(text);
            }
        };
        if (!this.executorService.isShutdown()) {
            this.executorService.execute((Runnable)task);
        }
        return task;
    }
}

