/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.model;

import java.io.Reader;
import java.io.StringReader;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.model.LogEntry;
import net.sourceforge.pmd.util.fxdesigner.model.ParseAbortedException;
import org.apache.commons.lang3.StringUtils;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class ASTManager {
    private final DesignerRoot designerRoot;
    private String lastValidSource;
    private LanguageVersion lastLanguageVersion;
    private Var<Node> compilationUnit = Var.newSimpleVar(null);
    private Var<LanguageVersion> languageVersion = Var.newSimpleVar((Object)LanguageRegistry.getDefaultLanguage().getDefaultVersion());

    public ASTManager(DesignerRoot owner) {
        this.designerRoot = owner;
    }

    public LanguageVersion getLanguageVersion() {
        return (LanguageVersion)this.languageVersion.getValue();
    }

    public void setLanguageVersion(LanguageVersion version) {
        this.languageVersion.setValue((Object)version);
    }

    public Var<LanguageVersion> languageVersionProperty() {
        return this.languageVersion;
    }

    public Node getCompilationUnit() {
        return (Node)this.compilationUnit.getValue();
    }

    public Val<Node> compilationUnitProperty() {
        return this.compilationUnit;
    }

    public Node updateCompilationUnit(String source) throws ParseAbortedException {
        Node node;
        if (this.compilationUnit.isPresent() && this.getLanguageVersion().equals(this.lastLanguageVersion) && StringUtils.equals((CharSequence)source, (CharSequence)this.lastValidSource)) {
            return this.getCompilationUnit();
        }
        LanguageVersionHandler languageVersionHandler = this.getLanguageVersion().getLanguageVersionHandler();
        Parser parser = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions());
        try {
            node = parser.parse(null, (Reader)new StringReader(source));
        }
        catch (Exception e) {
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.PARSE_EXCEPTION));
            throw new ParseAbortedException(e);
        }
        try {
            languageVersionHandler.getSymbolFacade().start(node);
        }
        catch (Exception e) {
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.SYMBOL_FACADE_EXCEPTION));
        }
        try {
            languageVersionHandler.getTypeResolutionFacade(ASTManager.class.getClassLoader()).start(node);
        }
        catch (Exception e) {
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.TYPERESOLUTION_EXCEPTION));
        }
        this.compilationUnit.setValue((Object)node);
        this.lastValidSource = source;
        this.lastLanguageVersion = this.getLanguageVersion();
        return this.getCompilationUnit();
    }
}

