/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListView;
import javafx.scene.control.TitledPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.ExportXPathWizardController;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.model.LogEntry;
import net.sourceforge.pmd.util.fxdesigner.model.ObservableXPathRuleBuilder;
import net.sourceforge.pmd.util.fxdesigner.model.XPathEvaluationException;
import net.sourceforge.pmd.util.fxdesigner.model.XPathEvaluator;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import net.sourceforge.pmd.util.fxdesigner.util.PropertyDescriptorSpec;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsPersistenceUtil;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.CustomCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.XPathSyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.controls.PropertyTableView;
import org.apache.commons.lang3.StringUtils;
import org.reactfx.EventStreams;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class XPathPanelController
implements Initializable,
SettingsOwner {
    private final DesignerRoot designerRoot;
    private final MainDesignerController parent;
    private final XPathEvaluator xpathEvaluator = new XPathEvaluator();
    private final ObservableXPathRuleBuilder ruleBuilder = new ObservableXPathRuleBuilder();
    @FXML
    private PropertyTableView propertyView;
    @FXML
    private CustomCodeArea xpathExpressionArea;
    @FXML
    private TitledPane violationsTitledPane;
    @FXML
    private ListView<Node> xpathResultListView;
    private ChoiceBox<String> xpathVersionChoiceBox;

    public XPathPanelController(DesignerRoot owner, MainDesignerController mainController) {
        this.designerRoot = owner;
        this.parent = mainController;
        this.getRuleBuilder().setClazz(XPathRule.class);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.xpathExpressionArea.setSyntaxHighlightingEnabled(new XPathSyntaxHighlighter());
        EventStreams.valuesOf((ObservableValue)this.xpathResultListView.getSelectionModel().selectedItemProperty()).filter(Objects::nonNull).subscribe(this.parent::onNodeItemSelected);
        Platform.runLater(this::bindToParent);
    }

    private void bindToParent() {
        DesignerUtil.rewire(this.getRuleBuilder().languageProperty(), Val.map(this.parent.languageVersionProperty(), LanguageVersion::getLanguage));
        DesignerUtil.rewire(this.getRuleBuilder().xpathVersionProperty(), this.parent.xpathVersionProperty());
        DesignerUtil.rewire(this.getRuleBuilder().xpathExpressionProperty(), this.xpathExpressionProperty());
        DesignerUtil.rewire(this.getRuleBuilder().rulePropertiesProperty(), this.propertyView.rulePropertiesProperty(), this.propertyView::setRuleProperties);
    }

    public void initialiseVersionChoiceBox(ChoiceBox<String> choiceBox) {
        this.xpathVersionChoiceBox = choiceBox;
        ObservableList versionItems = choiceBox.getItems();
        versionItems.add((Object)"1.0");
        versionItems.add((Object)"1.0 compatibility");
        versionItems.add((Object)"2.0");
        this.xpathVersionChoiceBox.getSelectionModel().select((Object)"2.0");
        choiceBox.setConverter(DesignerUtil.stringConverter(s -> "XPath " + s, s -> s.substring(6)));
    }

    public void evaluateXPath(Node compilationUnit, LanguageVersion version) {
        try {
            String xpath = this.getXpathExpression();
            if (StringUtils.isBlank((CharSequence)xpath)) {
                this.xpathResultListView.getItems().clear();
                return;
            }
            ObservableList results = FXCollections.observableArrayList(this.xpathEvaluator.evaluateQuery(compilationUnit, version, this.getXpathVersion(), xpath, (List<PropertyDescriptorSpec>)this.ruleBuilder.getRuleProperties()));
            this.xpathResultListView.setItems(results);
            this.violationsTitledPane.setText("Matched nodes\t(" + results.size() + ")");
        }
        catch (XPathEvaluationException e) {
            this.invalidateResults(true);
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.XPATH_EVALUATION_EXCEPTION));
        }
        this.xpathResultListView.refresh();
        this.xpathExpressionArea.requestFocus();
    }

    public void invalidateResults(boolean error) {
        this.xpathResultListView.getItems().clear();
        this.violationsTitledPane.setText("Matched nodes" + (error ? "\t(error)" : ""));
    }

    public void showExportXPathToRuleWizard() throws IOException {
        ExportXPathWizardController wizard = new ExportXPathWizardController((ObservableValue<String>)this.xpathExpressionProperty());
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("fxml/xpath-export-wizard.fxml"));
        loader.setController((Object)wizard);
        Stage dialog = new Stage();
        dialog.initOwner((Window)this.designerRoot.getMainStage());
        dialog.setOnCloseRequest(e -> wizard.shutdown());
        dialog.initModality(Modality.WINDOW_MODAL);
        Parent root = (Parent)loader.load();
        Scene scene = new Scene(root);
        dialog.setScene(scene);
        dialog.show();
    }

    public void shutdown() {
        this.xpathExpressionArea.disableSyntaxHighlighting();
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getXpathExpression() {
        return this.xpathExpressionArea.getText();
    }

    public void setXpathExpression(String expression) {
        this.xpathExpressionArea.replaceText(expression);
    }

    public Val<String> xpathExpressionProperty() {
        return Val.wrap((ObservableValue)this.xpathExpressionArea.textProperty());
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getXpathVersion() {
        return this.getRuleBuilder().getXpathVersion();
    }

    public void setXpathVersion(String xpathVersion) {
        this.getRuleBuilder().setXpathVersion(xpathVersion);
    }

    public Var<String> xpathVersionProperty() {
        return this.getRuleBuilder().xpathVersionProperty();
    }

    private ObservableXPathRuleBuilder getRuleBuilder() {
        return this.ruleBuilder;
    }

    @Override
    public List<SettingsOwner> getChildrenSettingsNodes() {
        return Collections.singletonList(this.getRuleBuilder());
    }
}

