/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Duration;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.EventLogController;
import net.sourceforge.pmd.util.fxdesigner.NodeInfoPanelController;
import net.sourceforge.pmd.util.fxdesigner.SourceEditorController;
import net.sourceforge.pmd.util.fxdesigner.XPathPanelController;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import net.sourceforge.pmd.util.fxdesigner.util.LimitedSizeStack;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsPersistenceUtil;
import org.apache.commons.io.IOUtils;
import org.reactfx.value.Val;

public class MainDesignerController
implements Initializable,
SettingsOwner {
    private final DesignerRoot designerRoot;
    @FXML
    private MenuItem openFileMenuItem;
    @FXML
    private MenuItem licenseMenuItem;
    @FXML
    private Menu openRecentMenu;
    @FXML
    private MenuItem exportToTestCodeMenuItem;
    @FXML
    private MenuItem exportXPathMenuItem;
    @FXML
    private Menu fileMenu;
    @FXML
    private Button refreshASTButton;
    @FXML
    private ChoiceBox<LanguageVersion> languageChoiceBox;
    @FXML
    private ChoiceBox<String> xpathVersionChoiceBox;
    @FXML
    private ToggleButton bottomTabsToggle;
    @FXML
    private TabPane bottomTabPane;
    @FXML
    private Tab eventLogTab;
    @FXML
    private Tab xpathEditorTab;
    @FXML
    private SplitPane mainHorizontalSplitPane;
    @FXML
    private NodeInfoPanelController nodeInfoPanelController;
    @FXML
    private XPathPanelController xpathPanelController;
    @FXML
    private SourceEditorController sourceEditorController;
    @FXML
    private EventLogController eventLogPanelController;
    private Stack<File> recentFiles = new LimitedSizeStack<File>(5);
    private Val<LanguageVersion> languageVersion = Val.constant((Object)DesignerUtil.defaultLanguageVersion());
    private Val<String> xpathVersion = Val.constant((Object)DesignerUtil.defaultXPathVersion());

    public MainDesignerController(DesignerRoot owner) {
        this.designerRoot = owner;
    }

    public void initialize(URL location, ResourceBundle resources) {
        try {
            SettingsPersistenceUtil.restoreProperties(this, DesignerUtil.getSettingsFile());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.initializeLanguageVersionMenu();
        this.initializeViewAnimation();
        this.xpathPanelController.initialiseVersionChoiceBox(this.xpathVersionChoiceBox);
        this.languageVersion = Val.wrap((ObservableValue)this.languageChoiceBox.getSelectionModel().selectedItemProperty());
        DesignerUtil.rewire(this.sourceEditorController.languageVersionProperty(), this.languageVersion, this::setLanguageVersion);
        this.xpathVersion = Val.wrap((ObservableValue)this.xpathVersionChoiceBox.getSelectionModel().selectedItemProperty());
        DesignerUtil.rewire(this.xpathPanelController.xpathVersionProperty(), this.xpathVersion, this::setXpathVersion);
        this.refreshASTButton.setOnAction(e -> this.onRefreshASTClicked());
        this.licenseMenuItem.setOnAction(e -> this.showLicensePopup());
        this.openFileMenuItem.setOnAction(e -> this.onOpenFileClicked());
        this.openRecentMenu.setOnAction(e -> this.updateRecentFilesMenu());
        this.openRecentMenu.setOnShowing(e -> this.updateRecentFilesMenu());
        this.fileMenu.setOnShowing(e -> this.onFileMenuShowing());
        this.exportXPathMenuItem.setOnAction(e -> {
            try {
                this.xpathPanelController.showExportXPathToRuleWizard();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
        this.sourceEditorController.refreshAST();
        this.xpathPanelController.evaluateXPath(this.sourceEditorController.getCompilationUnit(), this.getLanguageVersion());
        Platform.runLater(() -> this.sourceEditorController.moveCaret(0, 0));
        Platform.runLater(() -> {
            this.languageChoiceBox.show();
            this.languageChoiceBox.hide();
        });
    }

    private void initializeLanguageVersionMenu() {
        List<LanguageVersion> supported = DesignerUtil.getSupportedLanguageVersions();
        supported.sort(LanguageVersion::compareTo);
        this.languageChoiceBox.getItems().addAll(supported);
        this.languageChoiceBox.setConverter(DesignerUtil.languageVersionStringConverter());
        this.languageChoiceBox.getSelectionModel().select((Object)DesignerUtil.defaultLanguageVersion());
        this.languageChoiceBox.show();
    }

    private void initializeViewAnimation() {
        double defaultMainHorizontalSplitPaneDividerPosition = this.mainHorizontalSplitPane.getDividerPositions()[0];
        this.bottomTabsToggle.selectedProperty().addListener((observable, wasExpanded, isNowExpanded) -> {
            KeyValue keyValue = null;
            DoubleProperty divPosition = ((SplitPane.Divider)this.mainHorizontalSplitPane.getDividers().get(0)).positionProperty();
            if (wasExpanded.booleanValue() && !isNowExpanded.booleanValue()) {
                keyValue = new KeyValue((WritableValue)divPosition, (Object)1);
            } else if (!wasExpanded.booleanValue() && isNowExpanded.booleanValue()) {
                keyValue = new KeyValue((WritableValue)divPosition, (Object)defaultMainHorizontalSplitPaneDividerPosition);
            }
            if (keyValue != null) {
                Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{keyValue})});
                timeline.play();
            }
        });
    }

    public void shutdown() {
        try {
            SettingsPersistenceUtil.persistProperties(this, DesignerUtil.getSettingsFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sourceEditorController.shutdown();
        this.xpathPanelController.shutdown();
    }

    private void onRefreshASTClicked() {
        this.sourceEditorController.refreshAST();
        this.xpathPanelController.evaluateXPath(this.sourceEditorController.getCompilationUnit(), this.getLanguageVersion());
    }

    public void onNodeItemSelected(net.sourceforge.pmd.lang.ast.Node selectedValue) {
        this.nodeInfoPanelController.displayInfo(selectedValue);
        this.sourceEditorController.clearNodeHighlight();
        this.sourceEditorController.highlightNodePrimary(selectedValue);
        this.sourceEditorController.focusNodeInTreeView(selectedValue);
    }

    public void onNameDeclarationSelected(NameDeclaration declaration) {
        this.sourceEditorController.clearNodeHighlight();
        List occ = (List)declaration.getNode().getScope().getDeclarations().get(declaration);
        if (occ != null) {
            this.sourceEditorController.highlightNodesSecondary(occ.stream().map(NameOccurrence::getLocation).collect(Collectors.toList()));
        }
        this.sourceEditorController.highlightNodePrimary((net.sourceforge.pmd.lang.ast.Node)declaration.getNode());
    }

    private void showLicensePopup() {
        Alert licenseAlert = new Alert(Alert.AlertType.INFORMATION);
        licenseAlert.setWidth(500.0);
        licenseAlert.setHeaderText("License");
        ScrollPane scroll = new ScrollPane();
        try {
            scroll.setContent((Node)new TextArea(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("LICENSE"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        licenseAlert.getDialogPane().setContent((Node)scroll);
        licenseAlert.showAndWait();
    }

    private void onFileMenuShowing() {
        this.openRecentMenu.setDisable(this.recentFiles.isEmpty());
    }

    private void onOpenFileClicked() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load source from file");
        File file = chooser.showOpenDialog((Window)this.designerRoot.getMainStage());
        this.loadSourceFromFile(file);
        this.sourceEditorController.clearStyleLayers();
    }

    private void loadSourceFromFile(File file) {
        if (file != null) {
            try {
                String source = IOUtils.toString((InputStream)new FileInputStream(file));
                this.sourceEditorController.setText(source);
                LanguageVersion guess = DesignerUtil.getLanguageVersionFromExtension(file.getName());
                if (guess != null) {
                    this.languageChoiceBox.getSelectionModel().select((Object)guess);
                    this.onRefreshASTClicked();
                }
                this.recentFiles.push(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateRecentFilesMenu() {
        ArrayList<Object> items = new ArrayList<Object>();
        ArrayList<File> filesToClear = new ArrayList<File>();
        for (File f : this.recentFiles) {
            if (f.exists() && f.isFile()) {
                CustomMenuItem item = new CustomMenuItem((Node)new Label(f.getName()));
                item.setOnAction(e -> this.loadSourceFromFile(f));
                item.setMnemonicParsing(false);
                Tooltip.install((Node)item.getContent(), (Tooltip)new Tooltip(f.getAbsolutePath()));
                items.add(item);
                continue;
            }
            filesToClear.add(f);
        }
        this.recentFiles.removeAll(filesToClear);
        if (items.isEmpty()) {
            this.openRecentMenu.setDisable(true);
            return;
        }
        Collections.reverse(items);
        items.add(new SeparatorMenuItem());
        MenuItem clearItem = new MenuItem();
        clearItem.setText("Clear menu");
        clearItem.setOnAction(e -> {
            this.recentFiles.clear();
            this.openRecentMenu.setDisable(true);
        });
        items.add(clearItem);
        this.openRecentMenu.getItems().setAll(items);
    }

    public void invalidateAst() {
        this.nodeInfoPanelController.invalidateInfo();
        this.xpathPanelController.invalidateResults(false);
        this.sourceEditorController.clearNodeHighlight();
    }

    public LanguageVersion getLanguageVersion() {
        return (LanguageVersion)this.languageVersion.getValue();
    }

    public void setLanguageVersion(LanguageVersion version) {
        if (this.languageChoiceBox.getItems().contains((Object)version)) {
            this.languageChoiceBox.getSelectionModel().select((Object)version);
        }
    }

    public Val<LanguageVersion> languageVersionProperty() {
        return this.languageVersion;
    }

    public String getXpathVersion() {
        return (String)this.xpathVersion.getValue();
    }

    public void setXpathVersion(String version) {
        if (this.xpathVersionChoiceBox.getItems().contains((Object)version)) {
            this.xpathVersionChoiceBox.getSelectionModel().select((Object)version);
        }
    }

    public Val<String> xpathVersionProperty() {
        return this.xpathVersion;
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getRecentFiles() {
        StringBuilder sb = new StringBuilder();
        for (File f : this.recentFiles) {
            sb.append(',').append(f.getAbsolutePath());
        }
        return sb.length() > 0 ? sb.substring(1) : "";
    }

    public void setRecentFiles(String files) {
        List<String> fileNames = Arrays.asList(files.split(","));
        Collections.reverse(fileNames);
        for (String fileName : fileNames) {
            File f = new File(fileName);
            this.recentFiles.push(f);
        }
    }

    @SettingsPersistenceUtil.PersistentProperty
    public boolean isMaximized() {
        return this.designerRoot.getMainStage().isMaximized();
    }

    public void setMaximized(boolean b) {
        this.designerRoot.getMainStage().setMaximized(!b);
        this.designerRoot.getMainStage().setMaximized(b);
    }

    @SettingsPersistenceUtil.PersistentProperty
    public boolean isBottomTabExpanded() {
        return this.bottomTabsToggle.isSelected();
    }

    public void setBottomTabExpanded(boolean b) {
        this.bottomTabsToggle.setSelected(b);
    }

    @SettingsPersistenceUtil.PersistentProperty
    public int getBottomTabIndex() {
        return this.bottomTabPane.getSelectionModel().getSelectedIndex();
    }

    public void setBottomTabIndex(int i) {
        this.bottomTabPane.getSelectionModel().select(i);
    }

    @Override
    public List<SettingsOwner> getChildrenSettingsNodes() {
        return Arrays.asList(this.xpathPanelController, this.sourceEditorController);
    }
}

