/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForUpdate;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTRelationalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;
import org.jaxen.JaxenException;

public class ForLoopCanBeForeachRule
extends AbstractJavaRule {
    public ForLoopCanBeForeachRule() {
        this.addRuleChainVisit(ASTForStatement.class);
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        VariableNameDeclaration iterableDeclaration;
        ASTForInit init = (ASTForInit)node.getFirstChildOfType(ASTForInit.class);
        ASTForUpdate update = (ASTForUpdate)node.getFirstChildOfType(ASTForUpdate.class);
        ASTExpression guardCondition = (ASTExpression)node.getFirstChildOfType(ASTExpression.class);
        if (init == null && update == null || guardCondition == null) {
            return data;
        }
        Map.Entry<VariableNameDeclaration, List<NameOccurrence>> indexDecl = this.getIndexVarDeclaration(init, update);
        if (indexDecl == null) {
            return data;
        }
        List<NameOccurrence> occurrences = indexDecl.getValue();
        VariableNameDeclaration index = indexDecl.getKey();
        if (TypeHelper.isA(index, Iterator.class)) {
            Map.Entry<VariableNameDeclaration, List<NameOccurrence>> iterableInfo = this.getIterableDeclOfIteratorLoop(index, node.getScope());
            if (iterableInfo != null && this.isReplaceableIteratorLoop(indexDecl, guardCondition, iterableInfo, node)) {
                this.addViolation(data, (Node)node);
            }
            return data;
        }
        if (occurrences == null || !"int".equals(index.getTypeImage()) || !this.indexStartsAtZero(index)) {
            return data;
        }
        String itName = index.getName();
        String iterableName = this.getIterableNameOrNullToAbort(guardCondition, itName);
        if (!this.isForUpdateSimpleEnough(update, itName) || iterableName == null) {
            return data;
        }
        Map.Entry<VariableNameDeclaration, List<NameOccurrence>> iterableInfo = this.findDeclaration(iterableName, node.getScope());
        VariableNameDeclaration variableNameDeclaration = iterableDeclaration = iterableInfo == null ? null : iterableInfo.getKey();
        if (iterableDeclaration == null) {
            return data;
        }
        if (iterableDeclaration.isArray() && this.isReplaceableArrayLoop(node, occurrences, iterableDeclaration)) {
            this.addViolation(data, (Node)node);
        } else if (iterableDeclaration.getTypeImage() != null && iterableDeclaration.getTypeImage().matches("List|ArrayList|LinkedList") && this.isReplaceableListLoop(node, occurrences, iterableDeclaration)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private Map.Entry<VariableNameDeclaration, List<NameOccurrence>> getIndexVarDeclaration(ASTForInit init, ASTForUpdate update) {
        if (init == null) {
            return this.guessIndexVarFromUpdate(update);
        }
        ASTLocalVariableDeclaration decl = (ASTLocalVariableDeclaration)init.getFirstChildOfType(ASTLocalVariableDeclaration.class);
        if (decl == null) {
            return null;
        }
        int numDeclaredVars = decl.findChildrenOfType(ASTVariableDeclarator.class).size();
        if (numDeclaredVars > 1) {
            return null;
        }
        Map decls = init.getScope().getDeclarations(VariableNameDeclaration.class);
        Map.Entry indexVarAndOccurrences = null;
        for (Map.Entry e : decls.entrySet()) {
            ASTForInit declInit = (ASTForInit)((VariableNameDeclaration)e.getKey()).getNode().getFirstParentOfType(ASTForInit.class);
            if (declInit != init) continue;
            indexVarAndOccurrences = e;
            break;
        }
        return indexVarAndOccurrences;
    }

    private Map.Entry<VariableNameDeclaration, List<NameOccurrence>> guessIndexVarFromUpdate(ASTForUpdate update) {
        Node name = null;
        try {
            List match = update.findChildNodesWithXPath(this.getSimpleForUpdateXpath(null));
            if (!match.isEmpty()) {
                name = (Node)match.get(0);
            }
        }
        catch (JaxenException je) {
            throw new RuntimeException(je);
        }
        if (name == null || name.getImage() == null) {
            return null;
        }
        return this.findDeclaration(name.getImage(), update.getScope().getParent());
    }

    private boolean isForUpdateSimpleEnough(ASTForUpdate update, String itName) {
        return update != null && update.hasDescendantMatchingXPath(this.getSimpleForUpdateXpath(itName));
    }

    private String getSimpleForUpdateXpath(String itName) {
        return "./StatementExpressionList[count(*)=1]/StatementExpression/*[self::PostfixExpression and @Image='++' or self::PreIncrementExpression]/PrimaryExpression/PrimaryPrefix/Name" + (itName == null ? "" : "[@Image='" + itName + "']");
    }

    private boolean indexStartsAtZero(VariableNameDeclaration index) {
        ASTVariableDeclaratorId name = (ASTVariableDeclaratorId)index.getNode();
        ASTVariableDeclarator declarator = (ASTVariableDeclarator)name.getFirstParentOfType(ASTVariableDeclarator.class);
        if (declarator == null) {
            return false;
        }
        try {
            List zeroLiteral = declarator.findChildNodesWithXPath("./VariableInitializer/Expression/PrimaryExpression/PrimaryPrefix/Literal[@Image='0' and @StringLiteral='false']");
            if (!zeroLiteral.isEmpty()) {
                return true;
            }
        }
        catch (JaxenException je) {
            throw new RuntimeException(je);
        }
        return false;
    }

    private String getIterableNameOrNullToAbort(ASTExpression guardCondition, String itName) {
        ASTRelationalExpression relationalExpression;
        if (guardCondition.jjtGetNumChildren() > 0 && guardCondition.jjtGetChild(0) instanceof ASTRelationalExpression && ((relationalExpression = (ASTRelationalExpression)guardCondition.jjtGetChild(0)).hasImageEqualTo("<") || relationalExpression.hasImageEqualTo("<="))) {
            try {
                List left = guardCondition.findChildNodesWithXPath("./RelationalExpression/PrimaryExpression/PrimaryPrefix/Name[@Image='" + itName + "']");
                List right = guardCondition.findChildNodesWithXPath("./RelationalExpression[@Image='<']/PrimaryExpression/PrimaryPrefix/Name[matches(@Image,'\\w+\\.(size|length)')]|./RelationalExpression[@Image='<=']/AdditiveExpression[count(*)=2 and @Image='-' and PrimaryExpression/PrimaryPrefix/Literal[@Image='1']]/PrimaryExpression/PrimaryPrefix/Name[matches(@Image,'\\w+\\.(size|length)')]");
                if (left.isEmpty()) {
                    return null;
                }
                if (!right.isEmpty()) {
                    return ((Node)right.get(0)).getImage().split("\\.")[0];
                }
                return null;
            }
            catch (JaxenException je) {
                throw new RuntimeException(je);
            }
        }
        return null;
    }

    private Map.Entry<VariableNameDeclaration, List<NameOccurrence>> getIterableDeclOfIteratorLoop(VariableNameDeclaration indexDecl, Scope scope) {
        Node initializer = (Node)((ASTVariableDeclarator)indexDecl.getNode().getFirstParentOfType(ASTVariableDeclarator.class)).getFirstChildOfType(ASTVariableInitializer.class);
        if (initializer == null) {
            return null;
        }
        ASTName nameNode = (ASTName)initializer.getFirstDescendantOfType(ASTName.class);
        if (nameNode == null) {
            return null;
        }
        String name = nameNode.getImage();
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0) {
            name = name.substring(0, dotIndex);
        }
        return this.findDeclaration(name, scope);
    }

    private boolean isReplaceableArrayLoop(ASTForStatement stmt, List<NameOccurrence> occurrences, VariableNameDeclaration arrayDeclaration) {
        String arrayName = arrayDeclaration.getName();
        for (NameOccurrence occ : occurrences) {
            if (occ.getLocation().getFirstParentOfType(ASTForUpdate.class) != null || occ.getLocation().getFirstParentOfType(ASTExpression.class) == stmt.getFirstChildOfType(ASTExpression.class) || this.occurenceIsArrayAccess(occ, arrayName)) continue;
            return false;
        }
        return true;
    }

    private boolean occurenceIsArrayAccess(NameOccurrence occ, String arrayName) {
        if (occ.getLocation() instanceof ASTName) {
            ASTPrimarySuffix suffix = (ASTPrimarySuffix)occ.getLocation().getFirstParentOfType(ASTPrimarySuffix.class);
            if (suffix == null || !suffix.isArrayDereference()) {
                return false;
            }
            return suffix.hasDescendantMatchingXPath("./Expression/PrimaryExpression[count(*)=1]/PrimaryPrefix/Name[@Image='" + occ.getImage() + "']") && suffix.hasDescendantMatchingXPath("../PrimaryPrefix/Name[@Image='" + arrayName + "']") && !suffix.hasDescendantMatchingXPath("../../AssignmentOperator");
        }
        return false;
    }

    private boolean isReplaceableListLoop(ASTForStatement stmt, List<NameOccurrence> occurrences, VariableNameDeclaration listDeclaration) {
        String listName = listDeclaration.getName();
        for (NameOccurrence occ : occurrences) {
            if (occ.getLocation().getFirstParentOfType(ASTForUpdate.class) != null || occ.getLocation().getFirstParentOfType(ASTExpression.class) == stmt.getFirstChildOfType(ASTExpression.class) || this.occurenceIsListGet(occ, listName)) continue;
            return false;
        }
        return true;
    }

    private boolean occurenceIsListGet(NameOccurrence occ, String listName) {
        if (occ.getLocation() instanceof ASTName) {
            ASTPrimarySuffix suffix = (ASTPrimarySuffix)occ.getLocation().getFirstParentOfType(ASTPrimarySuffix.class);
            if (suffix == null) {
                return false;
            }
            Node prefix = suffix.jjtGetParent().jjtGetChild(0);
            if (!(prefix instanceof ASTPrimaryPrefix) && prefix.jjtGetNumChildren() != 1 && !(prefix.jjtGetChild(0) instanceof ASTName)) {
                return false;
            }
            String callImage = prefix.jjtGetChild(0).getImage();
            return (listName + ".get").equals(callImage);
        }
        return false;
    }

    private Map.Entry<VariableNameDeclaration, List<NameOccurrence>> findDeclaration(String varName, Scope innermost) {
        for (Scope currentScope = innermost; currentScope != null; currentScope = currentScope.getParent()) {
            for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : currentScope.getDeclarations(VariableNameDeclaration.class).entrySet()) {
                if (!((VariableNameDeclaration)entry.getKey()).getName().equals(varName)) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean isReplaceableIteratorLoop(Map.Entry<VariableNameDeclaration, List<NameOccurrence>> indexInfo, ASTExpression guardCondition, Map.Entry<VariableNameDeclaration, List<NameOccurrence>> iterableInfo, ASTForStatement stmt) {
        if (this.isIterableModifiedInsideLoop(iterableInfo, stmt)) {
            return false;
        }
        String indexName = indexInfo.getKey().getName();
        if (indexName == null) {
            return false;
        }
        if (!guardCondition.hasDescendantMatchingXPath("./PrimaryExpression/PrimaryPrefix/Name[@Image='" + indexName + ".hasNext']")) {
            return false;
        }
        List<NameOccurrence> occurrences = indexInfo.getValue();
        if (occurrences.size() > 2) {
            return false;
        }
        for (NameOccurrence occ : indexInfo.getValue()) {
            String image = occ.getLocation().getImage();
            if (occ.getLocation() instanceof ASTName && ((indexName + ".hasNext").equals(image) || (indexName + ".next").equals(image))) continue;
            return false;
        }
        return true;
    }

    private boolean isIterableModifiedInsideLoop(Map.Entry<VariableNameDeclaration, List<NameOccurrence>> iterableInfo, ASTForStatement stmt) {
        String iterableName = iterableInfo.getKey().getName();
        for (NameOccurrence occ : iterableInfo.getValue()) {
            String image;
            ASTForStatement forParent = (ASTForStatement)occ.getLocation().getFirstParentOfType(ASTForStatement.class);
            if (forParent != stmt || !(image = occ.getLocation().getImage()).startsWith(iterableName + ".remove")) continue;
            return true;
        }
        return false;
    }
}

