/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.constant.RefConstant;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramFieldOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class StoringInvocationUnit
extends BasicInvocationUnit {
    private boolean storeFieldValues;
    private boolean storeMethodParameterValues;
    private boolean storeMethodReturnValues;

    public StoringInvocationUnit(ValueFactory valueFactory) {
        this(valueFactory, true, true, true);
    }

    public StoringInvocationUnit(ValueFactory valueFactory, boolean bl, boolean bl2, boolean bl3) {
        super(valueFactory);
        this.storeFieldValues = bl;
        this.storeMethodParameterValues = bl2;
        this.storeMethodReturnValues = bl3;
    }

    @Override
    public void setFieldClassValue(Clazz clazz, RefConstant refConstant, ReferenceValue referenceValue) {
        Member member;
        if (this.storeFieldValues && (member = refConstant.referencedMember) != null) {
            StoringInvocationUnit.generalizeFieldClassValue((Field)member, referenceValue);
        }
    }

    @Override
    public void setFieldValue(Clazz clazz, RefConstant refConstant, Value value) {
        Member member;
        if (this.storeFieldValues && (member = refConstant.referencedMember) != null) {
            StoringInvocationUnit.generalizeFieldValue((Field)member, value);
        }
    }

    @Override
    public void setMethodParameterValue(Clazz clazz, RefConstant refConstant, int n, Value value) {
        Member member;
        if (this.storeMethodParameterValues && (member = refConstant.referencedMember) != null) {
            StoringInvocationUnit.generalizeMethodParameterValue((Method)member, n, value);
        }
    }

    @Override
    public void setMethodReturnValue(Clazz clazz, Method method, Value value) {
        if (this.storeMethodReturnValues) {
            StoringInvocationUnit.generalizeMethodReturnValue(method, value);
        }
    }

    private static void generalizeFieldClassValue(Field field, ReferenceValue referenceValue) {
        if (!KeepMarker.isKept(field)) {
            ProgramFieldOptimizationInfo.getProgramFieldOptimizationInfo(field).generalizeReferencedClass(referenceValue);
        }
    }

    public static ReferenceValue getFieldClassValue(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).getReferencedClass();
    }

    private static void generalizeFieldValue(Field field, Value value) {
        if (!KeepMarker.isKept(field)) {
            ProgramFieldOptimizationInfo.getProgramFieldOptimizationInfo(field).generalizeValue(value);
        }
    }

    public static Value getFieldValue(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).getValue();
    }

    private static void generalizeMethodParameterValue(Method method, int n, Value value) {
        if (!KeepMarker.isKept(method)) {
            ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).generalizeParameterValue(n, value);
        }
    }

    public static Value getMethodParameterValue(Method method, int n) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getParameterValue(n);
    }

    private static void generalizeMethodReturnValue(Method method, Value value) {
        if (!KeepMarker.isKept(method)) {
            ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).generalizeReturnValue(value);
        }
    }

    public static Value getMethodReturnValue(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getReturnValue();
    }
}

