/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllBootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.AllExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.DebugAttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.constant.visitor.BootstrapMethodArgumentVisitor;
import proguard.classfile.constant.visitor.BootstrapMethodHandleTraveler;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.MethodrefTraveler;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InnerClassesAccessFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.editor.MethodInvocationFixer;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionConstantVisitor;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.DotClassClassVisitor;
import proguard.classfile.visitor.DynamicReturnedClassVisitor;
import proguard.classfile.visitor.ExceptionCounter;
import proguard.classfile.visitor.ExceptionHandlerConstantVisitor;
import proguard.classfile.visitor.FunctionalInterfaceFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ParallelAllClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.DetailedArrayValueFactory;
import proguard.evaluation.value.IdentifiedValueFactory;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.BootstrapMethodArgumentShrinker;
import proguard.optimize.ConstantMemberFilter;
import proguard.optimize.ConstantParameterFilter;
import proguard.optimize.DuplicateInitializerFixer;
import proguard.optimize.DuplicateInitializerInvocationFixer;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptClassFilter;
import proguard.optimize.KeptMemberFilter;
import proguard.optimize.MethodDescriptorShrinker;
import proguard.optimize.MethodStaticizer;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.ParameterShrinker;
import proguard.optimize.TailRecursionSimplifier;
import proguard.optimize.WriteOnlyFieldFilter;
import proguard.optimize.evaluation.EvaluationShrinker;
import proguard.optimize.evaluation.EvaluationSimplifier;
import proguard.optimize.evaluation.InstructionUsageMarker;
import proguard.optimize.evaluation.LoadingInvocationUnit;
import proguard.optimize.evaluation.ParameterTracingInvocationUnit;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.optimize.evaluation.SimpleEnumArrayPropagator;
import proguard.optimize.evaluation.SimpleEnumClassChecker;
import proguard.optimize.evaluation.SimpleEnumClassSimplifier;
import proguard.optimize.evaluation.SimpleEnumDescriptorSimplifier;
import proguard.optimize.evaluation.SimpleEnumUseChecker;
import proguard.optimize.evaluation.SimpleEnumUseSimplifier;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.evaluation.VariableOptimizer;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.CaughtClassMarker;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.DynamicInvocationMarker;
import proguard.optimize.info.EscapingClassFilter;
import proguard.optimize.info.EscapingClassMarker;
import proguard.optimize.info.InstanceofClassMarker;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.MutableBoolean;
import proguard.optimize.info.NoEscapingParametersMethodMarker;
import proguard.optimize.info.NoExternalReturnValuesMethodMarker;
import proguard.optimize.info.NoExternalSideEffectMethodMarker;
import proguard.optimize.info.NoSideEffectClassMarker;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.NonEmptyStackReturnMarker;
import proguard.optimize.info.NonPrivateMemberMarker;
import proguard.optimize.info.OptimizationCodeAttributeFilter;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ParameterEscapeMarker;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.ProgramClassOptimizationInfoSetter;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.RepeatedClassPoolVisitor;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.optimize.info.SimpleEnumFilter;
import proguard.optimize.info.SimpleEnumMarker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.info.SynchronizedBlockMethodMarker;
import proguard.optimize.info.UnusedParameterMethodFilter;
import proguard.optimize.info.UnusedParameterOptimizationInfoUpdater;
import proguard.optimize.info.WrapperClassMarker;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.ClassFinalizer;
import proguard.optimize.peephole.GotoCommonCodeReplacer;
import proguard.optimize.peephole.GotoGotoReplacer;
import proguard.optimize.peephole.GotoReturnReplacer;
import proguard.optimize.peephole.HorizontalClassMerger;
import proguard.optimize.peephole.InstructionSequenceConstants;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.MemberPrivatizer;
import proguard.optimize.peephole.MethodFinalizer;
import proguard.optimize.peephole.MethodInliner;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.optimize.peephole.RetargetedClassFilter;
import proguard.optimize.peephole.RetargetedInnerClassAttributeRemover;
import proguard.optimize.peephole.TargetClassChanger;
import proguard.optimize.peephole.UnreachableCodeRemover;
import proguard.optimize.peephole.UnreachableExceptionRemover;
import proguard.optimize.peephole.VariableShrinker;
import proguard.optimize.peephole.VerticalClassMerger;
import proguard.optimize.peephole.WrapperClassMerger;
import proguard.optimize.peephole.WrapperClassUseSimplifier;
import proguard.util.CollectionMatcher;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.MultiValueMap;
import proguard.util.NameParser;
import proguard.util.NotMatcher;

public class Optimizer {
    public static final boolean DETAILS = System.getProperty("optd") != null;
    private static final String CLASS_MARKING_FINAL = "class/marking/final";
    private static final String CLASS_UNBOXING_ENUM = "class/unboxing/enum";
    private static final String CLASS_MERGING_VERTICAL = "class/merging/vertical";
    private static final String CLASS_MERGING_HORIZONTAL = "class/merging/horizontal";
    private static final String CLASS_MERGING_WRAPPER = "class/merging/wrapper";
    private static final String FIELD_REMOVAL_WRITEONLY = "field/removal/writeonly";
    private static final String FIELD_MARKING_PRIVATE = "field/marking/private";
    private static final String FIELD_PROPAGATION_VALUE = "field/propagation/value";
    private static final String METHOD_MARKING_PRIVATE = "method/marking/private";
    private static final String METHOD_MARKING_STATIC = "method/marking/static";
    private static final String METHOD_MARKING_FINAL = "method/marking/final";
    private static final String METHOD_MARKING_SYNCHRONIZED = "method/marking/synchronized";
    private static final String METHOD_REMOVAL_PARAMETER = "method/removal/parameter";
    private static final String METHOD_PROPAGATION_PARAMETER = "method/propagation/parameter";
    private static final String METHOD_PROPAGATION_RETURNVALUE = "method/propagation/returnvalue";
    private static final String METHOD_INLINING_SHORT = "method/inlining/short";
    private static final String METHOD_INLINING_UNIQUE = "method/inlining/unique";
    private static final String METHOD_INLINING_TAILRECURSION = "method/inlining/tailrecursion";
    private static final String CODE_MERGING = "code/merging";
    private static final String CODE_SIMPLIFICATION_VARIABLE = "code/simplification/variable";
    private static final String CODE_SIMPLIFICATION_ARITHMETIC = "code/simplification/arithmetic";
    private static final String CODE_SIMPLIFICATION_CAST = "code/simplification/cast";
    private static final String CODE_SIMPLIFICATION_FIELD = "code/simplification/field";
    private static final String CODE_SIMPLIFICATION_BRANCH = "code/simplification/branch";
    private static final String CODE_SIMPLIFICATION_OBJECT = "code/simplification/object";
    private static final String CODE_SIMPLIFICATION_STRING = "code/simplification/string";
    private static final String CODE_SIMPLIFICATION_MATH = "code/simplification/math";
    private static final String CODE_SIMPLIFICATION_ADVANCED = "code/simplification/advanced";
    private static final String CODE_REMOVAL_ADVANCED = "code/removal/advanced";
    private static final String CODE_REMOVAL_SIMPLE = "code/removal/simple";
    private static final String CODE_REMOVAL_VARIABLE = "code/removal/variable";
    private static final String CODE_REMOVAL_EXCEPTION = "code/removal/exception";
    private static final String CODE_ALLOCATION_VARIABLE = "code/allocation/variable";
    public static final String[] OPTIMIZATION_NAMES = new String[]{"class/marking/final", "class/merging/vertical", "class/merging/horizontal", "field/removal/writeonly", "field/marking/private", "field/propagation/value", "method/marking/private", "method/marking/static", "method/marking/final", "method/marking/synchronized", "method/removal/parameter", "method/propagation/parameter", "method/propagation/returnvalue", "method/inlining/short", "method/inlining/unique", "method/inlining/tailrecursion", "code/merging", "code/simplification/variable", "code/simplification/arithmetic", "code/simplification/cast", "code/simplification/field", "code/simplification/branch", "code/simplification/string", "code/simplification/math", "code/simplification/advanced", "code/removal/advanced", "code/removal/simple", "code/removal/variable", "code/removal/exception", "code/allocation/variable"};
    private final Configuration configuration;
    private final boolean classMarkingFinal;
    private final boolean classUnboxingEnum;
    private final boolean classMergingVertical;
    private final boolean classMergingHorizontal;
    private final boolean classMergingWrapper;
    private final boolean fieldRemovalWriteonly;
    private final boolean fieldMarkingPrivate;
    private final boolean fieldPropagationValue;
    private final boolean methodMarkingPrivate;
    private final boolean methodMarkingStatic;
    private final boolean methodMarkingFinal;
    private final boolean methodMarkingSynchronized;
    private final boolean methodRemovalParameter;
    private final boolean methodPropagationParameter;
    private final boolean methodPropagationReturnvalue;
    private final boolean methodInliningShort;
    private final boolean methodInliningUnique;
    private final boolean methodInliningTailrecursion;
    private final boolean codeMerging;
    private final boolean codeSimplificationVariable;
    private final boolean codeSimplificationArithmetic;
    private final boolean codeSimplificationCast;
    private final boolean codeSimplificationField;
    private final boolean codeSimplificationBranch;
    private final boolean codeSimplificationObject;
    private final boolean codeSimplificationString;
    private final boolean codeSimplificationMath;
    private final boolean codeSimplificationPeephole;
    private boolean codeSimplificationAdvanced;
    private boolean codeRemovalAdvanced;
    private boolean codeRemovalSimple;
    private final boolean codeRemovalVariable;
    private boolean codeRemovalException;
    private final boolean codeAllocationVariable;

    public Optimizer(Configuration configuration) {
        this.configuration = configuration;
        ConstantMatcher constantMatcher = configuration.optimizations != null ? new ListParser(new NameParser()).parse(configuration.optimizations) : new ConstantMatcher(true);
        this.classMarkingFinal = constantMatcher.matches(CLASS_MARKING_FINAL);
        this.classUnboxingEnum = constantMatcher.matches(CLASS_UNBOXING_ENUM);
        this.classMergingVertical = constantMatcher.matches(CLASS_MERGING_VERTICAL);
        this.classMergingHorizontal = constantMatcher.matches(CLASS_MERGING_HORIZONTAL);
        this.classMergingWrapper = constantMatcher.matches(CLASS_MERGING_WRAPPER);
        this.fieldRemovalWriteonly = constantMatcher.matches(FIELD_REMOVAL_WRITEONLY);
        this.fieldMarkingPrivate = constantMatcher.matches(FIELD_MARKING_PRIVATE);
        this.fieldPropagationValue = constantMatcher.matches(FIELD_PROPAGATION_VALUE);
        this.methodMarkingPrivate = constantMatcher.matches(METHOD_MARKING_PRIVATE);
        this.methodMarkingStatic = constantMatcher.matches(METHOD_MARKING_STATIC);
        this.methodMarkingFinal = constantMatcher.matches(METHOD_MARKING_FINAL);
        this.methodMarkingSynchronized = constantMatcher.matches(METHOD_MARKING_SYNCHRONIZED);
        this.methodRemovalParameter = constantMatcher.matches(METHOD_REMOVAL_PARAMETER);
        this.methodPropagationParameter = constantMatcher.matches(METHOD_PROPAGATION_PARAMETER);
        this.methodPropagationReturnvalue = constantMatcher.matches(METHOD_PROPAGATION_RETURNVALUE);
        this.methodInliningShort = constantMatcher.matches(METHOD_INLINING_SHORT);
        this.methodInliningUnique = constantMatcher.matches(METHOD_INLINING_UNIQUE);
        this.methodInliningTailrecursion = constantMatcher.matches(METHOD_INLINING_TAILRECURSION);
        this.codeMerging = constantMatcher.matches(CODE_MERGING);
        this.codeSimplificationVariable = constantMatcher.matches(CODE_SIMPLIFICATION_VARIABLE);
        this.codeSimplificationArithmetic = constantMatcher.matches(CODE_SIMPLIFICATION_ARITHMETIC);
        this.codeSimplificationCast = constantMatcher.matches(CODE_SIMPLIFICATION_CAST);
        this.codeSimplificationField = constantMatcher.matches(CODE_SIMPLIFICATION_FIELD);
        this.codeSimplificationBranch = constantMatcher.matches(CODE_SIMPLIFICATION_BRANCH);
        this.codeSimplificationObject = constantMatcher.matches(CODE_SIMPLIFICATION_OBJECT);
        this.codeSimplificationString = constantMatcher.matches(CODE_SIMPLIFICATION_STRING);
        this.codeSimplificationMath = constantMatcher.matches(CODE_SIMPLIFICATION_MATH);
        this.codeSimplificationAdvanced = constantMatcher.matches(CODE_SIMPLIFICATION_ADVANCED);
        this.codeRemovalAdvanced = constantMatcher.matches(CODE_REMOVAL_ADVANCED);
        this.codeRemovalSimple = constantMatcher.matches(CODE_REMOVAL_SIMPLE);
        this.codeRemovalVariable = constantMatcher.matches(CODE_REMOVAL_VARIABLE);
        this.codeRemovalException = constantMatcher.matches(CODE_REMOVAL_EXCEPTION);
        this.codeAllocationVariable = constantMatcher.matches(CODE_ALLOCATION_VARIABLE);
        this.codeSimplificationAdvanced = this.codeSimplificationAdvanced || this.fieldPropagationValue || this.methodPropagationParameter || this.methodPropagationReturnvalue;
        this.codeRemovalAdvanced = this.codeRemovalAdvanced || this.fieldRemovalWriteonly || this.methodMarkingStatic || this.methodRemovalParameter;
        this.codeRemovalSimple = this.codeRemovalSimple || this.codeSimplificationBranch;
        this.codeRemovalException = this.codeRemovalException || this.codeRemovalAdvanced || this.codeRemovalSimple;
        this.codeSimplificationPeephole = this.codeSimplificationVariable || this.codeSimplificationArithmetic || this.codeSimplificationCast || this.codeSimplificationField || this.codeSimplificationBranch || this.codeSimplificationObject || this.codeSimplificationString || this.codeSimplificationMath;
    }

    public boolean execute(final ClassPool classPool, final ClassPool classPool2, MultiValueMap<String, String> multiValueMap) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        ClassCounter classCounter = new ClassCounter();
        ClassCounter classCounter2 = new ClassCounter();
        ClassCounter classCounter3 = new ClassCounter();
        ClassCounter classCounter4 = new ClassCounter();
        ClassCounter classCounter5 = new ClassCounter();
        MemberCounter memberCounter = new MemberCounter();
        MemberCounter memberCounter2 = new MemberCounter();
        MemberCounter memberCounter3 = new MemberCounter();
        MemberCounter memberCounter4 = new MemberCounter();
        MemberCounter memberCounter5 = new MemberCounter();
        MemberCounter memberCounter6 = new MemberCounter();
        MemberCounter memberCounter7 = new MemberCounter();
        MemberCounter memberCounter8 = new MemberCounter();
        MemberCounter memberCounter9 = new MemberCounter();
        MemberCounter memberCounter10 = new MemberCounter();
        MemberCounter memberCounter11 = new MemberCounter();
        InstructionCounter instructionCounter = new InstructionCounter();
        InstructionCounter instructionCounter2 = new InstructionCounter();
        InstructionCounter instructionCounter3 = new InstructionCounter();
        InstructionCounter instructionCounter4 = new InstructionCounter();
        final InstructionCounter instructionCounter5 = new InstructionCounter();
        final InstructionCounter instructionCounter6 = new InstructionCounter();
        final InstructionCounter instructionCounter7 = new InstructionCounter();
        final InstructionCounter instructionCounter8 = new InstructionCounter();
        final InstructionCounter instructionCounter9 = new InstructionCounter();
        final InstructionCounter instructionCounter10 = new InstructionCounter();
        final InstructionCounter instructionCounter11 = new InstructionCounter();
        final InstructionCounter instructionCounter12 = new InstructionCounter();
        final InstructionCounter instructionCounter13 = new InstructionCounter();
        final InstructionCounter instructionCounter14 = new InstructionCounter();
        final InstructionCounter instructionCounter15 = new InstructionCounter();
        final InstructionCounter instructionCounter16 = new InstructionCounter();
        MemberCounter memberCounter12 = new MemberCounter();
        ExceptionCounter exceptionCounter = new ExceptionCounter();
        final MemberCounter memberCounter13 = new MemberCounter();
        MemberCounter memberCounter14 = new MemberCounter();
        MemberCounter memberCounter15 = new MemberCounter();
        classPool.classesAccept(new ClassCleaner());
        classPool2.classesAccept(new ClassCleaner());
        classPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        classPool2.classesAccept(new BottomClassFilter(new MethodLinker()));
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolVisitor = new KeepClassSpecificationVisitorFactory(false, true, false).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)keepMarker, (MemberVisitor)keepMarker, (MemberVisitor)keepMarker, (AttributeVisitor)keepMarker);
        classPool.accept(classPoolVisitor);
        classPool2.accept(classPoolVisitor);
        classPool2.classesAccept(keepMarker);
        classPool2.classesAccept(new AllMemberVisitor(keepMarker));
        classPool.classesAccept(new ClassAccessFilter(0, 16384, new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DotClassClassVisitor(keepMarker))))));
        classPool.classesAccept(new AllConstantVisitor(new ConstantTagFilter(8, (ConstantVisitor)new ReferencedClassVisitor(keepMarker))));
        classPool.classesAccept(new AllConstantVisitor(new ConstantTagFilter(8, (ConstantVisitor)new ReferencedMemberVisitor(keepMarker))));
        classPool.classesAccept(new ClassVersionFilter(0x330000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor(new BootstrapMethodHandleTraveler(new MethodrefTraveler(new ReferencedMemberVisitor(keepMarker))))))));
        classPool.classesAccept(new ClassVersionFilter(0x330000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor(new BootstrapMethodArgumentVisitor(new MethodrefTraveler(new ReferencedMemberVisitor(keepMarker))))))));
        classPool.classesAccept(new ClassVersionFilter(0x330000, new AllConstantVisitor(new DynamicReturnedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new MultiClassVisitor(keepMarker, new AllMethodVisitor(new MemberAccessFilter(1024, 0, keepMarker)))))))));
        classPool.classesAccept(new ProgramClassOptimizationInfoSetter());
        classPool.classesAccept(new AllMemberVisitor(new ProgramMemberOptimizationInfoSetter()));
        if (this.configuration.assumeNoSideEffects != null) {
            object5 = new NoSideEffectClassMarker();
            object4 = new NoSideEffectMethodMarker();
            object3 = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.assumeNoSideEffects, (ClassVisitor)object5, (MemberVisitor)object4);
            classPool.accept((ClassPoolVisitor)object3);
            classPool2.accept((ClassPoolVisitor)object3);
        }
        if (this.configuration.assumeNoExternalSideEffects != null) {
            object5 = new NoSideEffectClassMarker();
            object4 = new NoExternalSideEffectMethodMarker();
            object3 = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.assumeNoExternalSideEffects, (ClassVisitor)object5, (MemberVisitor)object4);
            classPool.accept((ClassPoolVisitor)object3);
            classPool2.accept((ClassPoolVisitor)object3);
        }
        if (this.configuration.assumeNoEscapingParameters != null) {
            object5 = new NoEscapingParametersMethodMarker();
            object4 = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.assumeNoEscapingParameters, null, (MemberVisitor)object5);
            classPool.accept((ClassPoolVisitor)object4);
            classPool2.accept((ClassPoolVisitor)object4);
        }
        if (this.configuration.assumeNoExternalReturnValues != null) {
            object5 = new NoExternalReturnValuesMethodMarker();
            object4 = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.assumeNoExternalReturnValues, null, (MemberVisitor)object5);
            classPool.accept((ClassPoolVisitor)object4);
            classPool2.accept((ClassPoolVisitor)object4);
        }
        if (this.classMarkingFinal) {
            classPool.classesAccept(new ClassFinalizer(classCounter));
        }
        if (this.methodMarkingFinal) {
            classPool.classesAccept(new ClassAccessFilter(0, 512, new AllMethodVisitor(new MethodFinalizer(memberCounter6))));
        }
        object5 = new MutableBoolean();
        object4 = new ReadWriteFieldMarker((MutableBoolean)object5);
        if (!this.fieldRemovalWriteonly) {
            classPool.classesAccept(new AllFieldVisitor((MemberVisitor)object4));
        }
        object3 = new SideEffectMethodMarker((MutableBoolean)object5);
        ParameterEscapeMarker parameterEscapeMarker = new ParameterEscapeMarker((MutableBoolean)object5);
        classPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MultiMemberVisitor(new MemberVisitor[]{object3, parameterEscapeMarker}))));
        classPool.accept(new TimedClassPoolVisitor("Marking field usage in kept methods", new AllMethodVisitor(new OptimizationInfoMemberFilter(null, new AllAttributeVisitor(new AllInstructionVisitor((InstructionVisitor)object4))))));
        Object object6 = new ParallelAllClassVisitor.ClassVisitorFactory((MutableBoolean)object5){
            final /* synthetic */ MutableBoolean val$repeatTrigger;
            {
                this.val$repeatTrigger = mutableBoolean;
            }

            @Override
            public ClassVisitor createClassVisitor() {
                ReferenceTracingValueFactory referenceTracingValueFactory = new ReferenceTracingValueFactory(new TypedReferenceValueFactory());
                PartialEvaluator partialEvaluator = new PartialEvaluator(referenceTracingValueFactory, new ParameterTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), false, referenceTracingValueFactory);
                InstructionUsageMarker instructionUsageMarker = new InstructionUsageMarker(partialEvaluator, false);
                ReadWriteFieldMarker readWriteFieldMarker = new ReadWriteFieldMarker(this.val$repeatTrigger);
                SideEffectMethodMarker sideEffectMethodMarker = new SideEffectMethodMarker(this.val$repeatTrigger);
                ParameterEscapeMarker parameterEscapeMarker = new ParameterEscapeMarker(this.val$repeatTrigger, partialEvaluator, false);
                return new AllMethodVisitor(new OptimizationInfoMemberFilter(new AllAttributeVisitor(new DebugAttributeVisitor("Marking fields, methods, and parameters", new MultiAttributeVisitor(partialEvaluator, parameterEscapeMarker, instructionUsageMarker, new AllInstructionVisitor(instructionUsageMarker.necessaryInstructionFilter(new MultiInstructionVisitor(readWriteFieldMarker, sideEffectMethodMarker, parameterEscapeMarker))))))));
            }
        };
        classPool.accept(new RepeatedClassPoolVisitor((MutableBoolean)object5, new TimedClassPoolVisitor("Marking fields, methods and parameters", new ParallelAllClassVisitor((ParallelAllClassVisitor.ClassVisitorFactory)object6))));
        if (this.methodMarkingSynchronized) {
            classPool.classesAccept(new EscapingClassFilter(new ClassHierarchyTraveler(false, true, true, false, new EscapingClassMarker())));
            object6 = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    return new AllMethodVisitor(new AllAttributeVisitor(new EscapingClassMarker()));
                }
            };
            classPool.accept(new TimedClassPoolVisitor("Marking escaping classes", new ParallelAllClassVisitor((ParallelAllClassVisitor.ClassVisitorFactory)object6)));
            classPool.classesAccept(new EscapingClassFilter(null, new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(32, 8, new MultiMemberVisitor(new MemberAccessFlagCleaner(32), memberCounter7))))));
        }
        if (this.fieldRemovalWriteonly) {
            classPool.classesAccept(new AllFieldVisitor(new WriteOnlyFieldFilter(memberCounter)));
        }
        if (this.classUnboxingEnum) {
            object6 = new ClassCounter();
            classPool.classesAccept(new ClassAccessFilter(16400, 0, new OptimizationInfoClassFilter(new SimpleEnumClassChecker())));
            classPool.classesAccept(new SimpleEnumFilter((ClassVisitor)object6));
            if (((ClassCounter)object6).getCount() > 0) {
                classPool.classesAccept(new SimpleEnumUseChecker());
                classPool.classesAccept(new SimpleEnumFilter(null, new AllMemberVisitor(new KeptMemberFilter(new MemberDescriptorReferencedClassVisitor(new OptimizationInfoClassFilter(new SimpleEnumMarker(false)))))));
                classPool.classesAccept(new SimpleEnumFilter(classCounter2));
                if (classCounter2.getCount() > 0) {
                    classPool.accept(new TimedClassPoolVisitor("Simplify use of simple enums", new AllMethodVisitor(new AllAttributeVisitor(new SimpleEnumUseSimplifier()))));
                    classPool.classesAccept(new SimpleEnumFilter(new SimpleEnumClassSimplifier()));
                    classPool.classesAccept(new SimpleEnumDescriptorSimplifier());
                    classPool.classesAccept(new MemberReferenceFixer());
                }
            }
        }
        object6 = new ParallelAllClassVisitor.ClassVisitorFactory(){

            @Override
            public ClassVisitor createClassVisitor() {
                return new AllMethodVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker(!Optimizer.this.methodMarkingStatic, !Optimizer.this.methodRemovalParameter)));
            }
        };
        classPool.accept(new TimedClassPoolVisitor("Marking used parameters", new ParallelAllClassVisitor((ParallelAllClassVisitor.ClassVisitorFactory)object6)));
        classPool.accept(new TimedClassPoolVisitor("Marking used parameters in kept code attributes", new AllClassVisitor(new AllMethodVisitor(new OptimizationInfoMemberFilter(null, new AllAttributeVisitor(new OptimizationCodeAttributeFilter(null, new AllInstructionVisitor(new InstructionConstantVisitor(new ConstantTagFilter(new int[]{10, 11}, (ConstantVisitor)new ReferencedMemberVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker(true, true, false)))))))))))));
        if (this.fieldPropagationValue || this.methodPropagationParameter || this.methodPropagationReturnvalue || this.classMergingWrapper) {
            object2 = new ParticularValueFactory();
            object = new DetailedArrayValueFactory();
            StoringInvocationUnit storingInvocationUnit = new StoringInvocationUnit((ValueFactory)object2, this.fieldPropagationValue, this.methodPropagationParameter || this.classMergingWrapper, this.methodPropagationReturnvalue);
            classPool.classesAccept(new ClassAccessFilter(4096, 0, new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Filling out fields, method parameters, and return values in synthetic classes", new PartialEvaluator((ValueFactory)object, storingInvocationUnit, false))))));
            ParallelAllClassVisitor.ClassVisitorFactory classVisitorFactory = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    ParticularValueFactory particularValueFactory = new ParticularValueFactory();
                    StoringInvocationUnit storingInvocationUnit = new StoringInvocationUnit(particularValueFactory, Optimizer.this.fieldPropagationValue, Optimizer.this.methodPropagationParameter || Optimizer.this.classMergingWrapper, Optimizer.this.methodPropagationReturnvalue);
                    return new ClassAccessFilter(0, 4096, new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Filling out fields, method parameters, and return values", new PartialEvaluator(particularValueFactory, storingInvocationUnit, false)))));
                }
            };
            classPool.accept(new TimedClassPoolVisitor("Filling out values in non-synthetic classes", new ParallelAllClassVisitor(classVisitorFactory)));
            if (this.fieldPropagationValue) {
                classPool.classesAccept(new AllFieldVisitor(new ConstantMemberFilter(memberCounter3)));
            }
            if (this.methodPropagationParameter) {
                classPool.classesAccept(new AllMethodVisitor(new ConstantParameterFilter(memberCounter10)));
            }
            if (this.methodPropagationReturnvalue) {
                classPool.classesAccept(new AllMethodVisitor(new ConstantMemberFilter(memberCounter11)));
            }
            if (classCounter2.getCount() > 0) {
                classPool.classesAccept(new SimpleEnumFilter(new SimpleEnumArrayPropagator()));
            }
            if (this.codeSimplificationAdvanced) {
                LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit((ValueFactory)object2, this.fieldPropagationValue, this.methodPropagationParameter, this.methodPropagationReturnvalue);
                classPool.classesAccept(new ClassAccessFilter(4096, 0, new AllMethodVisitor(new AllAttributeVisitor(new PartialEvaluator((ValueFactory)object2, loadingInvocationUnit, false)))));
            }
        }
        if (this.codeSimplificationAdvanced) {
            object2 = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    IdentifiedValueFactory identifiedValueFactory = new IdentifiedValueFactory();
                    LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(identifiedValueFactory, Optimizer.this.fieldPropagationValue, Optimizer.this.methodPropagationParameter, Optimizer.this.methodPropagationReturnvalue);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Simplifying code", new OptimizationCodeAttributeFilter(new EvaluationSimplifier(new PartialEvaluator(identifiedValueFactory, loadingInvocationUnit, false), instructionCounter14)))));
                }
            };
            classPool.accept(new TimedClassPoolVisitor("Simplifying code", new ParallelAllClassVisitor((ParallelAllClassVisitor.ClassVisitorFactory)object2)));
        }
        if (this.codeRemovalAdvanced) {
            object2 = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    IdentifiedValueFactory identifiedValueFactory = new IdentifiedValueFactory();
                    LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(identifiedValueFactory, Optimizer.this.fieldPropagationValue, Optimizer.this.methodPropagationParameter, Optimizer.this.methodPropagationReturnvalue);
                    ReferenceTracingValueFactory referenceTracingValueFactory = new ReferenceTracingValueFactory(identifiedValueFactory);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Shrinking code", new OptimizationCodeAttributeFilter(new EvaluationShrinker(new InstructionUsageMarker(new PartialEvaluator(referenceTracingValueFactory, new ParameterTracingInvocationUnit(loadingInvocationUnit), !Optimizer.this.codeSimplificationAdvanced, referenceTracingValueFactory), true), true, (InstructionVisitor)instructionCounter15, (InstructionVisitor)instructionCounter16)))));
                }
            };
            classPool.accept(new TimedClassPoolVisitor("Shrinking code", new ParallelAllClassVisitor((ParallelAllClassVisitor.ClassVisitorFactory)object2)));
        }
        if (this.methodRemovalParameter) {
            classPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new OptimizationInfoMemberFilter(new MethodDescriptorShrinker(memberCounter8)))));
        }
        if (this.methodMarkingStatic) {
            classPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(0, 8, new MethodStaticizer(memberCounter5)))));
        }
        if (memberCounter8.getCount() > 0) {
            classPool.classesAccept(new MemberReferenceFixer());
            classPool.classesAccept(new AllAttributeVisitor(new AllBootstrapMethodInfoVisitor(new BootstrapMethodArgumentShrinker())));
        }
        if (memberCounter8.getCount() > 0 || this.methodMarkingPrivate || memberCounter5.getCount() > 0) {
            classPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new AllAttributeVisitor(new ParameterShrinker(memberCounter9)))));
            classPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new AllAttributeVisitor(new UnusedParameterOptimizationInfoUpdater()))));
        } else if (this.codeRemovalAdvanced) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new OptimizationCodeAttributeFilter(new StackSizeUpdater()))));
        }
        if (this.methodRemovalParameter && memberCounter9.getCount() > 0) {
            classPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(memberCounter14)));
            if (memberCounter14.getCount() > 0) {
                classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(instructionCounter16))));
                classPool.classesAccept(new MemberReferenceFixer());
            }
        }
        object2 = new StackSizeComputer();
        classPool.accept(new TimedClassPoolVisitor("Marking method and referenced class properties", new MultiClassVisitor(new OptimizationInfoClassFilter(new MultiClassVisitor(new PackageVisibleMemberContainingClassMarker(), new WrapperClassMarker(), new AllConstantVisitor(new PackageVisibleMemberInvokingClassMarker()))), new AllMethodVisitor(new OptimizationInfoMemberFilter(new AllAttributeVisitor(new DebugAttributeVisitor("Marking method properties", new MultiAttributeVisitor(new AttributeVisitor[]{object2, new CatchExceptionMarker(), new AllInstructionVisitor(new MultiInstructionVisitor(new SuperInvocationMarker(), new DynamicInvocationMarker(), new BackwardBranchMarker(), new AccessMethodMarker(), new SynchronizedBlockMethodMarker(), new NonEmptyStackReturnMarker((StackSizeComputer)object2)))}))))), new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Marking referenced class properties", new MultiAttributeVisitor(new AllExceptionInfoVisitor(new ExceptionHandlerConstantVisitor(new ReferencedClassVisitor(new OptimizationInfoClassFilter(new CaughtClassMarker())))), new AllInstructionVisitor(new MultiInstructionVisitor(new InstantiationClassMarker(), new InstanceofClassMarker(), new DotClassMarker(), new MethodInvocationMarker())))))))));
        if (this.classMergingWrapper) {
            classPool.accept(new TimedClassPoolVisitor("Merging wrapper classes", new WrapperClassMerger(this.configuration.allowAccessModification, classCounter5)));
            if (classCounter5.getCount() > 0) {
                classPool.classesAccept(new RetargetedClassFilter(null, new AllMethodVisitor(new AllAttributeVisitor(new WrapperClassUseSimplifier()))));
            }
        }
        if (this.classMergingVertical) {
            classPool.accept(new TimedClassPoolVisitor("Merging classes vertically", new VerticalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classCounter3)));
        }
        if (this.classMergingHorizontal) {
            classPool.accept(new TimedClassPoolVisitor("Merging classes horizontally", new ClassNameFilter(new NotMatcher(new CollectionMatcher(multiValueMap.getValues())), (ClassVisitor)new HorizontalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classCounter4))));
        }
        if (classCounter3.getCount() > 0 || classCounter4.getCount() > 0 || classCounter5.getCount() > 0) {
            classPool.classesAccept(new RetargetedInnerClassAttributeRemover());
            classPool.classesAccept(new RetargetedClassFilter(null, new TargetClassChanger()));
            classPool.classesAccept(new RetargetedClassFilter(null, new ClassReferenceFixer(true)));
            classPool.classesAccept(new RetargetedClassFilter(null, new MemberReferenceFixer()));
            if (this.configuration.allowAccessModification) {
                classPool.classesAccept(new AccessFixer());
            }
            classPool.classesAccept(new KeptClassFilter(null, new AllAttributeVisitor(new AllInnerClassesInfoVisitor(new InnerClassesAccessFixer()))));
            classPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(memberCounter15)));
            if (memberCounter15.getCount() > 0) {
                classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(instructionCounter16))));
                classPool.classesAccept(new MemberReferenceFixer());
            }
        }
        if (this.methodInliningUnique) {
            classPool.accept(new TimedClassPoolVisitor("Inlining single methods", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Inlining single methods", new OptimizationCodeAttributeFilter(new MethodInliner(this.configuration.microEdition, this.configuration.android, this.configuration.allowAccessModification, true, instructionCounter2)))))));
        }
        if (this.methodInliningShort) {
            classPool.accept(new TimedClassPoolVisitor("Inlining short methods", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Inlining short methods", new OptimizationCodeAttributeFilter(new MethodInliner(this.configuration.microEdition, this.configuration.android, this.configuration.allowAccessModification, false, instructionCounter)))))));
        }
        if (this.methodInliningTailrecursion) {
            classPool.accept(new TimedClassPoolVisitor("Simplifying tail recursion", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Simplifying tail recursion", new OptimizationCodeAttributeFilter(new TailRecursionSimplifier(instructionCounter3)))))));
        }
        if (this.fieldMarkingPrivate || this.methodMarkingPrivate) {
            classPool.classesAccept(new NonPrivateMemberMarker());
        }
        if (this.fieldMarkingPrivate) {
            classPool.classesAccept(new ClassAccessFilter(0, 512, new AllFieldVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(memberCounter2)))));
        }
        if (this.methodMarkingPrivate) {
            classPool.classesAccept(new ClassAccessFilter(0, 512, new AllMethodVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(memberCounter4)))));
        }
        if ((instructionCounter2.getCount() > 0 || instructionCounter.getCount() > 0 || instructionCounter3.getCount() > 0) && this.configuration.allowAccessModification) {
            classPool.classesAccept(new AccessFixer());
        }
        if (memberCounter9.getCount() > 0 || classCounter3.getCount() > 0 || classCounter4.getCount() > 0 || classCounter5.getCount() > 0 || memberCounter4.getCount() > 0 || (instructionCounter2.getCount() > 0 || instructionCounter.getCount() > 0 || instructionCounter3.getCount() > 0) && this.configuration.allowAccessModification) {
            classPool.classesAccept(new AllMemberVisitor(new AllAttributeVisitor(new MethodInvocationFixer())));
        }
        if (this.codeMerging) {
            classPool.accept(new TimedClassPoolVisitor("Sharing common code", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Sharing common code", new OptimizationCodeAttributeFilter(new GotoCommonCodeReplacer(instructionCounter4)))))));
        }
        if (this.codeSimplificationPeephole) {
            object = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
                    CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
                    InstructionSequenceConstants instructionSequenceConstants = new InstructionSequenceConstants(classPool, classPool2);
                    List list = Optimizer.this.createPeepholeOptimizations(instructionSequenceConstants, branchTargetFinder, codeAttributeEditor, instructionCounter5, instructionCounter6, instructionCounter7, instructionCounter8, instructionCounter9, instructionCounter10, instructionCounter11, instructionCounter12, instructionCounter13);
                    InstructionVisitor[] instructionVisitorArray = new InstructionVisitor[list.size()];
                    list.toArray(instructionVisitorArray);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Peephole optimizations", new OptimizationCodeAttributeFilter(new PeepholeOptimizer(branchTargetFinder, codeAttributeEditor, new MultiInstructionVisitor(instructionVisitorArray))))));
                }
            };
            classPool.accept(new TimedClassPoolVisitor("Peephole optimizations", new ParallelAllClassVisitor((ParallelAllClassVisitor.ClassVisitorFactory)object)));
        }
        if (this.codeRemovalException) {
            classPool.accept(new TimedClassPoolVisitor("Unreachable exception removal", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Unreachable exception removal", new OptimizationCodeAttributeFilter(new UnreachableExceptionRemover(exceptionCounter)))))));
        }
        if (this.codeRemovalSimple) {
            classPool.accept(new TimedClassPoolVisitor("Unreachable code removal", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Unreachable code removal", new OptimizationCodeAttributeFilter(new UnreachableCodeRemover(instructionCounter15)))))));
        }
        if (this.codeRemovalVariable) {
            classPool.accept(new TimedClassPoolVisitor("Variable shrinking", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Variable shrinking", new OptimizationCodeAttributeFilter(new VariableShrinker(memberCounter12)))))));
        }
        if (this.codeAllocationVariable) {
            object = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Variable optimizations", new OptimizationCodeAttributeFilter(new VariableOptimizer(false, memberCounter13)))));
                }
            };
            classPool.accept(new TimedClassPoolVisitor("Variable optimizations", new ParallelAllClassVisitor((ParallelAllClassVisitor.ClassVisitorFactory)object)));
        }
        classPool.accept(new TimedClassPoolVisitor("Shrinking constant pool", new ConstantPoolShrinker()));
        int n = classCounter.getCount();
        int n2 = classCounter2.getCount();
        int n3 = classCounter3.getCount();
        int n4 = classCounter4.getCount();
        int n5 = classCounter5.getCount();
        int n6 = memberCounter.getCount();
        int n7 = memberCounter2.getCount();
        int n8 = memberCounter3.getCount();
        int n9 = memberCounter4.getCount();
        int n10 = memberCounter5.getCount();
        int n11 = memberCounter6.getCount();
        int n12 = memberCounter7.getCount();
        int n13 = memberCounter8.getCount() - memberCounter14.getCount() - memberCounter15.getCount();
        int n14 = memberCounter9.getCount() - memberCounter5.getCount() - memberCounter14.getCount() - memberCounter15.getCount();
        int n15 = memberCounter10.getCount();
        int n16 = memberCounter11.getCount();
        int n17 = instructionCounter.getCount();
        int n18 = instructionCounter2.getCount();
        int n19 = instructionCounter3.getCount();
        int n20 = instructionCounter4.getCount();
        int n21 = instructionCounter5.getCount();
        int n22 = instructionCounter6.getCount();
        int n23 = instructionCounter7.getCount();
        int n24 = instructionCounter8.getCount();
        int n25 = instructionCounter9.getCount();
        int n26 = instructionCounter10.getCount();
        int n27 = instructionCounter11.getCount();
        int n28 = instructionCounter12.getCount();
        int n29 = instructionCounter13.getCount();
        int n30 = instructionCounter14.getCount();
        int n31 = instructionCounter15.getCount() - instructionCounter16.getCount();
        int n32 = memberCounter12.getCount();
        int n33 = exceptionCounter.getCount();
        int n34 = memberCounter13.getCount();
        if (n30 == 0) {
            n8 = 0;
            n15 = 0;
            n16 = 0;
        }
        if (this.configuration.verbose) {
            System.out.println("  Number of finalized classes:                   " + n + this.disabled(this.classMarkingFinal));
            System.out.println("  Number of unboxed enum classes:                " + n2 + this.disabled(this.classUnboxingEnum));
            System.out.println("  Number of vertically merged classes:           " + n3 + this.disabled(this.classMergingVertical));
            System.out.println("  Number of horizontally merged classes:         " + n4 + this.disabled(this.classMergingHorizontal));
            System.out.println("  Number of merged wrapper classes:              " + n5 + this.disabled(this.classMergingWrapper));
            System.out.println("  Number of removed write-only fields:           " + n6 + this.disabled(this.fieldRemovalWriteonly));
            System.out.println("  Number of privatized fields:                   " + n7 + this.disabled(this.fieldMarkingPrivate));
            System.out.println("  Number of inlined constant fields:             " + n8 + this.disabled(this.fieldPropagationValue));
            System.out.println("  Number of privatized methods:                  " + n9 + this.disabled(this.methodMarkingPrivate));
            System.out.println("  Number of staticized methods:                  " + n10 + this.disabled(this.methodMarkingStatic));
            System.out.println("  Number of finalized methods:                   " + n11 + this.disabled(this.methodMarkingFinal));
            System.out.println("  Number of desynchronized methods:              " + n12 + this.disabled(this.methodMarkingSynchronized));
            System.out.println("  Number of simplified method signatures:        " + n13 + this.disabled(this.methodRemovalParameter));
            System.out.println("  Number of removed method parameters:           " + n14 + this.disabled(this.methodRemovalParameter));
            System.out.println("  Number of inlined constant parameters:         " + n15 + this.disabled(this.methodPropagationParameter));
            System.out.println("  Number of inlined constant return values:      " + n16 + this.disabled(this.methodPropagationReturnvalue));
            System.out.println("  Number of inlined short method calls:          " + n17 + this.disabled(this.methodInliningShort));
            System.out.println("  Number of inlined unique method calls:         " + n18 + this.disabled(this.methodInliningUnique));
            System.out.println("  Number of inlined tail recursion calls:        " + n19 + this.disabled(this.methodInliningTailrecursion));
            System.out.println("  Number of merged code blocks:                  " + n20 + this.disabled(this.codeMerging));
            System.out.println("  Number of variable peephole optimizations:     " + n21 + this.disabled(this.codeSimplificationVariable));
            System.out.println("  Number of arithmetic peephole optimizations:   " + n22 + this.disabled(this.codeSimplificationArithmetic));
            System.out.println("  Number of cast peephole optimizations:         " + n23 + this.disabled(this.codeSimplificationCast));
            System.out.println("  Number of field peephole optimizations:        " + n24 + this.disabled(this.codeSimplificationField));
            System.out.println("  Number of branch peephole optimizations:       " + n25 + this.disabled(this.codeSimplificationBranch));
            System.out.println("  Number of object peephole optimizations:       " + n26 + this.disabled(this.codeSimplificationObject));
            System.out.println("  Number of string peephole optimizations:       " + n27 + this.disabled(this.codeSimplificationString));
            System.out.println("  Number of math peephole optimizations:         " + n28 + this.disabled(this.codeSimplificationMath));
            if (this.configuration.android) {
                System.out.println("  Number of Android math peephole optimizations: " + n29 + this.disabled(this.codeSimplificationMath));
            }
            System.out.println("  Number of simplified instructions:             " + n30 + this.disabled(this.codeSimplificationAdvanced));
            System.out.println("  Number of removed instructions:                " + n31 + this.disabled(this.codeRemovalAdvanced));
            System.out.println("  Number of removed local variables:             " + n32 + this.disabled(this.codeRemovalVariable));
            System.out.println("  Number of removed exception blocks:            " + n33 + this.disabled(this.codeRemovalException));
            System.out.println("  Number of optimized local variable frames:     " + n34 + this.disabled(this.codeAllocationVariable));
        }
        return n > 0 || n2 > 0 || n3 > 0 || n4 > 0 || n5 > 0 || n6 > 0 || n7 > 0 || n9 > 0 || n10 > 0 || n11 > 0 || n8 > 0 || n13 > 0 || n14 > 0 || n15 > 0 || n16 > 0 || n17 > 0 || n18 > 0 || n19 > 0 || n20 > 0 || n21 > 0 || n22 > 0 || n23 > 0 || n24 > 0 || n25 > 0 || n26 > 0 || n27 > 0 || n28 > 0 || n29 > 0 || n30 > 0 || n31 > 0 || n32 > 0 || n33 > 0 || n34 > 0;
    }

    private List createPeepholeOptimizations(InstructionSequenceConstants instructionSequenceConstants, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionCounter instructionCounter, InstructionCounter instructionCounter2, InstructionCounter instructionCounter3, InstructionCounter instructionCounter4, InstructionCounter instructionCounter5, InstructionCounter instructionCounter6, InstructionCounter instructionCounter7, InstructionCounter instructionCounter8, InstructionCounter instructionCounter9) {
        ArrayList<InstructionVisitor> arrayList = new ArrayList<InstructionVisitor>();
        if (this.codeSimplificationVariable) {
            arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.VARIABLE_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter));
        }
        if (this.codeSimplificationArithmetic) {
            arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.ARITHMETIC_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter2));
        }
        if (this.codeSimplificationCast) {
            arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.CAST_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter3));
        }
        if (this.codeSimplificationField) {
            arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.FIELD_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter4));
        }
        if (this.codeSimplificationBranch) {
            arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.BRANCH_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter5));
            arrayList.add(new GotoGotoReplacer(codeAttributeEditor, instructionCounter5));
            arrayList.add(new GotoReturnReplacer(codeAttributeEditor, instructionCounter5));
        }
        if (this.codeSimplificationObject) {
            arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.OBJECT_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter6));
        }
        if (this.codeSimplificationString) {
            arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.STRING_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter7));
        }
        if (this.codeSimplificationMath) {
            arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.MATH_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter8));
            if (this.configuration.android) {
                arrayList.add(new InstructionSequencesReplacer(instructionSequenceConstants.CONSTANTS, instructionSequenceConstants.MATH_ANDROID_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)instructionCounter9));
            }
        }
        return arrayList;
    }

    private String disabled(boolean bl) {
        return bl ? "" : "   (disabled)";
    }

    private String disabled(boolean bl, boolean bl2) {
        return bl && bl2 ? "" : (bl || bl2 ? "   (partially disabled)" : "   (disabled)");
    }

    private class TimedClassPoolVisitor
    implements ClassPoolVisitor {
        private final String message;
        private final ClassPoolVisitor classPoolVisitor;

        public TimedClassPoolVisitor(String string, ClassVisitor classVisitor) {
            this(string, new AllClassVisitor(classVisitor));
        }

        public TimedClassPoolVisitor(String string, ClassPoolVisitor classPoolVisitor) {
            this.message = string;
            this.classPoolVisitor = classPoolVisitor;
        }

        @Override
        public void visitClassPool(ClassPool classPool) {
            long l = 0L;
            if (DETAILS) {
                System.out.print(this.message);
                System.out.print(this.getPadding(this.message.length(), 48));
                l = System.currentTimeMillis();
            }
            classPool.accept(this.classPoolVisitor);
            if (DETAILS) {
                long l2 = System.currentTimeMillis();
                System.out.println(String.format(" took: %6d ms", l2 - l));
            }
        }

        private String getPadding(int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n; i < n2; ++i) {
                stringBuilder.append('.');
            }
            return stringBuilder.toString();
        }
    }
}

