/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class OsmMapControl
extends MouseAdapter
implements MouseMotionListener,
MouseListener {
    private Point iStartSelectionPoint;
    private Point iEndSelectionPoint;
    private final SlippyMapChooser iSlippyMapChooser;
    private SizeButton iSizeButton = null;
    private SourceButton iSourceButton = null;

    public OsmMapControl(SlippyMapChooser navComp, JPanel contentPane, SizeButton sizeButton, SourceButton sourceButton) {
        this.iSlippyMapChooser = navComp;
        this.iSlippyMapChooser.addMouseListener(this);
        this.iSlippyMapChooser.addMouseMotionListener(this);
        String[] n = new String[]{",", ".", "up", "right", "down", "left"};
        int[] k = new int[]{44, 46, 38, 39, 40, 37};
        if (contentPane != null) {
            for (int i = 0; i < n.length; ++i) {
                contentPane.getInputMap(2).put(KeyStroke.getKeyStroke(k[i], 128), "MapMover.Zoomer." + n[i]);
            }
        }
        this.iSizeButton = sizeButton;
        this.iSourceButton = sourceButton;
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && !this.iSizeButton.hit(e.getPoint())) {
            this.iStartSelectionPoint = e.getPoint();
            this.iEndSelectionPoint = e.getPoint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024 && this.iStartSelectionPoint != null) {
            this.iEndSelectionPoint = e.getPoint();
            this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, this.iEndSelectionPoint);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            int sourceButton = this.iSourceButton.hit(e.getPoint());
            if (this.iSizeButton.hit(e.getPoint())) {
                this.iSizeButton.toggle();
                this.iSlippyMapChooser.resizeSlippyMap();
            } else if (sourceButton == 1) {
                this.iSourceButton.toggle();
                this.iSlippyMapChooser.repaint();
            } else if (sourceButton == 2 || sourceButton == 3 || sourceButton == 4) {
                this.iSlippyMapChooser.toggleMapSource(sourceButton);
            } else if (e.getClickCount() == 1) {
                this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, e.getPoint());
                this.iEndSelectionPoint = null;
                this.iStartSelectionPoint = null;
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

