/*
 * Decompiled with CFR 0.152.
 */
package UtilsPlugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToAction
extends JosmAction
implements MouseListener {
    public JTextField url = new JTextField();
    public JTextField lat = new JTextField();
    public JTextField lon = new JTextField();

    public JumpToAction() {
        super(I18n.tr((String)"Jump To Position"), null, I18n.tr((String)"Opens a dialog that allows to jump to a specific location"), Shortcut.registerShortcut((String)"tools:jumpto", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Jump To Position")}), (int)71, (int)1), true);
    }

    public void showJumpToDialog() {
        LatLon curPos = Main.proj.eastNorth2latlon(Main.map.mapView.getCenter());
        this.lat.setText(Double.toString(curPos.lat()));
        this.lon.setText(Double.toString(curPos.lon()));
        this.updateUrl(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("<html>" + I18n.tr((String)"Enter Lat/Lon to jump to position.") + "<br>" + I18n.tr((String)"You can also paste an URL from www.openstreetmap.org") + "<br>" + "</html>"), "North");
        class OsmLonLatListener
        implements DocumentListener {
            OsmLonLatListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }

            public void insertUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }

            public void removeUpdate(DocumentEvent e) {
                JumpToAction.this.updateUrl(false);
            }
        }
        OsmLonLatListener x = new OsmLonLatListener();
        this.lat.getDocument().addDocumentListener(x);
        this.lon.getDocument().addDocumentListener(x);
        class OsmURLListener
        implements DocumentListener {
            OsmURLListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }

            public void insertUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }

            public void removeUpdate(DocumentEvent e) {
                JumpToAction.this.parseURL();
            }
        }
        this.url.getDocument().addDocumentListener(new OsmURLListener());
        JPanel p = new JPanel(new GridBagLayout());
        panel.add((Component)p, "North");
        p.add((Component)new JLabel(I18n.tr((String)"Latitude")), GBC.eol());
        p.add((Component)this.lat, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr((String)"Longitude")), GBC.eol());
        p.add((Component)this.lon, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr((String)"URL")), GBC.eol());
        p.add((Component)this.url, GBC.eol().fill(2));
        Object[] buttons = new Object[]{I18n.tr((String)"Jump there"), I18n.tr((String)"Cancel")};
        LatLon ll = null;
        while (ll == null) {
            int option = JOptionPane.showOptionDialog(Main.parent, panel, I18n.tr((String)"Jump to Position"), 2, -1, null, buttons, buttons[0]);
            if (option != 0) {
                return;
            }
            try {
                ll = new LatLon(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not parse Latitude or Longitude. Please check."), I18n.tr((String)"Unable to parse Lon/Lat"), 0);
            }
        }
        Main.map.mapView.zoomTo(Main.proj.latlon2eastNorth(ll), Main.map.mapView.getScale());
    }

    private void parseURL() {
        if (!this.url.hasFocus()) {
            return;
        }
        Bounds b = OsmUrlToBounds.parse((String)this.url.getText());
        if (b != null) {
            this.lat.setText(Double.toString((b.min.lat() + b.max.lat()) / 2.0));
            this.lon.setText(Double.toString((b.min.lon() + b.max.lon()) / 2.0));
        }
    }

    private void updateUrl(boolean force) {
        if (!(this.lat.hasFocus() || this.lon.hasFocus() || force)) {
            return;
        }
        try {
            double dlat = Double.parseDouble(this.lat.getText());
            double dlon = Double.parseDouble(this.lon.getText());
            int zoom = Main.map.mapView.zoom();
            int decimals = (int)Math.pow(10.0, zoom / 3);
            dlat = Math.round(dlat * (double)decimals);
            dlon = Math.round(dlon * (double)decimals);
            this.url.setText("http://www.openstreetmap.org/?lat=" + (dlat /= (double)decimals) + "&lon=" + (dlon /= (double)decimals) + "&zoom=" + zoom);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.showJumpToDialog();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.showJumpToDialog();
    }
}

