/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastrePlugin;
import cadastre_fr.GeorefImage;
import cadastre_fr.WMSLayer;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.tools.I18n;

public class CacheControl
implements Runnable {
    public static boolean cacheEnabled = true;
    public static int cacheSize = 500;
    public WMSLayer wmsLayer = null;
    private ArrayList<GeorefImage> imagesToSave = new ArrayList();
    private Lock imagesLock = new ReentrantLock();

    public CacheControl(WMSLayer wmsLayer) {
        cacheEnabled = Main.pref.getBoolean("cadastrewms.enableCaching", true);
        this.wmsLayer = wmsLayer;
        try {
            cacheSize = Integer.parseInt(Main.pref.get("cadastrewms.cacheSize", String.valueOf(500)));
        }
        catch (NumberFormatException e) {
            cacheSize = 500;
        }
        File path = new File(CadastrePlugin.cacheDir);
        if (!path.exists()) {
            path.mkdirs();
        } else {
            this.checkDirSize(path);
        }
        new Thread(this).start();
    }

    private void checkDirSize(File path) {
        long size = 0L;
        long oldestFileDate = Long.MAX_VALUE;
        int oldestFile = 0;
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            size += files[i].length();
            if (files[i].lastModified() >= oldestFileDate) continue;
            oldestFile = i;
            oldestFileDate = files[i].lastModified();
        }
        if (size > (long)(cacheSize * 1024 * 1024)) {
            System.out.println("Delete oldest file  \"" + files[oldestFile].getName() + "\" in cache dir to stay under the limit of " + cacheSize + " MB.");
            files[oldestFile].delete();
            this.checkDirSize(path);
        }
    }

    public boolean loadCacheIfExist() {
        try {
            File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.name + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
            if (file.exists()) {
                int reply = JOptionPane.showConfirmDialog(null, "Location \"" + this.wmsLayer.name + "\" found in cache.\n" + "Load cache first ?\n" + "(No = new cache)", "Location in cache", 0);
                if (reply == 0) {
                    return this.loadCache(file, this.wmsLayer.lambertZone);
                }
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return false;
    }

    public void deleteCacheFile() {
        try {
            File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.name + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public boolean loadCache(File file, int currentLambertZone) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            int sfv = ois.readInt();
            ((Object)((Object)this.wmsLayer)).getClass();
            if (sfv != 1) {
                Object[] objectArray = new Object[2];
                objectArray[0] = sfv;
                ((Object)((Object)this.wmsLayer)).getClass();
                objectArray[1] = 1;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])objectArray), I18n.tr((String)"Cache Format Error"), 0);
                return false;
            }
            this.wmsLayer.setLocation((String)ois.readObject());
            this.wmsLayer.setCodeCommune((String)ois.readObject());
            this.wmsLayer.lambertZone = ois.readInt();
            this.wmsLayer.setRaster(ois.readBoolean());
            this.wmsLayer.setRasterMin((EastNorth)ois.readObject());
            this.wmsLayer.setRasterCenter((EastNorth)ois.readObject());
            this.wmsLayer.setRasterRatio(ois.readDouble());
            if (this.wmsLayer.lambertZone != currentLambertZone) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Lambert zone {0} in cache  incompatible with current Lambert zone {1}", (Object[])new Object[]{this.wmsLayer.lambertZone + 1, currentLambertZone}), I18n.tr((String)"Cache Lambert Zone Error"), 0);
                return false;
            }
            boolean EOF = false;
            try {
                while (!EOF) {
                    GeorefImage newImage = (GeorefImage)ois.readObject();
                    for (GeorefImage img : this.wmsLayer.images) {
                        if (!CadastrePlugin.backgroundTransparent) continue;
                        if (img.overlap(newImage)) {
                            img.withdraw(newImage);
                            continue;
                        }
                        newImage.withdraw(img);
                    }
                    this.wmsLayer.images.add(newImage);
                }
            }
            catch (EOFException e) {
                // empty catch block
            }
            ois.close();
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
        }
        return true;
    }

    public boolean existCache() {
        return false;
    }

    public synchronized void saveCache(GeorefImage image) {
        this.imagesLock.lock();
        this.imagesToSave.add(image);
        this.notify();
        this.imagesLock.unlock();
    }

    public synchronized void run() {
        while (true) {
            this.imagesLock.lock();
            ArrayList<GeorefImage> images = new ArrayList<GeorefImage>(this.imagesToSave);
            this.imagesToSave.clear();
            this.imagesLock.unlock();
            if (images != null && !images.isEmpty()) {
                File file = new File(CadastrePlugin.cacheDir + this.wmsLayer.name + "." + String.valueOf(this.wmsLayer.lambertZone + 1));
                try {
                    ObjectOutputStream oos;
                    if (file.exists()) {
                        oos = new ObjectOutputStreamAppend(new BufferedOutputStream(new FileOutputStream(file, true)));
                        for (GeorefImage img : images) {
                            oos.writeObject(img);
                        }
                        oos.close();
                    } else {
                        oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        ((Object)((Object)this.wmsLayer)).getClass();
                        oos.writeInt(1);
                        oos.writeObject(this.wmsLayer.getLocation());
                        oos.writeObject(this.wmsLayer.getCodeCommune());
                        oos.writeInt(this.wmsLayer.lambertZone);
                        oos.writeBoolean(this.wmsLayer.isRaster());
                        oos.writeObject(this.wmsLayer.getRasterMin());
                        oos.writeObject(this.wmsLayer.getRasterCenter());
                        oos.writeDouble(this.wmsLayer.getRasterRatio());
                        for (GeorefImage img : images) {
                            oos.writeObject(img);
                        }
                        oos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    public class ObjectOutputStreamAppend
    extends ObjectOutputStream {
        public ObjectOutputStreamAppend(OutputStream out) throws IOException {
            super(out);
        }

        protected void writeStreamHeader() throws IOException {
            this.reset();
        }
    }
}

