/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.pool;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.TypeVariableSource;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationValue;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.enumeration.EnumerationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.PackageDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.ClassFileLocator;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackSize;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.AnnotationVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassReader;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.FieldVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Label;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.TypePath;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.TypeReference;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.signature.SignatureReader;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.signature.SignatureVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

public interface TypePool {
    public Resolution describe(String var1);

    public void clear();

    public static class Explicit
    extends AbstractBase.Hierarchical {
        private final Map<String, TypeDescription> types;

        public Explicit(Map<String, TypeDescription> types) {
            this(Empty.INSTANCE, types);
        }

        public Explicit(TypePool parent, Map<String, TypeDescription> types) {
            super(CacheProvider.NoOp.INSTANCE, parent);
            this.types = types;
        }

        @Override
        protected Resolution doDescribe(String name) {
            TypeDescription typeDescription = this.types.get(name);
            return typeDescription == null ? new Resolution.Illegal(name) : new Resolution.Simple(typeDescription);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Explicit)) {
                return false;
            }
            Explicit other = (Explicit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, TypeDescription> this$types = this.types;
            Map<String, TypeDescription> other$types = other.types;
            return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Explicit;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            Map<String, TypeDescription> $types = this.types;
            result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
            return result;
        }
    }

    public static class ClassLoading
    extends AbstractBase.Hierarchical {
        private static final ClassLoader BOOTSTRAP_CLASS_LOADER = null;
        private final ClassLoader classLoader;

        public ClassLoading(CacheProvider cacheProvider, TypePool parent, ClassLoader classLoader) {
            super(cacheProvider, parent);
            this.classLoader = classLoader;
        }

        public static TypePool of(ClassLoader classLoader) {
            return ClassLoading.of(classLoader, Empty.INSTANCE);
        }

        public static TypePool of(ClassLoader classLoader, TypePool parent) {
            return new ClassLoading(CacheProvider.NoOp.INSTANCE, parent, classLoader);
        }

        public static TypePool ofBootPath() {
            return ClassLoading.of(BOOTSTRAP_CLASS_LOADER);
        }

        public static TypePool ofClassPath() {
            return ClassLoading.of(ClassLoader.getSystemClassLoader());
        }

        @Override
        public Resolution doDescribe(String name) {
            try {
                return new Resolution.Simple(new TypeDescription.ForLoadedType(Class.forName(name, false, this.classLoader)));
            }
            catch (ClassNotFoundException ignored) {
                return new Resolution.Illegal(name);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassLoading)) {
                return false;
            }
            ClassLoading other = (ClassLoading)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClassLoader this$classLoader = this.classLoader;
            ClassLoader other$classLoader = other.classLoader;
            return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ClassLoading;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            ClassLoader $classLoader = this.classLoader;
            result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
            return result;
        }
    }

    public static class LazyFacade
    extends AbstractBase {
        private final TypePool typePool;

        public LazyFacade(TypePool typePool) {
            super(CacheProvider.NoOp.INSTANCE);
            this.typePool = typePool;
        }

        @Override
        protected Resolution doDescribe(String name) {
            return new LazyResolution(this.typePool, name);
        }

        @Override
        public void clear() {
            this.typePool.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LazyFacade)) {
                return false;
            }
            LazyFacade other = (LazyFacade)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TypePool this$typePool = this.typePool;
            TypePool other$typePool = other.typePool;
            return !(this$typePool == null ? other$typePool != null : !this$typePool.equals(other$typePool));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LazyFacade;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypePool $typePool = this.typePool;
            result = result * 59 + ($typePool == null ? 43 : $typePool.hashCode());
            return result;
        }

        protected static class LazyTypeDescription
        extends TypeDescription.AbstractBase.OfSimpleType.WithDelegation {
            private final TypePool typePool;
            private final String name;

            protected LazyTypeDescription(TypePool typePool, String name) {
                this.typePool = typePool;
                this.name = name;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            protected TypeDescription delegate() {
                return this.typePool.describe(this.name).resolve();
            }
        }

        protected static class LazyResolution
        implements Resolution {
            private final TypePool typePool;
            private final String name;

            protected LazyResolution(TypePool typePool, String name) {
                this.typePool = typePool;
                this.name = name;
            }

            @Override
            public boolean isResolved() {
                return this.typePool.describe(this.name).isResolved();
            }

            @Override
            public TypeDescription resolve() {
                return new LazyTypeDescription(this.typePool, this.name);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LazyResolution)) {
                    return false;
                }
                LazyResolution other = (LazyResolution)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypePool this$typePool = this.typePool;
                TypePool other$typePool = other.typePool;
                if (this$typePool == null ? other$typePool != null : !this$typePool.equals(other$typePool)) {
                    return false;
                }
                String this$name = this.name;
                String other$name = other.name;
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            protected boolean canEqual(Object other) {
                return other instanceof LazyResolution;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypePool $typePool = this.typePool;
                result = result * 59 + ($typePool == null ? 43 : $typePool.hashCode());
                String $name = this.name;
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }
    }

    public static class Default
    extends AbstractBase.Hierarchical {
        private static final MethodVisitor IGNORE_METHOD = null;
        protected final ClassFileLocator classFileLocator;
        protected final ReaderMode readerMode;

        public Default(CacheProvider cacheProvider, ClassFileLocator classFileLocator, ReaderMode readerMode) {
            this(cacheProvider, classFileLocator, readerMode, Empty.INSTANCE);
        }

        public Default(CacheProvider cacheProvider, ClassFileLocator classFileLocator, ReaderMode readerMode, TypePool parentPool) {
            super(cacheProvider, parentPool);
            this.classFileLocator = classFileLocator;
            this.readerMode = readerMode;
        }

        public static TypePool ofClassPath() {
            return Default.of(ClassFileLocator.ForClassLoader.ofClassPath());
        }

        public static TypePool of(ClassLoader classLoader) {
            return Default.of(ClassFileLocator.ForClassLoader.of(classLoader));
        }

        public static TypePool of(ClassFileLocator classFileLocator) {
            return new Default(new CacheProvider.Simple(), classFileLocator, ReaderMode.FAST);
        }

        @Override
        protected Resolution doDescribe(String name) {
            try {
                ClassFileLocator.Resolution resolution = this.classFileLocator.locate(name);
                return resolution.isResolved() ? new Resolution.Simple(this.parse(resolution.resolve())) : new Resolution.Illegal(name);
            }
            catch (IOException exception) {
                throw new IllegalStateException("Error while reading class file", exception);
            }
        }

        private TypeDescription parse(byte[] binaryRepresentation) {
            ClassReader classReader = new ClassReader(binaryRepresentation);
            TypeExtractor typeExtractor = new TypeExtractor();
            classReader.accept(typeExtractor, this.readerMode.getFlags());
            return typeExtractor.toTypeDescription();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Default)) {
                return false;
            }
            Default other = (Default)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClassFileLocator this$classFileLocator = this.classFileLocator;
            ClassFileLocator other$classFileLocator = other.classFileLocator;
            if (this$classFileLocator == null ? other$classFileLocator != null : !this$classFileLocator.equals(other$classFileLocator)) {
                return false;
            }
            ReaderMode this$readerMode = this.readerMode;
            ReaderMode other$readerMode = other.readerMode;
            return !(this$readerMode == null ? other$readerMode != null : !((Object)((Object)this$readerMode)).equals((Object)other$readerMode));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Default;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            ClassFileLocator $classFileLocator = this.classFileLocator;
            result = result * 59 + ($classFileLocator == null ? 43 : $classFileLocator.hashCode());
            ReaderMode $readerMode = this.readerMode;
            result = result * 59 + ($readerMode == null ? 43 : ((Object)((Object)$readerMode)).hashCode());
            return result;
        }

        protected class TypeExtractor
        extends ClassVisitor {
            private static final int REAL_MODIFIER_MASK = 65535;
            private final Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> superTypeAnnotationTokens;
            private final Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> typeVariableAnnotationTokens;
            private final Map<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>> typeVariableBoundsAnnotationTokens;
            private final List<LazyTypeDescription.AnnotationToken> annotationTokens;
            private final List<LazyTypeDescription.FieldToken> fieldTokens;
            private final List<LazyTypeDescription.MethodToken> methodTokens;
            private int actualModifiers;
            private int modifiers;
            private String internalName;
            private String superClassName;
            private String genericSignature;
            private String[] interfaceName;
            private boolean anonymousType;
            private LazyTypeDescription.TypeContainment typeContainment;
            private String declaringTypeName;
            private final List<String> declaredTypes;

            protected TypeExtractor() {
                super(393216);
                this.superTypeAnnotationTokens = new HashMap<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>();
                this.typeVariableAnnotationTokens = new HashMap<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>();
                this.typeVariableBoundsAnnotationTokens = new HashMap<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>>();
                this.annotationTokens = new ArrayList<LazyTypeDescription.AnnotationToken>();
                this.fieldTokens = new ArrayList<LazyTypeDescription.FieldToken>();
                this.methodTokens = new ArrayList<LazyTypeDescription.MethodToken>();
                this.anonymousType = false;
                this.typeContainment = LazyTypeDescription.TypeContainment.SelfContained.INSTANCE;
                this.declaredTypes = new ArrayList<String>();
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The array is not to be modified by contract")
            public void visit(int classFileVersion, int modifiers, String internalName, String genericSignature, String superClassName, String[] interfaceName) {
                this.modifiers = modifiers & 0xFFFF;
                this.actualModifiers = modifiers;
                this.internalName = internalName;
                this.genericSignature = genericSignature;
                this.superClassName = superClassName;
                this.interfaceName = interfaceName;
            }

            @Override
            public void visitOuterClass(String typeName, String methodName, String methodDescriptor) {
                if (methodName != null) {
                    this.typeContainment = new LazyTypeDescription.TypeContainment.WithinMethod(typeName, methodName, methodDescriptor);
                } else if (typeName != null) {
                    this.typeContainment = new LazyTypeDescription.TypeContainment.WithinType(typeName, true);
                }
            }

            @Override
            public void visitInnerClass(String internalName, String outerName, String innerName, int modifiers) {
                if (internalName.equals(this.internalName)) {
                    this.modifiers = modifiers & 0xFFFF;
                    if (innerName == null) {
                        this.anonymousType = true;
                    }
                    if (outerName != null) {
                        this.declaringTypeName = outerName;
                        if (this.typeContainment.isSelfContained()) {
                            this.typeContainment = new LazyTypeDescription.TypeContainment.WithinType(outerName, false);
                        }
                    }
                } else if (outerName != null && innerName != null && internalName.equals(this.internalName + "$" + innerName)) {
                    this.declaredTypes.add("L" + internalName + ";");
                }
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int rawTypeReference, TypePath typePath, String descriptor, boolean visible) {
                AnnotationRegistrant.AbstractBase.ForTypeVariable.WithIndex annotationRegistrant;
                TypeReference typeReference = new TypeReference(rawTypeReference);
                switch (typeReference.getSort()) {
                    case 16: {
                        annotationRegistrant = new AnnotationRegistrant.ForTypeVariable.WithIndex(descriptor, typePath, typeReference.getSuperTypeIndex(), this.superTypeAnnotationTokens);
                        break;
                    }
                    case 0: {
                        annotationRegistrant = new AnnotationRegistrant.ForTypeVariable.WithIndex(descriptor, typePath, typeReference.getTypeParameterIndex(), this.typeVariableAnnotationTokens);
                        break;
                    }
                    case 17: {
                        annotationRegistrant = new AnnotationRegistrant.ForTypeVariable.WithIndex.DoubleIndexed(descriptor, typePath, typeReference.getTypeParameterBoundIndex(), typeReference.getTypeParameterIndex(), this.typeVariableBoundsAnnotationTokens);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected type reference: " + typeReference.getSort());
                    }
                }
                return new AnnotationExtractor(annotationRegistrant, new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return new AnnotationExtractor(descriptor, this.annotationTokens, new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
            }

            @Override
            public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String genericSignature, Object defaultValue) {
                return new FieldExtractor(modifiers & 0xFFFF, internalName, descriptor, genericSignature);
            }

            @Override
            public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String genericSignature, String[] exceptionName) {
                return internalName.equals("<clinit>") ? IGNORE_METHOD : new MethodExtractor(modifiers & 0xFFFF, internalName, descriptor, genericSignature, exceptionName);
            }

            protected TypeDescription toTypeDescription() {
                return new LazyTypeDescription(Default.this, this.actualModifiers, this.modifiers, this.internalName, this.superClassName, this.interfaceName, this.genericSignature, this.typeContainment, this.declaringTypeName, this.declaredTypes, this.anonymousType, this.superTypeAnnotationTokens, this.typeVariableAnnotationTokens, this.typeVariableBoundsAnnotationTokens, this.annotationTokens, this.fieldTokens, this.methodTokens);
            }

            protected class MethodExtractor
            extends MethodVisitor
            implements AnnotationRegistrant {
                private final int modifiers;
                private final String internalName;
                private final String descriptor;
                private final String genericSignature;
                private final String[] exceptionName;
                private final Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> typeVariableAnnotationTokens;
                private final Map<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>> typeVariableBoundAnnotationTokens;
                private final Map<String, List<LazyTypeDescription.AnnotationToken>> returnTypeAnnotationTokens;
                private final Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> parameterTypeAnnotationTokens;
                private final Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> exceptionTypeAnnotationTokens;
                private final Map<String, List<LazyTypeDescription.AnnotationToken>> receiverTypeAnnotationTokens;
                private final List<LazyTypeDescription.AnnotationToken> annotationTokens;
                private final Map<Integer, List<LazyTypeDescription.AnnotationToken>> parameterAnnotationTokens;
                private final List<LazyTypeDescription.MethodToken.ParameterToken> parameterTokens;
                private final ParameterBag legacyParameterBag;
                private Label firstLabel;
                private AnnotationValue<?, ?> defaultValue;

                protected MethodExtractor(int modifiers, String internalName, String descriptor, String genericSignature, String[] exceptionName) {
                    super(393216);
                    this.modifiers = modifiers;
                    this.internalName = internalName;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.exceptionName = exceptionName;
                    this.typeVariableAnnotationTokens = new HashMap<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>();
                    this.typeVariableBoundAnnotationTokens = new HashMap<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>>();
                    this.returnTypeAnnotationTokens = new HashMap<String, List<LazyTypeDescription.AnnotationToken>>();
                    this.parameterTypeAnnotationTokens = new HashMap<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>();
                    this.exceptionTypeAnnotationTokens = new HashMap<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>();
                    this.receiverTypeAnnotationTokens = new HashMap<String, List<LazyTypeDescription.AnnotationToken>>();
                    this.annotationTokens = new ArrayList<LazyTypeDescription.AnnotationToken>();
                    this.parameterAnnotationTokens = new HashMap<Integer, List<LazyTypeDescription.AnnotationToken>>();
                    this.parameterTokens = new ArrayList<LazyTypeDescription.MethodToken.ParameterToken>();
                    this.legacyParameterBag = new ParameterBag(nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getMethodType(descriptor).getArgumentTypes());
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int rawTypeReference, TypePath typePath, String descriptor, boolean visible) {
                    AnnotationRegistrant.AbstractBase.ForTypeVariable annotationRegistrant;
                    TypeReference typeReference = new TypeReference(rawTypeReference);
                    switch (typeReference.getSort()) {
                        case 1: {
                            annotationRegistrant = new AnnotationRegistrant.ForTypeVariable.WithIndex(descriptor, typePath, typeReference.getTypeParameterIndex(), this.typeVariableAnnotationTokens);
                            break;
                        }
                        case 18: {
                            annotationRegistrant = new AnnotationRegistrant.ForTypeVariable.WithIndex.DoubleIndexed(descriptor, typePath, typeReference.getTypeParameterBoundIndex(), typeReference.getTypeParameterIndex(), this.typeVariableBoundAnnotationTokens);
                            break;
                        }
                        case 20: {
                            annotationRegistrant = new AnnotationRegistrant.ForTypeVariable(descriptor, typePath, this.returnTypeAnnotationTokens);
                            break;
                        }
                        case 22: {
                            annotationRegistrant = new AnnotationRegistrant.ForTypeVariable.WithIndex(descriptor, typePath, typeReference.getFormalParameterIndex(), this.parameterTypeAnnotationTokens);
                            break;
                        }
                        case 23: {
                            annotationRegistrant = new AnnotationRegistrant.ForTypeVariable.WithIndex(descriptor, typePath, typeReference.getExceptionIndex(), this.exceptionTypeAnnotationTokens);
                            break;
                        }
                        case 21: {
                            annotationRegistrant = new AnnotationRegistrant.ForTypeVariable(descriptor, typePath, this.receiverTypeAnnotationTokens);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected type reference on method: " + typeReference.getSort());
                        }
                    }
                    return new AnnotationExtractor(annotationRegistrant, new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return new AnnotationExtractor(descriptor, this.annotationTokens, new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return new AnnotationExtractor(descriptor, index, this.parameterAnnotationTokens, new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public void visitLabel(Label label) {
                    if (Default.this.readerMode.isExtended() && this.firstLabel == null) {
                        this.firstLabel = label;
                    }
                }

                @Override
                public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                    if (Default.this.readerMode.isExtended() && start == this.firstLabel) {
                        this.legacyParameterBag.register(index, name);
                    }
                }

                @Override
                public void visitParameter(String name, int modifiers) {
                    this.parameterTokens.add(new LazyTypeDescription.MethodToken.ParameterToken(name, modifiers));
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationExtractor(this, new ComponentTypeLocator.ForArrayType(this.descriptor));
                }

                @Override
                public void register(String ignored, AnnotationValue<?, ?> annotationValue) {
                    this.defaultValue = annotationValue;
                }

                @Override
                public void onComplete() {
                }

                @Override
                public void visitEnd() {
                    TypeExtractor.this.methodTokens.add(new LazyTypeDescription.MethodToken(this.internalName, this.modifiers, this.descriptor, this.genericSignature, this.exceptionName, this.typeVariableAnnotationTokens, this.typeVariableBoundAnnotationTokens, this.returnTypeAnnotationTokens, this.parameterTypeAnnotationTokens, this.exceptionTypeAnnotationTokens, this.receiverTypeAnnotationTokens, this.annotationTokens, this.parameterAnnotationTokens, this.parameterTokens.isEmpty() ? this.legacyParameterBag.resolve((this.modifiers & 8) != 0) : this.parameterTokens, this.defaultValue));
                }
            }

            protected class FieldExtractor
            extends FieldVisitor {
                private final int modifiers;
                private final String internalName;
                private final String descriptor;
                private final String genericSignature;
                private final Map<String, List<LazyTypeDescription.AnnotationToken>> typeAnnotationTokens;
                private final List<LazyTypeDescription.AnnotationToken> annotationTokens;

                protected FieldExtractor(int modifiers, String internalName, String descriptor, String genericSignature) {
                    super(393216);
                    this.modifiers = modifiers;
                    this.internalName = internalName;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.typeAnnotationTokens = new HashMap<String, List<LazyTypeDescription.AnnotationToken>>();
                    this.annotationTokens = new ArrayList<LazyTypeDescription.AnnotationToken>();
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int rawTypeReference, TypePath typePath, String descriptor, boolean visible) {
                    AnnotationRegistrant.ForTypeVariable annotationRegistrant;
                    TypeReference typeReference = new TypeReference(rawTypeReference);
                    switch (typeReference.getSort()) {
                        case 19: {
                            annotationRegistrant = new AnnotationRegistrant.ForTypeVariable(descriptor, typePath, this.typeAnnotationTokens);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected type reference on field: " + typeReference.getSort());
                        }
                    }
                    return new AnnotationExtractor(annotationRegistrant, new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return new AnnotationExtractor(descriptor, this.annotationTokens, new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public void visitEnd() {
                    TypeExtractor.this.fieldTokens.add(new LazyTypeDescription.FieldToken(this.internalName, this.modifiers, this.descriptor, this.genericSignature, this.typeAnnotationTokens, this.annotationTokens));
                }
            }

            protected class AnnotationExtractor
            extends AnnotationVisitor {
                private final AnnotationRegistrant annotationRegistrant;
                private final ComponentTypeLocator componentTypeLocator;

                protected AnnotationExtractor(String descriptor, List<LazyTypeDescription.AnnotationToken> annotationTokens, ComponentTypeLocator componentTypeLocator) {
                    this(new AnnotationRegistrant.ForByteCodeElement(descriptor, annotationTokens), componentTypeLocator);
                }

                protected AnnotationExtractor(String descriptor, int index, Map<Integer, List<LazyTypeDescription.AnnotationToken>> annotationTokens, ComponentTypeLocator componentTypeLocator) {
                    this(new AnnotationRegistrant.ForByteCodeElement.WithIndex(descriptor, index, annotationTokens), componentTypeLocator);
                }

                protected AnnotationExtractor(AnnotationRegistrant annotationRegistrant, ComponentTypeLocator componentTypeLocator) {
                    super(393216);
                    this.annotationRegistrant = annotationRegistrant;
                    this.componentTypeLocator = componentTypeLocator;
                }

                @Override
                public void visit(String name, Object value) {
                    this.annotationRegistrant.register(name, value instanceof nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type ? new AbstractBase.RawTypeValue(Default.this, (nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type)value) : AnnotationValue.ForConstant.of(value));
                }

                @Override
                public void visitEnum(String name, String descriptor, String value) {
                    this.annotationRegistrant.register(name, new AbstractBase.RawEnumerationValue(Default.this, descriptor, value));
                }

                @Override
                public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                    return new AnnotationExtractor(new AnnotationLookup(descriptor, name), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitArray(String name) {
                    return new AnnotationExtractor(new ArrayLookup(name, this.componentTypeLocator.bind(name)), ComponentTypeLocator.Illegal.INSTANCE);
                }

                @Override
                public void visitEnd() {
                    this.annotationRegistrant.onComplete();
                }

                protected class AnnotationLookup
                implements AnnotationRegistrant {
                    private final String descriptor;
                    private final String name;
                    private final Map<String, AnnotationValue<?, ?>> values;

                    protected AnnotationLookup(String descriptor, String name) {
                        this.descriptor = descriptor;
                        this.name = name;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        AnnotationExtractor.this.annotationRegistrant.register(this.name, new AbstractBase.RawAnnotationValue(Default.this, new LazyTypeDescription.AnnotationToken(this.descriptor, this.values)));
                    }
                }

                protected class ArrayLookup
                implements AnnotationRegistrant {
                    private final String name;
                    private final AbstractBase.RawDescriptionArray.ComponentTypeReference componentTypeReference;
                    private final List<AnnotationValue<?, ?>> values;

                    protected ArrayLookup(String name, AbstractBase.RawDescriptionArray.ComponentTypeReference componentTypeReference) {
                        this.name = name;
                        this.componentTypeReference = componentTypeReference;
                        this.values = new ArrayList();
                    }

                    @Override
                    public void register(String ignored, AnnotationValue<?, ?> annotationValue) {
                        this.values.add(annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        AnnotationExtractor.this.annotationRegistrant.register(this.name, new AbstractBase.RawDescriptionArray(Default.this, this.componentTypeReference, this.values));
                    }
                }
            }
        }

        protected static class LazyTypeDescription
        extends TypeDescription.AbstractBase.OfSimpleType {
            private static final int SUPER_CLASS_INDEX = -1;
            private static final String NO_TYPE = null;
            private final TypePool typePool;
            private final int actualModifiers;
            private final int modifiers;
            private final String name;
            private final String superClassDescriptor;
            private final String genericSignature;
            private final GenericTypeToken.Resolution.ForType signatureResolution;
            private final List<String> interfaceTypeDescriptors;
            private final TypeContainment typeContainment;
            private final String declaringTypeName;
            private final List<String> declaredTypes;
            private final boolean anonymousType;
            private final Map<Integer, Map<String, List<AnnotationToken>>> superTypeAnnotationTokens;
            private final Map<Integer, Map<String, List<AnnotationToken>>> typeVariableAnnotationTokens;
            private final Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> typeVariableBoundsAnnotationTokens;
            private final List<AnnotationToken> annotationTokens;
            private final List<FieldToken> fieldTokens;
            private final List<MethodToken> methodTokens;

            protected LazyTypeDescription(TypePool typePool, int actualModifiers, int modifiers, String name, String superClassInternalName, String[] interfaceInternalName, String genericSignature, TypeContainment typeContainment, String declaringTypeInternalName, List<String> declaredTypes, boolean anonymousType, Map<Integer, Map<String, List<AnnotationToken>>> superTypeAnnotationTokens, Map<Integer, Map<String, List<AnnotationToken>>> typeVariableAnnotationTokens, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> typeVariableBoundsAnnotationTokens, List<AnnotationToken> annotationTokens, List<FieldToken> fieldTokens, List<MethodToken> methodTokens) {
                this.typePool = typePool;
                this.actualModifiers = actualModifiers & 0xFFFFFFDF;
                this.modifiers = modifiers & 0xFFFDFFDF;
                this.name = nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getObjectType(name).getClassName();
                this.superClassDescriptor = superClassInternalName == null ? NO_TYPE : nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getObjectType(superClassInternalName).getDescriptor();
                this.genericSignature = genericSignature;
                GenericTypeToken.Resolution.ForType forType = this.signatureResolution = RAW_TYPES ? GenericTypeToken.Resolution.Raw.INSTANCE : GenericTypeExtractor.ForSignature.OfType.extract(genericSignature);
                if (interfaceInternalName == null) {
                    this.interfaceTypeDescriptors = Collections.emptyList();
                } else {
                    this.interfaceTypeDescriptors = new ArrayList<String>(interfaceInternalName.length);
                    for (String internalName : interfaceInternalName) {
                        this.interfaceTypeDescriptors.add(nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getObjectType(internalName).getDescriptor());
                    }
                }
                this.typeContainment = typeContainment;
                this.declaringTypeName = declaringTypeInternalName == null ? NO_TYPE : declaringTypeInternalName.replace('/', '.');
                this.declaredTypes = declaredTypes;
                this.anonymousType = anonymousType;
                this.superTypeAnnotationTokens = superTypeAnnotationTokens;
                this.typeVariableAnnotationTokens = typeVariableAnnotationTokens;
                this.typeVariableBoundsAnnotationTokens = typeVariableBoundsAnnotationTokens;
                this.annotationTokens = annotationTokens;
                this.fieldTokens = fieldTokens;
                this.methodTokens = methodTokens;
            }

            @Override
            public TypeDescription.Generic getSuperClass() {
                return this.superClassDescriptor == null || this.isInterface() ? TypeDescription.Generic.UNDEFINED : this.signatureResolution.resolveSuperClass(this.superClassDescriptor, this.typePool, this.superTypeAnnotationTokens.get(-1), this);
            }

            @Override
            public TypeList.Generic getInterfaces() {
                return this.signatureResolution.resolveInterfaceTypes(this.interfaceTypeDescriptors, this.typePool, this.superTypeAnnotationTokens, this);
            }

            @Override
            public MethodDescription getEnclosingMethod() {
                return this.typeContainment.getEnclosingMethod(this.typePool);
            }

            @Override
            public TypeDescription getEnclosingType() {
                return this.typeContainment.getEnclosingType(this.typePool);
            }

            @Override
            public TypeList getDeclaredTypes() {
                return new LazyTypeList(this.typePool, this.declaredTypes);
            }

            @Override
            public boolean isAnonymousClass() {
                return this.anonymousType;
            }

            @Override
            public boolean isLocalClass() {
                return !this.anonymousType && this.typeContainment.isLocalType();
            }

            @Override
            public boolean isMemberClass() {
                return this.typeContainment.isMemberClass();
            }

            @Override
            public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
                return new FieldTokenList();
            }

            @Override
            public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
                return new MethodTokenList();
            }

            @Override
            public PackageDescription getPackage() {
                String name = this.getName();
                int index = name.lastIndexOf(46);
                return index == -1 ? PackageDescription.UNDEFINED : new LazyPackageDescription(this.typePool, name.substring(0, index));
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public TypeDescription getDeclaringType() {
                return this.declaringTypeName == null ? TypeDescription.UNDEFINED : this.typePool.describe(this.declaringTypeName).resolve();
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }

            @Override
            public int getActualModifiers(boolean superFlag) {
                return superFlag ? this.actualModifiers | 0x20 : this.actualModifiers;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return LazyAnnotationDescription.asList(this.typePool, this.annotationTokens);
            }

            @Override
            public TypeList.Generic getTypeVariables() {
                return this.signatureResolution.resolveTypeVariables(this.typePool, this, this.typeVariableAnnotationTokens, this.typeVariableBoundsAnnotationTokens);
            }

            @Override
            public String getGenericSignature() {
                return this.genericSignature;
            }

            private class LazyMethodDescription
            extends MethodDescription.InDefinedShape.AbstractBase {
                private final String internalName;
                private final int modifiers;
                private final String returnTypeDescriptor;
                private final String genericSignature;
                private final GenericTypeToken.Resolution.ForMethod signatureResolution;
                private final List<String> parameterTypeDescriptors;
                private final List<String> exceptionTypeDescriptors;
                private final Map<Integer, Map<String, List<AnnotationToken>>> typeVariableAnnotationTokens;
                private final Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> typeVariableBoundAnnotationTokens;
                private final Map<String, List<AnnotationToken>> returnTypeAnnotationTokens;
                private final Map<Integer, Map<String, List<AnnotationToken>>> parameterTypeAnnotationTokens;
                private final Map<Integer, Map<String, List<AnnotationToken>>> exceptionTypeAnnotationTokens;
                private final Map<String, List<AnnotationToken>> receiverTypeAnnotationTokens;
                private final List<AnnotationToken> annotationTokens;
                private final Map<Integer, List<AnnotationToken>> parameterAnnotationTokens;
                private final String[] parameterNames;
                private final Integer[] parameterModifiers;
                private final AnnotationValue<?, ?> defaultValue;

                private LazyMethodDescription(String internalName, int modifiers, String descriptor, String genericSignature, GenericTypeToken.Resolution.ForMethod signatureResolution, String[] exceptionTypeInternalName, Map<Integer, Map<String, List<AnnotationToken>>> typeVariableAnnotationTokens, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> typeVariableBoundAnnotationTokens, Map<String, List<AnnotationToken>> returnTypeAnnotationTokens, Map<Integer, Map<String, List<AnnotationToken>>> parameterTypeAnnotationTokens, Map<Integer, Map<String, List<AnnotationToken>>> exceptionTypeAnnotationTokens, Map<String, List<AnnotationToken>> receiverTypeAnnotationTokens, List<AnnotationToken> annotationTokens, Map<Integer, List<AnnotationToken>> parameterAnnotationTokens, List<MethodToken.ParameterToken> parameterTokens, AnnotationValue<?, ?> defaultValue) {
                    this.modifiers = modifiers;
                    this.internalName = internalName;
                    nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type methodType = nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getMethodType(descriptor);
                    nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type returnType = methodType.getReturnType();
                    nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type[] parameterType = methodType.getArgumentTypes();
                    this.returnTypeDescriptor = returnType.getDescriptor();
                    this.parameterTypeDescriptors = new ArrayList<String>(parameterType.length);
                    for (nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type type : parameterType) {
                        this.parameterTypeDescriptors.add(type.getDescriptor());
                    }
                    this.genericSignature = genericSignature;
                    this.signatureResolution = signatureResolution;
                    if (exceptionTypeInternalName == null) {
                        this.exceptionTypeDescriptors = Collections.emptyList();
                    } else {
                        this.exceptionTypeDescriptors = new ArrayList<String>(exceptionTypeInternalName.length);
                        for (String anExceptionTypeInternalName : exceptionTypeInternalName) {
                            this.exceptionTypeDescriptors.add(nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getObjectType(anExceptionTypeInternalName).getDescriptor());
                        }
                    }
                    this.typeVariableAnnotationTokens = typeVariableAnnotationTokens;
                    this.typeVariableBoundAnnotationTokens = typeVariableBoundAnnotationTokens;
                    this.returnTypeAnnotationTokens = returnTypeAnnotationTokens;
                    this.parameterTypeAnnotationTokens = parameterTypeAnnotationTokens;
                    this.exceptionTypeAnnotationTokens = exceptionTypeAnnotationTokens;
                    this.receiverTypeAnnotationTokens = receiverTypeAnnotationTokens;
                    this.annotationTokens = annotationTokens;
                    this.parameterAnnotationTokens = parameterAnnotationTokens;
                    this.parameterNames = new String[parameterType.length];
                    this.parameterModifiers = new Integer[parameterType.length];
                    if (parameterTokens.size() == parameterType.length) {
                        int index = 0;
                        for (MethodToken.ParameterToken parameterToken : parameterTokens) {
                            this.parameterNames[index] = parameterToken.getName();
                            this.parameterModifiers[index] = parameterToken.getModifiers();
                            ++index;
                        }
                    }
                    this.defaultValue = defaultValue;
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return this.signatureResolution.resolveReturnType(this.returnTypeDescriptor, LazyTypeDescription.this.typePool, this.returnTypeAnnotationTokens, this);
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return this.signatureResolution.resolveExceptionTypes(this.exceptionTypeDescriptors, LazyTypeDescription.this.typePool, this.exceptionTypeAnnotationTokens, this);
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new LazyParameterList();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return LazyAnnotationDescription.asList(LazyTypeDescription.this.typePool, this.annotationTokens);
                }

                @Override
                public String getInternalName() {
                    return this.internalName;
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return LazyTypeDescription.this;
                }

                @Override
                public int getModifiers() {
                    return this.modifiers;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return this.signatureResolution.resolveTypeVariables(LazyTypeDescription.this.typePool, this, this.typeVariableAnnotationTokens, this.typeVariableBoundAnnotationTokens);
                }

                @Override
                public AnnotationValue<?, ?> getDefaultValue() {
                    return this.defaultValue;
                }

                @Override
                public TypeDescription.Generic getReceiverType() {
                    if (this.isStatic()) {
                        return TypeDescription.Generic.UNDEFINED;
                    }
                    if (this.isConstructor()) {
                        TypeDescription declaringType = this.getDeclaringType();
                        TypeDescription enclosingDeclaringType = declaringType.getEnclosingType();
                        if (enclosingDeclaringType == null) {
                            return declaringType.isGenerified() ? new LazyParameterizedReceiverType(declaringType) : new LazyNonGenericReceiverType(declaringType);
                        }
                        return !declaringType.isStatic() && declaringType.isGenerified() ? new LazyParameterizedReceiverType(enclosingDeclaringType) : new LazyNonGenericReceiverType(enclosingDeclaringType);
                    }
                    return LazyTypeDescription.this.isGenerified() ? new LazyParameterizedReceiverType() : new LazyNonGenericReceiverType();
                }

                @Override
                public String getGenericSignature() {
                    return this.genericSignature;
                }

                protected class LazyNonGenericReceiverType
                extends TypeDescription.Generic.OfNonGenericType {
                    private final TypeDescription typeDescription;

                    protected LazyNonGenericReceiverType() {
                        this(this$1.LazyTypeDescription.this);
                    }

                    protected LazyNonGenericReceiverType(TypeDescription typeDescription) {
                        this.typeDescription = typeDescription;
                    }

                    @Override
                    public TypeDescription.Generic getOwnerType() {
                        TypeDescription declaringType = this.typeDescription.getDeclaringType();
                        return declaringType == null ? TypeDescription.Generic.UNDEFINED : new LazyNonGenericReceiverType(declaringType);
                    }

                    @Override
                    public TypeDescription.Generic getComponentType() {
                        return TypeDescription.Generic.UNDEFINED;
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        StringBuilder typePath = new StringBuilder();
                        for (int index = 0; index < this.typeDescription.getSegmentCount(); ++index) {
                            typePath = typePath.append('.');
                        }
                        return LazyAnnotationDescription.asListOfNullable(LazyTypeDescription.this.typePool, (List)LazyMethodDescription.this.receiverTypeAnnotationTokens.get(typePath.toString()));
                    }

                    @Override
                    public TypeDescription asErasure() {
                        return this.typeDescription;
                    }
                }

                private class LazyParameterizedReceiverType
                extends TypeDescription.Generic.OfParameterizedType {
                    private final TypeDescription typeDescription;

                    protected LazyParameterizedReceiverType() {
                        this(lazyMethodDescription.LazyTypeDescription.this);
                    }

                    protected LazyParameterizedReceiverType(TypeDescription typeDescription) {
                        this.typeDescription = typeDescription;
                    }

                    @Override
                    public TypeList.Generic getTypeArguments() {
                        return new TypeArgumentList(this.typeDescription.getTypeVariables());
                    }

                    @Override
                    public TypeDescription.Generic getOwnerType() {
                        TypeDescription declaringType = this.typeDescription.getDeclaringType();
                        if (declaringType == null) {
                            return TypeDescription.Generic.UNDEFINED;
                        }
                        return !this.typeDescription.isStatic() && declaringType.isGenerified() ? new LazyParameterizedReceiverType(declaringType) : new LazyNonGenericReceiverType(declaringType);
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return LazyAnnotationDescription.asListOfNullable(LazyTypeDescription.this.typePool, (List)LazyMethodDescription.this.receiverTypeAnnotationTokens.get(this.getTypePath()));
                    }

                    private String getTypePath() {
                        StringBuilder typePath = new StringBuilder();
                        for (int index = 0; index < this.typeDescription.getSegmentCount(); ++index) {
                            typePath = typePath.append('.');
                        }
                        return typePath.toString();
                    }

                    @Override
                    public TypeDescription asErasure() {
                        return this.typeDescription;
                    }

                    protected class TypeArgumentList
                    extends TypeList.Generic.AbstractBase {
                        private final List<? extends TypeDescription.Generic> typeVariables;

                        protected TypeArgumentList(List<? extends TypeDescription.Generic> typeVariables) {
                            this.typeVariables = typeVariables;
                        }

                        @Override
                        public TypeDescription.Generic get(int index) {
                            return new AnnotatedTypeVariable(this.typeVariables.get(index), index);
                        }

                        @Override
                        public int size() {
                            return this.typeVariables.size();
                        }

                        protected class AnnotatedTypeVariable
                        extends TypeDescription.Generic.OfTypeVariable {
                            private final TypeDescription.Generic typeVariable;
                            private final int index;

                            protected AnnotatedTypeVariable(TypeDescription.Generic typeVariable, int index) {
                                this.typeVariable = typeVariable;
                                this.index = index;
                            }

                            @Override
                            public TypeList.Generic getUpperBounds() {
                                return this.typeVariable.getUpperBounds();
                            }

                            @Override
                            public TypeVariableSource getTypeVariableSource() {
                                return this.typeVariable.getTypeVariableSource();
                            }

                            @Override
                            public String getSymbol() {
                                return this.typeVariable.getSymbol();
                            }

                            @Override
                            public AnnotationList getDeclaredAnnotations() {
                                return LazyAnnotationDescription.asListOfNullable(LazyTypeDescription.this.typePool, (List)LazyMethodDescription.this.receiverTypeAnnotationTokens.get(LazyParameterizedReceiverType.this.getTypePath() + this.index + ';'));
                            }
                        }
                    }
                }

                private class LazyParameterDescription
                extends ParameterDescription.InDefinedShape.AbstractBase {
                    private final int index;

                    protected LazyParameterDescription(int index) {
                        this.index = index;
                    }

                    @Override
                    public MethodDescription.InDefinedShape getDeclaringMethod() {
                        return LazyMethodDescription.this;
                    }

                    @Override
                    public int getIndex() {
                        return this.index;
                    }

                    @Override
                    public boolean isNamed() {
                        return LazyMethodDescription.this.parameterNames[this.index] != null;
                    }

                    @Override
                    public boolean hasModifiers() {
                        return LazyMethodDescription.this.parameterModifiers[this.index] != null;
                    }

                    @Override
                    public String getName() {
                        return this.isNamed() ? LazyMethodDescription.this.parameterNames[this.index] : super.getName();
                    }

                    @Override
                    public int getModifiers() {
                        return this.hasModifiers() ? LazyMethodDescription.this.parameterModifiers[this.index].intValue() : super.getModifiers();
                    }

                    @Override
                    public TypeDescription.Generic getType() {
                        return (TypeDescription.Generic)LazyMethodDescription.this.signatureResolution.resolveParameterTypes(LazyMethodDescription.this.parameterTypeDescriptors, LazyTypeDescription.this.typePool, LazyMethodDescription.this.parameterTypeAnnotationTokens, LazyMethodDescription.this).get(this.index);
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return LazyAnnotationDescription.asListOfNullable(LazyTypeDescription.this.typePool, (List)LazyMethodDescription.this.parameterAnnotationTokens.get(this.index));
                    }
                }

                private class LazyParameterList
                extends ParameterList.AbstractBase<ParameterDescription.InDefinedShape> {
                    private LazyParameterList() {
                    }

                    @Override
                    public ParameterDescription.InDefinedShape get(int index) {
                        return new LazyParameterDescription(index);
                    }

                    @Override
                    public boolean hasExplicitMetaData() {
                        for (int i = 0; i < this.size(); ++i) {
                            if (LazyMethodDescription.this.parameterNames[i] != null && LazyMethodDescription.this.parameterModifiers[i] != null) continue;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public int size() {
                        return LazyMethodDescription.this.parameterTypeDescriptors.size();
                    }

                    @Override
                    public TypeList.Generic asTypeList() {
                        return LazyMethodDescription.this.signatureResolution.resolveParameterTypes(LazyMethodDescription.this.parameterTypeDescriptors, LazyTypeDescription.this.typePool, LazyMethodDescription.this.parameterTypeAnnotationTokens, LazyMethodDescription.this);
                    }
                }
            }

            private class LazyFieldDescription
            extends FieldDescription.InDefinedShape.AbstractBase {
                private final String name;
                private final int modifiers;
                private final String descriptor;
                private final String genericSignature;
                private final GenericTypeToken.Resolution.ForField signatureResolution;
                private final Map<String, List<AnnotationToken>> typeAnnotationTokens;
                private final List<AnnotationToken> annotationTokens;

                private LazyFieldDescription(String name, int modifiers, String descriptor, String genericSignature, GenericTypeToken.Resolution.ForField signatureResolution, Map<String, List<AnnotationToken>> typeAnnotationTokens, List<AnnotationToken> annotationTokens) {
                    this.modifiers = modifiers;
                    this.name = name;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.signatureResolution = signatureResolution;
                    this.typeAnnotationTokens = typeAnnotationTokens;
                    this.annotationTokens = annotationTokens;
                }

                @Override
                public TypeDescription.Generic getType() {
                    return this.signatureResolution.resolveFieldType(this.descriptor, LazyTypeDescription.this.typePool, this.typeAnnotationTokens, this);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return LazyAnnotationDescription.asListOfNullable(LazyTypeDescription.this.typePool, this.annotationTokens);
                }

                @Override
                public String getName() {
                    return this.name;
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return LazyTypeDescription.this;
                }

                @Override
                public int getModifiers() {
                    return this.modifiers;
                }

                @Override
                public String getGenericSignature() {
                    return this.genericSignature;
                }
            }

            private static class TokenizedGenericType
            extends TypeDescription.Generic.LazyProjection.WithEagerNavigation {
                private final TypePool typePool;
                private final GenericTypeToken genericTypeToken;
                private final String rawTypeDescriptor;
                private final Map<String, List<AnnotationToken>> annotationTokens;
                private final TypeVariableSource typeVariableSource;

                protected TokenizedGenericType(TypePool typePool, GenericTypeToken genericTypeToken, String rawTypeDescriptor, Map<String, List<AnnotationToken>> annotationTokens, TypeVariableSource typeVariableSource) {
                    this.typePool = typePool;
                    this.genericTypeToken = genericTypeToken;
                    this.rawTypeDescriptor = rawTypeDescriptor;
                    this.annotationTokens = annotationTokens;
                    this.typeVariableSource = typeVariableSource;
                }

                protected static TypeDescription.Generic of(TypePool typePool, GenericTypeToken genericTypeToken, String rawTypeDescriptor, Map<String, List<AnnotationToken>> annotationTokens, TypeVariableSource typeVariableSource) {
                    return new TokenizedGenericType(typePool, genericTypeToken, rawTypeDescriptor, annotationTokens == null ? Collections.emptyMap() : annotationTokens, typeVariableSource);
                }

                protected static TypeDescription toErasure(TypePool typePool, String descriptor) {
                    nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type type = nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getType(descriptor);
                    return typePool.describe(type.getSort() == 9 ? type.getInternalName().replace('/', '.') : type.getClassName()).resolve();
                }

                @Override
                protected TypeDescription.Generic resolve() {
                    return this.genericTypeToken.toGenericType(this.typePool, this.typeVariableSource, "", this.annotationTokens);
                }

                @Override
                public TypeDescription asErasure() {
                    return TokenizedGenericType.toErasure(this.typePool, this.rawTypeDescriptor);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.resolve().getDeclaredAnnotations();
                }

                protected static class Malformed
                extends TypeDescription.Generic.LazyProjection.WithEagerNavigation {
                    private final TypePool typePool;
                    private final String rawTypeDescriptor;

                    protected Malformed(TypePool typePool, String rawTypeDescriptor) {
                        this.typePool = typePool;
                        this.rawTypeDescriptor = rawTypeDescriptor;
                    }

                    @Override
                    protected TypeDescription.Generic resolve() {
                        throw new GenericSignatureFormatError();
                    }

                    @Override
                    public TypeDescription asErasure() {
                        return TokenizedGenericType.toErasure(this.typePool, this.rawTypeDescriptor);
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        throw new GenericSignatureFormatError();
                    }

                    protected static class TokenList
                    extends TypeList.Generic.AbstractBase {
                        private final TypePool typePool;
                        private final List<String> rawTypeDescriptors;

                        protected TokenList(TypePool typePool, List<String> rawTypeDescriptors) {
                            this.typePool = typePool;
                            this.rawTypeDescriptors = rawTypeDescriptors;
                        }

                        @Override
                        public TypeDescription.Generic get(int index) {
                            return new Malformed(this.typePool, this.rawTypeDescriptors.get(index));
                        }

                        @Override
                        public int size() {
                            return this.rawTypeDescriptors.size();
                        }

                        @Override
                        public TypeList asErasures() {
                            return new LazyTypeList(this.typePool, this.rawTypeDescriptors);
                        }
                    }
                }

                protected static class TypeVariableList
                extends TypeList.Generic.AbstractBase {
                    private final TypePool typePool;
                    private final List<GenericTypeToken.OfFormalTypeVariable> typeVariables;
                    private final TypeVariableSource typeVariableSource;
                    private final Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens;
                    private final Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> boundAnnotationTokens;

                    protected TypeVariableList(TypePool typePool, List<GenericTypeToken.OfFormalTypeVariable> typeVariables, TypeVariableSource typeVariableSource, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> boundAnnotationTokens) {
                        this.typePool = typePool;
                        this.typeVariables = typeVariables;
                        this.typeVariableSource = typeVariableSource;
                        this.annotationTokens = annotationTokens;
                        this.boundAnnotationTokens = boundAnnotationTokens;
                    }

                    @Override
                    public TypeDescription.Generic get(int index) {
                        return this.typeVariables.get(index).toGenericType(this.typePool, this.typeVariableSource, this.annotationTokens.get(index), this.boundAnnotationTokens.get(index));
                    }

                    @Override
                    public int size() {
                        return this.typeVariables.size();
                    }
                }

                protected static class TokenList
                extends TypeList.Generic.AbstractBase {
                    private final TypePool typePool;
                    private final List<GenericTypeToken> genericTypeTokens;
                    private final List<String> rawTypeDescriptors;
                    private final TypeVariableSource typeVariableSource;
                    private final Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens;

                    private TokenList(TypePool typePool, List<GenericTypeToken> genericTypeTokens, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, List<String> rawTypeDescriptors, TypeVariableSource typeVariableSource) {
                        this.typePool = typePool;
                        this.genericTypeTokens = genericTypeTokens;
                        this.annotationTokens = annotationTokens;
                        this.rawTypeDescriptors = rawTypeDescriptors;
                        this.typeVariableSource = typeVariableSource;
                    }

                    @Override
                    public TypeDescription.Generic get(int index) {
                        return this.rawTypeDescriptors.size() == this.genericTypeTokens.size() ? TokenizedGenericType.of(this.typePool, this.genericTypeTokens.get(index), this.rawTypeDescriptors.get(index), this.annotationTokens.get(index), this.typeVariableSource) : TokenizedGenericType.toErasure(this.typePool, this.rawTypeDescriptors.get(index)).asGenericType();
                    }

                    @Override
                    public int size() {
                        return this.rawTypeDescriptors.size();
                    }

                    @Override
                    public TypeList asErasures() {
                        return new LazyTypeList(this.typePool, this.rawTypeDescriptors);
                    }
                }
            }

            private static class LazyTypeList
            extends TypeList.AbstractBase {
                private final TypePool typePool;
                private final List<String> descriptors;

                private LazyTypeList(TypePool typePool, List<String> descriptors) {
                    this.typePool = typePool;
                    this.descriptors = descriptors;
                }

                @Override
                public TypeDescription get(int index) {
                    return TokenizedGenericType.toErasure(this.typePool, this.descriptors.get(index));
                }

                @Override
                public int size() {
                    return this.descriptors.size();
                }

                @Override
                public String[] toInternalNames() {
                    String[] internalName = new String[this.descriptors.size()];
                    int index = 0;
                    for (String descriptor : this.descriptors) {
                        internalName[index++] = nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getType(descriptor).getInternalName();
                    }
                    return internalName.length == 0 ? NO_INTERFACES : internalName;
                }

                @Override
                public int getStackSize() {
                    int stackSize = 0;
                    for (String descriptor : this.descriptors) {
                        stackSize += nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getType(descriptor).getSize();
                    }
                    return stackSize;
                }
            }

            private static class LazyPackageDescription
            extends PackageDescription.AbstractBase {
                private final TypePool typePool;
                private final String name;

                private LazyPackageDescription(TypePool typePool, String name) {
                    this.typePool = typePool;
                    this.name = name;
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    Resolution resolution = this.typePool.describe(this.name + "." + "package-info");
                    return resolution.isResolved() ? resolution.resolve().getDeclaredAnnotations() : new AnnotationList.Empty();
                }

                @Override
                public String getName() {
                    return this.name;
                }
            }

            private static class LazyAnnotationDescription
            extends AnnotationDescription.AbstractBase {
                protected final TypePool typePool;
                private final TypeDescription annotationType;
                protected final Map<String, AnnotationValue<?, ?>> values;

                private LazyAnnotationDescription(TypePool typePool, TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> values) {
                    this.typePool = typePool;
                    this.annotationType = annotationType;
                    this.values = values;
                }

                protected static AnnotationList asListOfNullable(TypePool typePool, List<? extends AnnotationToken> tokens) {
                    return tokens == null ? new AnnotationList.Empty() : LazyAnnotationDescription.asList(typePool, tokens);
                }

                protected static AnnotationList asList(TypePool typePool, List<? extends AnnotationToken> tokens) {
                    ArrayList<AnnotationDescription> annotationDescriptions = new ArrayList<AnnotationDescription>(tokens.size());
                    for (AnnotationToken annotationToken : tokens) {
                        AnnotationToken.Resolution resolution = annotationToken.toAnnotationDescription(typePool);
                        if (!resolution.isResolved()) continue;
                        annotationDescriptions.add(resolution.resolve());
                    }
                    return new AnnotationList.Explicit(annotationDescriptions);
                }

                @Override
                public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property) {
                    if (!property.getDeclaringType().asErasure().equals(this.annotationType)) {
                        throw new IllegalArgumentException(property + " is not declared by " + this.getAnnotationType());
                    }
                    AnnotationValue<?, ?> annotationValue = this.values.get(property.getName());
                    if (annotationValue == null) {
                        annotationValue = ((MethodDescription.InDefinedShape)((MethodList)this.getAnnotationType().getDeclaredMethods().filter(ElementMatchers.is(property))).getOnly()).getDefaultValue();
                    }
                    if (annotationValue != null) {
                        return annotationValue;
                    }
                    throw new IllegalStateException(property + " is not defined on annotation");
                }

                @Override
                public TypeDescription getAnnotationType() {
                    return this.annotationType;
                }

                public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
                    if (!this.annotationType.represents(annotationType)) {
                        throw new IllegalArgumentException(annotationType + " does not represent " + this.annotationType);
                    }
                    return new Loadable(this.typePool, annotationType, this.values);
                }

                private static class Loadable<S extends Annotation>
                extends LazyAnnotationDescription
                implements AnnotationDescription.Loadable<S> {
                    private final Class<S> annotationType;

                    private Loadable(TypePool typePool, Class<S> annotationType, Map<String, AnnotationValue<?, ?>> values) {
                        super(typePool, new TypeDescription.ForLoadedType(annotationType), values);
                        this.annotationType = annotationType;
                    }

                    @Override
                    public S load() throws ClassNotFoundException {
                        return AnnotationDescription.AnnotationInvocationHandler.of(this.annotationType.getClassLoader(), this.annotationType, this.values);
                    }

                    @Override
                    public S loadSilent() {
                        try {
                            return this.load();
                        }
                        catch (ClassNotFoundException exception) {
                            throw new IllegalStateException("Could not load annotation type or referenced type", exception);
                        }
                    }
                }
            }

            protected static class MethodToken {
                private final String name;
                private final int modifiers;
                private final String descriptor;
                private final String genericSignature;
                private final GenericTypeToken.Resolution.ForMethod signatureResolution;
                private final String[] exceptionName;
                private final Map<Integer, Map<String, List<AnnotationToken>>> typeVariableAnnotationTokens;
                private final Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> typeVariableBoundAnnotationTokens;
                private final Map<String, List<AnnotationToken>> returnTypeAnnotationTokens;
                private final Map<Integer, Map<String, List<AnnotationToken>>> parameterTypeAnnotationTokens;
                private final Map<Integer, Map<String, List<AnnotationToken>>> exceptionTypeAnnotationTokens;
                private final Map<String, List<AnnotationToken>> receiverTypeAnnotationTokens;
                private final List<AnnotationToken> annotationTokens;
                private final Map<Integer, List<AnnotationToken>> parameterAnnotationTokens;
                private final List<ParameterToken> parameterTokens;
                private final AnnotationValue<?, ?> defaultValue;

                protected MethodToken(String name, int modifiers, String descriptor, String genericSignature, String[] exceptionName, Map<Integer, Map<String, List<AnnotationToken>>> typeVariableAnnotationTokens, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> typeVariableBoundAnnotationTokens, Map<String, List<AnnotationToken>> returnTypeAnnotationTokens, Map<Integer, Map<String, List<AnnotationToken>>> parameterTypeAnnotationTokens, Map<Integer, Map<String, List<AnnotationToken>>> exceptionTypeAnnotationTokens, Map<String, List<AnnotationToken>> receiverTypeAnnotationTokens, List<AnnotationToken> annotationTokens, Map<Integer, List<AnnotationToken>> parameterAnnotationTokens, List<ParameterToken> parameterTokens, AnnotationValue<?, ?> defaultValue) {
                    this.modifiers = modifiers & 0xFFFDFFFF;
                    this.name = name;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.signatureResolution = TypeDescription.AbstractBase.RAW_TYPES ? GenericTypeToken.Resolution.Raw.INSTANCE : GenericTypeExtractor.ForSignature.OfMethod.extract(genericSignature);
                    this.exceptionName = exceptionName;
                    this.typeVariableAnnotationTokens = typeVariableAnnotationTokens;
                    this.typeVariableBoundAnnotationTokens = typeVariableBoundAnnotationTokens;
                    this.returnTypeAnnotationTokens = returnTypeAnnotationTokens;
                    this.parameterTypeAnnotationTokens = parameterTypeAnnotationTokens;
                    this.exceptionTypeAnnotationTokens = exceptionTypeAnnotationTokens;
                    this.receiverTypeAnnotationTokens = receiverTypeAnnotationTokens;
                    this.annotationTokens = annotationTokens;
                    this.parameterAnnotationTokens = parameterAnnotationTokens;
                    this.parameterTokens = parameterTokens;
                    this.defaultValue = defaultValue;
                }

                private MethodDescription.InDefinedShape toMethodDescription(LazyTypeDescription lazyTypeDescription) {
                    LazyTypeDescription lazyTypeDescription2 = lazyTypeDescription;
                    lazyTypeDescription2.getClass();
                    return lazyTypeDescription2.new LazyMethodDescription(this.name, this.modifiers, this.descriptor, this.genericSignature, this.signatureResolution, this.exceptionName, this.typeVariableAnnotationTokens, this.typeVariableBoundAnnotationTokens, this.returnTypeAnnotationTokens, this.parameterTypeAnnotationTokens, this.exceptionTypeAnnotationTokens, this.receiverTypeAnnotationTokens, this.annotationTokens, this.parameterAnnotationTokens, this.parameterTokens, this.defaultValue);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MethodToken)) {
                        return false;
                    }
                    MethodToken other = (MethodToken)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.name;
                    String other$name = other.name;
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    if (this.modifiers != other.modifiers) {
                        return false;
                    }
                    String this$descriptor = this.descriptor;
                    String other$descriptor = other.descriptor;
                    if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                        return false;
                    }
                    String this$genericSignature = this.genericSignature;
                    String other$genericSignature = other.genericSignature;
                    if (this$genericSignature == null ? other$genericSignature != null : !this$genericSignature.equals(other$genericSignature)) {
                        return false;
                    }
                    GenericTypeToken.Resolution.ForMethod this$signatureResolution = this.signatureResolution;
                    GenericTypeToken.Resolution.ForMethod other$signatureResolution = other.signatureResolution;
                    if (this$signatureResolution == null ? other$signatureResolution != null : !this$signatureResolution.equals(other$signatureResolution)) {
                        return false;
                    }
                    if (!Arrays.deepEquals(this.exceptionName, other.exceptionName)) {
                        return false;
                    }
                    Map<Integer, Map<String, List<AnnotationToken>>> this$typeVariableAnnotationTokens = this.typeVariableAnnotationTokens;
                    Map<Integer, Map<String, List<AnnotationToken>>> other$typeVariableAnnotationTokens = other.typeVariableAnnotationTokens;
                    if (this$typeVariableAnnotationTokens == null ? other$typeVariableAnnotationTokens != null : !((Object)this$typeVariableAnnotationTokens).equals(other$typeVariableAnnotationTokens)) {
                        return false;
                    }
                    Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> this$typeVariableBoundAnnotationTokens = this.typeVariableBoundAnnotationTokens;
                    Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> other$typeVariableBoundAnnotationTokens = other.typeVariableBoundAnnotationTokens;
                    if (this$typeVariableBoundAnnotationTokens == null ? other$typeVariableBoundAnnotationTokens != null : !((Object)this$typeVariableBoundAnnotationTokens).equals(other$typeVariableBoundAnnotationTokens)) {
                        return false;
                    }
                    Map<String, List<AnnotationToken>> this$returnTypeAnnotationTokens = this.returnTypeAnnotationTokens;
                    Map<String, List<AnnotationToken>> other$returnTypeAnnotationTokens = other.returnTypeAnnotationTokens;
                    if (this$returnTypeAnnotationTokens == null ? other$returnTypeAnnotationTokens != null : !((Object)this$returnTypeAnnotationTokens).equals(other$returnTypeAnnotationTokens)) {
                        return false;
                    }
                    Map<Integer, Map<String, List<AnnotationToken>>> this$parameterTypeAnnotationTokens = this.parameterTypeAnnotationTokens;
                    Map<Integer, Map<String, List<AnnotationToken>>> other$parameterTypeAnnotationTokens = other.parameterTypeAnnotationTokens;
                    if (this$parameterTypeAnnotationTokens == null ? other$parameterTypeAnnotationTokens != null : !((Object)this$parameterTypeAnnotationTokens).equals(other$parameterTypeAnnotationTokens)) {
                        return false;
                    }
                    Map<Integer, Map<String, List<AnnotationToken>>> this$exceptionTypeAnnotationTokens = this.exceptionTypeAnnotationTokens;
                    Map<Integer, Map<String, List<AnnotationToken>>> other$exceptionTypeAnnotationTokens = other.exceptionTypeAnnotationTokens;
                    if (this$exceptionTypeAnnotationTokens == null ? other$exceptionTypeAnnotationTokens != null : !((Object)this$exceptionTypeAnnotationTokens).equals(other$exceptionTypeAnnotationTokens)) {
                        return false;
                    }
                    Map<String, List<AnnotationToken>> this$receiverTypeAnnotationTokens = this.receiverTypeAnnotationTokens;
                    Map<String, List<AnnotationToken>> other$receiverTypeAnnotationTokens = other.receiverTypeAnnotationTokens;
                    if (this$receiverTypeAnnotationTokens == null ? other$receiverTypeAnnotationTokens != null : !((Object)this$receiverTypeAnnotationTokens).equals(other$receiverTypeAnnotationTokens)) {
                        return false;
                    }
                    List<AnnotationToken> this$annotationTokens = this.annotationTokens;
                    List<AnnotationToken> other$annotationTokens = other.annotationTokens;
                    if (this$annotationTokens == null ? other$annotationTokens != null : !((Object)this$annotationTokens).equals(other$annotationTokens)) {
                        return false;
                    }
                    Map<Integer, List<AnnotationToken>> this$parameterAnnotationTokens = this.parameterAnnotationTokens;
                    Map<Integer, List<AnnotationToken>> other$parameterAnnotationTokens = other.parameterAnnotationTokens;
                    if (this$parameterAnnotationTokens == null ? other$parameterAnnotationTokens != null : !((Object)this$parameterAnnotationTokens).equals(other$parameterAnnotationTokens)) {
                        return false;
                    }
                    List<ParameterToken> this$parameterTokens = this.parameterTokens;
                    List<ParameterToken> other$parameterTokens = other.parameterTokens;
                    if (this$parameterTokens == null ? other$parameterTokens != null : !((Object)this$parameterTokens).equals(other$parameterTokens)) {
                        return false;
                    }
                    AnnotationValue<?, ?> this$defaultValue = this.defaultValue;
                    AnnotationValue<?, ?> other$defaultValue = other.defaultValue;
                    return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof MethodToken;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.name;
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    result = result * 59 + this.modifiers;
                    String $descriptor = this.descriptor;
                    result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
                    String $genericSignature = this.genericSignature;
                    result = result * 59 + ($genericSignature == null ? 43 : $genericSignature.hashCode());
                    GenericTypeToken.Resolution.ForMethod $signatureResolution = this.signatureResolution;
                    result = result * 59 + ($signatureResolution == null ? 43 : $signatureResolution.hashCode());
                    result = result * 59 + Arrays.deepHashCode(this.exceptionName);
                    Map<Integer, Map<String, List<AnnotationToken>>> $typeVariableAnnotationTokens = this.typeVariableAnnotationTokens;
                    result = result * 59 + ($typeVariableAnnotationTokens == null ? 43 : ((Object)$typeVariableAnnotationTokens).hashCode());
                    Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> $typeVariableBoundAnnotationTokens = this.typeVariableBoundAnnotationTokens;
                    result = result * 59 + ($typeVariableBoundAnnotationTokens == null ? 43 : ((Object)$typeVariableBoundAnnotationTokens).hashCode());
                    Map<String, List<AnnotationToken>> $returnTypeAnnotationTokens = this.returnTypeAnnotationTokens;
                    result = result * 59 + ($returnTypeAnnotationTokens == null ? 43 : ((Object)$returnTypeAnnotationTokens).hashCode());
                    Map<Integer, Map<String, List<AnnotationToken>>> $parameterTypeAnnotationTokens = this.parameterTypeAnnotationTokens;
                    result = result * 59 + ($parameterTypeAnnotationTokens == null ? 43 : ((Object)$parameterTypeAnnotationTokens).hashCode());
                    Map<Integer, Map<String, List<AnnotationToken>>> $exceptionTypeAnnotationTokens = this.exceptionTypeAnnotationTokens;
                    result = result * 59 + ($exceptionTypeAnnotationTokens == null ? 43 : ((Object)$exceptionTypeAnnotationTokens).hashCode());
                    Map<String, List<AnnotationToken>> $receiverTypeAnnotationTokens = this.receiverTypeAnnotationTokens;
                    result = result * 59 + ($receiverTypeAnnotationTokens == null ? 43 : ((Object)$receiverTypeAnnotationTokens).hashCode());
                    List<AnnotationToken> $annotationTokens = this.annotationTokens;
                    result = result * 59 + ($annotationTokens == null ? 43 : ((Object)$annotationTokens).hashCode());
                    Map<Integer, List<AnnotationToken>> $parameterAnnotationTokens = this.parameterAnnotationTokens;
                    result = result * 59 + ($parameterAnnotationTokens == null ? 43 : ((Object)$parameterAnnotationTokens).hashCode());
                    List<ParameterToken> $parameterTokens = this.parameterTokens;
                    result = result * 59 + ($parameterTokens == null ? 43 : ((Object)$parameterTokens).hashCode());
                    AnnotationValue<?, ?> $defaultValue = this.defaultValue;
                    result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
                    return result;
                }

                protected static class ParameterToken {
                    protected static final String NO_NAME = null;
                    protected static final Integer NO_MODIFIERS = null;
                    private final String name;
                    private final Integer modifiers;

                    protected ParameterToken() {
                        this(NO_NAME);
                    }

                    protected ParameterToken(String name) {
                        this(name, NO_MODIFIERS);
                    }

                    protected ParameterToken(String name, Integer modifiers) {
                        this.name = name;
                        this.modifiers = modifiers;
                    }

                    protected String getName() {
                        return this.name;
                    }

                    protected Integer getModifiers() {
                        return this.modifiers;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ParameterToken)) {
                            return false;
                        }
                        ParameterToken other = (ParameterToken)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        Integer this$modifiers = this.getModifiers();
                        Integer other$modifiers = other.getModifiers();
                        return !(this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ParameterToken;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        Integer $modifiers = this.getModifiers();
                        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
                        return result;
                    }
                }
            }

            protected static class FieldToken {
                private final String name;
                private final int modifiers;
                private final String descriptor;
                private final String genericSignature;
                private final GenericTypeToken.Resolution.ForField signatureResolution;
                private final Map<String, List<AnnotationToken>> typeAnnotationTokens;
                private final List<AnnotationToken> annotationTokens;

                protected FieldToken(String name, int modifiers, String descriptor, String genericSignature, Map<String, List<AnnotationToken>> typeAnnotationTokens, List<AnnotationToken> annotationTokens) {
                    this.modifiers = modifiers & 0xFFFDFFFF;
                    this.name = name;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.signatureResolution = TypeDescription.AbstractBase.RAW_TYPES ? GenericTypeToken.Resolution.Raw.INSTANCE : GenericTypeExtractor.ForSignature.OfField.extract(genericSignature);
                    this.typeAnnotationTokens = typeAnnotationTokens;
                    this.annotationTokens = annotationTokens;
                }

                private LazyFieldDescription toFieldDescription(LazyTypeDescription lazyTypeDescription) {
                    LazyTypeDescription lazyTypeDescription2 = lazyTypeDescription;
                    lazyTypeDescription2.getClass();
                    return lazyTypeDescription2.new LazyFieldDescription(this.name, this.modifiers, this.descriptor, this.genericSignature, this.signatureResolution, this.typeAnnotationTokens, this.annotationTokens);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof FieldToken)) {
                        return false;
                    }
                    FieldToken other = (FieldToken)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.name;
                    String other$name = other.name;
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    if (this.modifiers != other.modifiers) {
                        return false;
                    }
                    String this$descriptor = this.descriptor;
                    String other$descriptor = other.descriptor;
                    if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                        return false;
                    }
                    String this$genericSignature = this.genericSignature;
                    String other$genericSignature = other.genericSignature;
                    if (this$genericSignature == null ? other$genericSignature != null : !this$genericSignature.equals(other$genericSignature)) {
                        return false;
                    }
                    GenericTypeToken.Resolution.ForField this$signatureResolution = this.signatureResolution;
                    GenericTypeToken.Resolution.ForField other$signatureResolution = other.signatureResolution;
                    if (this$signatureResolution == null ? other$signatureResolution != null : !this$signatureResolution.equals(other$signatureResolution)) {
                        return false;
                    }
                    Map<String, List<AnnotationToken>> this$typeAnnotationTokens = this.typeAnnotationTokens;
                    Map<String, List<AnnotationToken>> other$typeAnnotationTokens = other.typeAnnotationTokens;
                    if (this$typeAnnotationTokens == null ? other$typeAnnotationTokens != null : !((Object)this$typeAnnotationTokens).equals(other$typeAnnotationTokens)) {
                        return false;
                    }
                    List<AnnotationToken> this$annotationTokens = this.annotationTokens;
                    List<AnnotationToken> other$annotationTokens = other.annotationTokens;
                    return !(this$annotationTokens == null ? other$annotationTokens != null : !((Object)this$annotationTokens).equals(other$annotationTokens));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof FieldToken;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.name;
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    result = result * 59 + this.modifiers;
                    String $descriptor = this.descriptor;
                    result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
                    String $genericSignature = this.genericSignature;
                    result = result * 59 + ($genericSignature == null ? 43 : $genericSignature.hashCode());
                    GenericTypeToken.Resolution.ForField $signatureResolution = this.signatureResolution;
                    result = result * 59 + ($signatureResolution == null ? 43 : $signatureResolution.hashCode());
                    Map<String, List<AnnotationToken>> $typeAnnotationTokens = this.typeAnnotationTokens;
                    result = result * 59 + ($typeAnnotationTokens == null ? 43 : ((Object)$typeAnnotationTokens).hashCode());
                    List<AnnotationToken> $annotationTokens = this.annotationTokens;
                    result = result * 59 + ($annotationTokens == null ? 43 : ((Object)$annotationTokens).hashCode());
                    return result;
                }
            }

            protected static class AnnotationToken {
                private final String descriptor;
                private final Map<String, AnnotationValue<?, ?>> values;

                protected AnnotationToken(String descriptor, Map<String, AnnotationValue<?, ?>> values) {
                    this.descriptor = descriptor;
                    this.values = values;
                }

                protected Map<String, AnnotationValue<?, ?>> getValues() {
                    return this.values;
                }

                protected String getBinaryName() {
                    return this.descriptor.substring(1, this.descriptor.length() - 1).replace('/', '.');
                }

                private Resolution toAnnotationDescription(TypePool typePool) {
                    nl.jqno.equalsverifier.internal.lib.bytebuddy.pool.TypePool$Resolution resolution = typePool.describe(this.getBinaryName());
                    return resolution.isResolved() ? new Resolution.Simple(new LazyAnnotationDescription(typePool, resolution.resolve(), this.values)) : new Resolution.Illegal(this.getBinaryName());
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AnnotationToken)) {
                        return false;
                    }
                    AnnotationToken other = (AnnotationToken)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$descriptor = this.descriptor;
                    String other$descriptor = other.descriptor;
                    if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                        return false;
                    }
                    Map<String, AnnotationValue<?, ?>> this$values = this.getValues();
                    Map<String, AnnotationValue<?, ?>> other$values = other.getValues();
                    return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof AnnotationToken;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $descriptor = this.descriptor;
                    result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
                    Map<String, AnnotationValue<?, ?>> $values = this.getValues();
                    result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
                    return result;
                }

                protected static interface Resolution {
                    public boolean isResolved();

                    public AnnotationDescription resolve();

                    public static class Illegal
                    implements Resolution {
                        private final String annotationType;

                        public Illegal(String annotationType) {
                            this.annotationType = annotationType;
                        }

                        @Override
                        public boolean isResolved() {
                            return false;
                        }

                        @Override
                        public AnnotationDescription resolve() {
                            throw new IllegalStateException("Annotation type is not available: " + this.annotationType);
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Illegal)) {
                                return false;
                            }
                            Illegal other = (Illegal)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            String this$annotationType = this.annotationType;
                            String other$annotationType = other.annotationType;
                            return !(this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Illegal;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            String $annotationType = this.annotationType;
                            result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                            return result;
                        }
                    }

                    public static class Simple
                    implements Resolution {
                        private final AnnotationDescription annotationDescription;

                        protected Simple(AnnotationDescription annotationDescription) {
                            this.annotationDescription = annotationDescription;
                        }

                        @Override
                        public boolean isResolved() {
                            return true;
                        }

                        @Override
                        public AnnotationDescription resolve() {
                            return this.annotationDescription;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Simple)) {
                                return false;
                            }
                            Simple other = (Simple)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            AnnotationDescription this$annotationDescription = this.annotationDescription;
                            AnnotationDescription other$annotationDescription = other.annotationDescription;
                            return !(this$annotationDescription == null ? other$annotationDescription != null : !this$annotationDescription.equals(other$annotationDescription));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Simple;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            AnnotationDescription $annotationDescription = this.annotationDescription;
                            result = result * 59 + ($annotationDescription == null ? 43 : $annotationDescription.hashCode());
                            return result;
                        }
                    }
                }
            }

            protected static interface GenericTypeToken {
                public static final String EMPTY_TYPE_PATH = "";
                public static final char COMPONENT_TYPE_PATH = '[';
                public static final char WILDCARD_TYPE_PATH = '*';
                public static final char INNER_CLASS_PATH = '.';
                public static final char INDEXED_TYPE_DELIMITER = ';';

                public TypeDescription.Generic toGenericType(TypePool var1, TypeVariableSource var2, String var3, Map<String, List<AnnotationToken>> var4);

                public boolean isPrimaryBound(TypePool var1);

                public String getTypePathPrefix();

                public static class LazyTokenList
                extends TypeList.Generic.AbstractBase {
                    private final TypePool typePool;
                    private final TypeVariableSource typeVariableSource;
                    private final String typePath;
                    private final Map<String, List<AnnotationToken>> annotationTokens;
                    private final List<GenericTypeToken> genericTypeTokens;

                    protected LazyTokenList(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens, List<GenericTypeToken> genericTypeTokens) {
                        this.typePool = typePool;
                        this.typeVariableSource = typeVariableSource;
                        this.typePath = typePath;
                        this.annotationTokens = annotationTokens;
                        this.genericTypeTokens = genericTypeTokens;
                    }

                    @Override
                    public TypeDescription.Generic get(int index) {
                        return this.genericTypeTokens.get(index).toGenericType(this.typePool, this.typeVariableSource, this.typePath + index + ';', this.annotationTokens);
                    }

                    @Override
                    public int size() {
                        return this.genericTypeTokens.size();
                    }

                    protected static class ForWildcardBound
                    extends TypeList.Generic.AbstractBase {
                        private final TypePool typePool;
                        private final TypeVariableSource typeVariableSource;
                        private final String typePath;
                        private final Map<String, List<AnnotationToken>> annotationTokens;
                        private final GenericTypeToken genericTypeToken;

                        protected ForWildcardBound(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens, GenericTypeToken genericTypeToken) {
                            this.typePool = typePool;
                            this.typeVariableSource = typeVariableSource;
                            this.typePath = typePath;
                            this.annotationTokens = annotationTokens;
                            this.genericTypeToken = genericTypeToken;
                        }

                        @Override
                        public TypeDescription.Generic get(int index) {
                            if (index == 0) {
                                return this.genericTypeToken.toGenericType(this.typePool, this.typeVariableSource, this.typePath + '*', this.annotationTokens);
                            }
                            throw new IndexOutOfBoundsException("index = " + index);
                        }

                        @Override
                        public int size() {
                            return 1;
                        }
                    }
                }

                public static class ForParameterizedType
                implements GenericTypeToken {
                    private final String name;
                    private final List<GenericTypeToken> parameterTypeTokens;

                    protected ForParameterizedType(String name, List<GenericTypeToken> parameterTypeTokens) {
                        this.name = name;
                        this.parameterTypeTokens = parameterTypeTokens;
                    }

                    @Override
                    public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                        return new LazyParameterizedType(typePool, typeVariableSource, typePath, annotationTokens, this.name, this.parameterTypeTokens);
                    }

                    @Override
                    public boolean isPrimaryBound(TypePool typePool) {
                        return !typePool.describe(this.name).resolve().isInterface();
                    }

                    @Override
                    public String getTypePathPrefix() {
                        return String.valueOf('.');
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForParameterizedType)) {
                            return false;
                        }
                        ForParameterizedType other = (ForParameterizedType)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$name = this.name;
                        String other$name = other.name;
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        List<GenericTypeToken> this$parameterTypeTokens = this.parameterTypeTokens;
                        List<GenericTypeToken> other$parameterTypeTokens = other.parameterTypeTokens;
                        return !(this$parameterTypeTokens == null ? other$parameterTypeTokens != null : !((Object)this$parameterTypeTokens).equals(other$parameterTypeTokens));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForParameterizedType;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $name = this.name;
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        List<GenericTypeToken> $parameterTypeTokens = this.parameterTypeTokens;
                        result = result * 59 + ($parameterTypeTokens == null ? 43 : ((Object)$parameterTypeTokens).hashCode());
                        return result;
                    }

                    protected static class LazyParameterizedType
                    extends TypeDescription.Generic.OfParameterizedType {
                        private final TypePool typePool;
                        private final TypeVariableSource typeVariableSource;
                        private final String typePath;
                        private final Map<String, List<AnnotationToken>> annotationTokens;
                        private final String name;
                        private final List<GenericTypeToken> parameterTypeTokens;

                        protected LazyParameterizedType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens, String name, List<GenericTypeToken> parameterTypeTokens) {
                            this.typePool = typePool;
                            this.typeVariableSource = typeVariableSource;
                            this.typePath = typePath;
                            this.annotationTokens = annotationTokens;
                            this.name = name;
                            this.parameterTypeTokens = parameterTypeTokens;
                        }

                        @Override
                        public TypeDescription asErasure() {
                            return this.typePool.describe(this.name).resolve();
                        }

                        @Override
                        public TypeList.Generic getTypeArguments() {
                            return new LazyTokenList(this.typePool, this.typeVariableSource, this.typePath, this.annotationTokens, this.parameterTypeTokens);
                        }

                        @Override
                        public TypeDescription.Generic getOwnerType() {
                            TypeDescription ownerType = this.typePool.describe(this.name).resolve().getEnclosingType();
                            return ownerType == null ? TypeDescription.Generic.UNDEFINED : ownerType.asGenericType();
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(this.typePath));
                        }
                    }

                    public static class Nested
                    implements GenericTypeToken {
                        private final String name;
                        private final List<GenericTypeToken> parameterTypeTokens;
                        private final GenericTypeToken ownerTypeToken;

                        protected Nested(String name, List<GenericTypeToken> parameterTypeTokens, GenericTypeToken ownerTypeToken) {
                            this.name = name;
                            this.parameterTypeTokens = parameterTypeTokens;
                            this.ownerTypeToken = ownerTypeToken;
                        }

                        @Override
                        public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                            return new LazyParameterizedType(typePool, typeVariableSource, typePath, annotationTokens, this.name, this.parameterTypeTokens, this.ownerTypeToken);
                        }

                        @Override
                        public String getTypePathPrefix() {
                            return this.ownerTypeToken.getTypePathPrefix() + '.';
                        }

                        @Override
                        public boolean isPrimaryBound(TypePool typePool) {
                            return !typePool.describe(this.name).resolve().isInterface();
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Nested)) {
                                return false;
                            }
                            Nested other = (Nested)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            String this$name = this.name;
                            String other$name = other.name;
                            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                                return false;
                            }
                            List<GenericTypeToken> this$parameterTypeTokens = this.parameterTypeTokens;
                            List<GenericTypeToken> other$parameterTypeTokens = other.parameterTypeTokens;
                            if (this$parameterTypeTokens == null ? other$parameterTypeTokens != null : !((Object)this$parameterTypeTokens).equals(other$parameterTypeTokens)) {
                                return false;
                            }
                            GenericTypeToken this$ownerTypeToken = this.ownerTypeToken;
                            GenericTypeToken other$ownerTypeToken = other.ownerTypeToken;
                            return !(this$ownerTypeToken == null ? other$ownerTypeToken != null : !this$ownerTypeToken.equals(other$ownerTypeToken));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Nested;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            String $name = this.name;
                            result = result * 59 + ($name == null ? 43 : $name.hashCode());
                            List<GenericTypeToken> $parameterTypeTokens = this.parameterTypeTokens;
                            result = result * 59 + ($parameterTypeTokens == null ? 43 : ((Object)$parameterTypeTokens).hashCode());
                            GenericTypeToken $ownerTypeToken = this.ownerTypeToken;
                            result = result * 59 + ($ownerTypeToken == null ? 43 : $ownerTypeToken.hashCode());
                            return result;
                        }

                        protected static class LazyParameterizedType
                        extends TypeDescription.Generic.OfParameterizedType {
                            private final TypePool typePool;
                            private final TypeVariableSource typeVariableSource;
                            private final String typePath;
                            private final Map<String, List<AnnotationToken>> annotationTokens;
                            private final String name;
                            private final List<GenericTypeToken> parameterTypeTokens;
                            private final GenericTypeToken ownerTypeToken;

                            protected LazyParameterizedType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens, String name, List<GenericTypeToken> parameterTypeTokens, GenericTypeToken ownerTypeToken) {
                                this.typePool = typePool;
                                this.typeVariableSource = typeVariableSource;
                                this.typePath = typePath;
                                this.annotationTokens = annotationTokens;
                                this.name = name;
                                this.parameterTypeTokens = parameterTypeTokens;
                                this.ownerTypeToken = ownerTypeToken;
                            }

                            @Override
                            public TypeDescription asErasure() {
                                return this.typePool.describe(this.name).resolve();
                            }

                            @Override
                            public TypeList.Generic getTypeArguments() {
                                return new LazyTokenList(this.typePool, this.typeVariableSource, this.typePath + this.ownerTypeToken.getTypePathPrefix(), this.annotationTokens, this.parameterTypeTokens);
                            }

                            @Override
                            public TypeDescription.Generic getOwnerType() {
                                return this.ownerTypeToken.toGenericType(this.typePool, this.typeVariableSource, this.typePath, this.annotationTokens);
                            }

                            @Override
                            public AnnotationList getDeclaredAnnotations() {
                                return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(this.typePath + this.ownerTypeToken.getTypePathPrefix()));
                            }
                        }
                    }
                }

                public static class ForUpperBoundWildcard
                implements GenericTypeToken {
                    private final GenericTypeToken boundTypeToken;

                    protected ForUpperBoundWildcard(GenericTypeToken boundTypeToken) {
                        this.boundTypeToken = boundTypeToken;
                    }

                    @Override
                    public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                        return new LazyUpperBoundWildcard(typePool, typeVariableSource, typePath, annotationTokens, this.boundTypeToken);
                    }

                    @Override
                    public boolean isPrimaryBound(TypePool typePool) {
                        throw new IllegalStateException("A wildcard type cannot be a type variable bound: " + this);
                    }

                    @Override
                    public String getTypePathPrefix() {
                        throw new IllegalStateException("An upper bound wildcard cannot be the owner of a nested type: " + this);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForUpperBoundWildcard)) {
                            return false;
                        }
                        ForUpperBoundWildcard other = (ForUpperBoundWildcard)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        GenericTypeToken this$boundTypeToken = this.boundTypeToken;
                        GenericTypeToken other$boundTypeToken = other.boundTypeToken;
                        return !(this$boundTypeToken == null ? other$boundTypeToken != null : !this$boundTypeToken.equals(other$boundTypeToken));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForUpperBoundWildcard;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        GenericTypeToken $boundTypeToken = this.boundTypeToken;
                        result = result * 59 + ($boundTypeToken == null ? 43 : $boundTypeToken.hashCode());
                        return result;
                    }

                    protected static class LazyUpperBoundWildcard
                    extends TypeDescription.Generic.OfWildcardType {
                        private final TypePool typePool;
                        private final TypeVariableSource typeVariableSource;
                        private final String typePath;
                        private final Map<String, List<AnnotationToken>> annotationTokens;
                        private final GenericTypeToken boundTypeToken;

                        protected LazyUpperBoundWildcard(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens, GenericTypeToken boundTypeToken) {
                            this.typePool = typePool;
                            this.typeVariableSource = typeVariableSource;
                            this.typePath = typePath;
                            this.annotationTokens = annotationTokens;
                            this.boundTypeToken = boundTypeToken;
                        }

                        @Override
                        public TypeList.Generic getUpperBounds() {
                            return new LazyTokenList.ForWildcardBound(this.typePool, this.typeVariableSource, this.typePath, this.annotationTokens, this.boundTypeToken);
                        }

                        @Override
                        public TypeList.Generic getLowerBounds() {
                            return new TypeList.Generic.Empty();
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(this.typePath));
                        }
                    }
                }

                public static class ForLowerBoundWildcard
                implements GenericTypeToken {
                    private final GenericTypeToken boundTypeToken;

                    protected ForLowerBoundWildcard(GenericTypeToken boundTypeToken) {
                        this.boundTypeToken = boundTypeToken;
                    }

                    @Override
                    public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                        return new LazyLowerBoundWildcard(typePool, typeVariableSource, typePath, annotationTokens, this.boundTypeToken);
                    }

                    @Override
                    public boolean isPrimaryBound(TypePool typePool) {
                        throw new IllegalStateException("A wildcard type cannot be a type variable bound: " + this);
                    }

                    @Override
                    public String getTypePathPrefix() {
                        throw new IllegalStateException("A lower bound wildcard cannot be the owner of a nested type: " + this);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForLowerBoundWildcard)) {
                            return false;
                        }
                        ForLowerBoundWildcard other = (ForLowerBoundWildcard)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        GenericTypeToken this$boundTypeToken = this.boundTypeToken;
                        GenericTypeToken other$boundTypeToken = other.boundTypeToken;
                        return !(this$boundTypeToken == null ? other$boundTypeToken != null : !this$boundTypeToken.equals(other$boundTypeToken));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForLowerBoundWildcard;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        GenericTypeToken $boundTypeToken = this.boundTypeToken;
                        result = result * 59 + ($boundTypeToken == null ? 43 : $boundTypeToken.hashCode());
                        return result;
                    }

                    protected static class LazyLowerBoundWildcard
                    extends TypeDescription.Generic.OfWildcardType {
                        private final TypePool typePool;
                        private final TypeVariableSource typeVariableSource;
                        private final String typePath;
                        private final Map<String, List<AnnotationToken>> annotationTokens;
                        private final GenericTypeToken boundTypeToken;

                        protected LazyLowerBoundWildcard(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens, GenericTypeToken boundTypeToken) {
                            this.typePool = typePool;
                            this.typeVariableSource = typeVariableSource;
                            this.typePath = typePath;
                            this.annotationTokens = annotationTokens;
                            this.boundTypeToken = boundTypeToken;
                        }

                        @Override
                        public TypeList.Generic getUpperBounds() {
                            return new TypeList.Generic.Explicit(TypeDescription.Generic.OBJECT);
                        }

                        @Override
                        public TypeList.Generic getLowerBounds() {
                            return new LazyTokenList.ForWildcardBound(this.typePool, this.typeVariableSource, this.typePath, this.annotationTokens, this.boundTypeToken);
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(this.typePath));
                        }
                    }
                }

                public static class ForGenericArray
                implements GenericTypeToken {
                    private final GenericTypeToken componentTypeToken;

                    protected ForGenericArray(GenericTypeToken componentTypeToken) {
                        this.componentTypeToken = componentTypeToken;
                    }

                    @Override
                    public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                        return new LazyGenericArray(typePool, typeVariableSource, typePath, annotationTokens, this.componentTypeToken);
                    }

                    @Override
                    public boolean isPrimaryBound(TypePool typePool) {
                        throw new IllegalStateException("A generic array type cannot be a type variable bound: " + this);
                    }

                    @Override
                    public String getTypePathPrefix() {
                        throw new IllegalStateException("A generic array type cannot be the owner of a nested type: " + this);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForGenericArray)) {
                            return false;
                        }
                        ForGenericArray other = (ForGenericArray)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        GenericTypeToken this$componentTypeToken = this.componentTypeToken;
                        GenericTypeToken other$componentTypeToken = other.componentTypeToken;
                        return !(this$componentTypeToken == null ? other$componentTypeToken != null : !this$componentTypeToken.equals(other$componentTypeToken));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForGenericArray;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        GenericTypeToken $componentTypeToken = this.componentTypeToken;
                        result = result * 59 + ($componentTypeToken == null ? 43 : $componentTypeToken.hashCode());
                        return result;
                    }

                    protected static class LazyGenericArray
                    extends TypeDescription.Generic.OfGenericArray {
                        private final TypePool typePool;
                        private final TypeVariableSource typeVariableSource;
                        private final String typePath;
                        private final Map<String, List<AnnotationToken>> annotationTokens;
                        private final GenericTypeToken componentTypeToken;

                        protected LazyGenericArray(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens, GenericTypeToken componentTypeToken) {
                            this.typePool = typePool;
                            this.typeVariableSource = typeVariableSource;
                            this.typePath = typePath;
                            this.annotationTokens = annotationTokens;
                            this.componentTypeToken = componentTypeToken;
                        }

                        @Override
                        public TypeDescription.Generic getComponentType() {
                            return this.componentTypeToken.toGenericType(this.typePool, this.typeVariableSource, this.typePath + '[', this.annotationTokens);
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(this.typePath));
                        }
                    }
                }

                public static class ForTypeVariable
                implements GenericTypeToken {
                    private final String symbol;

                    protected ForTypeVariable(String symbol) {
                        this.symbol = symbol;
                    }

                    @Override
                    public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                        TypeDescription.Generic typeVariable = typeVariableSource.findVariable(this.symbol);
                        return typeVariable == null ? new UnresolvedTypeVariable(typeVariableSource, typePool, this.symbol, annotationTokens.get(typePath)) : new AnnotatedTypeVariable(typePool, annotationTokens.get(typePath), typeVariable);
                    }

                    @Override
                    public boolean isPrimaryBound(TypePool typePool) {
                        return true;
                    }

                    @Override
                    public String getTypePathPrefix() {
                        throw new IllegalStateException("A type variable cannot be the owner of a nested type: " + this);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForTypeVariable)) {
                            return false;
                        }
                        ForTypeVariable other = (ForTypeVariable)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$symbol = this.symbol;
                        String other$symbol = other.symbol;
                        return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForTypeVariable;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $symbol = this.symbol;
                        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
                        return result;
                    }

                    protected static class Formal
                    implements OfFormalTypeVariable {
                        private final String symbol;
                        private final List<GenericTypeToken> boundTypeTokens;

                        protected Formal(String symbol, List<GenericTypeToken> boundTypeTokens) {
                            this.symbol = symbol;
                            this.boundTypeTokens = boundTypeTokens;
                        }

                        @Override
                        public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, Map<String, List<AnnotationToken>> annotationTokens, Map<Integer, Map<String, List<AnnotationToken>>> boundaryAnnotationTokens) {
                            return new LazyTypeVariable(typePool, typeVariableSource, annotationTokens == null ? Collections.emptyMap() : annotationTokens, boundaryAnnotationTokens == null ? Collections.emptyMap() : boundaryAnnotationTokens, this.symbol, this.boundTypeTokens);
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Formal)) {
                                return false;
                            }
                            Formal other = (Formal)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            String this$symbol = this.symbol;
                            String other$symbol = other.symbol;
                            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                                return false;
                            }
                            List<GenericTypeToken> this$boundTypeTokens = this.boundTypeTokens;
                            List<GenericTypeToken> other$boundTypeTokens = other.boundTypeTokens;
                            return !(this$boundTypeTokens == null ? other$boundTypeTokens != null : !((Object)this$boundTypeTokens).equals(other$boundTypeTokens));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Formal;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            String $symbol = this.symbol;
                            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
                            List<GenericTypeToken> $boundTypeTokens = this.boundTypeTokens;
                            result = result * 59 + ($boundTypeTokens == null ? 43 : ((Object)$boundTypeTokens).hashCode());
                            return result;
                        }

                        protected static class LazyTypeVariable
                        extends TypeDescription.Generic.OfTypeVariable {
                            private final TypePool typePool;
                            private final TypeVariableSource typeVariableSource;
                            private final Map<String, List<AnnotationToken>> annotationTokens;
                            private final Map<Integer, Map<String, List<AnnotationToken>>> boundaryAnnotationTokens;
                            private final String symbol;
                            private final List<GenericTypeToken> boundTypeTokens;

                            protected LazyTypeVariable(TypePool typePool, TypeVariableSource typeVariableSource, Map<String, List<AnnotationToken>> annotationTokens, Map<Integer, Map<String, List<AnnotationToken>>> boundaryAnnotationTokens, String symbol, List<GenericTypeToken> boundTypeTokens) {
                                this.typePool = typePool;
                                this.typeVariableSource = typeVariableSource;
                                this.annotationTokens = annotationTokens;
                                this.boundaryAnnotationTokens = boundaryAnnotationTokens;
                                this.symbol = symbol;
                                this.boundTypeTokens = boundTypeTokens;
                            }

                            @Override
                            public TypeList.Generic getUpperBounds() {
                                return new LazyBoundTokenList(this.typePool, this.typeVariableSource, this.boundaryAnnotationTokens, this.boundTypeTokens);
                            }

                            @Override
                            public TypeVariableSource getTypeVariableSource() {
                                return this.typeVariableSource;
                            }

                            @Override
                            public String getSymbol() {
                                return this.symbol;
                            }

                            @Override
                            public AnnotationList getDeclaredAnnotations() {
                                return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(GenericTypeToken.EMPTY_TYPE_PATH));
                            }

                            protected static class LazyBoundTokenList
                            extends TypeList.Generic.AbstractBase {
                                private final TypePool typePool;
                                private final TypeVariableSource typeVariableSource;
                                private final Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens;
                                private final List<GenericTypeToken> boundTypeTokens;

                                protected LazyBoundTokenList(TypePool typePool, TypeVariableSource typeVariableSource, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, List<GenericTypeToken> boundTypeTokens) {
                                    this.typePool = typePool;
                                    this.typeVariableSource = typeVariableSource;
                                    this.annotationTokens = annotationTokens;
                                    this.boundTypeTokens = boundTypeTokens;
                                }

                                @Override
                                public TypeDescription.Generic get(int index) {
                                    Map annotationTokens = !this.annotationTokens.containsKey(index) && !this.annotationTokens.containsKey(index + 1) ? Collections.emptyMap() : this.annotationTokens.get(index + (this.boundTypeTokens.get(0).isPrimaryBound(this.typePool) ? 0 : 1));
                                    return this.boundTypeTokens.get(index).toGenericType(this.typePool, this.typeVariableSource, GenericTypeToken.EMPTY_TYPE_PATH, annotationTokens == null ? Collections.emptyMap() : annotationTokens);
                                }

                                @Override
                                public int size() {
                                    return this.boundTypeTokens.size();
                                }
                            }
                        }
                    }

                    protected static class UnresolvedTypeVariable
                    extends TypeDescription.Generic.OfTypeVariable {
                        private final TypeVariableSource typeVariableSource;
                        private final TypePool typePool;
                        private final String symbol;
                        private final List<AnnotationToken> annotationTokens;

                        protected UnresolvedTypeVariable(TypeVariableSource typeVariableSource, TypePool typePool, String symbol, List<AnnotationToken> annotationTokens) {
                            this.typeVariableSource = typeVariableSource;
                            this.typePool = typePool;
                            this.symbol = symbol;
                            this.annotationTokens = annotationTokens;
                        }

                        @Override
                        public TypeList.Generic getUpperBounds() {
                            throw new IllegalStateException("Cannot resolve bounds of unresolved type variable " + this + " by " + this.typeVariableSource);
                        }

                        @Override
                        public TypeVariableSource getTypeVariableSource() {
                            return this.typeVariableSource;
                        }

                        @Override
                        public String getSymbol() {
                            return this.symbol;
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens);
                        }
                    }

                    protected static class AnnotatedTypeVariable
                    extends TypeDescription.Generic.OfTypeVariable {
                        private final TypePool typePool;
                        private final List<AnnotationToken> annotationTokens;
                        private final TypeDescription.Generic typeVariable;

                        protected AnnotatedTypeVariable(TypePool typePool, List<AnnotationToken> annotationTokens, TypeDescription.Generic typeVariable) {
                            this.typePool = typePool;
                            this.annotationTokens = annotationTokens;
                            this.typeVariable = typeVariable;
                        }

                        @Override
                        public TypeList.Generic getUpperBounds() {
                            return this.typeVariable.getUpperBounds();
                        }

                        @Override
                        public TypeVariableSource getTypeVariableSource() {
                            return this.typeVariable.getTypeVariableSource();
                        }

                        @Override
                        public String getSymbol() {
                            return this.typeVariable.getSymbol();
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens);
                        }
                    }
                }

                public static class ForRawType
                implements GenericTypeToken {
                    private final String name;

                    protected ForRawType(String name) {
                        this.name = name;
                    }

                    @Override
                    public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                        return new Resolution.Raw.RawAnnotatedType(typePool, typePath, annotationTokens == null ? Collections.emptyMap() : annotationTokens, typePool.describe(this.name).resolve());
                    }

                    @Override
                    public boolean isPrimaryBound(TypePool typePool) {
                        return !typePool.describe(this.name).resolve().isInterface();
                    }

                    @Override
                    public String getTypePathPrefix() {
                        throw new IllegalStateException("A non-generic type cannot be the owner of a nested type: " + this);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForRawType)) {
                            return false;
                        }
                        ForRawType other = (ForRawType)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$name = this.name;
                        String other$name = other.name;
                        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForRawType;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $name = this.name;
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        return result;
                    }
                }

                public static interface Resolution {
                    public TypeList.Generic resolveTypeVariables(TypePool var1, TypeVariableSource var2, Map<Integer, Map<String, List<AnnotationToken>>> var3, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> var4);

                    public static interface ForField {
                        public TypeDescription.Generic resolveFieldType(String var1, TypePool var2, Map<String, List<AnnotationToken>> var3, FieldDescription.InDefinedShape var4);

                        public static class Tokenized
                        implements ForField {
                            private final GenericTypeToken fieldTypeToken;

                            public Tokenized(GenericTypeToken fieldTypeToken) {
                                this.fieldTypeToken = fieldTypeToken;
                            }

                            @Override
                            public TypeDescription.Generic resolveFieldType(String fieldTypeDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, FieldDescription.InDefinedShape definingField) {
                                return TokenizedGenericType.of(typePool, this.fieldTypeToken, fieldTypeDescriptor, annotationTokens, definingField.getDeclaringType());
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Tokenized)) {
                                    return false;
                                }
                                Tokenized other = (Tokenized)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                GenericTypeToken this$fieldTypeToken = this.fieldTypeToken;
                                GenericTypeToken other$fieldTypeToken = other.fieldTypeToken;
                                return !(this$fieldTypeToken == null ? other$fieldTypeToken != null : !this$fieldTypeToken.equals(other$fieldTypeToken));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof Tokenized;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                GenericTypeToken $fieldTypeToken = this.fieldTypeToken;
                                result = result * 59 + ($fieldTypeToken == null ? 43 : $fieldTypeToken.hashCode());
                                return result;
                            }
                        }
                    }

                    public static interface ForMethod
                    extends Resolution {
                        public TypeDescription.Generic resolveReturnType(String var1, TypePool var2, Map<String, List<AnnotationToken>> var3, MethodDescription.InDefinedShape var4);

                        public TypeList.Generic resolveParameterTypes(List<String> var1, TypePool var2, Map<Integer, Map<String, List<AnnotationToken>>> var3, MethodDescription.InDefinedShape var4);

                        public TypeList.Generic resolveExceptionTypes(List<String> var1, TypePool var2, Map<Integer, Map<String, List<AnnotationToken>>> var3, MethodDescription.InDefinedShape var4);

                        public static class Tokenized
                        implements ForMethod {
                            private final GenericTypeToken returnTypeToken;
                            private final List<GenericTypeToken> parameterTypeTokens;
                            private final List<GenericTypeToken> exceptionTypeTokens;
                            private final List<OfFormalTypeVariable> typeVariableTokens;

                            public Tokenized(GenericTypeToken returnTypeToken, List<GenericTypeToken> parameterTypeTokens, List<GenericTypeToken> exceptionTypeTokens, List<OfFormalTypeVariable> typeVariableTokens) {
                                this.returnTypeToken = returnTypeToken;
                                this.parameterTypeTokens = parameterTypeTokens;
                                this.exceptionTypeTokens = exceptionTypeTokens;
                                this.typeVariableTokens = typeVariableTokens;
                            }

                            @Override
                            public TypeDescription.Generic resolveReturnType(String returnTypeDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                                return TokenizedGenericType.of(typePool, this.returnTypeToken, returnTypeDescriptor, annotationTokens, definingMethod);
                            }

                            @Override
                            public TypeList.Generic resolveParameterTypes(List<String> parameterTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                                return new TokenizedGenericType.TokenList(typePool, this.parameterTypeTokens, annotationTokens, parameterTypeDescriptors, definingMethod);
                            }

                            @Override
                            public TypeList.Generic resolveExceptionTypes(List<String> exceptionTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                                return this.exceptionTypeTokens.isEmpty() ? Raw.INSTANCE.resolveExceptionTypes(exceptionTypeDescriptors, typePool, annotationTokens, definingMethod) : new TokenizedGenericType.TokenList(typePool, this.exceptionTypeTokens, annotationTokens, exceptionTypeDescriptors, definingMethod);
                            }

                            @Override
                            public TypeList.Generic resolveTypeVariables(TypePool typePool, TypeVariableSource typeVariableSource, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> boundAnnotationTokens) {
                                return new TokenizedGenericType.TypeVariableList(typePool, this.typeVariableTokens, typeVariableSource, annotationTokens, boundAnnotationTokens);
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Tokenized)) {
                                    return false;
                                }
                                Tokenized other = (Tokenized)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                GenericTypeToken this$returnTypeToken = this.returnTypeToken;
                                GenericTypeToken other$returnTypeToken = other.returnTypeToken;
                                if (this$returnTypeToken == null ? other$returnTypeToken != null : !this$returnTypeToken.equals(other$returnTypeToken)) {
                                    return false;
                                }
                                List<GenericTypeToken> this$parameterTypeTokens = this.parameterTypeTokens;
                                List<GenericTypeToken> other$parameterTypeTokens = other.parameterTypeTokens;
                                if (this$parameterTypeTokens == null ? other$parameterTypeTokens != null : !((Object)this$parameterTypeTokens).equals(other$parameterTypeTokens)) {
                                    return false;
                                }
                                List<GenericTypeToken> this$exceptionTypeTokens = this.exceptionTypeTokens;
                                List<GenericTypeToken> other$exceptionTypeTokens = other.exceptionTypeTokens;
                                if (this$exceptionTypeTokens == null ? other$exceptionTypeTokens != null : !((Object)this$exceptionTypeTokens).equals(other$exceptionTypeTokens)) {
                                    return false;
                                }
                                List<OfFormalTypeVariable> this$typeVariableTokens = this.typeVariableTokens;
                                List<OfFormalTypeVariable> other$typeVariableTokens = other.typeVariableTokens;
                                return !(this$typeVariableTokens == null ? other$typeVariableTokens != null : !((Object)this$typeVariableTokens).equals(other$typeVariableTokens));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof Tokenized;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                GenericTypeToken $returnTypeToken = this.returnTypeToken;
                                result = result * 59 + ($returnTypeToken == null ? 43 : $returnTypeToken.hashCode());
                                List<GenericTypeToken> $parameterTypeTokens = this.parameterTypeTokens;
                                result = result * 59 + ($parameterTypeTokens == null ? 43 : ((Object)$parameterTypeTokens).hashCode());
                                List<GenericTypeToken> $exceptionTypeTokens = this.exceptionTypeTokens;
                                result = result * 59 + ($exceptionTypeTokens == null ? 43 : ((Object)$exceptionTypeTokens).hashCode());
                                List<OfFormalTypeVariable> $typeVariableTokens = this.typeVariableTokens;
                                result = result * 59 + ($typeVariableTokens == null ? 43 : ((Object)$typeVariableTokens).hashCode());
                                return result;
                            }
                        }
                    }

                    public static interface ForType
                    extends Resolution {
                        public TypeDescription.Generic resolveSuperClass(String var1, TypePool var2, Map<String, List<AnnotationToken>> var3, TypeDescription var4);

                        public TypeList.Generic resolveInterfaceTypes(List<String> var1, TypePool var2, Map<Integer, Map<String, List<AnnotationToken>>> var3, TypeDescription var4);

                        public static class Tokenized
                        implements ForType {
                            private final GenericTypeToken superClassToken;
                            private final List<GenericTypeToken> interfaceTypeTokens;
                            private final List<OfFormalTypeVariable> typeVariableTokens;

                            public Tokenized(GenericTypeToken superClassToken, List<GenericTypeToken> interfaceTypeTokens, List<OfFormalTypeVariable> typeVariableTokens) {
                                this.superClassToken = superClassToken;
                                this.interfaceTypeTokens = interfaceTypeTokens;
                                this.typeVariableTokens = typeVariableTokens;
                            }

                            @Override
                            public TypeDescription.Generic resolveSuperClass(String superClassDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, TypeDescription definingType) {
                                return TokenizedGenericType.of(typePool, this.superClassToken, superClassDescriptor, annotationTokens, definingType);
                            }

                            @Override
                            public TypeList.Generic resolveInterfaceTypes(List<String> interfaceTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, TypeDescription definingType) {
                                return new TokenizedGenericType.TokenList(typePool, this.interfaceTypeTokens, annotationTokens, interfaceTypeDescriptors, definingType);
                            }

                            @Override
                            public TypeList.Generic resolveTypeVariables(TypePool typePool, TypeVariableSource typeVariableSource, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> boundAnnotationTokens) {
                                return new TokenizedGenericType.TypeVariableList(typePool, this.typeVariableTokens, typeVariableSource, annotationTokens, boundAnnotationTokens);
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Tokenized)) {
                                    return false;
                                }
                                Tokenized other = (Tokenized)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                GenericTypeToken this$superClassToken = this.superClassToken;
                                GenericTypeToken other$superClassToken = other.superClassToken;
                                if (this$superClassToken == null ? other$superClassToken != null : !this$superClassToken.equals(other$superClassToken)) {
                                    return false;
                                }
                                List<GenericTypeToken> this$interfaceTypeTokens = this.interfaceTypeTokens;
                                List<GenericTypeToken> other$interfaceTypeTokens = other.interfaceTypeTokens;
                                if (this$interfaceTypeTokens == null ? other$interfaceTypeTokens != null : !((Object)this$interfaceTypeTokens).equals(other$interfaceTypeTokens)) {
                                    return false;
                                }
                                List<OfFormalTypeVariable> this$typeVariableTokens = this.typeVariableTokens;
                                List<OfFormalTypeVariable> other$typeVariableTokens = other.typeVariableTokens;
                                return !(this$typeVariableTokens == null ? other$typeVariableTokens != null : !((Object)this$typeVariableTokens).equals(other$typeVariableTokens));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof Tokenized;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                GenericTypeToken $superClassToken = this.superClassToken;
                                result = result * 59 + ($superClassToken == null ? 43 : $superClassToken.hashCode());
                                List<GenericTypeToken> $interfaceTypeTokens = this.interfaceTypeTokens;
                                result = result * 59 + ($interfaceTypeTokens == null ? 43 : ((Object)$interfaceTypeTokens).hashCode());
                                List<OfFormalTypeVariable> $typeVariableTokens = this.typeVariableTokens;
                                result = result * 59 + ($typeVariableTokens == null ? 43 : ((Object)$typeVariableTokens).hashCode());
                                return result;
                            }
                        }
                    }

                    public static enum Malformed implements ForType,
                    ForMethod,
                    ForField
                    {
                        INSTANCE;


                        @Override
                        public TypeDescription.Generic resolveFieldType(String fieldTypeDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, FieldDescription.InDefinedShape definingField) {
                            return new TokenizedGenericType.Malformed(typePool, fieldTypeDescriptor);
                        }

                        @Override
                        public TypeDescription.Generic resolveReturnType(String returnTypeDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                            return new TokenizedGenericType.Malformed(typePool, returnTypeDescriptor);
                        }

                        @Override
                        public TypeList.Generic resolveParameterTypes(List<String> parameterTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                            return new TokenizedGenericType.Malformed.TokenList(typePool, parameterTypeDescriptors);
                        }

                        @Override
                        public TypeList.Generic resolveExceptionTypes(List<String> exceptionTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                            return new TokenizedGenericType.Malformed.TokenList(typePool, exceptionTypeDescriptors);
                        }

                        @Override
                        public TypeDescription.Generic resolveSuperClass(String superClassDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, TypeDescription definingType) {
                            return new TokenizedGenericType.Malformed(typePool, superClassDescriptor);
                        }

                        @Override
                        public TypeList.Generic resolveInterfaceTypes(List<String> interfaceTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, TypeDescription definingType) {
                            return new TokenizedGenericType.Malformed.TokenList(typePool, interfaceTypeDescriptors);
                        }

                        @Override
                        public TypeList.Generic resolveTypeVariables(TypePool typePool, TypeVariableSource typeVariableSource, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> boundAnnotationTokens) {
                            throw new GenericSignatureFormatError();
                        }
                    }

                    public static enum Raw implements ForType,
                    ForMethod,
                    ForField
                    {
                        INSTANCE;


                        @Override
                        public TypeDescription.Generic resolveFieldType(String fieldTypeDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, FieldDescription.InDefinedShape definingField) {
                            return RawAnnotatedType.of(typePool, annotationTokens, fieldTypeDescriptor);
                        }

                        @Override
                        public TypeDescription.Generic resolveReturnType(String returnTypeDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                            return RawAnnotatedType.of(typePool, annotationTokens, returnTypeDescriptor);
                        }

                        @Override
                        public TypeList.Generic resolveParameterTypes(List<String> parameterTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                            return RawAnnotatedType.LazyRawAnnotatedTypeList.of(typePool, annotationTokens, parameterTypeDescriptors);
                        }

                        @Override
                        public TypeList.Generic resolveExceptionTypes(List<String> exceptionTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, MethodDescription.InDefinedShape definingMethod) {
                            return RawAnnotatedType.LazyRawAnnotatedTypeList.of(typePool, annotationTokens, exceptionTypeDescriptors);
                        }

                        @Override
                        public TypeDescription.Generic resolveSuperClass(String superClassDescriptor, TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, TypeDescription definingType) {
                            return RawAnnotatedType.of(typePool, annotationTokens, superClassDescriptor);
                        }

                        @Override
                        public TypeList.Generic resolveInterfaceTypes(List<String> interfaceTypeDescriptors, TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, TypeDescription definingType) {
                            return RawAnnotatedType.LazyRawAnnotatedTypeList.of(typePool, annotationTokens, interfaceTypeDescriptors);
                        }

                        @Override
                        public TypeList.Generic resolveTypeVariables(TypePool typePool, TypeVariableSource typeVariableSource, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, Map<Integer, Map<Integer, Map<String, List<AnnotationToken>>>> boundAnnotationTokens) {
                            return new TypeList.Generic.Empty();
                        }

                        protected static class RawAnnotatedType
                        extends TypeDescription.Generic.OfNonGenericType {
                            private final TypePool typePool;
                            private final String typePath;
                            private final Map<String, List<AnnotationToken>> annotationTokens;
                            private final TypeDescription typeDescription;

                            protected RawAnnotatedType(TypePool typePool, String typePath, Map<String, List<AnnotationToken>> annotationTokens, TypeDescription typeDescription) {
                                this.typePool = typePool;
                                this.typePath = typePath;
                                this.annotationTokens = annotationTokens;
                                this.typeDescription = typeDescription;
                            }

                            protected static TypeDescription.Generic of(TypePool typePool, Map<String, List<AnnotationToken>> annotationTokens, String descriptor) {
                                return new RawAnnotatedType(typePool, GenericTypeToken.EMPTY_TYPE_PATH, annotationTokens == null ? Collections.emptyMap() : annotationTokens, TokenizedGenericType.toErasure(typePool, descriptor));
                            }

                            @Override
                            public TypeDescription asErasure() {
                                return this.typeDescription;
                            }

                            @Override
                            public TypeDescription.Generic getOwnerType() {
                                TypeDescription declaringType = this.typeDescription.getDeclaringType();
                                return declaringType == null ? TypeDescription.Generic.UNDEFINED : new RawAnnotatedType(this.typePool, this.typePath, this.annotationTokens, declaringType);
                            }

                            @Override
                            public TypeDescription.Generic getComponentType() {
                                TypeDescription componentType = this.typeDescription.getComponentType();
                                return componentType == null ? TypeDescription.Generic.UNDEFINED : new RawAnnotatedType(this.typePool, this.typePath + '[', this.annotationTokens, componentType);
                            }

                            @Override
                            public AnnotationList getDeclaredAnnotations() {
                                StringBuilder typePath = new StringBuilder(this.typePath);
                                for (int index = 0; index < this.typeDescription.getSegmentCount(); ++index) {
                                    typePath = typePath.append('.');
                                }
                                return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(typePath.toString()));
                            }

                            protected static class LazyRawAnnotatedTypeList
                            extends TypeList.Generic.AbstractBase {
                                private final TypePool typePool;
                                private final Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens;
                                private final List<String> descriptors;

                                protected LazyRawAnnotatedTypeList(TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, List<String> descriptors) {
                                    this.typePool = typePool;
                                    this.annotationTokens = annotationTokens;
                                    this.descriptors = descriptors;
                                }

                                protected static TypeList.Generic of(TypePool typePool, Map<Integer, Map<String, List<AnnotationToken>>> annotationTokens, List<String> descriptors) {
                                    return new LazyRawAnnotatedTypeList(typePool, annotationTokens == null ? Collections.emptyMap() : annotationTokens, descriptors);
                                }

                                @Override
                                public TypeDescription.Generic get(int index) {
                                    return RawAnnotatedType.of(this.typePool, this.annotationTokens.get(index), this.descriptors.get(index));
                                }

                                @Override
                                public int size() {
                                    return this.descriptors.size();
                                }

                                @Override
                                public TypeList asErasures() {
                                    return new LazyTypeList(this.typePool, this.descriptors);
                                }

                                @Override
                                public TypeList.Generic asRawTypes() {
                                    return this;
                                }

                                @Override
                                public int getStackSize() {
                                    int stackSize = 0;
                                    for (String descriptor : this.descriptors) {
                                        stackSize += nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getType(descriptor).getSize();
                                    }
                                    return stackSize;
                                }
                            }
                        }
                    }
                }

                public static enum ForUnboundWildcard implements GenericTypeToken
                {
                    INSTANCE;


                    @Override
                    public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                        return new LazyUnboundWildcard(typePool, typePath, annotationTokens == null ? Collections.emptyMap() : annotationTokens);
                    }

                    @Override
                    public boolean isPrimaryBound(TypePool typePool) {
                        throw new IllegalStateException("A wildcard type cannot be a type variable bound: " + this);
                    }

                    @Override
                    public String getTypePathPrefix() {
                        throw new IllegalStateException("An unbound wildcard cannot be the owner of a nested type: " + this);
                    }

                    protected static class LazyUnboundWildcard
                    extends TypeDescription.Generic.OfWildcardType {
                        private final TypePool typePool;
                        private final String typePath;
                        private final Map<String, List<AnnotationToken>> annotationTokens;

                        protected LazyUnboundWildcard(TypePool typePool, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                            this.typePool = typePool;
                            this.typePath = typePath;
                            this.annotationTokens = annotationTokens;
                        }

                        @Override
                        public TypeList.Generic getUpperBounds() {
                            return new TypeList.Generic.Explicit(TypeDescription.Generic.OBJECT);
                        }

                        @Override
                        public TypeList.Generic getLowerBounds() {
                            return new TypeList.Generic.Empty();
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(this.typePath));
                        }
                    }
                }

                public static enum ForPrimitiveType implements GenericTypeToken
                {
                    BOOLEAN(Boolean.TYPE),
                    BYTE(Byte.TYPE),
                    SHORT(Short.TYPE),
                    CHAR(Character.TYPE),
                    INTEGER(Integer.TYPE),
                    LONG(Long.TYPE),
                    FLOAT(Float.TYPE),
                    DOUBLE(Double.TYPE),
                    VOID(Void.TYPE);

                    private final TypeDescription typeDescription;

                    private ForPrimitiveType(Class<?> type) {
                        this.typeDescription = new TypeDescription.ForLoadedType(type);
                    }

                    public static GenericTypeToken of(char descriptor) {
                        switch (descriptor) {
                            case 'V': {
                                return VOID;
                            }
                            case 'Z': {
                                return BOOLEAN;
                            }
                            case 'B': {
                                return BYTE;
                            }
                            case 'S': {
                                return SHORT;
                            }
                            case 'C': {
                                return CHAR;
                            }
                            case 'I': {
                                return INTEGER;
                            }
                            case 'J': {
                                return LONG;
                            }
                            case 'F': {
                                return FLOAT;
                            }
                            case 'D': {
                                return DOUBLE;
                            }
                        }
                        throw new IllegalArgumentException("Not a valid primitive type descriptor: " + descriptor);
                    }

                    @Override
                    public TypeDescription.Generic toGenericType(TypePool typePool, TypeVariableSource typeVariableSource, String typePath, Map<String, List<AnnotationToken>> annotationTokens) {
                        return new LazyPrimitiveType(typePool, typePath, annotationTokens == null ? Collections.emptyMap() : annotationTokens, this.typeDescription);
                    }

                    @Override
                    public boolean isPrimaryBound(TypePool typePool) {
                        throw new IllegalStateException("A primitive type cannot be a type variable bound: " + this);
                    }

                    @Override
                    public String getTypePathPrefix() {
                        throw new IllegalStateException("A primitive type cannot be the owner of a nested type: " + this);
                    }

                    protected static class LazyPrimitiveType
                    extends TypeDescription.Generic.OfNonGenericType {
                        private final TypePool typePool;
                        private final String typePath;
                        private final Map<String, List<AnnotationToken>> annotationTokens;
                        private final TypeDescription typeDescription;

                        protected LazyPrimitiveType(TypePool typePool, String typePath, Map<String, List<AnnotationToken>> annotationTokens, TypeDescription typeDescription) {
                            this.typePool = typePool;
                            this.typePath = typePath;
                            this.annotationTokens = annotationTokens;
                            this.typeDescription = typeDescription;
                        }

                        @Override
                        public TypeDescription asErasure() {
                            return this.typeDescription;
                        }

                        @Override
                        public TypeDescription.Generic getOwnerType() {
                            return TypeDescription.Generic.UNDEFINED;
                        }

                        @Override
                        public TypeDescription.Generic getComponentType() {
                            return TypeDescription.Generic.UNDEFINED;
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return LazyAnnotationDescription.asListOfNullable(this.typePool, this.annotationTokens.get(this.typePath));
                        }
                    }
                }

                public static interface OfFormalTypeVariable {
                    public TypeDescription.Generic toGenericType(TypePool var1, TypeVariableSource var2, Map<String, List<AnnotationToken>> var3, Map<Integer, Map<String, List<AnnotationToken>>> var4);
                }
            }

            protected static interface TypeContainment {
                public MethodDescription getEnclosingMethod(TypePool var1);

                public TypeDescription getEnclosingType(TypePool var1);

                public boolean isSelfContained();

                public boolean isMemberClass();

                public boolean isLocalType();

                public static class WithinMethod
                implements TypeContainment {
                    private final String name;
                    private final String methodName;
                    private final String methodDescriptor;

                    public WithinMethod(String internalName, String methodName, String methodDescriptor) {
                        this.name = internalName.replace('/', '.');
                        this.methodName = methodName;
                        this.methodDescriptor = methodDescriptor;
                    }

                    @Override
                    public MethodDescription getEnclosingMethod(TypePool typePool) {
                        return (MethodDescription)((MethodList)this.getEnclosingType(typePool).getDeclaredMethods().filter(ElementMatchers.hasMethodName(this.methodName).and(ElementMatchers.hasDescriptor(this.methodDescriptor)))).getOnly();
                    }

                    @Override
                    public TypeDescription getEnclosingType(TypePool typePool) {
                        return typePool.describe(this.name).resolve();
                    }

                    @Override
                    public boolean isSelfContained() {
                        return false;
                    }

                    @Override
                    public boolean isMemberClass() {
                        return false;
                    }

                    @Override
                    public boolean isLocalType() {
                        return true;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof WithinMethod)) {
                            return false;
                        }
                        WithinMethod other = (WithinMethod)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$name = this.name;
                        String other$name = other.name;
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        String this$methodName = this.methodName;
                        String other$methodName = other.methodName;
                        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                            return false;
                        }
                        String this$methodDescriptor = this.methodDescriptor;
                        String other$methodDescriptor = other.methodDescriptor;
                        return !(this$methodDescriptor == null ? other$methodDescriptor != null : !this$methodDescriptor.equals(other$methodDescriptor));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof WithinMethod;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $name = this.name;
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        String $methodName = this.methodName;
                        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
                        String $methodDescriptor = this.methodDescriptor;
                        result = result * 59 + ($methodDescriptor == null ? 43 : $methodDescriptor.hashCode());
                        return result;
                    }
                }

                public static class WithinType
                implements TypeContainment {
                    private final String name;
                    private final boolean localType;

                    public WithinType(String internalName, boolean localType) {
                        this.name = internalName.replace('/', '.');
                        this.localType = localType;
                    }

                    @Override
                    public MethodDescription getEnclosingMethod(TypePool typePool) {
                        return MethodDescription.UNDEFINED;
                    }

                    @Override
                    public TypeDescription getEnclosingType(TypePool typePool) {
                        return typePool.describe(this.name).resolve();
                    }

                    @Override
                    public boolean isSelfContained() {
                        return false;
                    }

                    @Override
                    public boolean isMemberClass() {
                        return !this.localType;
                    }

                    @Override
                    public boolean isLocalType() {
                        return this.localType;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof WithinType)) {
                            return false;
                        }
                        WithinType other = (WithinType)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$name = this.name;
                        String other$name = other.name;
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        return this.isLocalType() == other.isLocalType();
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof WithinType;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $name = this.name;
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        result = result * 59 + (this.isLocalType() ? 79 : 97);
                        return result;
                    }
                }

                public static enum SelfContained implements TypeContainment
                {
                    INSTANCE;


                    @Override
                    public MethodDescription getEnclosingMethod(TypePool typePool) {
                        return MethodDescription.UNDEFINED;
                    }

                    @Override
                    public TypeDescription getEnclosingType(TypePool typePool) {
                        return TypeDescription.UNDEFINED;
                    }

                    @Override
                    public boolean isSelfContained() {
                        return true;
                    }

                    @Override
                    public boolean isMemberClass() {
                        return false;
                    }

                    @Override
                    public boolean isLocalType() {
                        return false;
                    }
                }
            }

            protected class MethodTokenList
            extends MethodList.AbstractBase<MethodDescription.InDefinedShape> {
                protected MethodTokenList() {
                }

                @Override
                public MethodDescription.InDefinedShape get(int index) {
                    return ((MethodToken)LazyTypeDescription.this.methodTokens.get(index)).toMethodDescription(LazyTypeDescription.this);
                }

                @Override
                public int size() {
                    return LazyTypeDescription.this.methodTokens.size();
                }
            }

            protected class FieldTokenList
            extends FieldList.AbstractBase<FieldDescription.InDefinedShape> {
                protected FieldTokenList() {
                }

                @Override
                public FieldDescription.InDefinedShape get(int index) {
                    return ((FieldToken)LazyTypeDescription.this.fieldTokens.get(index)).toFieldDescription(LazyTypeDescription.this);
                }

                @Override
                public int size() {
                    return LazyTypeDescription.this.fieldTokens.size();
                }
            }
        }

        protected static class GenericTypeExtractor
        extends GenericTypeRegistrant.RejectingSignatureVisitor
        implements GenericTypeRegistrant {
            private final GenericTypeRegistrant genericTypeRegistrant;
            private IncompleteToken incompleteToken;

            protected GenericTypeExtractor(GenericTypeRegistrant genericTypeRegistrant) {
                this.genericTypeRegistrant = genericTypeRegistrant;
            }

            @Override
            public void visitBaseType(char descriptor) {
                this.genericTypeRegistrant.register(LazyTypeDescription.GenericTypeToken.ForPrimitiveType.of(descriptor));
            }

            @Override
            public void visitTypeVariable(String name) {
                this.genericTypeRegistrant.register(new LazyTypeDescription.GenericTypeToken.ForTypeVariable(name));
            }

            @Override
            public SignatureVisitor visitArrayType() {
                return new GenericTypeExtractor(this);
            }

            @Override
            public void register(LazyTypeDescription.GenericTypeToken componentTypeToken) {
                this.genericTypeRegistrant.register(new LazyTypeDescription.GenericTypeToken.ForGenericArray(componentTypeToken));
            }

            @Override
            public void visitClassType(String name) {
                this.incompleteToken = new IncompleteToken.ForTopLevelType(name);
            }

            @Override
            public void visitInnerClassType(String name) {
                this.incompleteToken = new IncompleteToken.ForInnerClass(name, this.incompleteToken);
            }

            @Override
            public void visitTypeArgument() {
                this.incompleteToken.appendPlaceholder();
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                switch (wildcard) {
                    case '-': {
                        return this.incompleteToken.appendLowerBound();
                    }
                    case '+': {
                        return this.incompleteToken.appendUpperBound();
                    }
                    case '=': {
                        return this.incompleteToken.appendDirectBound();
                    }
                }
                throw new IllegalArgumentException("Unknown wildcard: " + wildcard);
            }

            @Override
            public void visitEnd() {
                this.genericTypeRegistrant.register(this.incompleteToken.toToken());
            }

            protected static abstract class ForSignature<T extends LazyTypeDescription.GenericTypeToken.Resolution>
            extends GenericTypeRegistrant.RejectingSignatureVisitor
            implements GenericTypeRegistrant {
                protected final List<LazyTypeDescription.GenericTypeToken.OfFormalTypeVariable> typeVariableTokens = new ArrayList<LazyTypeDescription.GenericTypeToken.OfFormalTypeVariable>();
                protected String currentTypeParameter;
                protected List<LazyTypeDescription.GenericTypeToken> currentBounds;

                protected static <S extends LazyTypeDescription.GenericTypeToken.Resolution> S extract(String genericSignature, ForSignature<S> visitor) {
                    SignatureReader signatureReader = new SignatureReader(genericSignature);
                    signatureReader.accept(visitor);
                    return visitor.resolve();
                }

                @Override
                public void visitFormalTypeParameter(String name) {
                    this.collectTypeParameter();
                    this.currentTypeParameter = name;
                    this.currentBounds = new ArrayList<LazyTypeDescription.GenericTypeToken>();
                }

                @Override
                public SignatureVisitor visitClassBound() {
                    return new GenericTypeExtractor(this);
                }

                @Override
                public SignatureVisitor visitInterfaceBound() {
                    return new GenericTypeExtractor(this);
                }

                @Override
                public void register(LazyTypeDescription.GenericTypeToken token) {
                    if (this.currentBounds == null) {
                        throw new IllegalStateException("Did not expect " + token + " before finding formal parameter");
                    }
                    this.currentBounds.add(token);
                }

                protected void collectTypeParameter() {
                    if (this.currentTypeParameter != null) {
                        this.typeVariableTokens.add(new LazyTypeDescription.GenericTypeToken.ForTypeVariable.Formal(this.currentTypeParameter, this.currentBounds));
                    }
                }

                public abstract T resolve();

                protected static class OfField
                implements GenericTypeRegistrant {
                    private LazyTypeDescription.GenericTypeToken fieldTypeToken;

                    protected OfField() {
                    }

                    public static LazyTypeDescription.GenericTypeToken.Resolution.ForField extract(String genericSignature) {
                        if (genericSignature == null) {
                            return LazyTypeDescription.GenericTypeToken.Resolution.Raw.INSTANCE;
                        }
                        SignatureReader signatureReader = new SignatureReader(genericSignature);
                        OfField visitor = new OfField();
                        try {
                            signatureReader.acceptType(new GenericTypeExtractor(visitor));
                            return visitor.resolve();
                        }
                        catch (RuntimeException ignored) {
                            return LazyTypeDescription.GenericTypeToken.Resolution.Malformed.INSTANCE;
                        }
                    }

                    @Override
                    public void register(LazyTypeDescription.GenericTypeToken token) {
                        this.fieldTypeToken = token;
                    }

                    protected LazyTypeDescription.GenericTypeToken.Resolution.ForField resolve() {
                        return new LazyTypeDescription.GenericTypeToken.Resolution.ForField.Tokenized(this.fieldTypeToken);
                    }
                }

                protected static class OfMethod
                extends ForSignature<LazyTypeDescription.GenericTypeToken.Resolution.ForMethod> {
                    private final List<LazyTypeDescription.GenericTypeToken> parameterTypeTokens = new ArrayList<LazyTypeDescription.GenericTypeToken>();
                    private final List<LazyTypeDescription.GenericTypeToken> exceptionTypeTokens = new ArrayList<LazyTypeDescription.GenericTypeToken>();
                    private LazyTypeDescription.GenericTypeToken returnTypeToken;

                    public static LazyTypeDescription.GenericTypeToken.Resolution.ForMethod extract(String genericSignature) {
                        try {
                            return genericSignature == null ? LazyTypeDescription.GenericTypeToken.Resolution.Raw.INSTANCE : ForSignature.extract(genericSignature, new OfMethod());
                        }
                        catch (RuntimeException ignored) {
                            return LazyTypeDescription.GenericTypeToken.Resolution.Malformed.INSTANCE;
                        }
                    }

                    @Override
                    public SignatureVisitor visitParameterType() {
                        return new GenericTypeExtractor(new ParameterTypeRegistrant());
                    }

                    @Override
                    public SignatureVisitor visitReturnType() {
                        this.collectTypeParameter();
                        return new GenericTypeExtractor(new ReturnTypeTypeRegistrant());
                    }

                    @Override
                    public SignatureVisitor visitExceptionType() {
                        return new GenericTypeExtractor(new ExceptionTypeRegistrant());
                    }

                    @Override
                    public LazyTypeDescription.GenericTypeToken.Resolution.ForMethod resolve() {
                        return new LazyTypeDescription.GenericTypeToken.Resolution.ForMethod.Tokenized(this.returnTypeToken, this.parameterTypeTokens, this.exceptionTypeTokens, this.typeVariableTokens);
                    }

                    protected class ExceptionTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected ExceptionTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfMethod.this.exceptionTypeTokens.add(token);
                        }

                        public int hashCode() {
                            return OfMethod.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfMethod.this.equals(((ExceptionTypeRegistrant)other).getOuter());
                        }

                        private OfMethod getOuter() {
                            return OfMethod.this;
                        }
                    }

                    protected class ReturnTypeTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected ReturnTypeTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfMethod.this.returnTypeToken = token;
                        }

                        public int hashCode() {
                            return OfMethod.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfMethod.this.equals(((ReturnTypeTypeRegistrant)other).getOuter());
                        }

                        private OfMethod getOuter() {
                            return OfMethod.this;
                        }
                    }

                    protected class ParameterTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected ParameterTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfMethod.this.parameterTypeTokens.add(token);
                        }

                        public int hashCode() {
                            return OfMethod.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfMethod.this.equals(((ParameterTypeRegistrant)other).getOuter());
                        }

                        private OfMethod getOuter() {
                            return OfMethod.this;
                        }
                    }
                }

                protected static class OfType
                extends ForSignature<LazyTypeDescription.GenericTypeToken.Resolution.ForType> {
                    private final List<LazyTypeDescription.GenericTypeToken> interfaceTypeTokens = new ArrayList<LazyTypeDescription.GenericTypeToken>();
                    private LazyTypeDescription.GenericTypeToken superClassToken;

                    protected OfType() {
                    }

                    public static LazyTypeDescription.GenericTypeToken.Resolution.ForType extract(String genericSignature) {
                        try {
                            return genericSignature == null ? LazyTypeDescription.GenericTypeToken.Resolution.Raw.INSTANCE : ForSignature.extract(genericSignature, new OfType());
                        }
                        catch (RuntimeException ignored) {
                            return LazyTypeDescription.GenericTypeToken.Resolution.Malformed.INSTANCE;
                        }
                    }

                    @Override
                    public SignatureVisitor visitSuperclass() {
                        this.collectTypeParameter();
                        return new GenericTypeExtractor(new SuperClassRegistrant());
                    }

                    @Override
                    public SignatureVisitor visitInterface() {
                        return new GenericTypeExtractor(new InterfaceTypeRegistrant());
                    }

                    @Override
                    public LazyTypeDescription.GenericTypeToken.Resolution.ForType resolve() {
                        return new LazyTypeDescription.GenericTypeToken.Resolution.ForType.Tokenized(this.superClassToken, this.interfaceTypeTokens, this.typeVariableTokens);
                    }

                    protected class InterfaceTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected InterfaceTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfType.this.interfaceTypeTokens.add(token);
                        }

                        public int hashCode() {
                            return OfType.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfType.this.equals(((InterfaceTypeRegistrant)other).getOuter());
                        }

                        private OfType getOuter() {
                            return OfType.this;
                        }
                    }

                    protected class SuperClassRegistrant
                    implements GenericTypeRegistrant {
                        protected SuperClassRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfType.this.superClassToken = token;
                        }

                        public int hashCode() {
                            return OfType.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfType.this.equals(((SuperClassRegistrant)other).getOuter());
                        }

                        private OfType getOuter() {
                            return OfType.this;
                        }
                    }
                }
            }

            protected static interface IncompleteToken {
                public SignatureVisitor appendLowerBound();

                public SignatureVisitor appendUpperBound();

                public SignatureVisitor appendDirectBound();

                public void appendPlaceholder();

                public boolean isParameterized();

                public String getName();

                public LazyTypeDescription.GenericTypeToken toToken();

                public static class ForInnerClass
                extends AbstractBase {
                    private static final char INNER_CLASS_SEPARATOR = '$';
                    private final String internalName;
                    private final IncompleteToken outerTypeToken;

                    public ForInnerClass(String internalName, IncompleteToken outerTypeToken) {
                        this.internalName = internalName;
                        this.outerTypeToken = outerTypeToken;
                    }

                    @Override
                    public LazyTypeDescription.GenericTypeToken toToken() {
                        return this.isParameterized() || this.outerTypeToken.isParameterized() ? new LazyTypeDescription.GenericTypeToken.ForParameterizedType.Nested(this.getName(), this.parameters, this.outerTypeToken.toToken()) : new LazyTypeDescription.GenericTypeToken.ForRawType(this.getName());
                    }

                    @Override
                    public boolean isParameterized() {
                        return !this.parameters.isEmpty() || !this.outerTypeToken.isParameterized();
                    }

                    @Override
                    public String getName() {
                        return this.outerTypeToken.getName() + '$' + this.internalName.replace('/', '.');
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForInnerClass)) {
                            return false;
                        }
                        ForInnerClass other = (ForInnerClass)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$internalName = this.internalName;
                        String other$internalName = other.internalName;
                        if (this$internalName == null ? other$internalName != null : !this$internalName.equals(other$internalName)) {
                            return false;
                        }
                        IncompleteToken this$outerTypeToken = this.outerTypeToken;
                        IncompleteToken other$outerTypeToken = other.outerTypeToken;
                        return !(this$outerTypeToken == null ? other$outerTypeToken != null : !this$outerTypeToken.equals(other$outerTypeToken));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForInnerClass;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $internalName = this.internalName;
                        result = result * 59 + ($internalName == null ? 43 : $internalName.hashCode());
                        IncompleteToken $outerTypeToken = this.outerTypeToken;
                        result = result * 59 + ($outerTypeToken == null ? 43 : $outerTypeToken.hashCode());
                        return result;
                    }
                }

                public static class ForTopLevelType
                extends AbstractBase {
                    private final String internalName;

                    public ForTopLevelType(String internalName) {
                        this.internalName = internalName;
                    }

                    @Override
                    public LazyTypeDescription.GenericTypeToken toToken() {
                        return this.isParameterized() ? new LazyTypeDescription.GenericTypeToken.ForParameterizedType(this.getName(), this.parameters) : new LazyTypeDescription.GenericTypeToken.ForRawType(this.getName());
                    }

                    @Override
                    public boolean isParameterized() {
                        return !this.parameters.isEmpty();
                    }

                    @Override
                    public String getName() {
                        return this.internalName.replace('/', '.');
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForTopLevelType)) {
                            return false;
                        }
                        ForTopLevelType other = (ForTopLevelType)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$internalName = this.internalName;
                        String other$internalName = other.internalName;
                        return !(this$internalName == null ? other$internalName != null : !this$internalName.equals(other$internalName));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForTopLevelType;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $internalName = this.internalName;
                        result = result * 59 + ($internalName == null ? 43 : $internalName.hashCode());
                        return result;
                    }
                }

                public static abstract class AbstractBase
                implements IncompleteToken {
                    protected final List<LazyTypeDescription.GenericTypeToken> parameters = new ArrayList<LazyTypeDescription.GenericTypeToken>();

                    @Override
                    public SignatureVisitor appendDirectBound() {
                        return new GenericTypeExtractor(new ForDirectBound());
                    }

                    @Override
                    public SignatureVisitor appendUpperBound() {
                        return new GenericTypeExtractor(new ForUpperBound());
                    }

                    @Override
                    public SignatureVisitor appendLowerBound() {
                        return new GenericTypeExtractor(new ForLowerBound());
                    }

                    @Override
                    public void appendPlaceholder() {
                        this.parameters.add(LazyTypeDescription.GenericTypeToken.ForUnboundWildcard.INSTANCE);
                    }

                    protected class ForLowerBound
                    implements GenericTypeRegistrant {
                        protected ForLowerBound() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            AbstractBase.this.parameters.add(new LazyTypeDescription.GenericTypeToken.ForLowerBoundWildcard(token));
                        }
                    }

                    protected class ForUpperBound
                    implements GenericTypeRegistrant {
                        protected ForUpperBound() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            AbstractBase.this.parameters.add(new LazyTypeDescription.GenericTypeToken.ForUpperBoundWildcard(token));
                        }
                    }

                    protected class ForDirectBound
                    implements GenericTypeRegistrant {
                        protected ForDirectBound() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            AbstractBase.this.parameters.add(token);
                        }
                    }
                }
            }
        }

        protected static class ParameterBag {
            private final nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type[] parameterType;
            private final Map<Integer, String> parameterRegistry;

            protected ParameterBag(nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type[] parameterType) {
                this.parameterType = parameterType;
                this.parameterRegistry = new HashMap<Integer, String>();
            }

            protected void register(int offset, String name) {
                this.parameterRegistry.put(offset, name);
            }

            protected List<LazyTypeDescription.MethodToken.ParameterToken> resolve(boolean isStatic) {
                ArrayList<LazyTypeDescription.MethodToken.ParameterToken> parameterTokens = new ArrayList<LazyTypeDescription.MethodToken.ParameterToken>(this.parameterType.length);
                int offset = isStatic ? StackSize.ZERO.getSize() : StackSize.SINGLE.getSize();
                for (nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type aParameterType : this.parameterType) {
                    String name = this.parameterRegistry.get(offset);
                    parameterTokens.add(name == null ? new LazyTypeDescription.MethodToken.ParameterToken() : new LazyTypeDescription.MethodToken.ParameterToken(name));
                    offset += aParameterType.getSize();
                }
                return parameterTokens;
            }
        }

        protected static interface GenericTypeRegistrant {
            public void register(LazyTypeDescription.GenericTypeToken var1);

            public static class RejectingSignatureVisitor
            extends SignatureVisitor {
                private static final String MESSAGE = "Unexpected token in generic signature";

                public RejectingSignatureVisitor() {
                    super(393216);
                }

                @Override
                public void visitFormalTypeParameter(String name) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitClassBound() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitInterfaceBound() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitSuperclass() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitInterface() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitParameterType() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitReturnType() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitExceptionType() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitBaseType(char descriptor) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitTypeVariable(String name) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitArrayType() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitClassType(String name) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitInnerClassType(String name) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitTypeArgument() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitTypeArgument(char wildcard) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitEnd() {
                    throw new IllegalStateException(MESSAGE);
                }
            }
        }

        protected static interface ComponentTypeLocator {
            public AbstractBase.RawDescriptionArray.ComponentTypeReference bind(String var1);

            public static class ForArrayType
            implements ComponentTypeLocator,
            AbstractBase.RawDescriptionArray.ComponentTypeReference {
                private final String componentType;

                public ForArrayType(String methodDescriptor) {
                    String arrayType = nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getMethodType(methodDescriptor).getReturnType().getClassName();
                    this.componentType = arrayType.substring(0, arrayType.length() - 2);
                }

                @Override
                public AbstractBase.RawDescriptionArray.ComponentTypeReference bind(String name) {
                    return this;
                }

                @Override
                public String lookup() {
                    return this.componentType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForArrayType)) {
                        return false;
                    }
                    ForArrayType other = (ForArrayType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$componentType = this.componentType;
                    String other$componentType = other.componentType;
                    return !(this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForArrayType;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $componentType = this.componentType;
                    result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
                    return result;
                }
            }

            public static class ForAnnotationProperty
            implements ComponentTypeLocator {
                private final TypePool typePool;
                private final String annotationName;

                public ForAnnotationProperty(TypePool typePool, String annotationDescriptor) {
                    this.typePool = typePool;
                    this.annotationName = annotationDescriptor.substring(1, annotationDescriptor.length() - 1).replace('/', '.');
                }

                @Override
                public AbstractBase.RawDescriptionArray.ComponentTypeReference bind(String name) {
                    return new Bound(name);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForAnnotationProperty)) {
                        return false;
                    }
                    ForAnnotationProperty other = (ForAnnotationProperty)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypePool this$typePool = this.typePool;
                    TypePool other$typePool = other.typePool;
                    if (this$typePool == null ? other$typePool != null : !this$typePool.equals(other$typePool)) {
                        return false;
                    }
                    String this$annotationName = this.annotationName;
                    String other$annotationName = other.annotationName;
                    return !(this$annotationName == null ? other$annotationName != null : !this$annotationName.equals(other$annotationName));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForAnnotationProperty;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypePool $typePool = this.typePool;
                    result = result * 59 + ($typePool == null ? 43 : $typePool.hashCode());
                    String $annotationName = this.annotationName;
                    result = result * 59 + ($annotationName == null ? 43 : $annotationName.hashCode());
                    return result;
                }

                protected class Bound
                implements AbstractBase.RawDescriptionArray.ComponentTypeReference {
                    private final String name;

                    protected Bound(String name) {
                        this.name = name;
                    }

                    @Override
                    public String lookup() {
                        return ((MethodDescription.InDefinedShape)((MethodList)ForAnnotationProperty.this.typePool.describe(ForAnnotationProperty.this.annotationName).resolve().getDeclaredMethods().filter(ElementMatchers.named(this.name))).getOnly()).getReturnType().asErasure().getComponentType().getName();
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Bound)other).name) && ForAnnotationProperty.this.equals(((Bound)other).getOuter());
                    }

                    public int hashCode() {
                        return this.name.hashCode() + 31 * ForAnnotationProperty.this.hashCode();
                    }

                    private ForAnnotationProperty getOuter() {
                        return ForAnnotationProperty.this;
                    }
                }
            }

            public static enum Illegal implements ComponentTypeLocator
            {
                INSTANCE;


                @Override
                public AbstractBase.RawDescriptionArray.ComponentTypeReference bind(String name) {
                    throw new IllegalStateException("Unexpected lookup of component type for " + name);
                }
            }
        }

        protected static interface AnnotationRegistrant {
            public void register(String var1, AnnotationValue<?, ?> var2);

            public void onComplete();

            public static class ForTypeVariable
            extends AbstractBase.ForTypeVariable {
                private final Map<String, List<LazyTypeDescription.AnnotationToken>> pathMap;

                protected ForTypeVariable(String descriptor, TypePath typePath, Map<String, List<LazyTypeDescription.AnnotationToken>> pathMap) {
                    super(descriptor, typePath);
                    this.pathMap = pathMap;
                }

                @Override
                protected Map<String, List<LazyTypeDescription.AnnotationToken>> getPathMap() {
                    return this.pathMap;
                }

                public static class WithIndex
                extends AbstractBase.ForTypeVariable.WithIndex {
                    private final Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> indexedPathMap;

                    protected WithIndex(String descriptor, TypePath typePath, int index, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> indexedPathMap) {
                        super(descriptor, typePath, index);
                        this.indexedPathMap = indexedPathMap;
                    }

                    @Override
                    protected Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> getIndexedPathMap() {
                        return this.indexedPathMap;
                    }

                    public static class DoubleIndexed
                    extends AbstractBase.ForTypeVariable.WithIndex.DoubleIndexed {
                        private final Map<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>> doubleIndexedPathMap;

                        protected DoubleIndexed(String descriptor, TypePath typePath, int index, int preIndex, Map<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>> doubleIndexedPathMap) {
                            super(descriptor, typePath, index, preIndex);
                            this.doubleIndexedPathMap = doubleIndexedPathMap;
                        }

                        @Override
                        protected Map<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>> getDoubleIndexedPathMap() {
                            return this.doubleIndexedPathMap;
                        }
                    }
                }
            }

            public static class ForByteCodeElement
            extends AbstractBase {
                private final List<LazyTypeDescription.AnnotationToken> annotationTokens;

                protected ForByteCodeElement(String descriptor, List<LazyTypeDescription.AnnotationToken> annotationTokens) {
                    super(descriptor);
                    this.annotationTokens = annotationTokens;
                }

                @Override
                protected List<LazyTypeDescription.AnnotationToken> getTokens() {
                    return this.annotationTokens;
                }

                public static class WithIndex
                extends AbstractBase {
                    private final int index;
                    private final Map<Integer, List<LazyTypeDescription.AnnotationToken>> annotationTokens;

                    protected WithIndex(String descriptor, int index, Map<Integer, List<LazyTypeDescription.AnnotationToken>> annotationTokens) {
                        super(descriptor);
                        this.index = index;
                        this.annotationTokens = annotationTokens;
                    }

                    @Override
                    protected List<LazyTypeDescription.AnnotationToken> getTokens() {
                        List<LazyTypeDescription.AnnotationToken> annotationTokens = this.annotationTokens.get(this.index);
                        if (annotationTokens == null) {
                            annotationTokens = new ArrayList<LazyTypeDescription.AnnotationToken>();
                            this.annotationTokens.put(this.index, annotationTokens);
                        }
                        return annotationTokens;
                    }
                }
            }

            public static abstract class AbstractBase
            implements AnnotationRegistrant {
                private final String descriptor;
                private final Map<String, AnnotationValue<?, ?>> values;

                protected AbstractBase(String descriptor) {
                    this.descriptor = descriptor;
                    this.values = new HashMap();
                }

                @Override
                public void register(String name, AnnotationValue<?, ?> annotationValue) {
                    this.values.put(name, annotationValue);
                }

                @Override
                public void onComplete() {
                    this.getTokens().add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                }

                protected abstract List<LazyTypeDescription.AnnotationToken> getTokens();

                protected static abstract class ForTypeVariable
                extends AbstractBase {
                    private final String typePath;

                    protected ForTypeVariable(String descriptor, TypePath typePath) {
                        super(descriptor);
                        this.typePath = typePath == null ? "" : typePath.toString();
                    }

                    @Override
                    protected List<LazyTypeDescription.AnnotationToken> getTokens() {
                        Map<String, List<LazyTypeDescription.AnnotationToken>> pathMap = this.getPathMap();
                        List<LazyTypeDescription.AnnotationToken> tokens = pathMap.get(this.typePath);
                        if (tokens == null) {
                            tokens = new ArrayList<LazyTypeDescription.AnnotationToken>();
                            pathMap.put(this.typePath, tokens);
                        }
                        return tokens;
                    }

                    protected abstract Map<String, List<LazyTypeDescription.AnnotationToken>> getPathMap();

                    protected static abstract class WithIndex
                    extends ForTypeVariable {
                        private final int index;

                        protected WithIndex(String descriptor, TypePath typePath, int index) {
                            super(descriptor, typePath);
                            this.index = index;
                        }

                        @Override
                        protected Map<String, List<LazyTypeDescription.AnnotationToken>> getPathMap() {
                            Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> indexedPathMap = this.getIndexedPathMap();
                            Map<String, List<LazyTypeDescription.AnnotationToken>> pathMap = indexedPathMap.get(this.index);
                            if (pathMap == null) {
                                pathMap = new HashMap<String, List<LazyTypeDescription.AnnotationToken>>();
                                indexedPathMap.put(this.index, pathMap);
                            }
                            return pathMap;
                        }

                        protected abstract Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> getIndexedPathMap();

                        protected static abstract class DoubleIndexed
                        extends WithIndex {
                            private final int preIndex;

                            protected DoubleIndexed(String descriptor, TypePath typePath, int index, int preIndex) {
                                super(descriptor, typePath, index);
                                this.preIndex = preIndex;
                            }

                            @Override
                            protected Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> getIndexedPathMap() {
                                Map<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>> doubleIndexPathMap = this.getDoubleIndexedPathMap();
                                Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>> indexedPathMap = doubleIndexPathMap.get(this.preIndex);
                                if (indexedPathMap == null) {
                                    indexedPathMap = new HashMap<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>();
                                    doubleIndexPathMap.put(this.preIndex, indexedPathMap);
                                }
                                return indexedPathMap;
                            }

                            protected abstract Map<Integer, Map<Integer, Map<String, List<LazyTypeDescription.AnnotationToken>>>> getDoubleIndexedPathMap();
                        }
                    }
                }
            }
        }

        public static class WithLazyResolution
        extends Default {
            public WithLazyResolution(CacheProvider cacheProvider, ClassFileLocator classFileLocator, ReaderMode readerMode) {
                this(cacheProvider, classFileLocator, readerMode, Empty.INSTANCE);
            }

            public WithLazyResolution(CacheProvider cacheProvider, ClassFileLocator classFileLocator, ReaderMode readerMode, TypePool parentPool) {
                super(cacheProvider, classFileLocator, readerMode, parentPool);
            }

            public static TypePool ofClassPath() {
                return WithLazyResolution.of(ClassFileLocator.ForClassLoader.ofClassPath());
            }

            public static TypePool of(ClassLoader classLoader) {
                return WithLazyResolution.of(ClassFileLocator.ForClassLoader.of(classLoader));
            }

            public static TypePool of(ClassFileLocator classFileLocator) {
                return new WithLazyResolution(new CacheProvider.Simple(), classFileLocator, ReaderMode.FAST);
            }

            @Override
            protected Resolution doDescribe(String name) {
                return new LazyResolution(name);
            }

            @Override
            protected Resolution doCache(String name, Resolution resolution) {
                return resolution;
            }

            protected Resolution doResolve(String name) {
                Resolution resolution = this.cacheProvider.find(name);
                if (resolution == null) {
                    resolution = this.cacheProvider.register(name, WithLazyResolution.super.doDescribe(name));
                }
                return resolution;
            }

            protected class LazyTypeDescription
            extends TypeDescription.AbstractBase.OfSimpleType.WithDelegation {
                private final String name;

                protected LazyTypeDescription(String name) {
                    this.name = name;
                }

                @Override
                public String getName() {
                    return this.name;
                }

                @Override
                protected TypeDescription delegate() {
                    return WithLazyResolution.this.doResolve(this.name).resolve();
                }
            }

            protected class LazyResolution
            implements Resolution {
                private final String name;

                protected LazyResolution(String name) {
                    this.name = name;
                }

                @Override
                public boolean isResolved() {
                    return WithLazyResolution.this.doResolve(this.name).isResolved();
                }

                @Override
                public TypeDescription resolve() {
                    return new LazyTypeDescription(this.name);
                }

                private WithLazyResolution getOuter() {
                    return WithLazyResolution.this;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    LazyResolution that = (LazyResolution)object;
                    return this.name.equals(that.name) && this.getOuter().equals(that.getOuter());
                }

                public int hashCode() {
                    return this.name.hashCode() + 31 * this.getOuter().hashCode();
                }
            }
        }

        public static enum ReaderMode {
            EXTENDED(4),
            FAST(1);

            private final int flags;

            private ReaderMode(int flags) {
                this.flags = flags;
            }

            protected int getFlags() {
                return this.flags;
            }

            public boolean isExtended() {
                return this == EXTENDED;
            }
        }
    }

    public static abstract class AbstractBase
    implements TypePool {
        protected static final Map<String, TypeDescription> PRIMITIVE_TYPES;
        protected static final Map<String, String> PRIMITIVE_DESCRIPTORS;
        private static final String ARRAY_SYMBOL = "[";
        protected final CacheProvider cacheProvider;

        protected AbstractBase(CacheProvider cacheProvider) {
            this.cacheProvider = cacheProvider;
        }

        @Override
        public Resolution describe(String name) {
            TypeDescription typeDescription;
            Resolution resolution;
            if (name.contains("/")) {
                throw new IllegalArgumentException(name + " contains the illegal character '/'");
            }
            int arity = 0;
            while (name.startsWith(ARRAY_SYMBOL)) {
                ++arity;
                name = name.substring(1);
            }
            if (arity > 0) {
                String primitiveName = PRIMITIVE_DESCRIPTORS.get(name);
                name = primitiveName == null ? name.substring(1, name.length() - 1) : primitiveName;
            }
            Resolution resolution2 = resolution = (typeDescription = PRIMITIVE_TYPES.get(name)) == null ? this.cacheProvider.find(name) : new Resolution.Simple(typeDescription);
            if (resolution == null) {
                resolution = this.doCache(name, this.doDescribe(name));
            }
            return ArrayTypeResolution.of(resolution, arity);
        }

        protected Resolution doCache(String name, Resolution resolution) {
            return this.cacheProvider.register(name, resolution);
        }

        @Override
        public void clear() {
            this.cacheProvider.clear();
        }

        protected abstract Resolution doDescribe(String var1);

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbstractBase)) {
                return false;
            }
            AbstractBase other = (AbstractBase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CacheProvider this$cacheProvider = this.cacheProvider;
            CacheProvider other$cacheProvider = other.cacheProvider;
            return !(this$cacheProvider == null ? other$cacheProvider != null : !this$cacheProvider.equals(other$cacheProvider));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AbstractBase;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CacheProvider $cacheProvider = this.cacheProvider;
            result = result * 59 + ($cacheProvider == null ? 43 : $cacheProvider.hashCode());
            return result;
        }

        static {
            HashMap<String, TypeDescription.ForLoadedType> primitiveTypes = new HashMap<String, TypeDescription.ForLoadedType>();
            HashMap<String, String> primitiveDescriptors = new HashMap<String, String>();
            for (Class primitiveType : new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE}) {
                primitiveTypes.put(primitiveType.getName(), new TypeDescription.ForLoadedType(primitiveType));
                primitiveDescriptors.put(nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type.getDescriptor(primitiveType), primitiveType.getName());
            }
            PRIMITIVE_TYPES = Collections.unmodifiableMap(primitiveTypes);
            PRIMITIVE_DESCRIPTORS = Collections.unmodifiableMap(primitiveDescriptors);
        }

        protected static class RawDescriptionArray
        extends AnnotationValue.AbstractBase<Object[], Object[]> {
            private final TypePool typePool;
            private final ComponentTypeReference componentTypeReference;
            private List<AnnotationValue<?, ?>> values;

            public RawDescriptionArray(TypePool typePool, ComponentTypeReference componentTypeReference, List<AnnotationValue<?, ?>> values) {
                this.typePool = typePool;
                this.values = values;
                this.componentTypeReference = componentTypeReference;
            }

            @Override
            public Object[] resolve() {
                Class componentType;
                TypeDescription componentTypeDescription = this.typePool.describe(this.componentTypeReference.lookup()).resolve();
                if (componentTypeDescription.represents((Type)((Object)Class.class))) {
                    componentType = TypeDescription.class;
                } else if (componentTypeDescription.isAssignableTo(Enum.class)) {
                    componentType = EnumerationDescription.class;
                } else if (componentTypeDescription.isAssignableTo(Annotation.class)) {
                    componentType = AnnotationDescription.class;
                } else if (componentTypeDescription.represents((Type)((Object)String.class))) {
                    componentType = String.class;
                } else {
                    throw new IllegalStateException("Unexpected complex array component type " + componentTypeDescription);
                }
                Object[] array = (Object[])Array.newInstance(componentType, this.values.size());
                int index = 0;
                for (AnnotationValue<?, ?> annotationValue : this.values) {
                    Array.set(array, index++, annotationValue.resolve());
                }
                return array;
            }

            @Override
            public AnnotationValue.Loaded<Object[]> load(ClassLoader classLoader) throws ClassNotFoundException {
                ArrayList loadedValues = new ArrayList(this.values.size());
                for (AnnotationValue<?, ?> value : this.values) {
                    loadedValues.add(value.load(classLoader));
                }
                return new Loaded(Class.forName(this.componentTypeReference.lookup(), false, classLoader), loadedValues);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AnnotationValue)) {
                    return false;
                }
                Object value = ((AnnotationValue)other).resolve();
                return value instanceof Object[] && Arrays.equals(this.resolve(), (Object[])value);
            }

            public int hashCode() {
                return Arrays.hashCode(this.resolve());
            }

            public String toString() {
                return AnnotationValue.RenderingDispatcher.CURRENT.toSourceString(this.values);
            }

            protected static class Loaded
            extends AnnotationValue.Loaded.AbstractBase<Object[]> {
                private final Class<?> componentType;
                private final List<AnnotationValue.Loaded<?>> values;

                public Loaded(Class<?> componentType, List<AnnotationValue.Loaded<?>> values) {
                    this.componentType = componentType;
                    this.values = values;
                }

                @Override
                public AnnotationValue.Loaded.State getState() {
                    for (AnnotationValue.Loaded<?> value : this.values) {
                        if (value.getState().isResolved()) continue;
                        return AnnotationValue.Loaded.State.UNRESOLVED;
                    }
                    return AnnotationValue.Loaded.State.RESOLVED;
                }

                @Override
                public Object[] resolve() {
                    Object[] array = (Object[])Array.newInstance(this.componentType, this.values.size());
                    int index = 0;
                    for (AnnotationValue.Loaded<?> annotationValue : this.values) {
                        Array.set(array, index++, annotationValue.resolve());
                    }
                    return array;
                }

                @Override
                public boolean represents(Object value) {
                    if (!(value instanceof Object[])) {
                        return false;
                    }
                    if (value.getClass().getComponentType() != this.componentType) {
                        return false;
                    }
                    Object[] array = (Object[])value;
                    if (this.values.size() != array.length) {
                        return false;
                    }
                    Iterator<AnnotationValue.Loaded<?>> iterator = this.values.iterator();
                    for (Object aValue : array) {
                        AnnotationValue.Loaded<?> self = iterator.next();
                        if (self.getState().isResolved() && self.represents(aValue)) continue;
                        return false;
                    }
                    return true;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AnnotationValue.Loaded)) {
                        return false;
                    }
                    AnnotationValue.Loaded loadedOther = (AnnotationValue.Loaded)other;
                    if (!loadedOther.getState().isResolved()) {
                        return false;
                    }
                    Object otherValue = loadedOther.resolve();
                    if (!(otherValue instanceof Object[])) {
                        return false;
                    }
                    Object[] otherArrayValue = (Object[])otherValue;
                    if (this.values.size() != otherArrayValue.length) {
                        return false;
                    }
                    Iterator<AnnotationValue.Loaded<?>> iterator = this.values.iterator();
                    for (Object value : otherArrayValue) {
                        AnnotationValue.Loaded<?> self = iterator.next();
                        if (self.resolve().equals(value)) continue;
                        return false;
                    }
                    return true;
                }

                public int hashCode() {
                    int result = 1;
                    for (AnnotationValue.Loaded<?> value : this.values) {
                        result = 31 * result + value.hashCode();
                    }
                    return result;
                }

                public String toString() {
                    return AnnotationValue.RenderingDispatcher.CURRENT.toSourceString(this.values);
                }
            }

            public static interface ComponentTypeReference {
                public String lookup();
            }
        }

        protected static class RawTypeValue
        extends AnnotationValue.AbstractBase<TypeDescription, Class<?>> {
            private static final boolean NO_INITIALIZATION = false;
            private final TypePool typePool;
            private final String name;

            protected RawTypeValue(TypePool typePool, nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type type) {
                this.typePool = typePool;
                this.name = type.getSort() == 9 ? type.getInternalName().replace('/', '.') : type.getClassName();
            }

            @Override
            public TypeDescription resolve() {
                return this.typePool.describe(this.name).resolve();
            }

            @Override
            public AnnotationValue.Loaded<Class<?>> load(ClassLoader classLoader) throws ClassNotFoundException {
                return new Loaded(Class.forName(this.name, false, classLoader));
            }

            public boolean equals(Object other) {
                return this == other || other instanceof AnnotationValue && this.resolve().equals(((AnnotationValue)other).resolve());
            }

            public int hashCode() {
                return this.resolve().hashCode();
            }

            public String toString() {
                return AnnotationValue.RenderingDispatcher.CURRENT.toSourceString(this.resolve());
            }

            protected static class Loaded
            extends AnnotationValue.Loaded.AbstractBase<Class<?>> {
                private final Class<?> type;

                public Loaded(Class<?> type) {
                    this.type = type;
                }

                @Override
                public AnnotationValue.Loaded.State getState() {
                    return AnnotationValue.Loaded.State.RESOLVED;
                }

                @Override
                public Class<?> resolve() {
                    return this.type;
                }

                @Override
                public boolean represents(Object value) {
                    return this.type.equals(value);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AnnotationValue.Loaded)) {
                        return false;
                    }
                    AnnotationValue.Loaded loadedOther = (AnnotationValue.Loaded)other;
                    return loadedOther.getState().isResolved() && this.type.equals(loadedOther.resolve());
                }

                public int hashCode() {
                    return this.type.hashCode();
                }

                public String toString() {
                    return AnnotationValue.RenderingDispatcher.CURRENT.toSourceString(new TypeDescription.ForLoadedType(this.type));
                }
            }
        }

        protected static class RawEnumerationValue
        extends AnnotationValue.AbstractBase<EnumerationDescription, Enum<?>> {
            private final TypePool typePool;
            private final String descriptor;
            private final String value;

            public RawEnumerationValue(TypePool typePool, String descriptor, String value) {
                this.typePool = typePool;
                this.descriptor = descriptor;
                this.value = value;
            }

            @Override
            public EnumerationDescription resolve() {
                return new LazyEnumerationDescription();
            }

            @Override
            public AnnotationValue.Loaded<Enum<?>> load(ClassLoader classLoader) throws ClassNotFoundException {
                Class<?> type = Class.forName(this.descriptor.substring(1, this.descriptor.length() - 1).replace('/', '.'), false, classLoader);
                try {
                    return type.isEnum() ? new AnnotationValue.ForEnumerationDescription.Loaded(Enum.valueOf(type, this.value)) : new AnnotationValue.ForEnumerationDescription.IncompatibleRuntimeType(type);
                }
                catch (IllegalArgumentException ignored) {
                    return new AnnotationValue.ForEnumerationDescription.UnknownRuntimeEnumeration(type, this.value);
                }
            }

            public boolean equals(Object other) {
                return this == other || other instanceof AnnotationValue && this.resolve().equals(((AnnotationValue)other).resolve());
            }

            public int hashCode() {
                return this.resolve().hashCode();
            }

            public String toString() {
                return this.resolve().toString();
            }

            protected class LazyEnumerationDescription
            extends EnumerationDescription.AbstractBase {
                protected LazyEnumerationDescription() {
                }

                @Override
                public String getValue() {
                    return RawEnumerationValue.this.value;
                }

                @Override
                public TypeDescription getEnumerationType() {
                    return RawEnumerationValue.this.typePool.describe(RawEnumerationValue.this.descriptor.substring(1, RawEnumerationValue.this.descriptor.length() - 1).replace('/', '.')).resolve();
                }

                @Override
                public <T extends Enum<T>> T load(Class<T> type) {
                    return Enum.valueOf(type, RawEnumerationValue.this.value);
                }
            }
        }

        protected static class RawAnnotationValue
        extends AnnotationValue.AbstractBase<AnnotationDescription, Annotation> {
            private final TypePool typePool;
            private final Default.LazyTypeDescription.AnnotationToken annotationToken;

            public RawAnnotationValue(TypePool typePool, Default.LazyTypeDescription.AnnotationToken annotationToken) {
                this.typePool = typePool;
                this.annotationToken = annotationToken;
            }

            @Override
            public AnnotationDescription resolve() {
                return this.annotationToken.toAnnotationDescription(this.typePool).resolve();
            }

            @Override
            public AnnotationValue.Loaded<Annotation> load(ClassLoader classLoader) throws ClassNotFoundException {
                Class<?> type = Class.forName(this.annotationToken.getBinaryName(), false, classLoader);
                if (type.isAnnotation()) {
                    return new AnnotationValue.ForAnnotationDescription.Loaded<Annotation>((Annotation)AnnotationDescription.AnnotationInvocationHandler.of(classLoader, type, this.annotationToken.getValues()));
                }
                return new AnnotationValue.ForAnnotationDescription.IncompatibleRuntimeType(type);
            }

            public boolean equals(Object other) {
                return this == other || other instanceof AnnotationValue && this.resolve().equals(((AnnotationValue)other).resolve());
            }

            public int hashCode() {
                return this.resolve().hashCode();
            }

            public String toString() {
                return this.resolve().toString();
            }
        }

        protected static class ArrayTypeResolution
        implements Resolution {
            private final Resolution resolution;
            private final int arity;

            protected ArrayTypeResolution(Resolution resolution, int arity) {
                this.resolution = resolution;
                this.arity = arity;
            }

            protected static Resolution of(Resolution resolution, int arity) {
                return arity == 0 ? resolution : new ArrayTypeResolution(resolution, arity);
            }

            @Override
            public boolean isResolved() {
                return this.resolution.isResolved();
            }

            @Override
            public TypeDescription resolve() {
                return TypeDescription.ArrayProjection.of(this.resolution.resolve(), this.arity);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ArrayTypeResolution)) {
                    return false;
                }
                ArrayTypeResolution other = (ArrayTypeResolution)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Resolution this$resolution = this.resolution;
                Resolution other$resolution = other.resolution;
                if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) {
                    return false;
                }
                return this.arity == other.arity;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ArrayTypeResolution;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Resolution $resolution = this.resolution;
                result = result * 59 + ($resolution == null ? 43 : $resolution.hashCode());
                result = result * 59 + this.arity;
                return result;
            }
        }

        public static abstract class Hierarchical
        extends AbstractBase {
            private final TypePool parent;

            protected Hierarchical(CacheProvider cacheProvider, TypePool parent) {
                super(cacheProvider);
                this.parent = parent;
            }

            @Override
            public Resolution describe(String name) {
                Resolution resolution = this.parent.describe(name);
                return resolution.isResolved() ? resolution : super.describe(name);
            }

            @Override
            public void clear() {
                try {
                    this.parent.clear();
                }
                finally {
                    super.clear();
                }
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Hierarchical)) {
                    return false;
                }
                Hierarchical other = (Hierarchical)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                TypePool this$parent = this.parent;
                TypePool other$parent = other.parent;
                return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Hierarchical;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + super.hashCode();
                TypePool $parent = this.parent;
                result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
                return result;
            }
        }
    }

    public static enum Empty implements TypePool
    {
        INSTANCE;


        @Override
        public Resolution describe(String name) {
            return new Resolution.Illegal(name);
        }

        @Override
        public void clear() {
        }
    }

    public static interface CacheProvider {
        public static final Resolution UNRESOLVED = null;

        public Resolution find(String var1);

        public Resolution register(String var1, Resolution var2);

        public void clear();

        public static class Simple
        implements CacheProvider {
            private final ConcurrentMap<String, Resolution> cache = new ConcurrentHashMap<String, Resolution>();

            public static CacheProvider withObjectType() {
                Simple cacheProvider = new Simple();
                cacheProvider.register(Object.class.getName(), new Resolution.Simple(TypeDescription.OBJECT));
                return cacheProvider;
            }

            @Override
            public Resolution find(String name) {
                return (Resolution)this.cache.get(name);
            }

            @Override
            public Resolution register(String name, Resolution resolution) {
                Resolution cached = this.cache.putIfAbsent(name, resolution);
                return cached == null ? resolution : cached;
            }

            @Override
            public void clear() {
                this.cache.clear();
            }
        }

        public static enum NoOp implements CacheProvider
        {
            INSTANCE;


            @Override
            public Resolution find(String name) {
                return UNRESOLVED;
            }

            @Override
            public Resolution register(String name, Resolution resolution) {
                return resolution;
            }

            @Override
            public void clear() {
            }
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public TypeDescription resolve();

        public static class Illegal
        implements Resolution {
            private final String name;

            public Illegal(String name) {
                this.name = name;
            }

            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public TypeDescription resolve() {
                throw new IllegalStateException("Cannot resolve type description for " + this.name);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Illegal)) {
                    return false;
                }
                Illegal other = (Illegal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.name;
                String other$name = other.name;
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Illegal;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.name;
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }

        public static class Simple
        implements Resolution {
            private final TypeDescription typeDescription;

            public Simple(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            public TypeDescription resolve() {
                return this.typeDescription;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Simple)) {
                    return false;
                }
                Simple other = (Simple)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$typeDescription = this.typeDescription;
                TypeDescription other$typeDescription = other.typeDescription;
                return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Simple;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                return result;
            }
        }
    }
}

