/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.lang.reflect.Field;
import java.util.Set;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;

public class FieldInspector<T> {
    private final ClassAccessor<T> classAccessor;
    private final TypeTag typeTag;

    public FieldInspector(ClassAccessor<T> classAccessor, TypeTag typeTag) {
        this.classAccessor = classAccessor;
        this.typeTag = typeTag;
    }

    public void check(FieldCheck check) {
        for (Field field : FieldIterable.of(this.classAccessor.getType())) {
            ObjectAccessor<T> reference = this.classAccessor.getRedAccessor(this.typeTag);
            ObjectAccessor<T> changed = this.classAccessor.getRedAccessor(this.typeTag);
            check.execute(reference.fieldAccessorFor(field), changed.fieldAccessorFor(field));
        }
    }

    public void checkWithNull(Set<String> nonnullFields, FieldCheck check) {
        for (Field field : FieldIterable.of(this.classAccessor.getType())) {
            ObjectAccessor<T> reference = this.classAccessor.getDefaultValuesAccessor(this.typeTag, nonnullFields);
            ObjectAccessor<T> changed = this.classAccessor.getDefaultValuesAccessor(this.typeTag, nonnullFields);
            check.execute(reference.fieldAccessorFor(field), changed.fieldAccessorFor(field));
        }
    }

    public static interface FieldCheck {
        public void execute(FieldAccessor var1, FieldAccessor var2);
    }
}

