/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.util.EnumSet;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class CachedHashCodeChecker<T>
implements Checker {
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;
    private final EnumSet<Warning> warningsToSuppress;

    public CachedHashCodeChecker(Configuration<T> config) {
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
        this.warningsToSuppress = config.getWarningsToSuppress();
    }

    @Override
    public void check() {
        if (this.cachedHashCodeInitializer.isPassthrough()) {
            return;
        }
        if (this.warningsToSuppress.contains((Object)Warning.NONFINAL_FIELDS)) {
            Assert.fail(Formatter.of("Cached hashCode: EqualsVerifier can only check cached hashCodes for immutable classes.", new Object[0]));
        }
        T reference = this.cachedHashCodeInitializer.getExample();
        if (this.warningsToSuppress.contains((Object)Warning.NO_EXAMPLE_FOR_CACHED_HASHCODE)) {
            if (reference != null) {
                Assert.fail(Formatter.of("Cached hashCode: example must be null if %% is suppressed", Warning.NO_EXAMPLE_FOR_CACHED_HASHCODE.name()));
            }
        } else {
            if (reference == null) {
                Assert.fail(Formatter.of("Cached hashCode: example cannot be null.", new Object[0]));
            }
            int actualHashCode = reference.hashCode();
            int recomputedHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(reference);
            Assert.assertEquals(Formatter.of("Cached hashCode: hashCode is not properly initialized.", new Object[0]), actualHashCode, recomputedHashCode);
            Assert.assertFalse(Formatter.of("Cached hashCode: example.hashCode() cannot be zero. Please choose a different example.", new Object[0]), actualHashCode == 0);
        }
    }
}

