/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmTileSource {
    public static final String MAP_MAPNIK = "http://tile.openstreetmap.org";
    public static final String MAP_OSMA = "http://tah.openstreetmap.org/Tiles/tile";

    public static class TilesAtHome
    extends AbstractOsmTileSource {
        public static String NAME = "TilesAtHome";

        public int getMaxZoom() {
            return 17;
        }

        public String getName() {
            return NAME;
        }

        public String getTileUrl(int zoom, int tilex, int tiley) {
            return OsmTileSource.MAP_OSMA + super.getTileUrl(zoom, tilex, tiley);
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfModifiedSince;
        }
    }

    public static class CycleMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://%s.andy.sandbox.cloudmade.com/tiles/cycle/%d/%d/%d.png";
        public static String NAME = "OSM Cycle Map";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int SERVER_NUM = 0;

        public String getTileUrl(int zoom, int tilex, int tiley) {
            String url = String.format(PATTERN, SERVER[this.SERVER_NUM], zoom, tilex, tiley);
            this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
            return url;
        }

        public String getName() {
            return NAME;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.LastModified;
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        public static String NAME = "Mapnik";

        public String getName() {
            return NAME;
        }

        public String getTileUrl(int zoom, int tilex, int tiley) {
            return OsmTileSource.MAP_MAPNIK + super.getTileUrl(zoom, tilex, tiley);
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    protected static abstract class AbstractOsmTileSource
    implements TileSource {
        protected AbstractOsmTileSource() {
        }

        public int getMaxZoom() {
            return 18;
        }

        public int getMinZoom() {
            return 0;
        }

        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }

        public String toString() {
            return this.getName();
        }

        public String getTileType() {
            return "png";
        }
    }
}

