/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.settings;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLSettingsSaver {
    private final File outputFile;
    private Document document;

    private XMLSettingsSaver(File output) throws IOException {
        DocumentBuilder documentBuilder;
        this.outputFile = output;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Failed to create settings document builder", e);
        }
        this.document = documentBuilder.newDocument();
        Element settingsElement = this.document.createElement("settings");
        this.document.appendChild(settingsElement);
    }

    public XMLSettingsSaver put(String key, String value) {
        Element settingElement = this.document.createElement("setting");
        settingElement.setAttribute("key", key);
        settingElement.appendChild(this.document.createCDATASection(value));
        this.document.getDocumentElement().appendChild(settingElement);
        return this;
    }

    public void save() throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(this.document);
            this.outputFile.getParentFile().mkdirs();
            StreamResult result = new StreamResult(new FileWriter(this.outputFile));
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Failed to save settings", e);
        }
    }

    public static XMLSettingsSaver forFile(File file) throws IOException {
        return new XMLSettingsSaver(file);
    }
}

