/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSettingsLoader {
    private final File settingsFile;

    public XMLSettingsLoader(File settingsPath) {
        this.settingsFile = settingsPath;
    }

    private Set<Element> getSettingNodes(Document document) {
        NodeList nodes = document.getElementsByTagName("setting");
        HashSet<Element> set = new HashSet<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            set.add((Element)nodes.item(i));
        }
        return set;
    }

    public Map<String, String> getSettings() throws IOException {
        FileInputStream stream;
        block4: {
            Map<String, String> map;
            stream = null;
            try {
                if (!this.settingsFile.exists()) break block4;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                stream = new FileInputStream(this.settingsFile);
                Document document = builder.parse(stream);
                Set<Element> settings = this.getSettingNodes(document);
                map = settings.stream().collect(Collectors.toMap(elt -> elt.getAttribute("key"), Node::getTextContent));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                try {
                    throw new IOException("Failed to load settings", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
            return map;
        }
        IOUtils.closeQuietly(stream);
        return Collections.emptyMap();
    }
}

