/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.CustomCodeArea;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

class StyleLayer {
    private static final Pattern TAB_INDENT = Pattern.compile("^(\t*).*$");
    private final String id;
    private Stack<StyleSpans<Collection<String>>> spans = new Stack();
    private CustomCodeArea codeArea;

    StyleLayer(String id, CustomCodeArea parent) {
        Objects.requireNonNull(id, "The id of a style layer cannot be null");
        this.id = id;
        this.codeArea = parent;
    }

    public Stack<StyleSpans<Collection<String>>> getSpans() {
        return this.spans;
    }

    public void reset(StyleSpans<Collection<String>> replacement) {
        this.spans.clear();
        this.spans.push(replacement);
    }

    public void style(int beginLine, int beginColumn, int endLine, int endColumn, Set<String> cssClasses) {
        if (endLine > this.codeArea.getParagraphs().size() || endLine == this.codeArea.getParagraphs().size() && endColumn > this.codeArea.getParagraph(endLine).length()) {
            throw new IllegalArgumentException("Cannot style, the region is out of bounds");
        }
        int offset = this.getAbsolutePosition(beginLine, beginColumn - 1);
        int spanLength = this.getAbsolutePosition(endLine, endColumn) - offset;
        StyleSpansBuilder builder = new StyleSpansBuilder();
        builder.add(Collections.emptySet(), offset);
        builder.add(cssClasses, spanLength);
        builder.add(Collections.emptySet(), this.codeArea.getLength() - (offset + spanLength));
        this.spans.push((StyleSpans<Collection<String>>)builder.create());
    }

    private int getAbsolutePosition(int line, int column) {
        return this.codeArea.getAbsolutePosition(line - 1, column) - this.indentationOffset(line - 1);
    }

    private int indentationOffset(int paragraph) {
        Paragraph p = this.codeArea.getParagraph(paragraph);
        Matcher m = TAB_INDENT.matcher(p.getText());
        if (m.matches()) {
            return m.group(1).length() * 7;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleLayer that = (StyleLayer)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void clearStyles() {
        this.spans.clear();
    }

    public String toString() {
        return "StyleLayer{id='" + this.id + '\'' + ", spans=\"" + this.spans.size() + " spans\"" + '}';
    }
}

