/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.util.fxdesigner.model.XPathEvaluationException;
import org.apache.commons.lang3.StringUtils;

public class XPathEvaluator {
    private final StringProperty xpathVersion = new SimpleStringProperty("2.0");

    public String getXpathVersion() {
        return (String)this.xpathVersion.get();
    }

    public StringProperty xpathVersionProperty() {
        return this.xpathVersion;
    }

    public List<Node> evaluateQuery(Node compilationUnit, LanguageVersion languageVersion, String xpathQuery) throws XPathEvaluationException {
        if (StringUtils.isBlank((CharSequence)xpathQuery)) {
            return Collections.emptyList();
        }
        try {
            final ArrayList<Node> results = new ArrayList<Node>();
            XPathRule xpathRule = new XPathRule(){

                public void addViolation(Object data, Node node, String arg) {
                    results.add(node);
                }
            };
            xpathRule.setMessage("");
            xpathRule.setLanguage(languageVersion.getLanguage());
            xpathRule.setXPath(xpathQuery);
            xpathRule.setVersion((String)this.xpathVersion.get());
            RuleSet ruleSet = new RuleSetFactory().createSingleRuleRuleSet((Rule)xpathRule);
            RuleSets ruleSets = new RuleSets(ruleSet);
            RuleContext ruleContext = new RuleContext();
            ruleContext.setLanguageVersion(languageVersion);
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(compilationUnit);
            ruleSets.apply(nodes, ruleContext, xpathRule.getLanguage());
            return results;
        }
        catch (RuntimeException e) {
            throw new XPathEvaluationException(e);
        }
    }
}

