/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.model;

import java.io.Reader;
import java.io.StringReader;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.model.LogEntry;
import net.sourceforge.pmd.util.fxdesigner.model.ParseAbortedException;
import org.apache.commons.lang3.StringUtils;

public class ASTManager {
    private final DesignerRoot designerRoot;
    private String lastValidSource;
    private LanguageVersion lastLanguageVersion;
    private ObjectProperty<Node> compilationUnit = new SimpleObjectProperty();
    private ObjectProperty<LanguageVersion> languageVersion = new SimpleObjectProperty();

    public ASTManager(DesignerRoot owner) {
        this.languageVersion.setValue((Object)LanguageRegistry.findLanguageVersionByTerseName((String)"java 8"));
        this.designerRoot = owner;
    }

    public LanguageVersion getLanguageVersion() {
        return (LanguageVersion)this.languageVersion.get();
    }

    public ObjectProperty<LanguageVersion> languageVersionProperty() {
        return this.languageVersion;
    }

    public Node updateCompilationUnit() {
        return (Node)this.compilationUnit.get();
    }

    public ObjectProperty<Node> compilationUnitProperty() {
        return this.compilationUnit;
    }

    public Node updateCompilationUnit(String source) throws ParseAbortedException {
        Node node;
        if (this.compilationUnit.get() != null && ((LanguageVersion)this.languageVersion.get()).equals(this.lastLanguageVersion) && StringUtils.equals((CharSequence)source, (CharSequence)this.lastValidSource)) {
            return (Node)this.compilationUnit.get();
        }
        LanguageVersionHandler languageVersionHandler = ((LanguageVersion)this.languageVersion.get()).getLanguageVersionHandler();
        Parser parser = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions());
        try {
            node = parser.parse(null, (Reader)new StringReader(source));
        }
        catch (Exception e) {
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.PARSE_EXCEPTION));
            throw new ParseAbortedException(e);
        }
        try {
            languageVersionHandler.getSymbolFacade().start(node);
        }
        catch (Exception e) {
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.SYMBOL_FACADE_EXCEPTION));
        }
        try {
            languageVersionHandler.getTypeResolutionFacade(ASTManager.class.getClassLoader()).start(node);
        }
        catch (Exception e) {
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.TYPERESOLUTION_EXCEPTION));
        }
        this.compilationUnit.setValue((Object)node);
        this.lastValidSource = source;
        this.lastLanguageVersion = (LanguageVersion)this.languageVersion.get();
        return (Node)this.compilationUnit.get();
    }
}

