/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListView;
import javafx.scene.control.TitledPane;
import javafx.util.StringConverter;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.model.LogEntry;
import net.sourceforge.pmd.util.fxdesigner.model.XPathEvaluationException;
import net.sourceforge.pmd.util.fxdesigner.model.XPathEvaluator;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.CustomCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.XPathSyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.settings.AppSetting;
import net.sourceforge.pmd.util.fxdesigner.util.settings.SettingsOwner;
import org.apache.commons.lang3.StringUtils;

public class XPathPanelController
implements Initializable,
SettingsOwner {
    private final DesignerRoot designerRoot;
    private final MainDesignerController parent;
    private final XPathEvaluator xpathEvaluator = new XPathEvaluator();
    @FXML
    private CustomCodeArea xpathExpressionArea;
    @FXML
    private TitledPane violationsTitledPane;
    @FXML
    private ListView<Node> xpathResultListView;
    private ChoiceBox<String> xpathVersionChoiceBox;

    XPathPanelController(DesignerRoot owner, MainDesignerController mainController) {
        this.designerRoot = owner;
        this.parent = mainController;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.xpathExpressionArea.setSyntaxHighlightingEnabled(new XPathSyntaxHighlighter());
        this.xpathResultListView.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null) {
                this.parent.onNodeItemSelected((Node)newVal);
            }
        });
    }

    public void initialiseVersionChoiceBox(ChoiceBox<String> choiceBox) {
        this.xpathVersionChoiceBox = choiceBox;
        ObservableList versionItems = choiceBox.getItems();
        versionItems.add((Object)"1.0");
        versionItems.add((Object)"1.0 compatibility");
        versionItems.add((Object)"2.0");
        this.xpathVersionChoiceBox.getSelectionModel().select(this.xpathEvaluator.xpathVersionProperty().get());
        choiceBox.setConverter((StringConverter)new StringConverter<String>(){

            public String toString(String object) {
                return "XPath " + object;
            }

            public String fromString(String string) {
                return string.substring(6);
            }
        });
    }

    public void evaluateXPath(Node compilationUnit, LanguageVersion version) {
        try {
            String xpath = this.xpathExpressionArea.getText();
            if (StringUtils.isBlank((CharSequence)xpath)) {
                this.xpathResultListView.getItems().clear();
                return;
            }
            ObservableList results = FXCollections.observableArrayList(this.xpathEvaluator.evaluateQuery(compilationUnit, version, xpath));
            this.xpathResultListView.setItems(results);
            this.violationsTitledPane.setText("Matched nodes\t(" + results.size() + ")");
        }
        catch (XPathEvaluationException e) {
            this.invalidateResults(true);
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.XPATH_EVALUATION_EXCEPTION));
        }
        this.xpathResultListView.refresh();
        this.xpathExpressionArea.requestFocus();
    }

    public void invalidateResults(boolean error) {
        this.xpathResultListView.getItems().clear();
        this.violationsTitledPane.setText("Matched nodes" + (error ? "\t(error)" : ""));
    }

    public void shutdown() {
        this.xpathExpressionArea.disableSyntaxHighlighting();
    }

    public StringProperty xpathVersionProperty() {
        return this.xpathEvaluator.xpathVersionProperty();
    }

    @Override
    public List<AppSetting> getSettings() {
        ArrayList<AppSetting> settings = new ArrayList<AppSetting>();
        settings.add(new AppSetting("xpathVersion", () -> this.xpathEvaluator.xpathVersionProperty().getValue(), v -> {
            if (!"".equals(v)) {
                this.xpathEvaluator.xpathVersionProperty().setValue(v);
            }
        }));
        settings.add(new AppSetting("xpathCode", () -> this.xpathExpressionArea.getText(), v -> this.xpathExpressionArea.replaceText((String)v)));
        return settings;
    }

    public ObservableValue<String> xpathExpressionProperty() {
        return this.xpathExpressionArea.textProperty();
    }
}

