/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.model.ASTManager;
import net.sourceforge.pmd.util.fxdesigner.model.ParseAbortedException;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.AvailableSyntaxHighlighters;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.CustomCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.controls.ASTTreeItem;
import net.sourceforge.pmd.util.fxdesigner.util.settings.AppSetting;
import net.sourceforge.pmd.util.fxdesigner.util.settings.SettingsOwner;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;

public class SourceEditorController
implements Initializable,
SettingsOwner {
    private final DesignerRoot designerRoot;
    private final MainDesignerController parent;
    @FXML
    private Label astTitleLabel;
    @FXML
    private TreeView<Node> astTreeView;
    @FXML
    private CustomCodeArea codeEditorArea;
    private BooleanProperty isSyntaxHighlightingEnabled = new SimpleBooleanProperty(true);
    private ASTManager astManager;

    public SourceEditorController(DesignerRoot owner, MainDesignerController mainController) {
        this.designerRoot = owner;
        this.parent = mainController;
        this.astManager = new ASTManager(this.designerRoot);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.initializeSyntaxHighlighting();
        this.initializeASTTreeView();
        this.codeEditorArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.codeEditorArea));
    }

    private void initializeSyntaxHighlighting() {
        this.isSyntaxHighlightingEnabled.bind((ObservableValue)this.codeEditorArea.syntaxHighlightingEnabledProperty());
        this.isSyntaxHighlightingEnabled.addListener((observable, wasEnabled, isEnabled) -> {
            if (!wasEnabled.booleanValue() && isEnabled.booleanValue()) {
                this.updateSyntaxHighlighter();
            } else if (!isEnabled.booleanValue()) {
                this.codeEditorArea.disableSyntaxHighlighting();
            }
        });
        this.astManager.languageVersionProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null && !newVal.equals(oldVal)) {
                this.updateSyntaxHighlighter();
            }
        });
    }

    private void initializeASTTreeView() {
        this.astTreeView.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null && newVal.getValue() != null) {
                this.parent.onNodeItemSelected((Node)newVal.getValue());
            }
        });
    }

    public void refreshAST() {
        Node current;
        String source = this.codeEditorArea.getText();
        Node previous = (Node)this.astManager.compilationUnitProperty().get();
        try {
            current = this.astManager.updateCompilationUnit(source);
        }
        catch (ParseAbortedException e) {
            this.invalidateAST(true);
            return;
        }
        if (previous != current) {
            this.parent.invalidateAst();
        }
        this.setUpToDateCompilationUnit(current);
        this.codeEditorArea.clearPrimaryStyleLayer();
    }

    private void setUpToDateCompilationUnit(Node node) {
        this.astTitleLabel.setText("Abstract Syntax Tree");
        ASTTreeItem root = ASTTreeItem.getRoot(node);
        this.astTreeView.setRoot((TreeItem)root);
    }

    public void shutdown() {
        this.codeEditorArea.disableSyntaxHighlighting();
    }

    private void updateSyntaxHighlighter() {
        SyntaxHighlighter computer = AvailableSyntaxHighlighters.getComputerForLanguage(this.astManager.getLanguageVersion().getLanguage());
        if (computer != null) {
            this.codeEditorArea.setSyntaxHighlightingEnabled(computer);
        } else {
            this.codeEditorArea.disableSyntaxHighlighting();
        }
    }

    public void clearNodeHighlight() {
        this.codeEditorArea.clearPrimaryStyleLayer();
    }

    public void highlightNodePrimary(Node node) {
        this.highlightNodes(Collections.singleton(node), Collections.singleton("primary-highlight"));
    }

    private void highlightNodes(Collection<Node> nodes, Set<String> cssClasses) {
        for (Node node : nodes) {
            if (this.codeEditorArea.isInRange(node)) {
                this.codeEditorArea.styleCss(node, cssClasses);
                this.codeEditorArea.paintCss();
                this.codeEditorArea.moveTo(node.getBeginLine() - 1, 0);
                this.codeEditorArea.requestFollowCaret();
                continue;
            }
            this.codeEditorArea.clearPrimaryStyleLayer();
        }
    }

    public void highlightNodesSecondary(Collection<Node> nodes) {
        this.highlightNodes(nodes, Collections.singleton("secondary-highlight"));
    }

    public void focusNodeInTreeView(Node node) {
        ASTTreeItem found = ((ASTTreeItem)this.astTreeView.getRoot()).findItem(node);
        if (found != null) {
            MultipleSelectionModel selectionModel = this.astTreeView.getSelectionModel();
            selectionModel.select((Object)found);
            this.astTreeView.getFocusModel().focus(selectionModel.getSelectedIndex());
        }
    }

    private void invalidateAST(boolean error) {
        this.astTitleLabel.setText("Abstract syntax tree (" + (error ? "error" : "outdated") + ")");
    }

    public void moveCaret(int line, int column) {
        this.codeEditorArea.moveTo(line, column);
        this.codeEditorArea.requestFollowCaret();
    }

    public boolean isSyntaxHighlightingEnabled() {
        return this.isSyntaxHighlightingEnabled.get();
    }

    public ReadOnlyBooleanProperty syntaxHighlightingEnabledProperty() {
        return this.isSyntaxHighlightingEnabled;
    }

    public ObservableValue<String> sourceCodeProperty() {
        return this.codeEditorArea.textProperty();
    }

    public LanguageVersion getLanguageVersion() {
        return this.astManager.getLanguageVersion();
    }

    public ObjectProperty<LanguageVersion> languageVersionProperty() {
        return this.astManager.languageVersionProperty();
    }

    public Node getCompilationUnit() {
        return this.astManager.updateCompilationUnit();
    }

    public ObjectProperty<Node> compilationUnitProperty() {
        return this.astManager.compilationUnitProperty();
    }

    public void replaceText(String source) {
        this.codeEditorArea.replaceText(source);
    }

    public void clearStyleLayers() {
        this.codeEditorArea.clearStyleLayers();
    }

    @Override
    public List<AppSetting> getSettings() {
        ArrayList<AppSetting> settings = new ArrayList<AppSetting>();
        settings.add(new AppSetting("langVersion", () -> this.getLanguageVersion().getTerseName(), this::restoreLanguageVersion));
        settings.add(new AppSetting("code", () -> this.codeEditorArea.getText(), e -> this.codeEditorArea.replaceText((String)e)));
        return settings;
    }

    private void restoreLanguageVersion(String name) {
        LanguageVersion version = LanguageRegistry.findLanguageVersionByTerseName((String)name);
        if (version != null) {
            this.astManager.languageVersionProperty().setValue((Object)version);
        }
    }
}

