/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.ast.xpath.AttributeAxisIterator;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.model.MetricEvaluator;
import net.sourceforge.pmd.util.fxdesigner.model.MetricResult;
import net.sourceforge.pmd.util.fxdesigner.util.controls.ScopeHierarchyTreeItem;

public class NodeInfoPanelController
implements Initializable {
    private final DesignerRoot designerRoot;
    private final MainDesignerController parent;
    @FXML
    private TabPane nodeInfoTabPane;
    @FXML
    private Tab xpathAttributesTitledPane;
    @FXML
    private ListView<String> xpathAttributesListView;
    @FXML
    private Tab metricResultsTitledPane;
    @FXML
    private ListView<MetricResult> metricResultsListView;
    @FXML
    private Label metricsTitleLabel;
    @FXML
    private TreeView<Object> scopeHierarchyTreeView;
    private MetricEvaluator metricEvaluator = new MetricEvaluator();

    NodeInfoPanelController(DesignerRoot root, MainDesignerController mainController) {
        this.designerRoot = root;
        this.parent = mainController;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.scopeHierarchyTreeView.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null && newVal.getValue() instanceof NameDeclaration) {
                this.parent.onNameDeclarationSelected((NameDeclaration)newVal.getValue());
            }
        });
    }

    public void displayInfo(Node node) {
        Objects.requireNonNull(node, "Node cannot be null");
        ObservableList<String> atts = NodeInfoPanelController.getAttributes(node);
        this.xpathAttributesListView.setItems(atts);
        ObservableList<MetricResult> metrics = this.evaluateAllMetrics(node);
        this.metricResultsListView.setItems(metrics);
        this.notifyMetricsAvailable(metrics.stream().map(MetricResult::getValue).filter(result -> !result.isNaN()).count());
        ScopeHierarchyTreeItem rootScope = ScopeHierarchyTreeItem.buildAscendantHierarchy(node);
        this.scopeHierarchyTreeView.setRoot((TreeItem)rootScope);
    }

    public void invalidateInfo() {
        this.metricResultsListView.setItems(FXCollections.emptyObservableList());
        this.xpathAttributesListView.setItems(FXCollections.emptyObservableList());
        this.scopeHierarchyTreeView.setRoot(null);
    }

    private void notifyMetricsAvailable(long numMetrics) {
        this.metricResultsTitledPane.setText("Metrics\t(" + (numMetrics == 0L ? "none" : Long.valueOf(numMetrics)) + ")");
        this.metricsTitleLabel.setText("Metrics\t(" + (numMetrics == 0L ? "none" : Long.valueOf(numMetrics)) + " available)");
        this.metricResultsTitledPane.setDisable(numMetrics == 0L);
    }

    private ObservableList<MetricResult> evaluateAllMetrics(Node n) {
        try {
            return FXCollections.observableArrayList(this.metricEvaluator.evaluateAllMetrics(n));
        }
        catch (UnsupportedOperationException e) {
            return FXCollections.emptyObservableList();
        }
    }

    private static ObservableList<String> getAttributes(Node node) {
        ObservableList result = FXCollections.observableArrayList();
        AttributeAxisIterator attributeAxisIterator = new AttributeAxisIterator(node);
        while (attributeAxisIterator.hasNext()) {
            Attribute attribute = attributeAxisIterator.next();
            result.add((Object)(attribute.getName() + " = " + (attribute.getValue() != null ? attribute.getStringValue() : "null")));
        }
        if (node instanceof TypeNode) {
            result.add((Object)("typeof() = " + ((TypeNode)node).getType()));
        }
        Collections.sort(result);
        return result;
    }
}

