/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.StringConverter;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.EventLogController;
import net.sourceforge.pmd.util.fxdesigner.ExportXPathWizardController;
import net.sourceforge.pmd.util.fxdesigner.NodeInfoPanelController;
import net.sourceforge.pmd.util.fxdesigner.SourceEditorController;
import net.sourceforge.pmd.util.fxdesigner.XPathPanelController;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import net.sourceforge.pmd.util.fxdesigner.util.LimitedSizeStack;
import net.sourceforge.pmd.util.fxdesigner.util.settings.AppSetting;
import net.sourceforge.pmd.util.fxdesigner.util.settings.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.settings.XMLSettingsLoader;
import net.sourceforge.pmd.util.fxdesigner.util.settings.XMLSettingsSaver;
import org.apache.commons.io.IOUtils;

public class MainDesignerController
implements Initializable,
SettingsOwner {
    private final DesignerRoot designerRoot;
    @FXML
    private MenuItem openFileMenuItem;
    @FXML
    private MenuItem licenseMenuItem;
    @FXML
    private Menu openRecentMenu;
    @FXML
    private MenuItem exportToTestCodeMenuItem;
    @FXML
    private MenuItem exportXPathMenuItem;
    @FXML
    private Menu exportMenu;
    @FXML
    private Menu fileMenu;
    @FXML
    private Button refreshASTButton;
    @FXML
    private ChoiceBox<LanguageVersion> languageChoiceBox;
    @FXML
    private ChoiceBox<String> xpathVersionChoiceBox;
    @FXML
    private ToggleButton bottomTabsToggle;
    @FXML
    private TabPane bottomTabPane;
    @FXML
    private Tab eventLogTab;
    @FXML
    private Tab xpathEditorTab;
    @FXML
    private SplitPane mainHorizontalSplitPane;
    @FXML
    private NodeInfoPanelController nodeInfoPanelController;
    @FXML
    private XPathPanelController xpathPanelController;
    @FXML
    private SourceEditorController sourceEditorController;
    @FXML
    private EventLogController eventLogPanelController;
    private Stack<File> recentFiles = new LimitedSizeStack<File>(5);

    public MainDesignerController(DesignerRoot owner) {
        this.designerRoot = owner;
    }

    public void initialize(URL location, ResourceBundle resources) {
        try {
            XMLSettingsLoader loader = new XMLSettingsLoader(DesignerUtil.getSettingsFile());
            this.loadSettings(loader.getSettings());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initializeLanguageVersionMenu();
        this.initializeViewAnimation();
        this.xpathPanelController.initialiseVersionChoiceBox(this.xpathVersionChoiceBox);
        this.sourceEditorController.languageVersionProperty().bind((ObservableValue)this.languageChoiceBox.getSelectionModel().selectedItemProperty());
        this.xpathPanelController.xpathVersionProperty().bind((ObservableValue)this.xpathVersionChoiceBox.getSelectionModel().selectedItemProperty());
        this.refreshASTButton.setOnAction(e -> this.onRefreshASTClicked());
        this.licenseMenuItem.setOnAction(e -> this.showLicensePopup());
        this.openFileMenuItem.setOnAction(e -> this.onOpenFileClicked());
        this.openRecentMenu.setOnAction(e -> this.updateRecentFilesMenu());
        this.openRecentMenu.setOnShowing(e -> this.updateRecentFilesMenu());
        this.fileMenu.setOnShowing(e -> this.onFileMenuShowing());
        this.exportXPathMenuItem.setOnAction(e -> {
            try {
                this.onExportXPathToRuleClicked();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        this.sourceEditorController.refreshAST();
        Platform.runLater(() -> this.sourceEditorController.moveCaret(0, 0));
    }

    private void initializeLanguageVersionMenu() {
        List<LanguageVersion> supported = Arrays.asList(DesignerUtil.getSupportedLanguageVersions());
        supported.sort(LanguageVersion::compareTo);
        this.languageChoiceBox.getItems().addAll(supported);
        this.languageChoiceBox.setConverter((StringConverter)new StringConverter<LanguageVersion>(){

            public String toString(LanguageVersion object) {
                return object.getShortName();
            }

            public LanguageVersion fromString(String string) {
                return LanguageRegistry.findLanguageVersionByTerseName((String)string.toLowerCase());
            }
        });
        LanguageVersion defaultLangVersion = LanguageRegistry.getLanguage((String)"Java").getDefaultVersion();
        this.languageChoiceBox.getSelectionModel().select((Object)defaultLangVersion);
        this.languageChoiceBox.show();
    }

    private void initializeViewAnimation() {
        double defaultMainHorizontalSplitPaneDividerPosition = this.mainHorizontalSplitPane.getDividerPositions()[0];
        this.bottomTabsToggle.selectedProperty().addListener((observable, wasExpanded, isNowExpanded) -> {
            KeyValue keyValue = null;
            DoubleProperty divPosition = ((SplitPane.Divider)this.mainHorizontalSplitPane.getDividers().get(0)).positionProperty();
            if (wasExpanded.booleanValue() && !isNowExpanded.booleanValue()) {
                keyValue = new KeyValue((WritableValue)divPosition, (Object)1);
            } else if (!wasExpanded.booleanValue() && isNowExpanded.booleanValue()) {
                keyValue = new KeyValue((WritableValue)divPosition, (Object)defaultMainHorizontalSplitPaneDividerPosition);
            }
            if (keyValue != null) {
                Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{keyValue})});
                timeline.play();
            }
        });
    }

    public void shutdown() {
        try {
            XMLSettingsSaver saver = XMLSettingsSaver.forFile(DesignerUtil.getSettingsFile());
            this.saveSettings(saver);
            saver.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sourceEditorController.shutdown();
        this.xpathPanelController.shutdown();
    }

    private void onRefreshASTClicked() {
        this.sourceEditorController.refreshAST();
        this.xpathPanelController.evaluateXPath(this.sourceEditorController.getCompilationUnit(), this.sourceEditorController.getLanguageVersion());
    }

    public void onNodeItemSelected(net.sourceforge.pmd.lang.ast.Node selectedValue) {
        this.nodeInfoPanelController.displayInfo(selectedValue);
        this.sourceEditorController.clearNodeHighlight();
        this.sourceEditorController.highlightNodePrimary(selectedValue);
        this.sourceEditorController.focusNodeInTreeView(selectedValue);
    }

    public void onNameDeclarationSelected(NameDeclaration declaration) {
        this.sourceEditorController.clearNodeHighlight();
        this.sourceEditorController.highlightNodePrimary((net.sourceforge.pmd.lang.ast.Node)declaration.getNode());
        this.sourceEditorController.highlightNodesSecondary(((List)declaration.getNode().getScope().getDeclarations().get(declaration)).stream().map(NameOccurrence::getLocation).collect(Collectors.toList()));
    }

    private void showLicensePopup() {
        Alert licenseAlert = new Alert(Alert.AlertType.INFORMATION);
        licenseAlert.setWidth(500.0);
        licenseAlert.setHeaderText("License");
        ScrollPane scroll = new ScrollPane();
        try {
            scroll.setContent((Node)new TextArea(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("LICENSE"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        licenseAlert.getDialogPane().setContent((Node)scroll);
        licenseAlert.showAndWait();
    }

    private void onExportXPathToRuleClicked() throws IOException {
        ExportXPathWizardController wizard = new ExportXPathWizardController(this.xpathPanelController.xpathExpressionProperty());
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("fxml/xpath-export-wizard.fxml"));
        loader.setController((Object)wizard);
        Stage dialog = new Stage();
        dialog.initOwner((Window)this.designerRoot.getMainStage());
        dialog.setOnCloseRequest(e -> wizard.shutdown());
        dialog.initModality(Modality.WINDOW_MODAL);
        Parent root = (Parent)loader.load();
        Scene scene = new Scene(root);
        dialog.setScene(scene);
        dialog.show();
    }

    private void onFileMenuShowing() {
        this.openRecentMenu.setDisable(this.recentFiles.size() == 0);
    }

    private void onOpenFileClicked() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load source from file");
        File file = chooser.showOpenDialog((Window)this.designerRoot.getMainStage());
        this.loadSourceFromFile(file);
        this.sourceEditorController.clearStyleLayers();
    }

    private void loadSourceFromFile(File file) {
        if (file != null) {
            try {
                String source = IOUtils.toString((InputStream)new FileInputStream(file));
                this.sourceEditorController.replaceText(source);
                LanguageVersion guess = DesignerUtil.getLanguageVersionFromExtension(file.getName());
                if (guess != null) {
                    this.languageChoiceBox.getSelectionModel().select((Object)guess);
                }
                this.recentFiles.push(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateRecentFilesMenu() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (File f : this.recentFiles) {
            if (f.exists() && f.isFile()) {
                CustomMenuItem item = new CustomMenuItem((Node)new Label(f.getName()));
                item.setOnAction(e -> this.loadSourceFromFile(f));
                item.setMnemonicParsing(false);
                Tooltip.install((Node)item.getContent(), (Tooltip)new Tooltip(f.getAbsolutePath()));
                items.add(item);
                continue;
            }
            this.recentFiles.remove(f);
        }
        if (items.isEmpty()) {
            this.openRecentMenu.setDisable(true);
            return;
        }
        Collections.reverse(items);
        items.add(new SeparatorMenuItem());
        MenuItem clearItem = new MenuItem();
        clearItem.setText("Clear menu");
        clearItem.setOnAction(e -> {
            this.recentFiles.clear();
            this.openRecentMenu.setDisable(true);
        });
        items.add(clearItem);
        this.openRecentMenu.getItems().setAll(items);
    }

    @Override
    public List<AppSetting> getSettings() {
        ArrayList<AppSetting> settings = new ArrayList<AppSetting>();
        settings.add(new AppSetting("recentFiles", this::getRecentFiles, this::setRecentFiles));
        settings.add(new AppSetting("isMaximized", this::isMaximized, this::setIsMaximized));
        settings.add(new AppSetting("bottomExpandedTab", this::getBottomExpandedTab, this::setBottomExpandedTab));
        return settings;
    }

    private void saveSettings(XMLSettingsSaver saver) {
        this.saveSettingsOf(this, saver);
        this.saveSettingsOf(this.sourceEditorController, saver);
        this.saveSettingsOf(this.xpathPanelController, saver);
    }

    private void saveSettingsOf(SettingsOwner owner, XMLSettingsSaver saver) {
        for (AppSetting s : owner.getSettings()) {
            saver.put(s.getKeyName(), s.getValue());
        }
    }

    private void loadSettings(Map<String, String> settings) {
        this.loadSettingsOf(this.sourceEditorController, settings);
        this.loadSettingsOf(this.xpathPanelController, settings);
        this.loadSettingsOf(this, settings);
    }

    private void loadSettingsOf(SettingsOwner owner, Map<String, String> loaded) {
        for (AppSetting s : owner.getSettings()) {
            String val = loaded.get(s.getKeyName());
            if (val == null) continue;
            s.setValue(val);
        }
    }

    private String getRecentFiles() {
        StringBuilder sb = new StringBuilder();
        for (File f : this.recentFiles) {
            sb.append(',').append(f.getAbsolutePath());
        }
        return sb.length() > 0 ? sb.substring(1) : "";
    }

    private void setRecentFiles(String files) {
        List<String> fileNames = Arrays.asList(files.split(","));
        Collections.reverse(fileNames);
        for (String fileName : fileNames) {
            File f = new File(fileName);
            this.recentFiles.push(f);
        }
    }

    private String isMaximized() {
        return Boolean.toString(this.designerRoot.getMainStage().isMaximized());
    }

    private void setIsMaximized(String bool) {
        boolean b = Boolean.parseBoolean(bool);
        this.designerRoot.getMainStage().setMaximized(!b);
        this.designerRoot.getMainStage().setMaximized(b);
    }

    private String getBottomExpandedTab() {
        return (this.bottomTabsToggle.isSelected() ? "expanded:" : "collapsed:") + this.bottomTabPane.getSelectionModel().getSelectedIndex();
    }

    private void setBottomExpandedTab(String id) {
        String[] info = id.split(":");
        this.bottomTabsToggle.setSelected("expanded".equals(info[0]));
        this.bottomTabPane.getSelectionModel().select(Integer.parseInt(info[1]));
    }

    public void invalidateAst() {
        this.nodeInfoPanelController.invalidateInfo();
        this.xpathPanelController.invalidateResults(false);
        this.sourceEditorController.clearNodeHighlight();
    }
}

