/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.typedefinition;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinition;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.TypeDefinitionType;

class JavaTypeDefinitionUpper
extends JavaTypeDefinition {
    private final JavaTypeDefinition[] typeList;

    protected JavaTypeDefinitionUpper(TypeDefinitionType defType, JavaTypeDefinition ... typeList) {
        super(defType);
        if (typeList.length == 0) {
            throw new IllegalArgumentException("Intersection type list can't be empty");
        }
        this.typeList = typeList;
    }

    protected JavaTypeDefinition firstJavaType() {
        return this.typeList[0];
    }

    @Override
    public Class<?> getType() {
        if (this.firstJavaType() == null) {
            return null;
        }
        return this.firstJavaType().getType();
    }

    @Override
    public JavaTypeDefinition getEnclosingClass() {
        return this.firstJavaType().getEnclosingClass();
    }

    @Override
    public boolean isGeneric() {
        return this.firstJavaType().isGeneric();
    }

    @Override
    public JavaTypeDefinition getGenericType(String parameterName) {
        return this.firstJavaType().getGenericType(parameterName);
    }

    @Override
    public JavaTypeDefinition getGenericType(int index) {
        return this.firstJavaType().getGenericType(index);
    }

    @Override
    public JavaTypeDefinition resolveTypeDefinition(Type type) {
        return this.firstJavaType().resolveTypeDefinition(type);
    }

    @Override
    public JavaTypeDefinition resolveTypeDefinition(Type type, Method method, List<JavaTypeDefinition> methodTypeArgs) {
        return this.firstJavaType().resolveTypeDefinition(type, method, methodTypeArgs);
    }

    @Override
    public JavaTypeDefinition getComponentType() {
        return this.firstJavaType().getComponentType();
    }

    @Override
    public boolean isClassOrInterface() {
        return this.firstJavaType().isClassOrInterface();
    }

    @Override
    public boolean isNullType() {
        return this.firstJavaType().isNullType();
    }

    @Override
    public boolean isPrimitive() {
        return this.firstJavaType().isPrimitive();
    }

    @Override
    public boolean hasSameErasureAs(JavaTypeDefinition def) {
        return this.firstJavaType().hasSameErasureAs(def);
    }

    @Override
    public int getTypeParameterCount() {
        return this.firstJavaType().getTypeParameterCount();
    }

    @Override
    public boolean isArrayType() {
        return this.firstJavaType().isArrayType();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append("JavaTypeDefinition ").append(this.getDefinitionType().toString()).append(" [").append(this.typeList[0]);
        for (int index = 1; index < this.typeList.length; ++index) {
            builder.append(" && ");
            builder.append(this.typeList[index]);
        }
        return builder.append("]").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().isInstance(obj)) {
            return false;
        }
        JavaTypeDefinitionUpper otherTypeDef = (JavaTypeDefinitionUpper)obj;
        if (otherTypeDef.getJavaTypeCount() != this.getJavaTypeCount() || this.getDefinitionType() != otherTypeDef.getDefinitionType()) {
            return false;
        }
        block0: for (JavaTypeDefinition intersectionTypeDef : this.typeList) {
            for (JavaTypeDefinition otherIntersectionTypeDef : otherTypeDef.typeList) {
                if (intersectionTypeDef.equals(otherIntersectionTypeDef)) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 31;
        for (JavaTypeDefinition typeDef : this.typeList) {
            result *= typeDef.hashCode();
        }
        return result;
    }

    @Override
    public Set<JavaTypeDefinition> getSuperTypeSet() {
        return this.firstJavaType().getSuperTypeSet();
    }

    @Override
    protected Set<JavaTypeDefinition> getSuperTypeSet(Set<JavaTypeDefinition> destinationSet) {
        return this.firstJavaType().getSuperTypeSet(destinationSet);
    }

    @Override
    public Set<Class<?>> getErasedSuperTypeSet() {
        return this.firstJavaType().getErasedSuperTypeSet();
    }

    @Override
    public JavaTypeDefinition getAsSuper(Class<?> superClazz) {
        return this.firstJavaType().getAsSuper(superClazz);
    }

    @Override
    public JavaTypeDefinition getJavaType(int index) {
        return this.firstJavaType();
    }

    @Override
    public int getJavaTypeCount() {
        return this.typeList.length;
    }

    @Override
    public boolean isRawType() {
        return this.typeList.length == 1 && this.firstJavaType().isRawType();
    }

    @Override
    public boolean isIntersectionType() {
        return this.typeList.length > 1;
    }
}

